/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SingleObjectWeakIdentitySet<T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WeakReference<T> _single;

    @Override
    public boolean add(T object) {
        if (this._single != null) {
            if (this._single.get() != object) {
                throw new IllegalStateException("can only add one element");
            }
            return false;
        }
        this._single = new WeakReference<T>(object);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this._single.get() == o;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos == -1 && SingleObjectWeakIdentitySet.this._single != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("pos " + (this.pos + 1));
                }
                ++this.pos;
                return SingleObjectWeakIdentitySet.this._single.get();
            }

            @Override
            public void remove() {
                if (this.pos != 0 || SingleObjectWeakIdentitySet.this._single == null) {
                    throw new IllegalStateException("pos " + this.pos + ", object " + String.valueOf(SingleObjectWeakIdentitySet.this._single != null ? SingleObjectWeakIdentitySet.this._single.get() : null));
                }
                SingleObjectWeakIdentitySet.this._single = null;
            }
        };
    }

    @Override
    public int size() {
        return this._single == null ? 0 : 1;
    }
}

