/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.json.JSONAware;
import org.zkoss.zk.ui.Component;

public class GsonConverter
implements Converter<Object, Object, Component> {
    private Gson gson;

    public GsonConverter() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeHierarchyAdapter(Component.class, (Object)new ZKComponentAdapter());
        builder.registerTypeHierarchyAdapter(JSONAware.class, (Object)new ZKJSONAwareAdapter());
        this.gson = builder.create();
    }

    public Object coerceToUi(Object beanProp, Component component, BindContext ctx) {
        return this.gson.toJson(beanProp).replaceAll("\"__ZKSTART__", "zk.\\$('#").replaceAll("__ZKEND__\"", "')");
    }

    private TypeToken<?> getTypeToken(Type type) {
        return TypeToken.get((Type)type);
    }

    public Object coerceToBean(Object compAttr, Component component, BindContext ctx) {
        Class type = (Class)ctx.getAttribute((Object)"org.zkoss.bind.BindingParamCall.type");
        TypeToken<?> typeToken = this.getTypeToken(type);
        if (compAttr != null) {
            return this.gson.fromJson(compAttr.toString(), typeToken.getType());
        }
        return null;
    }

    private static class ZKJSONAwareAdapter
    implements JsonSerializer<JSONAware> {
        private ZKJSONAwareAdapter() {
        }

        public JsonElement serialize(JSONAware comp, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(comp.toJSONString());
        }
    }

    private static class ZKComponentAdapter
    implements JsonSerializer<Component> {
        private ZKComponentAdapter() {
        }

        public JsonElement serialize(Component comp, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive("__ZKSTART__" + comp.getUuid() + "__ZKEND__");
        }
    }
}

