/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.GoldenLayout;
import org.zkoss.zul.impl.XulElement;

public class GoldenPanel
extends XulElement {
    private static final String ON_ACTIVE = "onActive";
    private static final String ON_PANEL_DROP = "onPanelDrop";
    private static final String ON_FLEX_SIZE = "onFlexSize";
    private static final String ON_AREA_RENAME = "onAreaRename";
    private String _area;
    private String _title;
    private boolean _draggable = true;
    private boolean _droppable = true;
    private boolean _closable = true;
    private GoldenPanel _dropTarget;
    private String _region;
    private static HashMap<String, PropertyAccess> _properties;

    public GoldenPanel() {
    }

    public GoldenPanel(String area) {
        this._area = area;
    }

    public void onInitMatrix() {
        GoldenLayout gl;
        if (this._area == null) {
            this._area = this.getUuid();
        }
        if ((gl = (GoldenLayout)this.getParent()) != null) {
            Set<String> areaNames;
            if ("stack".equals(this._region) && this._dropTarget instanceof GoldenPanel && this._dropTarget != null) {
                this._area = this._dropTarget.getArea();
            }
            if (!(areaNames = gl.getAreasNames()).contains(this._area)) {
                areaNames.add(this._area);
                if (!gl.isInitialized()) {
                    String region = gl.updateInitialMatrix(this._dropTarget, this._region, this._area);
                    if (!Objects.equals((Object)region, (Object)this._region)) {
                        this._region = region;
                    }
                } else if ("stack".equalsIgnoreCase(this._region)) {
                    this._region = "east";
                }
            } else if (!"stack".equals(this._region)) {
                this._region = "stack";
            }
        }
        if (Strings.isEmpty((String)this._region)) {
            this._region = "east";
        }
    }

    public String getArea() {
        return this._area;
    }

    public void setArea(String area) {
        if (this.isInitialized()) {
            throw new UiException("Setting area is only supported on initial rendering.");
        }
        this._area = area;
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("Should use hflex instead");
    }

    public void setHeight(String height) {
        throw new UnsupportedOperationException("Should use vflex instead");
    }

    protected void setVflexDirectly(String flex) {
        super.setVflexDirectly(flex);
    }

    public void setVflex(String flex) {
        if ("min".equals(flex)) {
            throw new UnsupportedOperationException("flex min is not supported in GoldenPanel");
        }
        super.setVflex(flex);
    }

    protected void setHflexDirectly(String flex) {
        super.setHflexDirectly(flex);
    }

    public void setHflex(String flex) {
        if ("min".equals(flex)) {
            throw new UnsupportedOperationException("flex min is not supported in GoldenPanel");
        }
        super.setHflex(flex);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartUpdate("title", this._title);
        }
    }

    public boolean isDraggable() {
        return this._draggable;
    }

    public void setDraggable(boolean draggable) {
        if (this._draggable != draggable) {
            this._draggable = draggable;
            this.smartUpdate("draggable", draggable);
        }
    }

    public boolean isDroppable() {
        return this._droppable;
    }

    public void setDroppable(boolean droppable) {
        if (this._droppable != droppable) {
            this._droppable = droppable;
            this.smartUpdate("droppable", this._droppable);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", this._closable);
        }
    }

    public void onClose() {
        this.detach();
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof GoldenLayout)) {
            throw new UiException("Unsupported parent for goldenpanel: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    protected void droppedToRoot(String region) {
        this._region = region;
        this.response(null, (AuResponse)new AuInvoke((Component)this, "_droppedTo", (Object)"$root", (Object)region));
    }

    protected void droppedTo(GoldenPanel dropTarget, String region) {
        if (!this.isInitialized()) {
            this._dropTarget = dropTarget;
        }
        this._region = region;
        this.response(null, (AuResponse)new AuInvoke((Component)this, "_droppedTo", (Object)dropTarget.getUuid(), (Object)region));
    }

    public Map<String, Integer> getLocation() {
        HashMap<String, Integer> location = new HashMap<String, Integer>(4);
        List<List<String>> matrix = ((GoldenLayout)this.getParent()).getAreasMatrix();
        boolean row0Found = false;
        for (int row = 0; row < matrix.size(); ++row) {
            List<String> currRow = matrix.get(row);
            if (currRow.contains(this._area)) {
                if (!row0Found) {
                    location.put("y0", row);
                    location.put("x0", currRow.indexOf(this._area));
                    location.put("x1", currRow.lastIndexOf(this._area));
                    row0Found = true;
                    continue;
                }
                location.put("y1", row);
                continue;
            }
            if (row0Found) break;
        }
        return location;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "_area", this._area);
        if (this._title != null && !"".equals(this._title)) {
            this.render(renderer, "title", this._title);
        }
        if (!this._draggable) {
            renderer.render("draggable", false);
        }
        if (!this._droppable) {
            renderer.render("droppable", false);
        }
        if (!this._closable) {
            renderer.render("closable", false);
        }
        if (this._region != null) {
            String dropTargetUuid = null;
            if (this._dropTarget != null && Objects.equals((Object)this.getParent(), (Object)this._dropTarget.getParent())) {
                dropTargetUuid = this._dropTarget.getUuid();
                this._dropTarget = null;
            }
            this.render(renderer, "_dropTargetUuid", dropTargetUuid == null ? "$root" : dropTargetUuid);
            this.render(renderer, "_region", this._region);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if (cmd.equals(ON_PANEL_DROP)) {
            Events.postEvent((Event)Event.getEvent((AuRequest)request));
        } else if (cmd.equals(ON_FLEX_SIZE)) {
            this.setVflexDirectly(data.get("vflex").toString());
            this.setHflexDirectly(data.get("hflex").toString());
            if (!((Boolean)data.get("init")).booleanValue()) {
                Events.postEvent((Event)Event.getEvent((AuRequest)request));
            }
        } else if (cmd.equals(ON_AREA_RENAME)) {
            this._area = (String)data.get("area");
        } else {
            super.service(request, everError);
        }
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    public boolean evalCSSFlex() {
        return false;
    }

    static {
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)"onClose", (int)0);
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)"onMaximize", (int)0);
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)"onMinimize", (int)0);
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)ON_PANEL_DROP, (int)8193);
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)ON_FLEX_SIZE, (int)8193);
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)ON_ACTIVE, (int)0);
        GoldenPanel.addClientEvent(GoldenPanel.class, (String)ON_AREA_RENAME, (int)8193);
        _properties = new HashMap(10);
        _properties.put("draggable", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((GoldenPanel)cmp).setDraggable(value);
            }

            public Boolean getValue(Component cmp) {
                return ((GoldenPanel)cmp).isDraggable();
            }
        });
        _properties.put("droppable", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((GoldenPanel)cmp).setDroppable(value);
            }

            public Boolean getValue(Component cmp) {
                return ((GoldenPanel)cmp).isDroppable();
            }
        });
        _properties.put("closable", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((GoldenPanel)cmp).setClosable(value);
            }

            public Boolean getValue(Component cmp) {
                return ((GoldenPanel)cmp).isClosable();
            }
        });
    }
}

