/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.validator.AbstractValidator;
import org.zkoss.bind.validator.BeanValidations;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.UiException;

public class FormBeanValidator
extends AbstractValidator {
    protected Validator getValidator() {
        return BeanValidations.getValidator();
    }

    protected Set<ConstraintViolation<?>> validate(Class clz, String property, Object value) {
        return this.getValidator().validateValue(clz, property, value, new Class[0]);
    }

    public void validate(ValidationContext ctx) {
        Property p = ctx.getProperty();
        Object base = p.getBase();
        if (ctx.getBindContext().getBinding() instanceof SaveFormBinding) {
            String prefix = (String)ctx.getValidatorArg("prefix");
            if (Strings.isEmpty((String)prefix)) {
                throw new NullPointerException("prefix of message key is empty, did you set prefix argument in @validator?");
            }
            Class[] groups = (Class[])ctx.getValidatorArg("groups");
            Set validates = groups != null ? this.getValidator().validate(p.getValue(), groups) : this.getValidator().validate(p.getValue(), new Class[0]);
            HashMap<Path, LinkedHashSet<ConstraintViolation>> group = new HashMap<Path, LinkedHashSet<ConstraintViolation>>();
            for (ConstraintViolation constraintViolation : validates) {
                LinkedHashSet<ConstraintViolation> set = (LinkedHashSet<ConstraintViolation>)group.get(constraintViolation.getPropertyPath());
                if (set == null) {
                    set = new LinkedHashSet<ConstraintViolation>();
                    group.put(constraintViolation.getPropertyPath(), set);
                }
                set.add(constraintViolation);
            }
            for (Map.Entry entry : group.entrySet()) {
                this.handleConstraintViolation(ctx, prefix + entry.getKey(), (Set)entry.getValue());
            }
        } else {
            throw new UiException("Can be used in form binding only");
        }
    }

    protected void sort(List<ConstraintViolation<?>> viloations) {
        Collections.sort(viloations, new Comparator<ConstraintViolation<?>>(){

            @Override
            public int compare(ConstraintViolation<?> o1, ConstraintViolation<?> o2) {
                String s1 = o1.getConstraintDescriptor().getAnnotation().toString();
                String s2 = o2.getConstraintDescriptor().getAnnotation().toString();
                return s1.compareTo(s2);
            }
        });
    }

    protected void handleConstraintViolation(ValidationContext ctx, String key, Set<ConstraintViolation<?>> violations) {
        int s = violations.size();
        if (s == 1) {
            this.addInvalidMessages(ctx, key, new String[]{violations.iterator().next().getMessage()});
        } else if (s > 0) {
            String[] msgs = new String[violations.size()];
            ArrayList l = new ArrayList(violations);
            this.sort(l);
            for (int i = 0; i < msgs.length; ++i) {
                msgs[i] = ((ConstraintViolation)l.get(i)).getMessage();
            }
            this.addInvalidMessages(ctx, key, msgs);
        }
    }

    protected Class getBeanClass(ValidationContext ctx, Object base) {
        return base.getClass();
    }
}

