/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.impl.rule;

import java.util.Arrays;
import java.util.stream.Stream;
import org.w3c.dom.Attr;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Element;
import org.zkoss.zklinter.MVVMOnlyRule;
import org.zkoss.zklinter.ZulFileVisitor;

public class ModelELBinding
extends MVVMOnlyRule {
    @Override
    public String getDescription() {
        return this.getDescription("${...}", "@init/load/save/bind(...)");
    }

    public String getDescription(String el, String binding) {
        return "Client MVVM doesn't support EL `model=\"" + el + "\"` with data binding `" + binding + "`, please continue using server MVVM";
    }

    @Override
    public ZulFileVisitor newZulFileVisitor() {
        return new ZulFileVisitor(){

            @Override
            protected void visitAttribute(Attribute attribute) {
                if (!this.isInsideMVVM()) {
                    return;
                }
                Stream<String> bindAnnotations = Arrays.stream(new String[]{"@(", "@init", "@load", "@save", "@bind"});
                if (bindAnnotations.anyMatch(annotation -> attribute.getValue().startsWith((String)annotation))) {
                    boolean inModelTemplate = false;
                    for (Element element : this.getCurrentPath()) {
                        Attr modelAttr;
                        if (inModelTemplate && (modelAttr = element.getAttributeNode("model")) != null && modelAttr.getValue().startsWith("${")) {
                            this.report(modelAttr, ModelELBinding.this.getDescription(modelAttr.getValue(), attribute.getValue()));
                            return;
                        }
                        if (!"template".equals(element.getLocalName()) || !"model".equals(element.getAttributeValue("name"))) continue;
                        inModelTemplate = true;
                    }
                }
            }
        };
    }
}

