/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.impl.rule;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Name;
import org.zkoss.zklinter.JavaFileVisitor;
import org.zkoss.zklinter.MVVMOnlyRule;

public class ConverterCastObject
extends MVVMOnlyRule {
    @Override
    public String getDescription() {
        return "In Client MVVM, `Converter` must not cast an `Object` type parameter to another type, please change the parameter type in the method signature";
    }

    @Override
    public JavaFileVisitor newJavaFileVisitor() {
        return new JavaFileVisitor(){

            @Override
            protected void visitTypeCast(TypeCastTree node) {
                ExpressionTree expression = node.getExpression();
                if (expression.getKind() != Tree.Kind.IDENTIFIER) {
                    return;
                }
                Name castedVariable = ((IdentifierTree)expression).getName();
                boolean inConverter = false;
                MethodTree methodNode = null;
                for (Tree parentNode : this.getCurrentPath()) {
                    if (parentNode.getKind() == Tree.Kind.NEW_CLASS && "Converter".equals(String.valueOf(((NewClassTree)parentNode).getIdentifier()))) {
                        inConverter = true;
                        break;
                    }
                    if (parentNode.getKind() != Tree.Kind.METHOD || methodNode != null) continue;
                    methodNode = (MethodTree)parentNode;
                }
                if (!inConverter || methodNode == null) {
                    return;
                }
                String methodName = String.valueOf(methodNode.getName());
                if ("equals".equals(methodName) || "compare".equals(methodName)) {
                    return;
                }
                for (VariableTree variableTree : methodNode.getParameters()) {
                    if (!castedVariable.equals(variableTree.getName()) || !"Object".equals(String.valueOf(variableTree.getType()))) continue;
                    this.report(node, ConverterCastObject.this.getDescription());
                }
            }
        };
    }
}

