/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.impl.rule;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Name;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zklinter.JavaFileVisitor;
import org.zkoss.zklinter.JavaParser;
import org.zkoss.zklinter.impl.rule.Annotation;

public class BindingParam
extends Annotation {
    @Override
    public String getDescription() {
        return this.getDescription("`@BindingParam Component c` or `@BindingParam Event e` with `e.getTarget()`");
    }

    protected String getDescription(String expression) {
        return "To ensure the decoupling of ViewModel from View, Client MVVM doesn't support using " + expression + " to get components, please change the usage or continue using server MVVM";
    }

    @Override
    public JavaFileVisitor newJavaFileVisitor() {
        return new JavaFileVisitor(){
            private final Map<String, Set<AnnotationTree>> _componentChecks = new HashMap<String, Set<AnnotationTree>>();
            private final Map<String, Set<AnnotationTree>> _eventChecks = new HashMap<String, Set<AnnotationTree>>();
            private final Map<String, ClassTree> _innerClasses = new HashMap<String, ClassTree>();
            private final Map<String, String> _singleClassImports = new HashMap<String, String>();
            private final List<String> _onDemandImports = new ArrayList<String>();

            @Override
            protected void visitMethod(MethodTree node) {
                block0: for (VariableTree variableTree : node.getParameters()) {
                    for (AnnotationTree annotationTree : variableTree.getModifiers().getAnnotations()) {
                        if (!"BindingParam".equals(String.valueOf(annotationTree.getAnnotationType()))) continue;
                        Tree parameterType = this.getBaseType(variableTree.getType());
                        if (parameterType == null || this.isPrimitive(parameterType)) continue block0;
                        this._componentChecks.computeIfAbsent(parameterType.toString(), k -> new HashSet()).add(annotationTree);
                    }
                }
            }

            @Override
            protected void visitMethodInvocation(MethodInvocationTree node) {
                if (node.getMethodSelect() == null) {
                    return;
                }
                String[] methodName = node.getMethodSelect().toString().split("\\.");
                if (methodName.length != 2 || !"getTarget".equals(methodName[1])) {
                    return;
                }
                String eventVariable = methodName[0];
                MethodTree methodNode = null;
                for (Tree tree : this.getCurrentPath()) {
                    if (tree.getKind() != Tree.Kind.METHOD) continue;
                    methodNode = (MethodTree)tree;
                    break;
                }
                if (methodNode == null) {
                    return;
                }
                for (VariableTree variableTree : methodNode.getParameters()) {
                    if (!eventVariable.equals(String.valueOf(variableTree.getName()))) continue;
                    for (AnnotationTree annotationTree : variableTree.getModifiers().getAnnotations()) {
                        if (!"BindingParam".equals(String.valueOf(annotationTree.getAnnotationType()))) continue;
                        Tree parameterType = this.getBaseType(variableTree.getType());
                        if (parameterType == null || this.isPrimitive(parameterType)) {
                            return;
                        }
                        this._eventChecks.computeIfAbsent(parameterType.toString(), k -> new HashSet()).add(annotationTree);
                    }
                    return;
                }
            }

            private Tree getBaseType(Tree type) {
                switch (type.getKind()) {
                    case ARRAY_TYPE: {
                        return ((ArrayTypeTree)type).getType();
                    }
                    case PARAMETERIZED_TYPE: {
                        return ((ParameterizedTypeTree)type).getType();
                    }
                }
                return type;
            }

            private boolean isPrimitive(Tree type) {
                if (type.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                    return true;
                }
                try {
                    Class.forName("java.lang." + String.valueOf(type));
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }

            @Override
            protected void visitClass(ClassTree node) {
                Name name = node.getSimpleName();
                if (name != null) {
                    this._innerClasses.put(name.toString(), node);
                }
            }

            @Override
            protected void afterAll() {
                this.addImports(this.getRootNode());
                this._componentChecks.forEach((className, nodes) -> {
                    Class<?> classObject = this.getClassObjectFromSimpleName((String)className);
                    if (classObject == null) {
                        nodes.forEach(node -> this.report((Tree)node, "Failed to check if `" + className + "` extends `Component`, please provide its external Jar file through `jarFiles` in `app.properties`"));
                    } else if (Component.class.isAssignableFrom(classObject)) {
                        nodes.forEach(node -> this.report((Tree)node, BindingParam.this.getDescription("`@BindingParam " + className + "`")));
                    }
                });
                this._eventChecks.forEach((className, nodes) -> {
                    Class<?> classObject = this.getClassObjectFromSimpleName((String)className);
                    if (classObject == null) {
                        nodes.forEach(node -> this.report((Tree)node, "Failed to check if `" + className + "` extends `Event`please provide its external Jar file through `jarFiles` in `app.properties`"));
                    } else if (Event.class.isAssignableFrom(classObject)) {
                        nodes.forEach(node -> this.report((Tree)node, BindingParam.this.getDescription("`@BindingParam " + className + " e` and `e.getTarget()`")));
                    }
                });
            }

            private void addImports(CompilationUnitTree tree) {
                ExpressionTree currentPackageName = this.getRootNode().getPackageName();
                if (currentPackageName != null) {
                    this._onDemandImports.add(currentPackageName.toString());
                }
                for (ImportTree importTree : tree.getImports()) {
                    String qualifiedIdentifier = importTree.getQualifiedIdentifier().toString();
                    int i = qualifiedIdentifier.lastIndexOf(46);
                    String packageName = qualifiedIdentifier.substring(0, i);
                    String identifier = qualifiedIdentifier.substring(i + 1);
                    if ("*".equals(identifier)) {
                        this._onDemandImports.add(packageName);
                        continue;
                    }
                    this._singleClassImports.put(identifier, qualifiedIdentifier);
                }
            }

            private Class<?> getClassObjectFromSimpleName(String className) {
                ClassTree classNode;
                int endIndex = className.indexOf(60);
                if (endIndex >= 0) {
                    className = className.substring(0, endIndex);
                }
                if ((classNode = this._innerClasses.get(className)) != null) {
                    Tree extendClause = classNode.getExtendsClause();
                    return extendClause == null ? Object.class : this.getClassObjectFromSimpleName(extendClause.toString());
                }
                String fullClassName = this._singleClassImports.get(className);
                if (fullClassName != null) {
                    return this.getClassObjectFromFullName(fullClassName);
                }
                for (String packageName : this._onDemandImports) {
                    Class<?> classObject = this.getClassObjectFromFullName(packageName + "." + className);
                    if (classObject == null) continue;
                    return classObject;
                }
                return null;
            }

            private Class<?> getClassObjectFromFullName(String className) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return this.getSettings().getUrlClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        String relativePath = className.replace('.', File.separatorChar) + ".java";
                        File file = this.getSettings().getJavaDir().resolve(relativePath).toFile();
                        if (file.exists()) {
                            List<JavaParser.ParsedJava> parsedJavas = JavaParser.parse(file, this.getSettings());
                            if (parsedJavas.isEmpty()) {
                                return null;
                            }
                            CompilationUnitTree tree = parsedJavas.get(parsedJavas.size() - 1).getCompilationUnitTree();
                            List<? extends Tree> typeDecls = tree.getTypeDecls();
                            if (typeDecls.isEmpty() || !(typeDecls.get(0) instanceof ClassTree)) {
                                return null;
                            }
                            Tree extendsClause = ((ClassTree)typeDecls.get(0)).getExtendsClause();
                            if (extendsClause == null) {
                                return Object.class;
                            }
                            this.addImports(tree);
                            return this.getClassObjectFromSimpleName(extendsClause.toString());
                        }
                        return null;
                    }
                }
            }
        };
    }
}

