/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zklinter.App;
import org.zkoss.zklinter.EmptyJavaFileVisitor;
import org.zkoss.zklinter.EmptyZulFileVisitor;
import org.zkoss.zklinter.JavaFileVisitor;
import org.zkoss.zklinter.JavaParser;
import org.zkoss.zklinter.ZulFileVisitor;
import org.zkoss.zklinter.ZulParser;

public abstract class Rule {
    protected String getName() {
        return this.getClass().getSimpleName();
    }

    protected abstract String getDescription();

    protected boolean isMVVMOnly() {
        return false;
    }

    protected ZulFileVisitor newZulFileVisitor() {
        return EmptyZulFileVisitor.INSTANCE;
    }

    protected JavaFileVisitor newJavaFileVisitor() {
        return EmptyJavaFileVisitor.INSTANCE;
    }

    protected static Map<String, List<String>> applyRules(File zulFile, App.Settings settings, Iterable<Rule> rules) {
        LinkedHashMap<String, List<String>> violations = new LinkedHashMap<String, List<String>>();
        ZulParser.ParsedZul parsedZul = ZulParser.parse(zulFile, settings);
        if (parsedZul == null) {
            return null;
        }
        HashSet parsedJavas = new HashSet();
        parsedZul.getViewModels().forEach(javaFile -> parsedJavas.addAll(JavaParser.parse(javaFile, settings)));
        Rule.addViolations(violations, parsedZul.getViolations());
        rules.forEach(rule -> {
            try {
                if (rule.isMVVMOnly() && !parsedZul.isMVVM()) {
                    return;
                }
                Rule.addViolations(violations, rule.newZulFileVisitor().visit(parsedZul));
                parsedJavas.forEach(parsedJava -> rule.newJavaFileVisitor().visit((JavaParser.ParsedJava)parsedJava, settings));
            }
            catch (Exception e) {
                String message = "Failed to apply " + rule.getName() + " rule to " + zulFile.getAbsolutePath();
                String horizontalLine = String.format("%" + message.length() + "s", "").replace(' ', '-');
                App.LOGGER.info(horizontalLine);
                App.LOGGER.error(message, (Throwable)e);
            }
        });
        parsedJavas.forEach(parsedJava -> Rule.addViolations(violations, parsedJava.getViolations()));
        violations.values().forEach(Collections::sort);
        return violations;
    }

    private static void addViolations(Map<String, List<String>> violations, Map<String, List<String>> newViolations) {
        newViolations.forEach((filename, messages) -> violations.computeIfAbsent((String)filename, k -> new ArrayList()).addAll(messages));
    }
}

