/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.zkoss.zklinter.App;

public class JavaParser {
    private static final JavaCompiler _compiler = ToolProvider.getSystemJavaCompiler();
    private static final StandardJavaFileManager _fileManager = _compiler.getStandardFileManager(null, null, null);

    private JavaParser() {
    }

    public static List<ParsedJava> parse(File file, App.Settings settings) {
        ArrayList<ParsedJava> parsedJavas = new ArrayList<ParsedJava>();
        JavaParser.parse(file, settings, parsedJavas);
        return parsedJavas;
    }

    private static void parse(File file, App.Settings settings, List<ParsedJava> parsedJavas) {
        File superClassFile;
        ParsedJava parsedJava = new ParsedJava(file, settings);
        try {
            JavacTask javacTask = (JavacTask)_compiler.getTask(null, _fileManager, null, null, null, _fileManager.getJavaFileObjectsFromFiles(Collections.singletonList(file)));
            parsedJava._rootNode = javacTask.parse().iterator().next();
            parsedJava._sourcePositions = Trees.instance(javacTask).getSourcePositions();
            parsedJava._leadingTabs = JavaParser.countLeadingTabs(file);
            parsedJavas.add(parsedJava);
        }
        catch (Exception e) {
            App.LOGGER.error("Failed to parse " + file.getAbsolutePath(), (Throwable)e);
            return;
        }
        CompilationUnitTree tree = parsedJava._rootNode;
        List<? extends Tree> typeDecls = tree.getTypeDecls();
        if (typeDecls.isEmpty() || !(typeDecls.get(0) instanceof ClassTree)) {
            return;
        }
        Tree extendsClause = ((ClassTree)typeDecls.get(0)).getExtendsClause();
        if (extendsClause == null) {
            return;
        }
        String superClassName = extendsClause.toString();
        int endIndex = superClassName.indexOf(60);
        if (endIndex >= 0) {
            superClassName = superClassName.substring(0, endIndex);
        }
        if ((superClassFile = file.getParentFile().toPath().resolve(superClassName + ".java").toFile()).exists()) {
            JavaParser.parse(superClassFile, settings, parsedJavas);
            return;
        }
        String singleClassImport = null;
        HashSet<String> onDemandImports = new HashSet<String>();
        for (ImportTree importTree : tree.getImports()) {
            String qualifiedIdentifier = importTree.getQualifiedIdentifier().toString();
            int i = qualifiedIdentifier.lastIndexOf(46);
            String packageName = qualifiedIdentifier.substring(0, i);
            String identifier = qualifiedIdentifier.substring(i + 1);
            if (superClassName.equals(identifier)) {
                singleClassImport = qualifiedIdentifier;
            }
            if (!"*".equals(identifier)) continue;
            onDemandImports.add(packageName);
        }
        if (singleClassImport == null) {
            for (String string : onDemandImports) {
                String relativePath = (string + "." + superClassName).replace('.', File.separatorChar) + ".java";
                superClassFile = settings.getJavaDir().resolve(relativePath).toFile();
                if (!superClassFile.exists()) continue;
                JavaParser.parse(superClassFile, settings, parsedJavas);
                return;
            }
            parsedJava.report(extendsClause, "Superclass " + superClassName + " not checked");
            return;
        }
        String relativePath = singleClassImport.replace('.', File.separatorChar) + ".java";
        superClassFile = settings.getJavaDir().resolve(relativePath).toFile();
        if (superClassFile.exists()) {
            JavaParser.parse(superClassFile, settings, parsedJavas);
        } else {
            parsedJava.report(extendsClause, "Superclass " + superClassName + " not checked");
        }
    }

    private static List<Integer> countLeadingTabs(File file) {
        ArrayList<Integer> tabs = new ArrayList<Integer>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                int i;
                for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
                }
                tabs.add(i);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tabs;
    }

    public static class ParsedJava {
        private final File _file;
        private final App.Settings _settings;
        private CompilationUnitTree _rootNode;
        private final Map<String, List<String>> _violations = new LinkedHashMap<String, List<String>>();
        private SourcePositions _sourcePositions;
        private List<Integer> _leadingTabs;

        private ParsedJava(File file, App.Settings settings) {
            this._file = file;
            this._settings = settings;
        }

        public CompilationUnitTree getCompilationUnitTree() {
            return this._rootNode;
        }

        public Map<String, List<String>> getViolations() {
            return this._violations;
        }

        public void report(Tree node, String message) {
            String filename = this._file.getAbsolutePath();
            LineMap lineMap = this._rootNode.getLineMap();
            long pos = this._sourcePositions.getStartPosition(this._rootNode, node);
            int lineNumber = (int)lineMap.getLineNumber(pos);
            int columnNumber = (int)lineMap.getColumnNumber(pos);
            this._violations.computeIfAbsent(filename, k -> new ArrayList()).add(String.format("%4d:%3d", lineNumber, columnNumber += (this._settings.getTabSize() - 8) * this._leadingTabs.get(lineNumber - 1)) + "\t" + message);
        }
    }
}

