/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.upgrade;

import java.util.Objects;
import javax.annotation.Nullable;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final DefaultScheme DEFAULT_SCHEME = new DefaultScheme();
    private static final SchemeWithPatchVersion PATCH_SCHEME = new SchemeWithPatchVersion();
    public static final VersionNumber UNKNOWN = VersionNumber.version(0);
    private final int _major;
    private final int _minor;
    private final int _micro;
    private final int _patch;
    private final String _qualifier;
    private final AbstractScheme _scheme;

    public VersionNumber(int major, int minor, int micro, @Nullable String qualifier) {
        this(major, minor, micro, 0, qualifier, DEFAULT_SCHEME);
    }

    public VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier) {
        this(major, minor, micro, patch, qualifier, PATCH_SCHEME);
    }

    private VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier, AbstractScheme scheme) {
        this._major = major;
        this._minor = minor;
        this._micro = micro;
        this._patch = patch;
        this._qualifier = qualifier;
        this._scheme = scheme;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getMicro() {
        return this._micro;
    }

    public int getPatch() {
        return this._patch;
    }

    @Nullable
    public String getQualifier() {
        return this._qualifier;
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this._major != other._major) {
            return this._major - other._major;
        }
        if (this._minor != other._minor) {
            return this._minor - other._minor;
        }
        if (this._micro != other._micro) {
            return this._micro - other._micro;
        }
        if (this._patch != other._patch) {
            return this._patch - other._patch;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this._major;
        result = 31 * result + this._minor;
        result = 31 * result + this._micro;
        result = 31 * result + this._patch;
        result = 31 * result + Objects.hashCode(this._qualifier);
        return result;
    }

    public String toString() {
        return this._scheme.format(this);
    }

    public static VersionNumber version(int major) {
        return VersionNumber.version(major, 0);
    }

    public static VersionNumber version(int major, int minor) {
        return VersionNumber.version(major, minor, 0);
    }

    public static VersionNumber version(int major, int minor, int micro) {
        return new VersionNumber(major, minor, micro, 0, null, DEFAULT_SCHEME);
    }

    public static VersionNumber parse(String versionString) {
        return DEFAULT_SCHEME.parse(versionString);
    }

    private static class SchemeWithPatchVersion
    extends AbstractScheme {
        private static final String VERSION_TEMPLATE = "%d.%d.%d.%d%s";

        private SchemeWithPatchVersion() {
            super(4);
        }

        @Override
        public String format(VersionNumber versionNumber) {
            return String.format(VERSION_TEMPLATE, versionNumber._major, versionNumber._minor, versionNumber._micro, versionNumber._patch, versionNumber._qualifier == null ? "" : "-" + versionNumber._qualifier);
        }
    }

    private static class DefaultScheme
    extends AbstractScheme {
        private static final String VERSION_TEMPLATE = "%d.%d.%d%s";

        public DefaultScheme() {
            super(3);
        }

        @Override
        public String format(VersionNumber versionNumber) {
            return String.format(VERSION_TEMPLATE, versionNumber._major, versionNumber._minor, versionNumber._micro, versionNumber._qualifier == null ? "" : "-" + versionNumber._qualifier);
        }
    }

    private static abstract class AbstractScheme
    implements Scheme {
        final int depth;

        protected AbstractScheme(int depth) {
            this.depth = depth;
        }

        @Override
        public VersionNumber parse(@Nullable String versionString) {
            if (versionString == null || versionString.isEmpty()) {
                return UNKNOWN;
            }
            Scanner scanner = new Scanner(versionString);
            if (!scanner.hasDigit()) {
                return UNKNOWN;
            }
            int minor = 0;
            int micro = 0;
            int patch = 0;
            int major = scanner.scanDigit();
            if (scanner.isSeparatorAndDigit('.')) {
                scanner.skipSeparator();
                minor = scanner.scanDigit();
                if (scanner.isSeparatorAndDigit('.')) {
                    scanner.skipSeparator();
                    micro = scanner.scanDigit();
                    if (this.depth > 3 && scanner.isSeparatorAndDigit('.', '_')) {
                        scanner.skipSeparator();
                        patch = scanner.scanDigit();
                    }
                }
            }
            if (scanner.isEnd()) {
                return new VersionNumber(major, minor, micro, patch, null, this);
            }
            if (scanner.isQualifier()) {
                scanner.skipSeparator();
                return new VersionNumber(major, minor, micro, patch, scanner.remainder(), this);
            }
            return UNKNOWN;
        }

        private static class Scanner {
            int pos;
            final String str;

            private Scanner(String string) {
                this.str = string;
            }

            boolean hasDigit() {
                return this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos));
            }

            boolean isSeparatorAndDigit(char ... separators) {
                return this.pos < this.str.length() - 1 && this.oneOf(separators) && Character.isDigit(this.str.charAt(this.pos + 1));
            }

            private boolean oneOf(char ... separators) {
                char current = this.str.charAt(this.pos);
                for (int i = 0; i < separators.length; ++i) {
                    char separator = separators[i];
                    if (current != separator) continue;
                    return true;
                }
                return false;
            }

            boolean isQualifier() {
                return this.pos < this.str.length() - 1 && this.oneOf('.', '-');
            }

            int scanDigit() {
                int start = this.pos;
                while (this.hasDigit()) {
                    ++this.pos;
                }
                return Integer.parseInt(this.str.substring(start, this.pos));
            }

            public boolean isEnd() {
                return this.pos == this.str.length();
            }

            public void skipSeparator() {
                ++this.pos;
            }

            @Nullable
            public String remainder() {
                return this.pos == this.str.length() ? null : this.str.substring(this.pos);
            }
        }
    }

    public static interface Scheme {
        public VersionNumber parse(String var1);

        public String format(VersionNumber var1);
    }
}

