/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.upgrade;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.zkoss.idom.Element;
import org.zkoss.util.Pair;
import org.zkoss.zklinter.Rule;
import org.zkoss.zklinter.ZulFileVisitor;
import org.zkoss.zklinter.upgrade.VersionNumber;

public class RemovedComponentsAndAttributes
extends Rule {
    protected static final List<Pair<VersionNumber, Map<String, RemovedComponent>>> _removedComponents;
    protected static final List<Pair<VersionNumber, Map<String, RemovedAttribute>>> _removedAttributes;
    private final VersionNumber _upgradeToVersion;

    private static Map<String, RemovedComponent> toComponentMap(List<RemovedComponent> components) {
        return components.stream().collect(Collectors.toMap(RemovedComponent::getName, Function.identity()));
    }

    private static Map<String, RemovedAttribute> toAttributeMap(List<RemovedAttribute> attributes) {
        return attributes.stream().collect(Collectors.toMap(RemovedAttribute::getName, Function.identity()));
    }

    public RemovedComponentsAndAttributes(VersionNumber upgradeToVersion) {
        this._upgradeToVersion = upgradeToVersion;
    }

    @Override
    protected String getDescription() {
        return "Check the components and attributes removed since ZK " + String.valueOf(this._upgradeToVersion);
    }

    @Override
    protected ZulFileVisitor newZulFileVisitor() {
        return new ZulFileVisitor(){

            @Override
            protected void visitElement(Element node) {
                StringBuilder message = new StringBuilder();
                String tagName = node.getTagName();
                for (Pair<VersionNumber, Map<String, RemovedComponent>> pair : _removedComponents) {
                    if (RemovedComponentsAndAttributes.this._upgradeToVersion.compareTo((VersionNumber)pair.x) < 0) break;
                    RemovedComponent component = (RemovedComponent)((Map)pair.y).get(tagName);
                    if (component == null) continue;
                    message.append(String.format("The component, <%s>, is no longer supported since ZK %s. ", component.getName(), pair.x));
                    message.append(component.getDescription());
                }
                if (message.length() == 0) {
                    NamedNodeMap attributes = node.getAttributes();
                    for (Pair<VersionNumber, Map<String, RemovedAttribute>> pair : _removedAttributes) {
                        if (RemovedComponentsAndAttributes.this._upgradeToVersion.compareTo((VersionNumber)pair.x) < 0) break;
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            String attrName = attributes.item(i).getLocalName();
                            RemovedAttribute attribute = (RemovedAttribute)((Map)pair.y).get(attrName);
                            if (attribute == null || !attribute.getComponents().contains(tagName)) continue;
                            message.append(String.format("The attribute, %s, in <%s> is no longer supported since ZK %s. ", attribute.getName(), tagName, pair.x));
                            message.append(attribute.getDescription());
                        }
                    }
                }
                if (message.length() > 0) {
                    this.report((Node)node, message.toString());
                }
            }
        };
    }

    static {
        List<RemovedComponent> componentsRemovedIn1020 = List.of(new RemovedComponent("fragment", "Removed since 10.2.0, use the new Client MVVM  (client-bind.jar) library instead"));
        List<RemovedAttribute> attributesRemovedIn1000 = List.of(new RemovedAttribute("autostart", List.of("audio"), "Deprecated since 7.0.0, use \"autoplay\" attribute instead."), new RemovedAttribute("widths", List.of("box", "hbox", "vbox"), "Deprecated since 5.0.0, put <cell width> inside instead."), new RemovedAttribute("heights", List.of("box", "hbox", "vbox"), "Deprecated since 5.0.0, put <cell height> inside instead."), new RemovedAttribute("timeZone", List.of("calendar"), "Deprecated since 5.0.5, please remove it."), new RemovedAttribute("border", List.of("captcha"), "Deprecated since 5.0.4, use \"frame\" attribute instead."), new RemovedAttribute("align", List.of("div", "grid", "iframe", "image"), "Deprecated since 5.0/6.0, use CSS instead e.g. align=\"left\" --> style=\"text-align:left\", align=\"right\" --> style=\"text-align:right\""), new RemovedAttribute("compact", List.of("datebox"), "Deprecated since 5.0.0, please remove it."), new RemovedAttribute("maxsize", List.of("fileupload"), "Deprecated since 5.0.0, specified it in \"upload\" attribute e.g. upload=\"maxsize=1024\""), new RemovedAttribute("number", List.of("fileupload"), "Deprecated since 5.0.0, specified it in \"upload\" attribute"), new RemovedAttribute("native", List.of("fileupload"), "Deprecated since 5.0.0, specified it in \"upload\" attribute e.g. upload=\"native\""), new RemovedAttribute("fixedLayout", List.of("grid", "listbox", "tree"), "Since 5.0.0, use \"sizedByContent\" attribute instead."), new RemovedAttribute("legend", List.of("groupbox"), "Deprecated since 6.0, please remove it."), new RemovedAttribute("hspace", List.of("image"), "Deprecated since 6.0.0, use CSS instead, style=\"margin-left:10px; margin-right:10px;\""), new RemovedAttribute("vspace", List.of("image"), "Deprecated since 6.0.0, use CSS instead, style=\"margin-top:10px; margin-bottom:10px;\""), new RemovedAttribute("hyphen", List.of("label"), "Deprecated since 5.0.0, use CSS instead, style=\"overflow-wrap: break-word;\""), new RemovedAttribute("flex", List.of("center", "east", "north", "south", "west"), "Deprecated since 6.0.2, use hflex or vflex on child components instead"), new RemovedAttribute("preloadSize", List.of("grid", "listbox"), "Deprecated since 5.0.8, use <custom-attributes org.zkoss.zul.listbox.preloadSize=\"\"> or <custom-attributes org.zkoss.zul.grid.preloadSize=\"\" instead."), new RemovedAttribute("checkable", List.of("listitem", "treeitem"), "Deprecated since 8.0.0, please use selectable"), new RemovedAttribute("framable", List.of("panel"), "Deprecated since 5.0.6, use \"border\" attribute instead."), new RemovedAttribute("spans", List.of("row", "group", "groupfoot"), "Deprecated since 5.0.0, use <cell colspan> instead."), new RemovedAttribute("type", List.of("script"), "Deprecated since 5.0.0, text/javascript is always assumed, please remove it."), new RemovedAttribute("dynamic", List.of("style"), "Deprecated since 5.0.0, it is decided by ZK automatically, please remove it."), new RemovedAttribute("treeitemRenderer", List.of("tree"), "Deprecated since 5.0.6, replaced with \"itemRenderer\" attribute"), new RemovedAttribute("defaultActionOnShow", List.of("window"), "Deprecated since 5.0.0, replaced with \"action\" attribute."), new RemovedAttribute("src", List.of("a", "button", "caption", "checkbox", "comboitem", "fisheye", "footer", "listfooter", "treefooter", "auheader", "column", "listheader", "treecol", "listcell", "menu", "menuitem", "nav", "navitem", "orgnode", "tab", "treecell"), "Deprecated since 3.5.0, use \"image\" instead."));
        _removedComponents = List.of(new Pair((Object)VersionNumber.version(10, 2, 0), RemovedComponentsAndAttributes.toComponentMap(componentsRemovedIn1020)));
        _removedAttributes = List.of(new Pair((Object)VersionNumber.version(10, 0, 0), RemovedComponentsAndAttributes.toAttributeMap(attributesRemovedIn1000)));
    }

    protected static class RemovedComponent {
        private final String _name;
        private final String _description;

        public RemovedComponent(String name, String description) {
            this._name = name;
            this._description = description;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return this._description;
        }
    }

    protected static class RemovedAttribute {
        private final String _name;
        private final List<String> _components;
        private final String _description;

        public RemovedAttribute(String name, List<String> components, String description) {
            this._name = name;
            this._components = components;
            this._description = description;
        }

        public String getName() {
            return this._name;
        }

        public List<String> getComponents() {
            return this._components;
        }

        public String getDescription() {
            return this._description;
        }
    }
}

