/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.impl.rule;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.zkoss.zklinter.JavaFileVisitor;
import org.zkoss.zklinter.MVVMOnlyRule;

public class PureGetter
extends MVVMOnlyRule {
    @Override
    public String getDescription() {
        return "In Client MVVM, getters must be pure, meaning they should only contain a simple return statement without any calculation or manipulation logic, please ensure your getter returns a literal, identifier, or another getter's result directly";
    }

    @Override
    public JavaFileVisitor newJavaFileVisitor() {
        return new JavaFileVisitor(){

            @Override
            protected void visitMethod(MethodTree node) {
                if (!node.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                    return;
                }
                if (!this.isGetter(String.valueOf(node.getName()))) {
                    return;
                }
                BlockTree body = node.getBody();
                if (body == null) {
                    return;
                }
                List<? extends StatementTree> statements = body.getStatements();
                if (statements.size() == 1 && statements.get(0).getKind() == Tree.Kind.RETURN) {
                    ExpressionTree returnedExpression = ((ReturnTree)statements.get(0)).getExpression();
                    switch (returnedExpression.getKind()) {
                        case IDENTIFIER: 
                        case MEMBER_SELECT: 
                        case NULL_LITERAL: 
                        case BOOLEAN_LITERAL: 
                        case CHAR_LITERAL: 
                        case INT_LITERAL: 
                        case LONG_LITERAL: 
                        case FLOAT_LITERAL: 
                        case DOUBLE_LITERAL: 
                        case STRING_LITERAL: {
                            return;
                        }
                        case METHOD_INVOCATION: {
                            String methodName = returnedExpression.toString();
                            int startIndex = methodName.lastIndexOf(46);
                            if (startIndex >= 0) {
                                methodName = methodName.substring(startIndex + 1);
                            }
                            if (!this.isGetter(methodName)) break;
                            return;
                        }
                    }
                }
                this.report(node.getBody(), PureGetter.this.getDescription());
            }

            private boolean isGetter(String methodName) {
                return methodName.length() >= 3 && methodName.startsWith("is") && Character.isUpperCase(methodName.charAt(2)) || methodName.length() >= 4 && methodName.startsWith("get") && Character.isUpperCase(methodName.charAt(3));
            }
        };
    }
}

