/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.impl.rule;

import java.util.Arrays;
import java.util.stream.Stream;
import org.w3c.dom.Node;
import org.zkoss.idom.Attribute;
import org.zkoss.zklinter.MVVMOnlyRule;
import org.zkoss.zklinter.ZulFileVisitor;

public class PaginalBinding
extends MVVMOnlyRule {
    @Override
    public String getDescription() {
        return this.getDescription("@init/load/save/bind(...)");
    }

    public String getDescription(String expression) {
        return "Client MVVM doesn't support server-side Paginal `paginal=\"" + expression + "\"`, please continue using server MVVM";
    }

    @Override
    public ZulFileVisitor newZulFileVisitor() {
        return new ZulFileVisitor(){

            @Override
            protected void visitAttribute(Attribute attribute) {
                Stream<String> bindAnnotations = Arrays.stream(new String[]{"@(", "@init", "@load", "@save", "@bind"});
                if (this.isInsideMVVM() && "paginal".equals(attribute.getLocalName()) && bindAnnotations.anyMatch(annotation -> attribute.getValue().startsWith((String)annotation))) {
                    this.report((Node)attribute, PaginalBinding.this.getDescription(attribute.getValue()));
                }
            }
        };
    }
}

