/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter.impl.rule;

import java.util.Arrays;
import java.util.stream.Stream;
import org.w3c.dom.Node;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Element;
import org.zkoss.zklinter.MVVMOnlyRule;
import org.zkoss.zklinter.ZulFileVisitor;

public class OnEvent
extends MVVMOnlyRule {
    @Override
    public String getDescription() {
        return this.getDescription("onXXX");
    }

    public String getDescription(String name) {
        return "Client MVVM doesn't support adding event listeners in zscript `" + name + "=\"...\"`, please use a command binding `" + name + "=\"@command(...)\"` instead";
    }

    @Override
    public ZulFileVisitor newZulFileVisitor() {
        return new ZulFileVisitor(){

            @Override
            protected void visitAttribute(Attribute attribute) {
                Stream<String> commandAnnotations;
                String name = attribute.getLocalName();
                if (this.isInsideMVVM() && name.length() >= 3 && name.startsWith("on") && Character.isUpperCase(name.charAt(2)) && (commandAnnotations = Arrays.stream(new String[]{"@(", "@command(", "@global-command("})).noneMatch(annotation -> attribute.getValue().startsWith((String)annotation))) {
                    this.report((Node)attribute, OnEvent.this.getDescription(attribute.getLocalName()));
                }
            }

            @Override
            protected void visitElement(Element component) {
                String name;
                if (this.isInsideMVVM() && "attribute".equals(component.getLocalName()) && (name = component.getAttribute("name")).length() >= 3 && name.startsWith("on") && Character.isUpperCase(name.charAt(2))) {
                    this.report((Node)component, OnEvent.this.getDescription(name));
                }
            }
        };
    }
}

