/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.xml.Locator;
import org.zkoss.zk.ui.metainfo.TreeBuilderFactory;
import org.zkoss.zklinter.App;
import org.zkoss.zklinter.ZulFileVisitor;

public class ZulParser {
    private final File _zulFile;
    private final App.Settings _settings;
    private final ParsedZul _parsedZul = new ParsedZul();

    private ZulParser(File file, App.Settings settings) {
        this._zulFile = file;
        this._settings = settings;
    }

    private void setNodePosition() {
        try (final BufferedReader reader = new BufferedReader(new FileReader(this._zulFile));){
            new ZulFileVisitor(){
                private int _readerLineNumber = 0;
                private String _readerCurrentLine = "";

                @Override
                protected void visitElement(Element node) {
                    Locator locator = node.getLocator();
                    int endLineNumber = locator.getLineNumber();
                    int endColumnNumber = locator.getColumnNumber();
                    StringBuilder buffer = new StringBuilder();
                    ArrayDeque<Integer> leadingSpacesStack = new ArrayDeque<Integer>();
                    ArrayDeque<Integer> lineStartIndexStack = new ArrayDeque<Integer>();
                    try {
                        int i = 0;
                        while (this._readerLineNumber <= endLineNumber) {
                            lineStartIndexStack.add(buffer.length());
                            if (i > 0) {
                                this._readerCurrentLine = reader.readLine();
                            }
                            buffer.append(' ').append((this._readerLineNumber < endLineNumber ? this._readerCurrentLine : this._readerCurrentLine.substring(0, endColumnNumber - 1)).stripLeading());
                            leadingSpacesStack.add(ZulParser.this.countLeadingSpaces(this._readerCurrentLine));
                            ++i;
                            ++this._readerLineNumber;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    --this._readerLineNumber;
                    int lineNumber = endLineNumber;
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = attributes.getLength() - 1; i >= 0; --i) {
                        int offset;
                        Attribute attribute = (Attribute)attributes.item(i);
                        String[] words = attribute.getValue().replaceAll("\\W+", " ").split("\\s+");
                        for (int j = words.length - 1; j >= 0; --j) {
                            offset = buffer.lastIndexOf(words[j]);
                            buffer.delete(offset, buffer.length());
                        }
                        offset = buffer.lastIndexOf(attribute.getLocalName());
                        buffer.delete(offset, buffer.length());
                        while (offset < (Integer)lineStartIndexStack.peekLast()) {
                            --lineNumber;
                            leadingSpacesStack.removeLast();
                            lineStartIndexStack.removeLast();
                        }
                        int columnNumber = (Integer)leadingSpacesStack.peekLast() + offset - (Integer)lineStartIndexStack.peekLast();
                        attribute.setUserData("file", (Object)ZulParser.this._zulFile.getAbsolutePath(), null);
                        attribute.setUserData("position", (Object)String.format("%4d:%3d", lineNumber, columnNumber), null);
                    }
                    int offset = buffer.lastIndexOf(node.getLocalName());
                    while (offset < (Integer)lineStartIndexStack.peekLast()) {
                        --lineNumber;
                        leadingSpacesStack.removeLast();
                        lineStartIndexStack.removeLast();
                    }
                    int columnNumber = (Integer)leadingSpacesStack.peekLast() + offset - (Integer)lineStartIndexStack.peekLast();
                    node.setUserData("file", (Object)ZulParser.this._zulFile.getAbsolutePath(), null);
                    node.setUserData("position", (Object)String.format("%4d:%3d", lineNumber, columnNumber), null);
                }
            }.visit(this._parsedZul);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int countLeadingSpaces(String line) {
        int spaces = 0;
        for (char c : line.toCharArray()) {
            if (c == ' ') {
                ++spaces;
                continue;
            }
            if (c != '\t') break;
            spaces += this._settings.getTabSize();
        }
        return spaces;
    }

    private void findAssociatedFiles() {
        this._parsedZul._violations = new ZulFileVisitor(){

            @Override
            protected void visitAttribute(Attribute attribute) {
                if ("viewModel".equals(attribute.getLocalName())) {
                    ZulParser.this._parsedZul._isMVVM = true;
                    String value = attribute.getValue().trim();
                    if (value.isEmpty()) {
                        return;
                    }
                    String relativePath = ZulParser.getJavaFilePath(value);
                    if (relativePath == null) {
                        if (ZulParser.this._settings.warnUncheckedVM()) {
                            this.report((Node)attribute, "ViewModel `" + value + "` is not checked because it's not a fully-qualified class name, please move the Java code to a separate Java file and supply its fully-qualified class name");
                        }
                        return;
                    }
                    File javaFile = ZulParser.this._settings.getJavaDir().resolve(relativePath).toFile();
                    if (javaFile.exists()) {
                        ZulParser.this._parsedZul.getViewModels().add(javaFile);
                    } else if (ZulParser.this._settings.warnUncheckedVM()) {
                        this.report((Node)attribute, "Failed to find ViewModel at " + javaFile.getAbsolutePath() + ", please check the supplied fully-qualified class name");
                    }
                }
            }

            @Override
            protected void visitElement(Element component) {
                File file;
                String filename;
                if (!this.isInsideMVVM()) {
                    return;
                }
                Attribute attribute = null;
                switch (component.getLocalName()) {
                    case "apply": {
                        attribute = component.getAttributeItem("templateURI");
                        break;
                    }
                    case "include": {
                        attribute = component.getAttributeItem("src");
                    }
                }
                if (attribute == null) {
                    return;
                }
                String relativePath = attribute.getValue().trim();
                if (relativePath.isEmpty()) {
                    return;
                }
                if (relativePath.startsWith("${") || relativePath.startsWith("@")) {
                    if (ZulParser.this._settings.warnUncheckedZul()) {
                        this.report((Node)attribute, "Zul file path evaluated at runtime using `" + relativePath + "` is not checked, please supply the relative path as a constant string (e.g. `src=\"/dir/file.zul\"`)");
                    }
                    return;
                }
                int endIndex = relativePath.indexOf(63);
                if (endIndex >= 0) {
                    relativePath = relativePath.substring(0, endIndex);
                }
                if ((filename = (file = ZulParser.this._zulFile.getParentFile().toPath().resolve(relativePath).toFile()).getName()).endsWith(".xul") || filename.endsWith(".zul")) {
                    if (file.exists()) {
                        ParsedZul parsedZul = ZulParser.parse(file, ZulParser.this._settings);
                        if (parsedZul == null) {
                            return;
                        }
                        component.getParentNode().appendChild(parsedZul.getRootNode().getRootElement().cloneNode(true));
                    } else if (ZulParser.this._settings.warnUncheckedZul()) {
                        this.report((Node)attribute, "Failed to find Zul file at " + file.getAbsolutePath());
                    }
                } else if (ZulParser.this._settings.warnUncheckedZul()) {
                    this.report((Node)attribute, "Skipped file at " + file.getAbsolutePath() + " as does not end with `.xul` or `.zul`");
                }
            }
        }.visit(this._parsedZul);
    }

    private static String getJavaFilePath(String value) {
        if (((String)value).contains("@id")) {
            value = ((String)value).substring(((String)value).indexOf("@init"));
        }
        int start = ((String)value).indexOf(39);
        int end = ((String)value).indexOf(39, start + 1);
        if (start == -1) {
            start = ((String)value).indexOf(34);
            end = ((String)value).indexOf(34, start + 1);
        }
        if (start == -1) {
            return null;
        }
        if (((String)(value = ((String)value).substring(start + 1, end).replace('.', File.separatorChar) + ".java")).contains("$") || !((String)value).contains(String.valueOf(File.separatorChar))) {
            return null;
        }
        return value;
    }

    protected static ParsedZul parse(File file, App.Settings settings) {
        try {
            if (file.length() == 0L) {
                String skippingMessage = "Skipping empty file " + file.getAbsolutePath();
                String horizontalLine = String.format("%" + skippingMessage.length() + "s", "").replace(' ', '-');
                App.LOGGER.info(horizontalLine);
                App.LOGGER.info(skippingMessage);
                return null;
            }
            ZulParser parser = new ZulParser(file, settings);
            parser._parsedZul._rootNode = TreeBuilderFactory.makeBuilder((String)"zul").parse(file);
            parser.setNodePosition();
            parser.findAssociatedFiles();
            return parser._parsedZul;
        }
        catch (Exception e) {
            String checkingMessage = "Checking " + file.getAbsolutePath();
            String horizontalLine = String.format("%" + checkingMessage.length() + "s", "").replace(' ', '-');
            App.LOGGER.info(horizontalLine);
            App.LOGGER.info(checkingMessage);
            App.LOGGER.error("Failed to parse " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    protected static class ParsedZul {
        private boolean _isMVVM = false;
        private Document _rootNode;
        private final Set<File> _viewModels = new HashSet<File>();
        private Map<String, List<String>> _violations;

        protected ParsedZul() {
        }

        protected boolean isMVVM() {
            return this._isMVVM;
        }

        protected Document getRootNode() {
            return this._rootNode;
        }

        protected Set<File> getViewModels() {
            return this._viewModels;
        }

        protected Map<String, List<String>> getViolations() {
            return this._violations;
        }
    }
}

