/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Element;
import org.zkoss.zklinter.ZulParser;

public class ZulFileVisitor {
    private static final Set<String> ZK_NAMESPACES = Set.of("zk", "zul", "http://www.zkoss.org/2005/zk", "http://www.zkoss.org/2005/zul");
    private Deque<Element> _currentPath = new ArrayDeque<Element>();
    private final Map<String, List<String>> _violations = new LinkedHashMap<String, List<String>>();

    protected Deque<Element> getCurrentPath() {
        return this._currentPath;
    }

    protected boolean isInsideMVVM() {
        return this.getCurrentPath().stream().anyMatch(element -> element.hasAttribute("viewModel"));
    }

    protected Map<String, List<String>> visit(ZulParser.ParsedZul parsedZul) {
        this.beforeAll();
        this.visitNode((Node)parsedZul.getRootNode());
        this.afterAll();
        return this._violations;
    }

    private void visitNode(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this._currentPath.addFirst(element);
            boolean isZkElement = false;
            String namespace = element.getNamespaceURI();
            if ("".equals(namespace) || ZK_NAMESPACES.contains(namespace)) {
                isZkElement = true;
                this.visitElement(element);
            }
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attribute attribute = (Attribute)attributes.item(i);
                namespace = attribute.getNamespaceURI();
                if ((!isZkElement || !"".equals(namespace)) && !ZK_NAMESPACES.contains(namespace)) continue;
                this.visitAttribute(attribute);
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.visitNode(children.item(i));
        }
        if (node.getNodeType() == 1) {
            this._currentPath.removeFirst();
        }
    }

    protected void beforeAll() {
    }

    protected void afterAll() {
    }

    protected void visitAttribute(Attribute node) {
    }

    protected void visitElement(Element node) {
    }

    protected void report(Node node, String message) {
        String filename = node.getUserData("file").toString();
        this._violations.computeIfAbsent(filename, k -> new ArrayList()).add(String.valueOf(node.getUserData("position")) + "\t" + message);
    }
}

