/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zklinter;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zklinter.Rule;
import org.zkoss.zklinter.impl.rule.FragmentComponent;
import org.zkoss.zklinter.impl.rule.WarnUncheckedVM;
import org.zkoss.zklinter.impl.rule.WarnUncheckedZul;
import org.zkoss.zklinter.upgrade.RemovedComponentsAndAttributes;
import org.zkoss.zklinter.upgrade.VersionNumber;

public class App {
    public static final Logger LOGGER = LoggerFactory.getLogger(App.class);

    private App() {
    }

    public static void main(String[] args) {
        Settings settings = Settings.readSettings("app.properties");
        if (settings == null) {
            return;
        }
        LOGGER.info("==============");
        LOGGER.info("Enabled rules:");
        LOGGER.info("==============");
        settings.getEnabledRules().forEach(rule -> LOGGER.info("[{}] {}", (Object)rule.getName(), (Object)rule.getDescription()));
        LOGGER.info("===========");
        LOGGER.info("Violations:");
        LOGGER.info("===========");
        try (Stream<Path> paths = Files.walk(settings.getZulDir(), new FileVisitOption[0]);){
            paths.map(Path::toFile).forEach(file -> {
                String filename = file.getName();
                if (filename.endsWith(".xul") || filename.endsWith(".zul")) {
                    try {
                        App.showViolations(file, Rule.applyRules(file, settings, settings.getEnabledRules()));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to check " + filename, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to walk `zulDir`", (Throwable)e);
        }
    }

    private static void showViolations(File file, Map<String, List<String>> violations) {
        if (violations == null) {
            return;
        }
        String checkingMessage = "Checking " + file.getAbsolutePath();
        String horizontalLine = String.format("%" + checkingMessage.length() + "s", "").replace(' ', '-');
        if (violations.isEmpty()) {
            LOGGER.debug(horizontalLine);
            LOGGER.debug(checkingMessage);
        } else {
            LOGGER.info(horizontalLine);
            LOGGER.info(checkingMessage);
            violations.forEach((filename, messages) -> {
                LOGGER.info(filename);
                messages.forEach(arg_0 -> ((Logger)LOGGER).warn(arg_0));
            });
        }
    }

    public static class Settings {
        private Path _zulDir;
        private Path _javaDir;
        private URLClassLoader _urlClassLoader;
        private int _tabSize;
        private boolean _warnUncheckedVM;
        private boolean _warnUncheckedZul;
        private final List<Rule> _enabledRules = new ArrayList<Rule>();

        public Path getZulDir() {
            return this._zulDir;
        }

        public Path getJavaDir() {
            return this._javaDir;
        }

        public URLClassLoader getUrlClassLoader() {
            return this._urlClassLoader;
        }

        public int getTabSize() {
            return this._tabSize;
        }

        public boolean warnUncheckedVM() {
            return this._warnUncheckedVM;
        }

        public boolean warnUncheckedZul() {
            return this._warnUncheckedZul;
        }

        public List<Rule> getEnabledRules() {
            return this._enabledRules;
        }

        public static Settings readSettings(String filename) {
            Properties properties = new Properties();
            try (InputStream inputStream = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
                properties.load(inputStream);
            }
            catch (Exception e) {
                LOGGER.error("Failed to read `" + filename + "`", (Throwable)e);
                return null;
            }
            Settings settings = new Settings();
            try {
                Path currentDir = Paths.get(System.getProperty("user.dir"), new String[0]);
                settings._zulDir = currentDir.resolve(properties.getProperty("zulDir")).toRealPath(new LinkOption[0]);
                settings._javaDir = currentDir.resolve(properties.getProperty("javaDir")).toRealPath(new LinkOption[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to find `zulDir` or `javaDir`", (Throwable)e);
                return null;
            }
            try {
                settings._tabSize = Integer.parseInt(properties.getProperty("tabSize", "4"));
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse `tabSize` as an integer", (Throwable)e);
                return null;
            }
            try {
                String homeDir = System.getProperty("user.home");
                String[] jarPaths = properties.getProperty("jarFiles", "").split(",");
                URL[] jarUrls = new URL[jarPaths.length];
                for (int i = 0; i < jarPaths.length; ++i) {
                    jarUrls[i] = new File(jarPaths[i].replaceFirst("^~", homeDir)).toURI().toURL();
                }
                settings._urlClassLoader = new URLClassLoader(jarUrls);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load `jarFiles`", (Throwable)e);
                return null;
            }
            try {
                LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
                ServiceLoader.load(Rule.class).forEach(rules::add);
                String versionString = properties.getProperty("upgradeToVersion", "").trim();
                if (!versionString.isEmpty()) {
                    VersionNumber version = VersionNumber.parse(versionString);
                    if (VersionNumber.UNKNOWN.equals(version)) {
                        LOGGER.error("Failed to parse `upgradeToVersion` as a version number");
                    } else {
                        rules.add(new RemovedComponentsAndAttributes(version));
                        if (VersionNumber.version(10, 2, 0).compareTo(version) <= 0) {
                            rules.removeIf(FragmentComponent.class::isInstance);
                        }
                    }
                }
                String customRules = properties.getProperty("customRules", "");
                for (String s : customRules.split(",")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    if (s.endsWith("*")) {
                        String prefix = s.substring(0, s.length() - 1);
                        Reflections reflections = new Reflections(prefix, new Scanner[]{Scanners.SubTypes});
                        for (Class ruleClass : reflections.getSubTypesOf(Rule.class)) {
                            if (Modifier.isAbstract(ruleClass.getModifiers())) continue;
                            rules.add((Rule)ruleClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        continue;
                    }
                    Class<?> clazz = Class.forName(s);
                    if (Rule.class.isAssignableFrom(clazz)) {
                        rules.add((Rule)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        continue;
                    }
                    LOGGER.error("Custom rule `{}` must extend Rule", (Object)clazz.getName());
                }
                String disabledRules = properties.getProperty("disabledRules", "");
                for (String s : disabledRules.split(",")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    if (s.endsWith("*")) {
                        String prefix = s.substring(0, s.length() - 1);
                        rules.removeIf(rule -> rule.getClass().getName().startsWith(prefix));
                        continue;
                    }
                    String suffix = s.substring(s.indexOf("*") + 1);
                    rules.removeIf(rule -> rule.getClass().getName().endsWith(suffix));
                }
                settings._warnUncheckedVM = rules.stream().anyMatch(WarnUncheckedVM.class::isInstance);
                settings._warnUncheckedZul = rules.stream().anyMatch(WarnUncheckedZul.class::isInstance);
                settings._enabledRules.addAll(rules);
                return settings;
            }
            catch (Exception e) {
                LOGGER.error("Failed to add `customRules` or disable `disabledRules`", (Throwable)e);
                return null;
            }
        }
    }
}

