/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.ui.comet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.ui.comet.CometServerPush;

class CometExtension
implements AuExtension {
    private ServletContext _ctx;

    private CometExtension() {
    }

    public void init(DHtmlUpdateServlet servlet) {
        this._ctx = servlet.getServletContext();
    }

    static void init(WebApp wapp) throws ServletException {
        if (DHtmlUpdateServlet.getAuExtension((WebApp)wapp, (String)"/comet") == null) {
            DHtmlUpdateServlet.addAuExtension((WebApp)wapp, (String)"/comet", (AuExtension)new CometExtension());
        }
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        Session sess = Sessions.getCurrent((boolean)false);
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        SessionCtrl sessCtrl = (SessionCtrl)sess;
        sessCtrl.notifyClientRequest(false);
        this.service0(sess, request, response);
        if (sessCtrl.isInvalidated()) {
            sessCtrl.invalidateNow();
        }
    }

    private void service0(Session sess, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String dtid = request.getParameter("dtid");
        if (dtid == null || dtid.length() == 0) {
            response.setHeader("ZK-Comet-Error", "DesktopID");
            return;
        }
        Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            response.setHeader("ZK-Comet-Error", "DesktopUnavailable");
            return;
        }
        WebManager.setDesktop((HttpServletRequest)request, (Desktop)desktop);
        DesktopCtrl desktopCtrl = (DesktopCtrl)desktop;
        ServerPush sp = desktopCtrl.getServerPush();
        if (!(sp instanceof CometServerPush)) {
            response.setHeader("ZK-Comet-Error", "Disabled");
            return;
        }
        CometServerPush cmsp = (CometServerPush)sp;
        String hibernate = request.getParameter("hibernate");
        if (hibernate != null && Boolean.valueOf(hibernate).booleanValue()) {
            cmsp.hibernate();
            response.setHeader("ZK-Comet-Error", "Hibernate");
            return;
        }
        if (cmsp.setBusy()) {
            response.setHeader("ZK-Comet-Error", "Busy");
            return;
        }
        ExecutionImpl exec = new ExecutionImpl(this._ctx, request, response, desktop, null);
        Runtime.init(exec);
        cmsp.processRequest((Execution)exec, null);
        if (desktopCtrl.piggyResponse(null, false) != null || desktopCtrl.scheduledServerPush()) {
            response.setHeader("ZK-Comet", "echo");
        }
    }
}

