/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.ui.comet;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.ui.comet.CometExtension;

public class CometServerPush
implements ServerPush {
    private static final Logger log = LoggerFactory.getLogger(CometServerPush.class);
    private static final int GIVEUP = -99;
    private Desktop _desktop;
    private final List<ThreadInfo> _pending = new LinkedList<ThreadInfo>();
    private ThreadInfo _active;
    private final Object _mutex = new Object();
    private AsyncInfo _ai;
    private ThreadInfo _ready;
    private boolean _busy;

    protected void startClientPush() {
        String script = this._desktop.getWebApp().getConfiguration().getPreference("CometServerPush.start", null);
        if (script == null) {
            script = this.getStartScript();
        }
        Clients.response((String)"zk.cometpush.start", (AuResponse)new AuScript(null, script));
    }

    protected void stopClientPush() {
        String script = this._desktop.getWebApp().getConfiguration().getPreference("CometServerPush.stop", null);
        if (script == null) {
            script = this.getStopScript();
        }
        Clients.response((String)"zk.cometpush.stop", (AuResponse)new AuScript(null, script));
    }

    protected String getStartScript() {
        return this.getStartScript("zkex");
    }

    protected String getStartScript(String zkediton) {
        boolean disabled = Boolean.valueOf(Library.getProperty((String)"org.zkoss.zkex.ui.comet.smartconnection.disabled", (String)"true"));
        int retryDelay = this.getIntPref("CometServerPush.retry.delay");
        int ajaxTimeout = this.getIntPref("CometServerPush.ajax.timeout");
        String retryCountStr = "-1";
        String s = this._desktop.getWebApp().getConfiguration().getPreference("CometServerPush.retry.count", null);
        if (s != null) {
            try {
                int retryCount = Integer.parseInt(s);
                retryCountStr = retryCount == -1 ? "Infinity" : String.valueOf(retryCount);
            }
            catch (NumberFormatException ex) {
                log.warn("Not a number specified at CometServerPush.retry.count");
            }
        }
        return "zk.load('zkex.cmsp');zk.afterLoad('zkex.cmsp', function(){" + zkediton + ".cmsp.start('" + this._desktop.getId() + "'," + disabled + ", " + retryCountStr + ", " + retryDelay + ", " + ajaxTimeout + ");});";
    }

    protected int getIntPref(String key) {
        String s = this._desktop.getWebApp().getConfiguration().getPreference(key, null);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                log.warn("Not a number specified at " + key);
            }
        }
        return -1;
    }

    protected String getStopScript() {
        return "zk.afterLoad('zkex.cmsp', function(){zkex.cmsp.stop('" + this._desktop.getId() + "');});";
    }

    public Desktop getDesktop() {
        return this._desktop;
    }

    public boolean isActive() {
        return this._active != null && this._active.nActive > 0;
    }

    public void start(Desktop desktop) {
        if (this._desktop != null) {
            log.warn("Ignored: Sever-push already started");
            return;
        }
        this._desktop = desktop;
        this.onStart();
        this.startClientPush();
    }

    public void resume() {
        if (this._desktop == null) {
            throw new IllegalStateException("ServerPush cannot be resumed without desktop, or has been stopped!call #start(desktop)} instead");
        }
        this.startClientPush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this._desktop == null) {
            log.warn("Ignored: Sever-push not started");
            return;
        }
        Execution exec = Executions.getCurrent();
        boolean inexec = exec != null && exec.getDesktop() == this._desktop;
        try {
            if (inexec && this._desktop.isAlive()) {
                this.stopClientPush();
            }
        }
        finally {
            this._desktop = null;
            this.wakePending();
            if (!inexec) {
                Object object = this._mutex;
                synchronized (object) {
                    this._mutex.notify();
                }
            }
        }
        this.onStop();
    }

    protected void onStart() {
        try {
            CometExtension.init(this._desktop.getWebApp());
        }
        catch (ServletException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    protected void onStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakePending() {
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            Iterator<ThreadInfo> iterator = this._pending.iterator();
            while (iterator.hasNext()) {
                ThreadInfo info;
                ThreadInfo threadInfo = info = iterator.next();
                synchronized (threadInfo) {
                    info.notify();
                }
            }
            this._pending.clear();
            this._pending.notify();
            this.cleanAsyncInfo();
        }
    }

    public void onPiggyback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Event> void schedule(EventListener<T> listener, T event, Scheduler<T> scheduler) {
        scheduler.schedule(listener, event);
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            this._pending.notify();
            this.cleanAsyncInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean setBusy() {
        boolean old = this._busy;
        boolean bl = this._busy = !old;
        if (old) {
            List<ThreadInfo> list = this._pending;
            synchronized (list) {
                Iterator<ThreadInfo> iterator = this._pending.iterator();
                while (iterator.hasNext()) {
                    ThreadInfo info;
                    ThreadInfo threadInfo = info = iterator.next();
                    synchronized (threadInfo) {
                        info.notify();
                    }
                }
                this._pending.clear();
                this._pending.notifyAll();
                this.cleanAsyncInfo();
            }
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void hibernate() {
        Desktop desktop = this._desktop;
        try {
            boolean inexec;
            Execution exec = Executions.getCurrent();
            boolean bl = inexec = exec != null && exec.getDesktop() == this._desktop;
            if (!inexec) {
                if (log.isDebugEnabled()) {
                    log.debug("hibernate the server push");
                }
                this.stop();
            }
        }
        finally {
            this._desktop = desktop;
        }
    }

    /*
     * Exception decompiling
     */
    protected void processRequest(Execution exec, AsyncInfo ai) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAsyncInfo() {
        if (this._ai != null && !this.isActive()) {
            List<ThreadInfo> list = this._pending;
            synchronized (list) {
                if (this._ai != null) {
                    this._ready = null;
                    this._ai.complete();
                    this._ai = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        boolean loop;
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            if (!log.isDebugEnabled()) return true;
            log.debug("Re-activate");
            return true;
        }
        ThreadInfo info = new ThreadInfo(curr);
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            if (this._desktop != null) {
                if (this._ready != null) {
                    info = this._ready;
                    this._ready.thread = curr;
                    this._ready = null;
                    this._pending.notify();
                } else {
                    this._pending.add(info);
                }
            }
        }
        do {
            loop = false;
            boolean bTimeout = false;
            boolean bDead = false;
            boolean interrupted = false;
            try {
                ThreadInfo threadInfo = info;
                synchronized (threadInfo) {
                    if (this._desktop != null) {
                        if (info.nActive == 0) {
                            info.wait(timeout <= 0L ? 600000L : timeout);
                        }
                        if (info.nActive <= 0) {
                            bTimeout = timeout > 0L;
                            boolean bl = bDead = this._desktop == null || !this._desktop.isAlive();
                            if (bTimeout || bDead) {
                                info.nActive = -99;
                                if (bDead) {
                                    throw new DesktopUnavailableException("Stopped");
                                }
                                boolean bl2 = false;
                                return bl2;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Executions.activate() took more than 10 minutes");
                            }
                            loop = true;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (bTimeout || bDead || interrupted) {
                    List<ThreadInfo> list2 = this._pending;
                    synchronized (list2) {
                        this._pending.remove(info);
                    }
                }
            }
        } while (loop);
        if (this._desktop == null) {
            throw new DesktopUnavailableException("Stopped");
        }
        Runtime.init(this._desktop);
        this._active = info;
        this.beforeUpdate(this._active);
        ((WebAppCtrl)this._desktop.getWebApp()).getUiEngine().beginUpdate(this._active.getExecution());
        if (!log.isDebugEnabled()) return true;
        log.debug("Activated");
        return true;
    }

    protected void beforeUpdate(ThreadInfo info) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            Execution exec = this._active.getExecution();
            this._active.exec = null;
            this._active.nActive = 0;
            this._active = null;
            if (exec != null) {
                try {
                    if (stop) {
                        this.stopClientPush();
                    }
                    ((WebAppCtrl)this._desktop.getWebApp()).getUiEngine().endUpdate(exec);
                }
                catch (Throwable ex) {
                    log.warn("Ignored error", ex);
                }
            }
            if (stop) {
                this._desktop = null;
                this.wakePending();
                stopped = true;
            }
            Object object = this._mutex;
            synchronized (object) {
                this._busy = false;
                this._mutex.notify();
            }
            this.cleanAsyncInfo();
        }
        if (log.isDebugEnabled()) {
            log.debug("Deactivate, and should be stopped [{}] ", (Object)stopped);
        }
        return stopped;
    }

    public static interface AsyncInfo {
        public void complete();
    }

    protected static class ThreadInfo {
        private Thread thread;
        private int nActive;
        private Execution exec;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        public void setActive(Execution exec) {
            this.nActive = 1;
            this.exec = exec;
        }

        public Execution getExecution() {
            return this.exec;
        }

        public String toString() {
            return "[" + String.valueOf(this.thread) + "," + this.nActive + "]";
        }
    }
}

