/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.io.IOException;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.zul.Sliderbuttons;
import org.zkoss.zkex.zul.event.RangeValueChangeEvent;
import org.zkoss.zul.impl.XulElement;

public class Rangeslider
extends XulElement
implements Disable {
    public static final String ON_RANGE_VALUE_CHANGE = "onRangeValueChange";
    private int _min = 0;
    private int _max = 100;
    private int _step = 1;
    private int _markScale = 0;
    private Map<Integer, String> _marks;
    private boolean _tooltipVisible = false;
    private boolean _disabled = false;
    private String _orient = "horizontal";

    public Rangeslider() {
        this.initSliderButtons();
    }

    protected void initSliderButtons() {
        Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
        if (btns == null) {
            btns = new Sliderbuttons();
            btns.applyProperties();
            btns.setParent((Component)this);
        }
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int min) {
        if (min < 0) {
            throw new WrongValueException("Negative min is not allowed: " + min);
        }
        if (min > this._max) {
            throw new WrongValueException("Min (" + min + ") should not be greater than max (" + this._max + ").");
        }
        if (this._min != min) {
            int startValue;
            this._min = min;
            this.smartUpdate("min", this._min);
            Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
            if (btns != null && (startValue = btns.getStartValue()) < min) {
                btns.setStartValue(startValue);
            }
        }
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int max) {
        if (max < 0) {
            throw new WrongValueException("Negative max is not allowed: " + max);
        }
        if (max < this._min) {
            throw new WrongValueException("Max (" + max + ") should not be less than min (" + this._min + ").");
        }
        if (this._max != max) {
            int endValue;
            this._max = max;
            this.smartUpdate("max", this._max);
            Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
            if (btns != null && (endValue = btns.getEndValue()) > max) {
                btns.setStartValue(endValue);
            }
        }
    }

    public int getStep() {
        return this._step;
    }

    public void setStep(int step) {
        if (step <= 0) {
            throw new WrongValueException("Non-positive step is not allowed: " + step);
        }
        if (this._step != step) {
            this._step = step;
            this.smartUpdate("step", this._step);
        }
    }

    public int getStartValue() {
        Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
        if (btns != null) {
            return btns.getStartValue();
        }
        return 0;
    }

    public void setStartValue(int value) {
        Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
        if (btns == null) {
            return;
        }
        int startValue = btns.getStartValue();
        if (startValue != value) {
            if (value < this._min) {
                value = this._min;
            } else if (value > this._max) {
                value = this._max;
            }
            btns.setStartValue(value);
        }
    }

    public int getEndValue() {
        Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
        if (btns != null) {
            return btns.getEndValue();
        }
        return 0;
    }

    public void setEndValue(int value) {
        Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
        if (btns == null) {
            return;
        }
        int startValue = btns.getEndValue();
        if (startValue != value) {
            if (value < this._min) {
                value = this._min;
            } else if (value > this._max) {
                value = this._max;
            }
            btns.setEndValue(value);
        }
    }

    public int getMarkScale() {
        return this._markScale == 0 && this._marks == null ? 20 : this._markScale;
    }

    public void setMarkScale(int markScale) {
        if (markScale < 0) {
            throw new WrongValueException("Negative markScale is not allowed: " + markScale);
        }
        if (this._marks != null && !this._marks.isEmpty() && markScale > 0) {
            throw new UiException("Not allowed to set markScale and marks at the same time.");
        }
        if (this._markScale != markScale) {
            this._markScale = markScale;
            this.smartUpdate("marks", this._markScale);
        }
    }

    public Map<Integer, String> getMarks() {
        return this._marks;
    }

    public void setMarks(Map<Integer, String> marks) {
        if (this._markScale > 0 && marks != null && !marks.isEmpty()) {
            throw new UiException("Not allowed to set markScale and marks at the same time.");
        }
        if (!Objects.equals(this._marks, marks)) {
            this._marks = marks;
            this.smartUpdate("marks", this._marks);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)orient, (Object)this._orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public void setTooltipVisible(boolean tooltipVisible) {
        if (!Objects.equals((Object)this._tooltipVisible, (Object)tooltipVisible)) {
            this._tooltipVisible = tooltipVisible;
            this.smartUpdate("tooltipVisible", this._tooltipVisible);
        }
    }

    public boolean isTooltipVisible() {
        return this._tooltipVisible;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Sliderbuttons)) {
            throw new UiException("Unsupported child for Rangeslider " + String.valueOf(child));
        }
        if (this.getChildren().size() >= 1) {
            throw new UiException("Unsupported child for more than one SliderButtons " + String.valueOf(child));
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)this);
        super.renderProperties(renderer);
        if (this._min != 0) {
            renderer.render("min", this._min);
        }
        if (this._max != 100) {
            renderer.render("max", this._max);
        }
        if (this._step > 1) {
            renderer.render("step", this._step);
        }
        if (this._marks != null && !this._marks.isEmpty()) {
            renderer.render("marks", this._marks);
        } else if (this._markScale != 0) {
            renderer.render("marks", this._markScale);
        }
        if (this._disabled) {
            renderer.render("disabled", true);
        }
        if (!"horizontal".equals(this._orient)) {
            renderer.render("orient", this._orient);
        }
        if (this._tooltipVisible) {
            renderer.render("tooltipVisible", this._tooltipVisible);
        }
    }

    public void service(AuRequest request, boolean everError) {
        if (ON_RANGE_VALUE_CHANGE.equals(request.getCommand())) {
            Sliderbuttons btns = (Sliderbuttons)this.getFirstChild();
            if (btns == null) {
                return;
            }
            RangeValueChangeEvent event = RangeValueChangeEvent.getRangeValueChangeEvent(request);
            btns.setStartValueDirectly(event.getStartValue());
            btns.setEndValueDirectly(event.getEndValue());
            Events.postEvent((Event)event);
        } else {
            super.service(request, everError);
        }
    }

    protected void handleOtherButtonsValues(Sliderbuttons child) {
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-rangeslider";
    }

    static {
        Rangeslider.addClientEvent(Rangeslider.class, (String)ON_RANGE_VALUE_CHANGE, (int)8193);
    }
}

