/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.zul.ListModelSharer;
import org.zkoss.zkex.zul.impl.Operation;
import org.zkoss.zkex.zul.impl.OperationQueue;
import org.zkoss.zkex.zul.impl.OperationQueueListener;
import org.zkoss.zkex.zul.impl.OperationThread;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class SimpleListModelSharer<T>
implements ListModelSharer<T> {
    private static final Logger log = LoggerFactory.getLogger(SimpleListModelSharer.class);
    private static final int OP_ADD = 1;
    private static final int OP_REMOVE = 2;
    private static final int OP_SET = 3;
    private List<ProxyModel<T>> _proxys = new LinkedList<ProxyModel<T>>();
    private List<T> _innerData;
    private ListModel<T> _srcModel;
    private ListDataListener _srcListener;

    public SimpleListModelSharer(ListModel<T> model) {
        this._srcModel = model;
        this.init();
    }

    private void init() {
        this._innerData = Collections.synchronizedList(new LinkedList());
        int size = this._srcModel.getSize();
        for (int i = 0; i < size; ++i) {
            this._innerData.add(this._srcModel.getElementAt(i));
        }
        this._srcListener = new ListDataListener(){

            public void onChange(ListDataEvent event) {
                SimpleListModelSharer.this.onListDataChange(event);
            }
        };
        this._srcModel.addListDataListener(this._srcListener);
    }

    private void onListDataChange(ListDataEvent event) {
        int index1;
        Runtime.init(this);
        int type = event.getType();
        ListModel model = event.getModel();
        if (this._srcModel != model) {
            return;
        }
        int index0 = event.getIndex0();
        int min = index0 > (index1 = event.getIndex1()) ? index1 : index0;
        int max = index0 > index1 ? index0 : index1;
        switch (type) {
            case 0: {
                int start = min < 0 ? 0 : min;
                int end = max < 0 ? this._srcModel.getSize() : max;
                for (int i = start; i <= end; ++i) {
                    Object obj = this._srcModel.getElementAt(i);
                    this._innerData.set(i, obj);
                    this.putToQueue(3, i, obj);
                }
                break;
            }
            case 1: {
                int start = min < 0 ? 0 : min;
                int end = max < 0 ? this._srcModel.getSize() : max;
                for (int i = start; i <= end; ++i) {
                    Object obj = this._srcModel.getElementAt(i);
                    this._innerData.add(i, obj);
                    this.putToQueue(1, i, obj);
                }
                break;
            }
            case 2: {
                int end;
                int start = min < 0 ? 0 : min;
                for (int i = end = max < 0 ? this._srcModel.getSize() : max; i >= start; --i) {
                    this._innerData.remove(i);
                    this.putToQueue(2, i, null);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknow Event Type:" + type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListModel<T> getProxy(Desktop desktop) {
        ProxyModel<T> proxy;
        if (log.isDebugEnabled()) {
            log.debug("create proxy model for:" + String.valueOf(desktop));
        }
        List<ProxyModel<T>> list = this._proxys;
        synchronized (list) {
            proxy = new ProxyModel<T>(this._innerData);
            QueueListener oql = new QueueListener(desktop, proxy);
            proxy.setOperationQueueListener(oql);
            OperationQueue queue = OperationThread.getQueue(desktop);
            queue.addListener(oql);
            proxy.setQueue(queue);
            this._proxys.add(proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProxyCount() {
        List<ProxyModel<T>> list = this._proxys;
        synchronized (list) {
            return this._proxys.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyProxy(Desktop desktop, ListModel model, boolean rmQueueListener) {
        if (!(model instanceof ProxyModel)) {
            throw new IllegalArgumentException("Not a created proxy model:" + String.valueOf(model.getClass()));
        }
        List<ProxyModel<T>> list = this._proxys;
        synchronized (list) {
            if (this._proxys.remove(model)) {
                if (log.isDebugEnabled()) {
                    log.debug("destory proxy model for:" + String.valueOf(desktop));
                }
                ((ProxyModel)model).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToQueue(int op, int index, T value) {
        List<ProxyModel<T>> list = this._proxys;
        synchronized (list) {
            for (ProxyModel<T> model : this._proxys) {
                ListModelOperation lmop = new ListModelOperation(op, index, value, model);
                OperationQueue queue = model.getQueue();
                if (queue == null) continue;
                queue.put(lmop);
            }
        }
    }

    private static class ProxyModel<T>
    extends AbstractListModel<T> {
        private OperationQueue _queue;
        private OperationQueueListener _oqListener;
        List<T> _proxyedData;

        OperationQueue getQueue() {
            return this._queue;
        }

        void setQueue(OperationQueue queue) {
            this._queue = queue;
        }

        ProxyModel(Collection<T> c) {
            this._proxyedData = Collections.synchronizedList(new LinkedList<T>(c));
        }

        void clear() {
            if (this._queue != null && this._oqListener != null) {
                this._queue.removeListener(this._oqListener);
            }
            this._queue = null;
            this._oqListener = null;
            this._proxyedData.clear();
            this.clearSelection();
        }

        void add(int index, T element) {
            this._proxyedData.add(index, element);
            this.fireEvent(1, index, index);
        }

        T remove(int index) {
            T obj = this._proxyedData.remove(index);
            this.removeFromSelection(obj);
            this.fireEvent(2, index, index);
            return obj;
        }

        T set(int index, T element) {
            T obj = this._proxyedData.set(index, element);
            this.fireEvent(0, index, index);
            return obj;
        }

        void setOperationQueueListener(OperationQueueListener oql) {
            this._oqListener = oql;
        }

        public T getElementAt(int index) {
            return this._proxyedData.get(index);
        }

        public int getSize() {
            return this._proxyedData.size();
        }
    }

    private class ListModelOperation
    implements Operation {
        int _op;
        int _index;
        T _value;
        ProxyModel<T> _model;

        ListModelOperation(int op, int index, T value, ProxyModel<T> model) {
            this._op = op;
            this._index = index;
            this._value = value;
            this._model = model;
        }

        @Override
        public void execute(Desktop desktop) {
            switch (this._op) {
                case 1: {
                    this._model.add(this._index, this._value);
                    break;
                }
                case 2: {
                    this._model.remove(this._index);
                    break;
                }
                case 3: {
                    this._model.set(this._index, this._value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknow operation:" + this._op);
                }
            }
        }

        @Override
        public void failToExecute(Desktop desktop) {
            SimpleListModelSharer.this.destroyProxy(desktop, (ListModel)this._model, true);
        }
    }

    private class QueueListener
    implements OperationQueueListener {
        Desktop _desktop;
        ProxyModel _proxy;

        QueueListener(Desktop desktop, ProxyModel proxy) {
            this._desktop = desktop;
            this._proxy = proxy;
        }

        @Override
        public void queueUnavailable(Desktop desktop) {
            if (this._desktop == desktop) {
                SimpleListModelSharer.this.destroyProxy(desktop, (ListModel)this._proxy, false);
            }
        }
    }
}

