/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.bind.impl;

import java.util.HashSet;
import java.util.Set;
import org.zkoss.bind.impl.AbstractBindingHandler;
import org.zkoss.bind.impl.ReferenceBindingHandler;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.zk.ui.Component;

public class ReferenceBindingHandlerImpl
extends AbstractBindingHandler
implements ReferenceBindingHandler {
    private static final long serialVersionUID = 1L;
    private static final String REFERENCE_SET = "$REF_SET$";

    public void addReferenceBinding(Component comp, String attr, ReferenceBinding binding) {
        comp.setAttribute(attr, (Object)binding);
        HashSet<String> refs = (HashSet<String>)comp.getAttribute(REFERENCE_SET, 0);
        if (refs == null) {
            refs = new HashSet<String>();
            comp.setAttribute(REFERENCE_SET, refs);
        }
        refs.add(attr);
    }

    public void removeReferenceBinding(Component comp) {
        Set refs = (Set)comp.removeAttribute(REFERENCE_SET);
        if (refs != null) {
            for (String attr : refs) {
                comp.removeAttribute(attr);
            }
        }
    }

    public void removeReferenceBinding(Component comp, String attr) {
        Set refs = (Set)comp.getAttribute(REFERENCE_SET, 0);
        if (refs != null) {
            if (refs.remove(attr)) {
                comp.removeAttribute(attr);
            }
            if (refs.size() == 0) {
                comp.removeAttribute(REFERENCE_SET);
            }
        }
    }
}

