/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ObjectPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.ui.event.RotationEvent;
import org.zkoss.zkex.ui.event.ZoomEvent;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Pdfviewer
extends XulElement
implements Pageable {
    private String _src;
    private Media _content;
    private byte _contentVersion;
    private int _pageCount = 1;
    private int _activePage;
    private ZoomMode _zoomMode = ZoomMode.NORMAL;
    private double _zoom = 1.0;
    private int _rotation;
    private Toolbar _toolbar;
    private static final Map<String, PropertyAccess<?>> _properties;

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._content = null;
            if (this.isInitialized()) {
                this._activePage = 0;
            }
            this.smartUpdate("src", this::getEncodedSrc);
        }
    }

    public Media getContent() {
        return this._content;
    }

    public void setContent(Media content) {
        if (this._src != null || content != this._content) {
            this._content = content;
            this._src = null;
            if (this._content != null) {
                this._contentVersion = (byte)(this._contentVersion + 1);
            }
            if (this.isInitialized()) {
                this._activePage = 0;
            }
            this.smartUpdate("src", this::getEncodedSrc);
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        if (this._content != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._contentVersion, (String)this._content.getName(), (String)this._content.getFormat());
        }
        if (dt != null) {
            return dt.getExecution().encodeURL(this._src);
        }
        return null;
    }

    public int getActivePage() {
        return this._activePage;
    }

    public void setActivePage(int page) throws WrongValueException {
        if (page < 0) {
            throw new WrongValueException("Page cannot be negative: " + page);
        }
        if (this._activePage != page) {
            this._activePage = page;
            this.smartUpdate("activePage", this._activePage);
        }
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        if (zoom <= 0.0) {
            throw new WrongValueException("Zoom should be positive: " + zoom);
        }
        this.setZoomMode(ZoomMode.NORMAL);
        if (this._zoom != zoom) {
            this._zoom = zoom;
            this.smartUpdate("zoom", this._zoom);
        }
    }

    public void setZoom(String zoom) {
        switch (zoom) {
            case "fit-page-width": {
                this.setZoomMode(ZoomMode.FIT_PAGE_WIDTH);
                break;
            }
            case "fit-page-height": {
                this.setZoomMode(ZoomMode.FIT_PAGE_HEIGHT);
                break;
            }
            default: {
                throw new WrongValueException("Only fit-page-width and fit-page-height are supported, given " + zoom);
            }
        }
    }

    private void setZoomMode(ZoomMode mode) {
        if (this._zoomMode != mode) {
            this._zoomMode = mode;
            this.smartUpdate("zoomMode", (Object)mode);
        }
    }

    public int getRotation() {
        return this._rotation;
    }

    public void setRotation(int rotation) {
        if (rotation < 0 || rotation >= 360) {
            throw new WrongValueException("invalid degrees: " + rotation);
        }
        if (rotation % 90 != 0) {
            throw new WrongValueException("support multiple of 90 degrees only: " + rotation);
        }
        if (this._rotation != rotation) {
            this._rotation = rotation;
            this.smartUpdate("rotation", this._rotation);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)this);
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedSrc());
        if (this._activePage != 0) {
            this.render(renderer, "activePage", this._activePage);
        }
        if (this._zoom != 1.0) {
            this.render(renderer, "zoom", this._zoom);
        }
        if (this._zoomMode != ZoomMode.NORMAL) {
            this.render(renderer, "zoomMode", this._zoomMode.toString());
        }
        if (this._rotation != 0) {
            this.render(renderer, "rotation", this._rotation);
        }
    }

    public int getPageSize() {
        return 1;
    }

    public void setPageSize(int size) throws WrongValueException {
        throw new UnsupportedOperationException("readonly");
    }

    public int getPageCount() {
        return this._pageCount;
    }

    public boolean firstPage() {
        this.setActivePage(0);
        return true;
    }

    public boolean previousPage() {
        int targetPage = this._activePage - 1;
        if (targetPage >= 0) {
            this.setActivePage(targetPage);
            return true;
        }
        return false;
    }

    public boolean nextPage() {
        int targetPage = this._activePage + 1;
        if (targetPage < this._pageCount) {
            this.setActivePage(targetPage);
            return true;
        }
        return false;
    }

    public boolean lastPage() {
        this.setActivePage(this.getPageCount() - 1);
        return true;
    }

    public boolean zoomIn() {
        this.setZoom(this._zoom + 0.1);
        return true;
    }

    public boolean zoomOut() {
        double newValue = this._zoom - 0.1;
        if (newValue > 0.0) {
            this.setZoom(newValue);
            return true;
        }
        return false;
    }

    public void rotateClockwise() {
        this.setRotation((this._rotation + 90) % 360);
    }

    public void rotateCounterclockwise() {
        int newValue = this._rotation - 90;
        if (newValue < 0) {
            newValue = 270;
        }
        this.setRotation(newValue);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        switch (cmd) {
            case "onRender": {
                this._pageCount = AuRequests.getInt((Map)data, (String)"pageCount", (int)0);
                Events.postEvent((Event)Event.getEvent((AuRequest)request));
                break;
            }
            case "onPaging": {
                PagingEvent pagingEvent = PagingEvent.getPagingEvent((AuRequest)request);
                this._activePage = pagingEvent.getActivePage();
                Events.postEvent((Event)pagingEvent);
                break;
            }
            case "onZoom": {
                ZoomEvent zoomEvent = ZoomEvent.getZoomEvent(request);
                this._zoom = zoomEvent.getZoom();
                this._zoomMode = ZoomMode.getEnum(String.valueOf(data.get("mode")));
                Events.postEvent((Event)zoomEvent);
                break;
            }
            case "onRotate": {
                RotationEvent rotationEvent = RotationEvent.getRotationEvent(request);
                this._rotation = rotationEvent.getRotation();
                Events.postEvent((Event)rotationEvent);
                break;
            }
            default: {
                super.service(request, everError);
            }
        }
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (!(child instanceof Toolbar)) {
            throw new UiException("Unsupported child: " + String.valueOf(child));
        }
        if (this._toolbar != null) {
            throw new UiException("Only one toolbar is allowed: " + String.valueOf((Object)this));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (child instanceof Toolbar) {
            this._toolbar = (Toolbar)child;
        }
    }

    public void onChildRemoved(Component child) {
        if (this._toolbar == child) {
            this._toolbar = null;
        }
        super.onChildRemoved(child);
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-pdfviewer";
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public PropertyAccess<?> getPropertyAccess(String prop) {
        PropertyAccess<?> pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        Pdfviewer.addClientEvent(Pdfviewer.class, (String)"onPaging", (int)8193);
        Pdfviewer.addClientEvent(Pdfviewer.class, (String)"onRender", (int)1);
        Pdfviewer.addClientEvent(Pdfviewer.class, (String)"onZoom", (int)8193);
        Pdfviewer.addClientEvent(Pdfviewer.class, (String)"onRotate", (int)8193);
        _properties = new HashMap(1);
        _properties.put("zoom", (PropertyAccess<?>)new ObjectPropertyAccess(){

            public void setValue(Component cmp, Object value) {
                Pdfviewer self = (Pdfviewer)cmp;
                String val = String.valueOf(value);
                try {
                    double zoom = Double.parseDouble(val);
                    self.setZoom(zoom);
                }
                catch (NumberFormatException ignored) {
                    self.setZoom(val);
                }
            }

            public Object getValue(Component cmp) {
                return ((Pdfviewer)cmp).getZoom();
            }
        });
    }

    private static enum ZoomMode {
        NORMAL,
        FIT_PAGE_WIDTH,
        FIT_PAGE_HEIGHT;


        public String toString() {
            return super.toString().toLowerCase().replace('_', '-');
        }

        public static ZoomMode getEnum(String mode) {
            switch (mode) {
                case "fit-page-width": {
                    return FIT_PAGE_WIDTH;
                }
                case "fit-page-height": {
                    return FIT_PAGE_HEIGHT;
                }
            }
            return NORMAL;
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Pdfviewer.this);
        }

        public Media getMedia(String pathInfo) {
            return Pdfviewer.this._content;
        }
    }
}

