/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import javax.swing.filechooser.FileFilter;
import org.zkoss.zkex.license.CipherParam;
import org.zkoss.zkex.license.LicenseContent;
import org.zkoss.zkex.license.LicenseContentException;
import org.zkoss.zkex.license.LicenseCreator;
import org.zkoss.zkex.license.LicenseNotary;
import org.zkoss.zkex.license.LicenseParam;
import org.zkoss.zkex.license.LicenseVerifier;
import org.zkoss.zkex.license.NoLicenseInstalledException;
import org.zkoss.zkex.license.Policy;
import org.zkoss.zkex.license.PrivacyGuard;
import org.zkoss.zkex.license.Resources;
import org.zkoss.zkex.util.ObfuscatedString;
import org.zkoss.zkex.xml.GenericCertificate;

public class LicenseManager
implements LicenseCreator,
LicenseVerifier {
    private static final long TIMEOUT = 1800000L;
    private static final String PREFERENCES_KEY = new ObfuscatedString(new long[]{-2999492566024573771L, -1728025856628382701L}).toString();
    public static final String LICENSE_SUFFIX = new ObfuscatedString(new long[]{-7559156485370438418L, 5084921010819724770L}).toString();
    private static final String PARAM;
    private static final String SUBJECT;
    private static final String KEY_STORE_PARAM;
    private static final String CIPHER_PARAM;
    protected static final String CN;
    private static final String CN_USER;
    private static final String USER;
    private static final String SYSTEM;
    private static final String EXC_INVALID_SUBJECT;
    private static final String EXC_HOLDER_IS_NULL;
    private static final String EXC_ISSUER_IS_NULL;
    private static final String EXC_ISSUED_IS_NULL;
    private static final String EXC_LICENSE_IS_NOT_YET_VALID;
    private static final String EXC_LICENSE_HAS_EXPIRED;
    private static final String EXC_CONSUMER_TYPE_IS_NULL;
    private static final String EXC_CONSUMER_TYPE_IS_NOT_USER;
    private static final String EXC_CONSUMER_AMOUNT_IS_NOT_ONE;
    private static final String EXC_CONSUMER_AMOUNT_IS_NOT_POSITIVE;
    private static final String FILE_FILTER_DESCRIPTION;
    private static final String FILE_FILTER_SUFFIX;
    private LicenseParam param;
    private LicenseNotary notary;
    private PrivacyGuard guard;
    private GenericCertificate certificate;
    private long certificateTime;
    private FileFilter fileFilter;
    private Preferences preferences;

    protected static Date midnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    protected LicenseManager() {
    }

    public LicenseManager(LicenseParam param) {
        this.setLicenseParam0(param);
    }

    public LicenseParam getLicenseParam() {
        return this.param;
    }

    public synchronized void setLicenseParam(LicenseParam param) {
        this.setLicenseParam0(param);
    }

    private void setLicenseParam0(LicenseParam param) {
        if (param == null) {
            throw new NullPointerException(PARAM);
        }
        if (param.getSubject() == null) {
            throw new NullPointerException(SUBJECT);
        }
        if (param.getKeyStoreParam() == null) {
            throw new NullPointerException(KEY_STORE_PARAM);
        }
        CipherParam cipherParam = param.getCipherParam();
        if (cipherParam == null) {
            throw new NullPointerException(CIPHER_PARAM);
        }
        Policy.getCurrent().checkPwd(cipherParam.getKeyPwd());
        this.param = param;
        this.notary = null;
        this.certificate = null;
        this.certificateTime = 0L;
        this.fileFilter = null;
        this.preferences = null;
    }

    public final synchronized void store(LicenseContent content, File keyFile) throws Exception {
        this.store(content, this.getLicenseNotary(), keyFile);
    }

    protected synchronized void store(LicenseContent content, LicenseNotary notary, File keyFile) throws Exception {
        LicenseManager.storeLicenseKey(this.create(content, notary), keyFile);
    }

    @Override
    public final synchronized byte[] create(LicenseContent content) throws Exception {
        return this.create(content, this.getLicenseNotary());
    }

    protected synchronized byte[] create(LicenseContent content, LicenseNotary notary) throws Exception {
        this.initialize(content);
        this.validate(content);
        GenericCertificate certificate = notary.sign(content);
        byte[] key = this.getPrivacyGuard().cert2key(certificate);
        return key;
    }

    public final synchronized LicenseContent install(File keyFile) throws Exception {
        return this.install(keyFile, this.getLicenseNotary());
    }

    protected synchronized LicenseContent install(File keyFile, LicenseNotary notary) throws Exception {
        return this.install(LicenseManager.loadLicenseKey(keyFile), notary);
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return content;
    }

    public final synchronized LicenseContent verify() throws Exception {
        return this.verify(this.getLicenseNotary());
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getCertificate();
        if (certificate != null) {
            return (LicenseContent)certificate.getContent();
        }
        byte[] key = this.getLicenseKey();
        if (key == null) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        this.setCertificate(certificate);
        return content;
    }

    @Override
    public final synchronized LicenseContent verify(byte[] key) throws Exception {
        return this.verify(key, this.getLicenseNotary());
    }

    protected synchronized LicenseContent verify(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        return content;
    }

    public synchronized void uninstall() throws Exception {
        this.setLicenseKey(null);
        this.setCertificate(null);
    }

    protected synchronized void initialize(LicenseContent content) {
        Preferences prefs;
        if (content.getHolder() == null) {
            content.setHolder(new X500Principal(CN_USER));
        }
        if (content.getSubject() == null) {
            content.setSubject(this.getLicenseParam().getSubject());
        }
        if (content.getConsumerType() == null && (prefs = this.getLicenseParam().getPreferences()) != null) {
            if (prefs.isUserNode()) {
                content.setConsumerType(USER);
            } else {
                content.setConsumerType(SYSTEM);
            }
            content.setConsumerAmount(1);
        }
        if (content.getIssuer() == null) {
            content.setIssuer(new X500Principal(CN + this.getLicenseParam().getSubject()));
        }
        if (content.getIssued() == null) {
            content.setIssued(new Date());
        }
        if (content.getNotBefore() == null) {
            content.setNotBefore(LicenseManager.midnight());
        }
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        LicenseParam param = this.getLicenseParam();
        if (!param.getSubject().equals(content.getSubject())) {
            throw new LicenseContentException(EXC_INVALID_SUBJECT);
        }
        if (content.getHolder() == null) {
            throw new LicenseContentException(EXC_HOLDER_IS_NULL);
        }
        if (content.getIssuer() == null) {
            throw new LicenseContentException(EXC_ISSUER_IS_NULL);
        }
        if (content.getIssued() == null) {
            throw new LicenseContentException(EXC_ISSUED_IS_NULL);
        }
        String consumerType = content.getConsumerType();
        if (consumerType == null) {
            throw new LicenseContentException(EXC_CONSUMER_TYPE_IS_NULL);
        }
        Preferences prefs = param.getPreferences();
        if (prefs != null && prefs.isUserNode()) {
            if (!USER.equalsIgnoreCase(consumerType)) {
                throw new LicenseContentException(EXC_CONSUMER_TYPE_IS_NOT_USER);
            }
            if (content.getConsumerAmount() != 1) {
                throw new LicenseContentException(EXC_CONSUMER_AMOUNT_IS_NOT_ONE);
            }
        } else if (content.getConsumerAmount() <= 0) {
            throw new LicenseContentException(EXC_CONSUMER_AMOUNT_IS_NOT_POSITIVE);
        }
    }

    protected GenericCertificate getCertificate() {
        if (this.certificate != null && System.currentTimeMillis() < this.certificateTime + 1800000L) {
            return this.certificate;
        }
        return null;
    }

    protected synchronized void setCertificate(GenericCertificate certificate) {
        this.certificate = certificate;
        this.certificateTime = System.currentTimeMillis();
    }

    protected byte[] getLicenseKey() {
        Preferences prefs = this.getLicenseParam().getPreferences();
        return prefs != null ? prefs.getByteArray(PREFERENCES_KEY, null) : null;
    }

    protected synchronized void setLicenseKey(byte[] key) {
        Preferences prefs = this.getLicenseParam().getPreferences();
        if (prefs != null) {
            if (key != null) {
                prefs.putByteArray(PREFERENCES_KEY, key);
            } else {
                prefs.remove(PREFERENCES_KEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void storeLicenseKey(byte[] key, File keyFile) throws IOException {
        FileOutputStream out = new FileOutputStream(keyFile);
        try {
            ((OutputStream)out).write(key);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadLicenseKey(File keyFile) throws IOException {
        int size = Math.min((int)keyFile.length(), 0x100000);
        byte[] b = new byte[size];
        try (FileInputStream in = new FileInputStream(keyFile);){
            ((InputStream)in).read(b);
        }
        return b;
    }

    protected synchronized LicenseNotary getLicenseNotary() {
        if (this.notary == null) {
            this.notary = new LicenseNotary(this.getLicenseParam().getKeyStoreParam());
        }
        return this.notary;
    }

    protected synchronized PrivacyGuard getPrivacyGuard() {
        if (this.guard == null) {
            this.guard = new PrivacyGuard(this.getLicenseParam().getCipherParam());
        }
        return this.guard;
    }

    public synchronized FileFilter getFileFilter() {
        if (this.fileFilter != null) {
            return this.fileFilter;
        }
        final String description = Resources.getString(FILE_FILTER_DESCRIPTION, this.getLicenseParam().getSubject());
        this.fileFilter = File.separatorChar == '\\' ? new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().toLowerCase(Locale.ENGLISH).endsWith(LICENSE_SUFFIX);
            }

            @Override
            public String getDescription() {
                return description + FILE_FILTER_SUFFIX;
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().endsWith(LICENSE_SUFFIX);
            }

            @Override
            public String getDescription() {
                return description + FILE_FILTER_SUFFIX;
            }
        };
        return this.fileFilter;
    }

    static {
        assert (LICENSE_SUFFIX.equals(LICENSE_SUFFIX.toLowerCase(Locale.ENGLISH)));
        PARAM = LicenseNotary.PARAM;
        SUBJECT = new ObfuscatedString(new long[]{-6788193907359448604L, -2787711522493615434L}).toString();
        KEY_STORE_PARAM = new ObfuscatedString(new long[]{4943981370588954830L, 8065447823433585419L, -2749528823549501332L}).toString();
        CIPHER_PARAM = new ObfuscatedString(new long[]{-3651048337721043740L, 1928803483347080380L, 1649789960289346230L}).toString();
        CN = new ObfuscatedString(new long[]{7165044359350484836L, -6008675436704023088L}).toString();
        CN_USER = CN + Resources.getString(new ObfuscatedString(new long[]{-883182015789302099L, 6587252612286394632L}).toString());
        USER = new ObfuscatedString(new long[]{-6950934198262740461L, -10280221617836935L}).toString();
        SYSTEM = new ObfuscatedString(new long[]{-1441033263392531498L, 6113162389128247115L}).toString();
        EXC_INVALID_SUBJECT = new ObfuscatedString(new long[]{-9211605111142713620L, 391714365510707393L, -7356761750428556372L, 6379560902598103028L}).toString();
        EXC_HOLDER_IS_NULL = new ObfuscatedString(new long[]{7150026245468079143L, 6314884536402738366L, -1360923923476698800L}).toString();
        EXC_ISSUER_IS_NULL = new ObfuscatedString(new long[]{-3034693013076752554L, -1011266899694033610L, 6775785917404597234L}).toString();
        EXC_ISSUED_IS_NULL = new ObfuscatedString(new long[]{-6084371209004858580L, 3028840747031697166L, -3524637886726219307L}).toString();
        EXC_LICENSE_IS_NOT_YET_VALID = new ObfuscatedString(new long[]{5434633639502011825L, -3406117476263181371L, 6903673940810780388L, -6816911225052310716L}).toString();
        EXC_LICENSE_HAS_EXPIRED = new ObfuscatedString(new long[]{1000558500458715757L, -6998261911041258483L, -5490039629745846648L, 3561172928787106880L}).toString();
        EXC_CONSUMER_TYPE_IS_NULL = new ObfuscatedString(new long[]{-3274088377466921882L, -1704115158449736962L, -1134622897105293263L, 2875630655915253859L}).toString();
        EXC_CONSUMER_TYPE_IS_NOT_USER = new ObfuscatedString(new long[]{-3559580260061340089L, 8807812719464926891L, 3255622466169980128L, 3208430498260873670L, 8772089725159421213L}).toString();
        EXC_CONSUMER_AMOUNT_IS_NOT_ONE = new ObfuscatedString(new long[]{6854702630454082314L, -1676630527348424687L, 4853969635229547239L, -7087814313396201500L, 7133601245775504376L}).toString();
        EXC_CONSUMER_AMOUNT_IS_NOT_POSITIVE = new ObfuscatedString(new long[]{-5670394608177286583L, -3674104453170648872L, 4159301984262248157L, 7442355638167795990L, 4780252201915657674L}).toString();
        FILE_FILTER_DESCRIPTION = new ObfuscatedString(new long[]{3160933239845492228L, -2320904495012387647L, -5935185636215549881L, -3418607682842311949L}).toString();
        FILE_FILTER_SUFFIX = new ObfuscatedString(new long[]{-6576160320308571504L, 7010427383913371869L}).toString();
    }
}

