/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.util;

import java.io.UnsupportedEncodingException;
import java.util.Random;

public final class ObfuscatedString {
    private static final String UTF8 = new String(new char[]{'U', 'T', 'F', '8'});
    private final long[] obfuscated;

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(ObfuscatedString.obfuscate(args[i]));
        }
    }

    public static String obfuscate(String s) {
        long seed;
        byte[] encoded;
        if (-1 != s.indexOf(0)) {
            throw new IllegalArgumentException(new ObfuscatedString(new long[]{2598583114197433456L, -2532951909540716745L, 1850312903926917213L, -7324743161950196342L, 3319654553699491298L}).toString());
        }
        try {
            encoded = s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        Random prng = new Random();
        while ((seed = prng.nextLong()) == 0L) {
        }
        prng = new Random(seed);
        StringBuffer code = new StringBuffer(new ObfuscatedString(new long[]{-6733388613909857970L, -557652741307719956L, 563088487624542180L, 5623833171491374716L, -2309350771052518321L, 2627844803624578169L}).toString());
        ObfuscatedString.appendHexLiteral(code, seed);
        int length = encoded.length;
        for (int i = 0; i < length; i += 8) {
            long key = prng.nextLong();
            long obfuscated = ObfuscatedString.toLong(encoded, i) ^ key;
            code.append(", ");
            ObfuscatedString.appendHexLiteral(code, obfuscated);
        }
        code.append(new ObfuscatedString(new long[]{4756003162039514438L, -7241174029104351587L, 2576762727660584163L, 2432800632635846553L}).toString());
        code.append(s.replaceAll("\\\\", new ObfuscatedString(new long[]{7866777055383403009L, -5101749501440392498L}).toString()).replaceAll("\"", new ObfuscatedString(new long[]{-8797265930671803829L, -5738757606858957305L}).toString()));
        code.append(new ObfuscatedString(new long[]{-4228881123273879289L, 1823585417647083411L}).toString());
        return code.toString();
    }

    private static void appendHexLiteral(StringBuffer sb, long l) {
        sb.append('0');
        sb.append('x');
        sb.append(Long.toHexString(l).toUpperCase());
        sb.append('L');
    }

    private static long toLong(byte[] bytes, int off) {
        int end = Math.min(bytes.length, off + 8);
        long l = 0L;
        int i = end;
        while (--i >= off) {
            l <<= 8;
            l |= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static void toBytes(long l, byte[] bytes, int off) {
        int end = Math.min(bytes.length, off + 8);
        for (int i = off; i < end; ++i) {
            bytes[i] = (byte)l;
            l >>= 8;
        }
    }

    public ObfuscatedString(long[] obfuscated) {
        this.obfuscated = (long[])obfuscated.clone();
        this.obfuscated[0] = obfuscated[0];
    }

    public String toString() {
        String decoded;
        int length = this.obfuscated.length;
        byte[] encoded = new byte[8 * (length - 1)];
        long seed = this.obfuscated[0];
        Random prng = new Random(seed);
        for (int i = 1; i < length; ++i) {
            long key = prng.nextLong();
            ObfuscatedString.toBytes(this.obfuscated[i] ^ key, encoded, 8 * (i - 1));
        }
        try {
            decoded = new String(encoded, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        int i = decoded.indexOf(0);
        return -1 == i ? decoded : decoded.substring(0, i);
    }
}

