/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.zkoss.zkex.rt.quota.FileSystemPreferences;

public class XmlSupport {
    private static final String PREFS_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    private static final String PREFS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT preferences (root) ><!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\"  ><!ELEMENT root (map, node*) ><!ATTLIST root          type (system|user) #REQUIRED ><!ELEMENT node (map, node*) ><!ATTLIST node          name CDATA #REQUIRED ><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private static final String MAP_XML_VERSION = "1.0";

    static void export(OutputStream os, Preferences p, boolean subTree) throws IOException, BackingStoreException {
        if (((FileSystemPreferences)p).isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        Document doc = XmlSupport.createPrefsDoc("preferences");
        Element preferences = doc.getDocumentElement();
        preferences.setAttribute("EXTERNAL_XML_VERSION", "1.0");
        Element xmlRoot = (Element)preferences.appendChild(doc.createElement("root"));
        xmlRoot.setAttribute("type", p.isUserNode() ? "user" : "system");
        ArrayList<Preferences> ancestors = new ArrayList<Preferences>();
        Preferences kid = p;
        Preferences dad = kid.parent();
        while (dad != null) {
            ancestors.add(kid);
            kid = dad;
            dad = kid.parent();
        }
        Element e = xmlRoot;
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            e.appendChild(doc.createElement("map"));
            e = (Element)e.appendChild(doc.createElement("node"));
            e.setAttribute("name", ((Preferences)ancestors.get(i)).name());
        }
        XmlSupport.putPreferencesInXml(e, doc, p, subTree);
        XmlSupport.writeDoc(doc, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putPreferencesInXml(Element elt, Document doc, Preferences prefs, boolean subTree) throws BackingStoreException {
        Preferences[] kidsCopy = null;
        String[] kidNames = null;
        Object object = ((FileSystemPreferences)prefs).lock();
        synchronized (object) {
            int i;
            if (((FileSystemPreferences)prefs).isRemoved()) {
                elt.getParentNode().removeChild(elt);
                return;
            }
            String[] keys = prefs.keys();
            Element map = (Element)elt.appendChild(doc.createElement("map"));
            for (i = 0; i < keys.length; ++i) {
                Element entry = (Element)map.appendChild(doc.createElement("entry"));
                entry.setAttribute("key", keys[i]);
                entry.setAttribute("value", prefs.get(keys[i], null));
            }
            if (subTree) {
                kidNames = prefs.childrenNames();
                kidsCopy = new Preferences[kidNames.length];
                for (i = 0; i < kidNames.length; ++i) {
                    kidsCopy[i] = prefs.node(kidNames[i]);
                }
            }
        }
        if (subTree) {
            for (int i = 0; i < kidNames.length; ++i) {
                Element xmlKid = (Element)elt.appendChild(doc.createElement("node"));
                xmlKid.setAttribute("name", kidNames[i]);
                XmlSupport.putPreferencesInXml(xmlKid, doc, kidsCopy[i], subTree);
            }
        }
    }

    static void importPreferences(InputStream is) throws IOException, InvalidPreferencesFormatException {
        try {
            Document doc = XmlSupport.loadPrefsDoc(is);
            String xmlVersion = doc.getDocumentElement().getAttribute("EXTERNAL_XML_VERSION");
            if (xmlVersion.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Exported preferences file format version " + xmlVersion + " is not supported. This java installation can read versions 1.0 or older. You may need to install a newer version of JDK.");
            }
            Element xmlRoot = (Element)doc.getDocumentElement().getChildNodes().item(0);
            Preferences prefsRoot = xmlRoot.getAttribute("type").equals("user") ? Preferences.userRoot() : Preferences.systemRoot();
            XmlSupport.ImportSubtree(prefsRoot, xmlRoot);
        }
        catch (SAXException e) {
            throw new InvalidPreferencesFormatException(e);
        }
    }

    private static Document createPrefsDoc(String qname) {
        try {
            DOMImplementation di = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            DocumentType dt = di.createDocumentType(qname, null, PREFS_DTD_URI);
            return di.createDocument(null, qname, dt);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Document loadPrefsDoc(InputStream in) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new Resolver());
            db.setErrorHandler(new EH());
            return db.parse(new InputSource(in));
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final void writeDoc(Document doc, OutputStream out) throws IOException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", new Integer(2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer t = tf.newTransformer();
            t.setOutputProperty("doctype-system", doc.getDoctype().getSystemId());
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(doc), new StreamResult(new BufferedWriter(new OutputStreamWriter(out, "UTF-8"))));
        }
        catch (TransformerException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ImportSubtree(Preferences prefsNode, Element xmlNode) {
        Preferences[] prefsKids;
        NodeList xmlKids = xmlNode.getChildNodes();
        int numXmlKids = xmlKids.getLength();
        Object object = ((FileSystemPreferences)prefsNode).lock();
        synchronized (object) {
            if (((FileSystemPreferences)prefsNode).isRemoved()) {
                return;
            }
            Element firstXmlKid = (Element)xmlKids.item(0);
            XmlSupport.ImportPrefs(prefsNode, firstXmlKid);
            prefsKids = new Preferences[numXmlKids - 1];
            for (int i = 1; i < numXmlKids; ++i) {
                Element xmlKid = (Element)xmlKids.item(i);
                prefsKids[i - 1] = prefsNode.node(xmlKid.getAttribute("name"));
            }
        }
        for (int i = 1; i < numXmlKids; ++i) {
            XmlSupport.ImportSubtree(prefsKids[i - 1], (Element)xmlKids.item(i));
        }
    }

    private static void ImportPrefs(Preferences prefsNode, Element map) {
        NodeList entries = map.getChildNodes();
        int numEntries = entries.getLength();
        for (int i = 0; i < numEntries; ++i) {
            Element entry = (Element)entries.item(i);
            prefsNode.put(entry.getAttribute("key"), entry.getAttribute("value"));
        }
    }

    static void exportMap(OutputStream os, Map map) throws IOException {
        Document doc = XmlSupport.createPrefsDoc("map");
        Element xmlMap = doc.getDocumentElement();
        xmlMap.setAttribute("MAP_XML_VERSION", "1.0");
        for (Map.Entry e : map.entrySet()) {
            Element xe = (Element)xmlMap.appendChild(doc.createElement("entry"));
            xe.setAttribute("key", (String)e.getKey());
            xe.setAttribute("value", (String)e.getValue());
        }
        XmlSupport.writeDoc(doc, os);
    }

    static void importMap(InputStream is, Map m) throws IOException, InvalidPreferencesFormatException {
        try {
            Document doc = XmlSupport.loadPrefsDoc(is);
            Element xmlMap = doc.getDocumentElement();
            String mapVersion = xmlMap.getAttribute("MAP_XML_VERSION");
            if (mapVersion.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Preferences map file format version " + mapVersion + " is not supported. This java installation can read versions 1.0 or older. You may need to install a newer version of JDK.");
            }
            NodeList entries = xmlMap.getChildNodes();
            int numEntries = entries.getLength();
            for (int i = 0; i < numEntries; ++i) {
                Element entry = (Element)entries.item(i);
                m.put(entry.getAttribute("key"), entry.getAttribute("value"));
            }
        }
        catch (SAXException e) {
            throw new InvalidPreferencesFormatException(e);
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        @Override
        public void error(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void warning(SAXParseException x) throws SAXException {
            throw x;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(XmlSupport.PREFS_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(XmlSupport.PREFS_DTD));
                is.setSystemId(XmlSupport.PREFS_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }
}

