/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import org.zkoss.json.JSONObject;
import org.zkoss.zkex.rt.quota.QuotaPacket;
import org.zkoss.zkex.util.Base64Coder;
import org.zkoss.zkex.util.ObfuscatedString;

public class QuotaServer
implements Runnable {
    static final int MAGIC_NUMBER = 12630;
    static final String QUOTA_SERVER_REQUEST = new ObfuscatedString(new long[]{-5280160079698134864L, 6816310321625333069L, 7124877924464830494L, 4662657535783743143L}).toString();
    static final String QUOTA_SERVER_RESPONSE = new ObfuscatedString(new long[]{685434516663572746L, -3130458535885330448L, -1468303277238357638L, -2239106465336737241L}).toString();
    private volatile boolean _running;
    private volatile Map<String, QuotaPacket> _packs;
    private volatile DatagramSocket socket = null;

    private QuotaServer() {
    }

    void init(Map<String, QuotaPacket> packs, Map<String, String> licenseInfo) {
        this._packs = packs;
        for (QuotaPacket pack : packs.values()) {
            pack.init(licenseInfo);
        }
    }

    public void stop() {
        this._running = false;
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._running = true;
        try {
            this.socket = new DatagramSocket(12630);
            this.socket.setBroadcast(true);
            while (this._running) {
                String message;
                int s;
                byte[] recvBuf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(recvBuf, recvBuf.length);
                this.socket.receive(packet);
                InetAddress address = packet.getAddress();
                String ip = address.getHostAddress();
                if (ip != null && (s = ip.lastIndexOf(".")) > 0) {
                    ip = ip.substring(0, s);
                }
                if (!QUOTA_SERVER_REQUEST.equals(message = new String(packet.getData()).trim())) continue;
                JSONObject jsonObject = new JSONObject();
                for (QuotaPacket pack : this._packs.values()) {
                    pack.setNetworkPrefix(ip);
                    jsonObject.put((Object)pack.getGroupId(), (Object)pack.getRemoteData());
                }
                String dirty = UUID.randomUUID().toString().substring(0, 3);
                byte[] sendData = (QUOTA_SERVER_RESPONSE + dirty + Base64Coder.encodeString(jsonObject.toJSONString())).getBytes();
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, packet.getAddress(), packet.getPort());
                this.socket.send(sendPacket);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (this.socket != null) {
                this.socket.close();
            }
            this._running = false;
        }
    }

    public static QuotaServer getInstance() {
        return QuotaServerThreadHolder.INSTANCE;
    }

    private static class QuotaServerThreadHolder {
        private static final QuotaServer INSTANCE = new QuotaServer();

        private QuotaServerThreadHolder() {
        }
    }
}

