/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.zkoss.zk.ui.util.AggregationListener;
import org.zkoss.zkex.rt.RuntimeUtil;
import org.zkoss.zkex.rt.quota.QuotaPacket;

public class QuotaPacketRegister
implements AggregationListener {
    private static Map<String, QuotaPacket> _listeners = new ConcurrentHashMap<String, QuotaPacket>();

    public boolean isHandled(Class<?> klass) {
        if (QuotaPacket.class.isAssignableFrom(klass)) {
            try {
                if (!_listeners.containsKey(klass.getName())) {
                    _listeners.put(klass.getName(), (QuotaPacket)klass.newInstance());
                }
            }
            catch (Throwable e) {
                RuntimeUtil.sendError(e);
            }
            return true;
        }
        return false;
    }

    public static Map<String, QuotaPacket> getAllQuotaPackets() {
        Collection<QuotaPacket> values = _listeners.values();
        HashMap<String, QuotaPacket> all = new HashMap<String, QuotaPacket>();
        for (QuotaPacket pack : values) {
            all.put(pack.getGroupId(), pack);
        }
        return all;
    }
}

