/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.zkoss.io.Files;
import org.zkoss.zkex.rt.RuntimeUtil;
import org.zkoss.zkex.rt.quota.Base64;
import org.zkoss.zkex.rt.quota.XmlSupport;

public class FileSystemPreferences
extends AbstractPreferences {
    private static final int SYNC_INTERVAL = Math.max(1, Integer.parseInt((String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("java.util.prefs.syncInterval", "30");
        }
    })));
    private static File systemRootDir;
    private static boolean isSystemRootWritable;
    private static File userRootDir;
    private static boolean isUserRootWritable;
    static Preferences userRoot;
    private static final String OS;
    private static final int OS_TYPE;
    static File userLockFile;
    static File systemLockFile;
    private static int userRootLockHandle;
    private static int systemRootLockHandle;
    private final File dir;
    private final File prefsFile;
    private final File tmpFile;
    private static File userRootModFile;
    private static boolean isUserRootModified;
    private static long userRootModTime;
    private static File systemRootModFile;
    private static boolean isSystemRootModified;
    private static long systemRootModTime;
    private Map prefsCache = null;
    private long lastSyncTime = 0L;
    final List changeLog = new ArrayList();
    NodeCreate nodeCreate = null;
    private static Timer syncTimer;
    private final boolean isUserNode;
    private static final String[] EMPTY_STRING_ARRAY;

    static boolean isUnix() {
        return OS_TYPE == 1;
    }

    static boolean isWindows() {
        return OS_TYPE == 2;
    }

    static boolean isSolaris() {
        return OS_TYPE == 4;
    }

    static boolean isMac() {
        return OS_TYPE == 3;
    }

    static synchronized Preferences getUserRoot() {
        if (userRoot == null) {
            FileSystemPreferences.setupUserRoot();
            userRoot = new FileSystemPreferences(true);
        }
        return userRoot;
    }

    private static int chmod(String fileName, int permission) throws Exception {
        if (FileSystemPreferences.isUnix() || FileSystemPreferences.isSolaris()) {
            Class<?> fspClass = Class.forName("java.util.prefs.FileSystemPreferences");
            Method chmodMethod = fspClass.getDeclaredMethod("chmod", String.class, Integer.TYPE);
            chmodMethod.setAccessible(true);
            return (Integer)chmodMethod.invoke(null, userRootDir.getCanonicalPath(), 448);
        }
        return 0;
    }

    private static void setupUserRoot() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int result;
                userRootDir = new File(System.getProperty("java.util.prefs.userRoot", System.getProperty("user.home")), ".java/.userPrefs");
                if (!userRootDir.exists() && userRootDir.mkdirs()) {
                    try {
                        FileSystemPreferences.chmod(userRootDir.getCanonicalPath(), 448);
                    }
                    catch (Throwable e) {
                        RuntimeUtil.sendError(e);
                    }
                }
                isUserRootWritable = userRootDir.canWrite();
                String USER_NAME = System.getProperty("user.name");
                userLockFile = new File(userRootDir, ".user.lock." + USER_NAME);
                if (!userLockFile.exists()) {
                    try {
                        userLockFile.createNewFile();
                        result = FileSystemPreferences.chmod(userLockFile.getCanonicalPath(), 384);
                        if (result != 0) {
                            RuntimeUtil.sendError("Problem creating userRoot mod file. Chmod failed on userLockFile Unix error code " + result);
                        }
                    }
                    catch (Throwable e) {
                        RuntimeUtil.sendError(e);
                    }
                }
                if (!(userRootModFile = new File(userRootDir, ".userRootModFile." + USER_NAME)).exists()) {
                    try {
                        userRootModFile.createNewFile();
                        result = FileSystemPreferences.chmod(userRootModFile.getCanonicalPath(), 384);
                        if (result != 0) {
                            RuntimeUtil.sendError("Problem creating userRoot mod file. Chmod failed on userRootModFile Unix error code " + result);
                        }
                    }
                    catch (Throwable e) {
                        RuntimeUtil.sendError(e);
                    }
                }
                userRootModTime = userRootModFile.lastModified();
                return null;
            }
        });
    }

    private void replayChanges() {
        int n = this.changeLog.size();
        for (int i = 0; i < n; ++i) {
            ((Change)this.changeLog.get(i)).replay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncWorld() {
        Class<FileSystemPreferences> clazz = FileSystemPreferences.class;
        synchronized (FileSystemPreferences.class) {
            Preferences userRt = userRoot;
            // ** MonitorExit[var1] (shouldn't be in output)
            try {
                if (userRt != null) {
                    userRt.flush();
                }
            }
            catch (Throwable e) {
                RuntimeUtil.sendError(e);
            }
            return;
        }
    }

    private FileSystemPreferences(boolean user) {
        super(null, "");
        this.isUserNode = user;
        this.dir = user ? userRootDir : systemRootDir;
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
    }

    private FileSystemPreferences(FileSystemPreferences parent, String name) {
        super(parent, name);
        this.isUserNode = parent.isUserNode;
        this.dir = new File(parent.dir, FileSystemPreferences.dirName(name));
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileSystemPreferences.this.newNode = !FileSystemPreferences.this.dir.exists();
                return null;
            }
        });
        if (this.newNode) {
            this.prefsCache = new TreeMap();
            this.nodeCreate = new NodeCreate();
            this.changeLog.add(this.nodeCreate);
        }
    }

    @Override
    public boolean isUserNode() {
        return this.isUserNode;
    }

    @Override
    protected void putSpi(String key, String value) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Put(key, value));
        this.prefsCache.put(key, value);
    }

    @Override
    protected String getSpi(String key) {
        this.initCacheIfNecessary();
        return (String)this.prefsCache.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Remove(key));
        this.prefsCache.remove(key);
    }

    private void initCacheIfNecessary() {
        if (this.prefsCache != null) {
            return;
        }
        try {
            this.loadCache();
        }
        catch (Exception e) {
            this.prefsCache = new TreeMap();
        }
    }

    private void loadCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    TreeMap m = new TreeMap();
                    long newLastSyncTime = 0L;
                    try {
                        newLastSyncTime = FileSystemPreferences.this.prefsFile.lastModified();
                        FileInputStream fis = new FileInputStream(FileSystemPreferences.this.prefsFile);
                        XmlSupport.importMap(fis, m);
                        fis.close();
                    }
                    catch (Throwable e) {
                        RuntimeUtil.sendError(e);
                    }
                    FileSystemPreferences.this.prefsCache = m;
                    FileSystemPreferences.this.lastSyncTime = newLastSyncTime;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BackingStoreException)e.getException();
        }
    }

    private void writeBackCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    block5: {
                        try {
                            if (!FileSystemPreferences.this.dir.exists() && !FileSystemPreferences.this.dir.mkdirs()) {
                                throw new BackingStoreException(String.valueOf(FileSystemPreferences.this.dir) + " create failed.");
                            }
                            FileOutputStream fos = new FileOutputStream(FileSystemPreferences.this.tmpFile);
                            XmlSupport.exportMap(fos, FileSystemPreferences.this.prefsCache);
                            fos.close();
                            FileSystemPreferences.this.prefsFile.delete();
                            boolean rename = FileSystemPreferences.this.tmpFile.renameTo(FileSystemPreferences.this.prefsFile);
                            if (rename) break block5;
                            Files.copy((File)FileSystemPreferences.this.tmpFile, (File)FileSystemPreferences.this.prefsFile, (int)Files.CP_PRESERVE);
                            if (FileSystemPreferences.this.tmpFile.delete()) break block5;
                            try {
                                Files.deleteAll((File)FileSystemPreferences.this.prefsFile);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw new IOException("Failed to delete original file '" + String.valueOf(FileSystemPreferences.this.tmpFile) + "' after copy to '" + String.valueOf(FileSystemPreferences.this.prefsFile) + "'");
                        }
                        catch (Throwable e) {
                            RuntimeUtil.sendError(e);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BackingStoreException)e.getException();
        }
    }

    @Override
    protected String[] keysSpi() {
        this.initCacheIfNecessary();
        return this.prefsCache.keySet().toArray(new String[this.prefsCache.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<String> result = new ArrayList<String>();
                File[] dirContents = FileSystemPreferences.this.dir.listFiles();
                if (dirContents != null) {
                    for (int i = 0; i < dirContents.length; ++i) {
                        if (!dirContents[i].isDirectory()) continue;
                        result.add(FileSystemPreferences.nodeName(dirContents[i].getName()));
                    }
                }
                return result.toArray(EMPTY_STRING_ARRAY);
            }
        });
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new FileSystemPreferences(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        FileChannel channel = null;
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            FileLock lock = channel.lock();
            try {
                super.removeNode();
            }
            finally {
                lock.release();
            }
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException lock) {}
            }
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    if (FileSystemPreferences.this.changeLog.contains(FileSystemPreferences.this.nodeCreate)) {
                        FileSystemPreferences.this.changeLog.remove(FileSystemPreferences.this.nodeCreate);
                        FileSystemPreferences.this.nodeCreate = null;
                        return null;
                    }
                    if (!FileSystemPreferences.this.dir.exists()) {
                        return null;
                    }
                    FileSystemPreferences.this.prefsFile.delete();
                    FileSystemPreferences.this.tmpFile.delete();
                    File[] junk = FileSystemPreferences.this.dir.listFiles();
                    if (junk.length != 0) {
                        for (int i = 0; i < junk.length; ++i) {
                            junk[i].delete();
                        }
                    }
                    if (!FileSystemPreferences.this.dir.delete()) {
                        throw new BackingStoreException("Couldn't delete dir: " + String.valueOf(FileSystemPreferences.this.dir));
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() throws BackingStoreException {
        boolean userNode = this.isUserNode();
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        FileChannel channel = null;
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            FileLock lock = channel.lock();
            final Long newModTime = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    long nmt;
                    if (FileSystemPreferences.this.isUserNode()) {
                        nmt = userRootModFile.lastModified();
                        isUserRootModified = userRootModTime == nmt;
                    } else {
                        nmt = systemRootModFile.lastModified();
                        isSystemRootModified = systemRootModTime == nmt;
                    }
                    return new Long(nmt);
                }
            });
            try {
                super.sync();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (FileSystemPreferences.this.isUserNode()) {
                            userRootModTime = newModTime + 1000L;
                            userRootModFile.setLastModified(userRootModTime);
                        } else {
                            systemRootModTime = newModTime + 1000L;
                            systemRootModFile.setLastModified(systemRootModTime);
                        }
                        return null;
                    }
                });
            }
            finally {
                lock.release();
            }
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException lock) {}
            }
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    FileSystemPreferences.this.syncSpiPrivileged();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BackingStoreException)e.getException();
        }
    }

    private void syncSpiPrivileged() throws BackingStoreException {
        long lastModifiedTime;
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        if (this.prefsCache == null) {
            return;
        }
        if (this.isUserNode() ? isUserRootModified : isSystemRootModified) {
            lastModifiedTime = this.prefsFile.lastModified();
            if (lastModifiedTime != this.lastSyncTime) {
                this.loadCache();
                this.replayChanges();
                this.lastSyncTime = lastModifiedTime;
            }
        } else if (this.lastSyncTime != 0L && !this.dir.exists()) {
            this.prefsCache = new TreeMap();
            this.replayChanges();
        }
        if (!this.changeLog.isEmpty()) {
            this.writeBackCache();
            lastModifiedTime = this.prefsFile.lastModified();
            if (this.lastSyncTime <= lastModifiedTime) {
                this.lastSyncTime = lastModifiedTime + 1000L;
                this.prefsFile.setLastModified(this.lastSyncTime);
            }
            this.changeLog.clear();
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        this.sync();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    private static boolean isDirChar(char ch) {
        return ch > '\u001f' && ch < '\u007f' && ch != '/' && ch != '.' && ch != '_';
    }

    private static String dirName(String nodeName) {
        int n = nodeName.length();
        for (int i = 0; i < n; ++i) {
            if (FileSystemPreferences.isDirChar(nodeName.charAt(i))) continue;
            return "_" + Base64.byteArrayToAltBase64(FileSystemPreferences.byteArray(nodeName));
        }
        return nodeName;
    }

    private static byte[] byteArray(String s) {
        int len = s.length();
        byte[] result = new byte[2 * len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            result[j++] = (byte)(c >> 8);
            result[j++] = (byte)c;
        }
        return result;
    }

    private static String nodeName(String dirName) {
        if (dirName.charAt(0) != '_') {
            return dirName;
        }
        byte[] a = Base64.altBase64ToByteArray(dirName.substring(1));
        StringBuffer result = new StringBuffer(a.length / 2);
        int i = 0;
        while (i < a.length) {
            int highByte = a[i++] & 0xFF;
            int lowByte = a[i++] & 0xFF;
            result.append((char)(highByte << 8 | lowByte));
        }
        return result.toString();
    }

    @Override
    protected boolean isRemoved() {
        return super.isRemoved();
    }

    protected Object lock() {
        return this.lock;
    }

    static {
        userRoot = null;
        OS = System.getProperty("os.name").toLowerCase();
        OS_TYPE = OS.contains("nix") || OS.contains("nux") || OS.contains("aix") ? 1 : (OS.contains("win") ? 2 : (OS.contains("mac") ? 3 : (OS.contains("sunos") ? 4 : -1)));
        userRootLockHandle = 0;
        systemRootLockHandle = 0;
        isUserRootModified = false;
        isSystemRootModified = false;
        syncTimer = new Timer(true);
        syncTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                FileSystemPreferences.syncWorld();
            }
        }, SYNC_INTERVAL * 1000, (long)(SYNC_INTERVAL * 1000));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread syncThread = new Thread(){

                    @Override
                    public void run() {
                        syncTimer.cancel();
                        FileSystemPreferences.syncWorld();
                    }
                };
                syncThread.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(syncThread);
                return null;
            }
        });
        EMPTY_STRING_ARRAY = new String[0];
    }

    private class NodeCreate
    extends Change {
        private NodeCreate() {
        }

        @Override
        void replay() {
        }
    }

    private class Remove
    extends Change {
        String key;

        Remove(String key) {
            this.key = key;
        }

        @Override
        void replay() {
            FileSystemPreferences.this.prefsCache.remove(this.key);
        }
    }

    private class Put
    extends Change {
        String key;
        String value;

        Put(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        void replay() {
            FileSystemPreferences.this.prefsCache.put(this.key, this.value);
        }
    }

    private abstract class Change {
        private Change() {
        }

        abstract void replay();
    }
}

