/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.net.URL;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import org.zkoss.lang.Library;
import org.zkoss.util.Cleanups;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zkex.license.LicenseContent;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.rt.RuntimeLicense;
import org.zkoss.zkex.rt.RuntimeUtil;
import org.zkoss.zkex.rt.quota.QuotaClient;
import org.zkoss.zkex.rt.quota.QuotaPacket;
import org.zkoss.zkex.rt.quota.QuotaPacketRegister;
import org.zkoss.zkex.rt.quota.QuotaServer;

class RuntimeUtilImpl
extends RuntimeUtil {
    private static final AtomicBoolean IS_QUOTA_SERVER_ENABLED = new AtomicBoolean();

    RuntimeUtilImpl() {
    }

    @Override
    public void run(RuntimeLicense _evalLicManager) {
        try {
            Map<String, QuotaPacket> packets;
            URL dirUrl;
            if (QuotaServer.getInstance().isRunning()) {
                return;
            }
            if (IS_QUOTA_SERVER_ENABLED.getAndSet(true)) {
                return;
            }
            boolean isScheduled = false;
            String dir = Library.getProperty((String)Runtime.EVALUATION_LICENSE_DIRECTORY_PROPERTY);
            if (dir != null && (dirUrl = RuntimeUtilImpl.getURLFromString(dir)) != null) {
                isScheduled = _evalLicManager.install(dirUrl);
            }
            if (isScheduled) {
                _evalLicManager.setWapp(WebApps.getCurrent());
                _evalLicManager.startScheduler();
            }
            if ((packets = QuotaPacketRegister.getAllQuotaPackets()) != null && !packets.isEmpty()) {
                final QuotaServer quotaServer = QuotaServer.getInstance();
                if (isScheduled) {
                    quotaServer.init(packets, Collections.unmodifiableMap(new LiveLicDataMap(_evalLicManager)));
                } else {
                    quotaServer.init(packets, Collections.emptyMap());
                }
                final Thread server = new Thread(quotaServer);
                server.start();
                QuotaClient quotaClient = QuotaClient.getInstance();
                quotaClient.init(packets);
                final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
                final ScheduledFuture<?> scheduledFuture = service.scheduleAtFixedRate(quotaClient, 0L, 10L, TimeUnit.MINUTES);
                Cleanups.add((Cleanups.Cleanup)new Cleanups.Cleanup(){

                    public void cleanup() {
                        try {
                            if (server != null && server.isAlive()) {
                                quotaServer.stop();
                                server.interrupt();
                            }
                            if (!scheduledFuture.isCancelled() && !scheduledFuture.isDone()) {
                                scheduledFuture.cancel(true);
                            }
                            if (!service.isShutdown()) {
                                service.shutdownNow();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            RuntimeUtilImpl.sendError(e);
        }
    }

    @Override
    public String getUFlag() {
        Map<String, QuotaPacket> packets = QuotaPacketRegister.getAllQuotaPackets();
        if (packets != null && !packets.isEmpty()) {
            QuotaPacket qp = packets.values().iterator().next();
            return qp.getUid();
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return IS_QUOTA_SERVER_ENABLED.get();
    }

    @Override
    public void updatePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(Runtime.class);
        int zau = prefs.getInt(QuotaPacket.NUMBER_AU_TODAY, 0);
        prefs.put(QuotaPacket.NUMBER_AU_TODAY, String.valueOf(++zau));
    }

    static {
        RuntimeUtilImpl.setUtilImplementation(new RuntimeUtilImpl());
    }

    private static class LiveLicDataMap
    extends AbstractMap<String, String> {
        private long _nextCheckTime;
        private RuntimeLicense _manager;
        private Map<String, String> _data;

        public LiveLicDataMap(RuntimeLicense manager) {
            this._nextCheckTime = System.currentTimeMillis() + manager.getDelay();
            this._manager = manager;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this._nextCheckTime < System.currentTimeMillis()) {
                this._data = null;
            }
            if (this._data == null) {
                this._data = new HashMap<String, String>(5);
                Map<String, LicenseContent> contents = this._manager.getAllMaximums();
                if (contents != null && !contents.isEmpty()) {
                    for (Map.Entry<String, LicenseContent> me : contents.entrySet()) {
                        this._data.put(me.getKey(), String.valueOf(me.getValue().getConsumerAmount()));
                    }
                }
            }
            return this._data.isEmpty() ? Collections.emptySet() : this._data.entrySet();
        }
    }
}

