/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JSONs;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.sys.DigestUtilsHelper;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.rt.RuntimeUtil;
import org.zkoss.zkex.rt.quota.FileSystemPreferences;
import org.zkoss.zkex.rt.quota.QuotaPacket;
import org.zkoss.zkex.rt.quota.QuotaPreferences;
import org.zkoss.zkex.util.Base64Coder;
import org.zkoss.zkex.util.ObfuscatedString;

public final class QuotaPacketImpl
implements QuotaPacket {
    private static final int VERSION = 2;
    private static final String CONCURRENT_LIMIT = new ObfuscatedString(new long[]{-5656614761161248047L, -7849538374141745281L, 886518256921674521L, -1842787209234954232L, -3991298363093865362L, -8554143497541875142L, -8024526734152770697L, -3940563785680223587L, 4868824732444364405L, 3034040245252742987L, 7671522431334505372L, -1212030700748532223L, -7239338263162799733L, -6335981435016144231L, 7069427466779962644L, 5625514067273310778L, -1398164118151711149L, -2067523271962333433L, 1069814287382463043L, 1432138631304052379L, 6811521280898003426L, -5042372387454272669L, 401904709149471571L, 6013094840588798742L, 1075588580498091752L}).toString();
    private static final String SCRIPT = new ObfuscatedString(new long[]{-3316310646038716289L, -16010142215385081L, -16744331660262981L, -3374070105247467176L, 8044179767493578517L, -8822134517448667874L, 8393747840144249149L, 7244734262132396820L, -4668763503435814926L, 2382808520404165390L, -2035499601430354671L, 8510573132609522317L, 5186016553481293068L, -2103683272118640484L, -3169345940646604071L, 3706716557731100312L, -1892915971534057265L, 3248795115811777134L, -6037282038532076389L, 7877199656454768532L, -2633202855678634668L, 3672193141237420583L, -2014328521142201905L, 8349507010749707294L}).toString();
    private static final String TIMESTAMP = new ObfuscatedString(new long[]{-964788170713430697L, 7574892770427062742L, 1851654598747206993L}).toString();
    private Map<String, String> _licenseInfo = null;
    private String _cid = null;
    private String _networkPrefix = null;
    private String _prefix = null;
    private static Pattern macpt = null;
    private static long HOUR = 3600000L;
    private static long DAY = HOUR * 24L;

    @Override
    public void init(Map<String, String> licenseInfo) {
        String ip;
        String[] data;
        this._licenseInfo = licenseInfo;
        Preferences prefs = this.getPreferences();
        String initDate = prefs.get(INIT_DATE, null);
        Date now = new Date();
        if (initDate == null) {
            initDate = this.getInitDate(prefs);
            String initVersion = this.getInitVersion(prefs);
            prefs.put(CURRENT_USING_VERSION, initVersion);
            prefs.put(CURRENT_USING_DATE, initDate);
            prefs.put(NUMBER_USING_TODAY, "1");
            prefs.put(NUMBER_USING_LAST_TIME, "1");
            prefs.put(NUMBER_DAYS_USING, "1");
        } else {
            String currentDate = prefs.get(CURRENT_USING_DATE, null);
            try {
                Date date1 = JSONs.j2d((String)currentDate);
                if (!Runtime.isInSameDay(date1, now)) {
                    QuotaPacketImpl.swapAndReset(NUMBER_AU_TODAY, NUMBER_AU_LAST_TIME, prefs);
                    QuotaPacketImpl.swapAndReset(MAX_NUMBER_CONCURRENT_SERVERS_TODAY, MAX_NUMBER_CONCURRENT_SERVERS_LAST_TIME, prefs);
                    QuotaPacketImpl.swapAndReset(NUMBER_USING_TODAY, NUMBER_USING_LAST_TIME, prefs);
                    prefs.put(DATE_USING_LAST_TIME, currentDate);
                    int ndu = prefs.getInt(NUMBER_DAYS_USING, 1);
                    prefs.put(NUMBER_DAYS_USING, String.valueOf(++ndu));
                } else {
                    int usingCount = prefs.getInt(NUMBER_USING_TODAY, 1);
                    prefs.put(NUMBER_USING_TODAY, String.valueOf(++usingCount));
                }
            }
            catch (Throwable e) {
                RuntimeUtil.sendError(e);
            }
            prefs.put(CURRENT_USING_VERSION, "10.2.0.FL.20250428 " + (WebApps.getFeature((String)"ee") ? "EE" : "PE"));
            prefs.put(CURRENT_USING_DATE, JSONs.d2j((Date)now));
        }
        String cid = prefs.get(CID, null);
        if (cid != null && (data = cid.split("\\$\\$")).length == 3) {
            try {
                if (Runtime.isInSameDay(JSONs.j2d((String)data[2]), now)) {
                    this._networkPrefix = data[1];
                    this._cid = data[0];
                }
            }
            catch (Exception usingCount) {
                // empty catch block
            }
        }
        if (this._cid == null && !Strings.isEmpty((String)(ip = QuotaPacketImpl.getRouterIP()))) {
            String mac;
            int i;
            String s;
            int i2;
            String[] str;
            if (ip.contains(" ") && (str = ip.split(" ")).length == 2 && (i2 = (s = str[1]).lastIndexOf(".")) > 0) {
                this._networkPrefix = s.substring(0, i2);
            }
            if (this._networkPrefix == null && (i = ip.lastIndexOf(".")) > 0) {
                this._networkPrefix = ip.substring(0, i);
            }
            String[] macHex = (mac = QuotaPacketImpl.getMac(ip).toLowerCase()).contains("-") ? mac.split("-") : mac.split(":");
            StringBuilder sb = new StringBuilder();
            for (String hex : macHex) {
                if (hex.length() > 1) {
                    sb.append(hex);
                    continue;
                }
                sb.append('0').append(hex);
            }
            this._cid = QuotaPacketImpl.encode(sb.toString());
            prefs.put(CID, this._cid + "$$" + this._networkPrefix + "$$" + JSONs.d2j((Date)now));
        }
    }

    private static void swapAndReset(String current, String last, Preferences prefs) {
        String currentValue = prefs.get(current, null);
        if (currentValue != null) {
            prefs.put(last, currentValue);
        }
        prefs.remove(current);
    }

    private String getInitDate(Preferences prefs) {
        String initDate = prefs.get(INIT_DATE, null);
        if (initDate == null) {
            initDate = JSONs.d2j((Date)new Date());
            prefs.put(INIT_DATE, initDate);
        }
        return initDate;
    }

    private static void waitFor(Process p) {
        long now = System.currentTimeMillis();
        try {
            long timeoutInMillis = 3000L;
            long finish = now + timeoutInMillis;
            while (QuotaPacketImpl.isAlive(p)) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() <= finish) continue;
                p.destroy();
                break;
            }
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
    }

    private static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getRouterIP() {
        StringBuilder sb;
        String line;
        BufferedReader reader;
        block36: {
            String line2;
            Process p;
            block35: {
                reader = null;
                try {
                    if (FileSystemPreferences.isWindows()) {
                        p = java.lang.Runtime.getRuntime().exec("ipconfig");
                        QuotaPacketImpl.waitFor(p);
                        reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        line2 = reader.readLine();
                        break block35;
                    }
                    if (FileSystemPreferences.isMac()) {
                        p = java.lang.Runtime.getRuntime().exec("route -n get default");
                        QuotaPacketImpl.waitFor(p);
                        reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        line = reader.readLine();
                        sb = new StringBuilder();
                        break block36;
                    }
                    Process p2 = java.lang.Runtime.getRuntime().exec("ip route show match 0/0");
                    QuotaPacketImpl.waitFor(p2);
                    reader = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                    String line3 = reader.readLine();
                    String subcmd = null;
                    StringBuilder sb2 = new StringBuilder();
                    while (line3 != null) {
                        if (line3.startsWith("default via")) {
                            String[] cols = line3.split(" ");
                            subcmd = cols[4].trim() + " " + cols[2].trim();
                            break;
                        }
                        sb2.append(line3);
                        line3 = reader.readLine();
                    }
                    if (subcmd == null) return "";
                    String string = subcmd;
                    return string;
                }
                catch (Throwable e) {
                    RuntimeUtil.sendError(e);
                    return "";
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            while (line2 != null) {
                int i;
                if (line2.contains("Default Gateway") && (i = line2.indexOf(":")) > 0) {
                    String ip = line2.substring(i + 1).trim();
                    if (!Strings.isEmpty((String)ip)) {
                        return ip;
                    }
                    line2 = reader.readLine();
                    continue;
                }
                line2 = reader.readLine();
            }
            if (reader != null) {
                reader.close();
            }
            p = java.lang.Runtime.getRuntime().exec("netstat -rn");
            QuotaPacketImpl.waitFor(p);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            line2 = reader.readLine();
            StringBuilder sb3 = new StringBuilder();
            while (line2 != null) {
                if ((line2 = line2.trim()).contains("0.0.0.0")) {
                    return line2.split(" ")[2].trim();
                }
                sb3.append(line2);
                line2 = reader.readLine();
            }
            return "";
        }
        while (line != null) {
            int i;
            if (line.contains("gateway:") && (i = line.indexOf(":")) > 0) {
                return line.substring(i + 1).trim();
            }
            sb.append(line);
            line = reader.readLine();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMac(String ip) {
        String line;
        Process p;
        BufferedReader reader;
        String[] a;
        String[] cmd = null;
        if (FileSystemPreferences.isWindows()) {
            macpt = Pattern.compile("[0-9a-f]+-[0-9a-f]+-[0-9a-f]+-[0-9a-f]+-[0-9a-f]+-[0-9a-f]+");
            cmd = a = new String[]{"arp", "-a", ip};
        } else if (FileSystemPreferences.isMac()) {
            macpt = Pattern.compile("[0-9a-f]+:[0-9a-f]+:[0-9a-f]+:[0-9a-f]+:[0-9a-f]+:[0-9a-f]+");
            cmd = a = new String[]{"arp", ip};
        } else {
            reader = null;
            try {
                p = java.lang.Runtime.getRuntime().exec(new String[]{"arping -f -I ", ip});
                QuotaPacketImpl.waitFor(p);
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                line = reader.readLine();
                while (true) {
                    if (line != null) {
                        int e;
                        int s;
                        if (line.startsWith("Unicast reply from") && (s = line.indexOf("[")) < (e = line.indexOf("]"))) {
                            String string = line.substring(s + 1, e).trim();
                            return string;
                        }
                        line = reader.readLine();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                macpt = Pattern.compile("[0-9a-f]+:[0-9a-f]+:[0-9a-f]+:[0-9a-f]+:[0-9a-f]+:[0-9a-f]+");
                String[] a2 = new String[]{"arp", ip};
                cmd = a2;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        reader = null;
        try {
            p = java.lang.Runtime.getRuntime().exec(cmd);
            QuotaPacketImpl.waitFor(p);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            line = reader.readLine();
            while (true) {
                if (line != null) {
                    Matcher m = macpt.matcher(line);
                    if (m.find()) {
                        String string = m.group(0);
                        return string;
                    }
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    @Override
    public String getUid() {
        try {
            return QuotaPacketImpl.getUid(this.getPreferences());
        }
        catch (Throwable throwable) {
            return "NAN";
        }
    }

    protected Preferences getPreferences() {
        return QuotaPreferences.fetch();
    }

    private static String getUid(Preferences prefs) {
        String uid = prefs.get(UID, null);
        if (uid == null) {
            uid = QuotaPacketImpl.genUid();
            prefs.put(UID, uid);
        }
        return uid;
    }

    private String getInitVersion(Preferences prefs) {
        Object version = prefs.get(INIT_VERSION, null);
        if (version == null) {
            version = "10.2.0.FL.20250428 " + (WebApps.getFeature((String)"ee") ? "EE" : "PE");
            prefs.put(INIT_VERSION, (String)version);
        }
        return version;
    }

    private JSONObject stringToJson(String encodedStr) {
        try {
            return (JSONObject)JSONValue.parse((String)Base64Coder.decodeString(encodedStr));
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    private String jsonToString(JSONObject obj) {
        return Base64Coder.encodeString(obj.toJSONString());
    }

    @Override
    public String getGroupId() {
        return "ZK";
    }

    @Override
    public String getRemoteData() {
        JSONObject json = new JSONObject();
        Preferences prefs = this.getPreferences();
        json.put((Object)UID, (Object)QuotaPacketImpl.getUid(prefs));
        json.put((Object)CONCURRENT_ROOMMATE, this.getRoommate(prefs));
        return this.jsonToString(json);
    }

    @Override
    public void setNetworkPrefix(String prefix) {
        this._prefix = prefix;
    }

    private Map<String, Long> getRoommate(Preferences prefs) {
        String roommate = prefs.get(CONCURRENT_ROOMMATE, null);
        if (roommate == null) {
            return Collections.EMPTY_MAP;
        }
        return (Map)JSONValue.parse((String)roommate);
    }

    @Override
    public String validate(String ... remotePackets) {
        String data;
        int quota;
        Preferences prefs = this.getPreferences();
        HashSet<String> maxConcurrentServers = new HashSet<String>();
        HashMap<String, Long> currentConcurrentServer = new HashMap<String, Long>();
        String myself = QuotaPacketImpl.getUid(prefs);
        long now = System.currentTimeMillis();
        long lessThanHour = now - HOUR;
        for (String packet : remotePackets) {
            JSONObject jsonObject = this.stringToJson(packet);
            String uid = (String)jsonObject.get((Object)UID);
            if (uid == null && (uid = Base64Coder.decodeString(packet)).length() != 10) continue;
            boolean isMyself = myself.equals(uid);
            Object roommate = jsonObject.get((Object)CONCURRENT_ROOMMATE);
            if (roommate instanceof Map) {
                Map selfRoommate = (Map)roommate;
                for (Map.Entry me : selfRoommate.entrySet()) {
                    if ((Long)me.getValue() <= lessThanHour) continue;
                    maxConcurrentServers.add((String)me.getKey());
                    if (!isMyself) continue;
                    currentConcurrentServer.put((String)me.getKey(), (Long)me.getValue());
                }
            }
            currentConcurrentServer.put(uid, now);
            maxConcurrentServers.add(uid);
        }
        prefs.put(CONCURRENT_ROOMMATE, JSONObject.toJSONString(currentConcurrentServer));
        int cMax = maxConcurrentServers.size();
        int max = prefs.getInt(MAX_NUMBER_CONCURRENT_SERVERS_TODAY, 0);
        if (max < cMax) {
            prefs.put(MAX_NUMBER_CONCURRENT_SERVERS_TODAY, String.valueOf(cMax));
        }
        if ((quota = Integer.parseInt((data = this._licenseInfo.get(this.getGroupId())) != null ? data : "5")) < cMax) {
            String msg = WebApps.getFeature((String)"ee") ? "EE" : "PE";
            return CONCURRENT_LIMIT.replaceAll("\\{0\\}", msg).replaceAll("\\{1\\}", String.valueOf(quota));
        }
        return null;
    }

    @Override
    public String getScript(String ... remotePackets) {
        Preferences prefs = this.getPreferences();
        Object s = "";
        String gtagId = "G-E1QGSJ396G";
        String uid = QuotaPacketImpl.getUid(prefs);
        s = (String)s + "gtag('config', 'G-E1QGSJ396G', {'user_id': '" + uid + "', 'legacy_cookie_domain': 'zkoss.org', 'page_location': 'http://www.zkoss.org/eval'});";
        s = (String)s + "gtag('event', 'user_properties', {";
        String gaSetFormatter = "'%1$s': '%2$s',";
        String gaSetFormatterInt = "'%1$s': %2$d,";
        String gaSetFormatterBool = "'%1$s': %2$s,";
        String edition = WebApps.getFeature((String)"ee") ? "ZK EE" : "ZK PE";
        int ndu = prefs.getInt(NUMBER_DAYS_USING, 1);
        Date initDate = null;
        try {
            initDate = JSONs.j2d((String)prefs.get(INIT_DATE, null));
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
        GregorianCalendar beginOfInitDate = new GregorianCalendar();
        beginOfInitDate.setTime(initDate);
        beginOfInitDate.set(11, 0);
        beginOfInitDate.set(12, 0);
        beginOfInitDate.set(13, 0);
        beginOfInitDate.set(14, 0);
        int ndi = QuotaPacketImpl.toDays(beginOfInitDate.getTime());
        s = (String)s + String.format(gaSetFormatter, "appName", edition);
        s = (String)s + String.format(gaSetFormatter, "appVersion", "10.2.0.FL.20250428");
        s = (String)s + String.format(gaSetFormatter, "appId", uid);
        if (this._cid != null) {
            s = (String)s + String.format(gaSetFormatter, "appInstallerId", this._cid + Integer.toString(2, 36));
        }
        if (this._prefix != null && !this._prefix.equals(this._networkPrefix)) {
            s = (String)s + String.format(gaSetFormatter, "screenColors", "2-bit");
        }
        s = (String)s + String.format(gaSetFormatter, "flashVersion", prefs.get(MAX_NUMBER_CONCURRENT_SERVERS_LAST_TIME, "0"));
        s = (String)s + String.format(gaSetFormatterInt, "dimension1", ndi);
        s = (String)s + String.format(gaSetFormatterInt, "dimension2", ndu);
        s = (String)s + "});";
        return String.format(SCRIPT, "G-E1QGSJ396G", s);
    }

    private static int toDays(Date lastDate) {
        long ms = new Date().getTime() - lastDate.getTime();
        return new Double(Math.ceil((double)ms / ((double)DAY * 1.0))).intValue();
    }

    private static String genUid() {
        return QuotaPacketImpl.encode(UUID.randomUUID().toString().replace("-", "").replace(":", "").toUpperCase(), -1);
    }

    private static String encode(String val, int length) {
        if (length < 0) {
            return DigestUtilsHelper.md5Hex((String)Base64Coder.encodeString(val));
        }
        return DigestUtilsHelper.md5Hex((String)Base64Coder.encodeString(val)).substring(0, length);
    }

    private static String encode(String val) {
        return QuotaPacketImpl.encode(val, 10);
    }
}

