/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt.quota;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zkex.rt.RuntimeUtil;
import org.zkoss.zkex.rt.quota.QuotaPacket;
import org.zkoss.zkex.rt.quota.QuotaServer;
import org.zkoss.zkex.util.Base64Coder;

public class QuotaClient
implements Runnable {
    private volatile Map<String, QuotaPacket> _packs;

    private QuotaClient() {
    }

    public static QuotaClient getInstance() {
        return QuotaClientThreadHolder.INSTANCE;
    }

    void init(Map<String, QuotaPacket> packs) {
        this._packs = packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> checkQuota() {
        HashMap<String, String> ips = new HashMap<String, String>();
        try (DatagramSocket c = null;){
            c = new DatagramSocket();
            c.setBroadcast(true);
            c.setSoTimeout(300);
            byte[] sendData = QuotaServer.QUOTA_SERVER_REQUEST.getBytes();
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, InetAddress.getByName("255.255.255.255"), 12630);
            c.send(sendPacket);
            long endTime = System.currentTimeMillis() + 3000L;
            while (System.currentTimeMillis() <= endTime) {
                byte[] recvBuf = new byte[65507];
                DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
                try {
                    c.receive(receivePacket);
                }
                catch (SocketTimeoutException e) {
                    break;
                }
                String message = new String(receivePacket.getData()).trim();
                if (message == null || !message.startsWith(QuotaServer.QUOTA_SERVER_RESPONSE)) continue;
                String info = message.substring(QuotaServer.QUOTA_SERVER_RESPONSE.length());
                ips.put(receivePacket.getAddress().getHostAddress(), info);
            }
        }
        return ips;
    }

    @Override
    public void run() {
        try {
            Object json;
            WebApp webApp = WebApps.getCurrent();
            if (webApp == null) {
                return;
            }
            Map<String, String> stringMap = QuotaClient.checkQuota();
            HashMap<String, LinkedList<String>> dataSet = new HashMap<String, LinkedList<String>>(5);
            for (String data : stringMap.values()) {
                if (data.length() % 4 != 0) {
                    data = data.substring(3);
                }
                json = (JSONObject)JSONValue.parse((String)Base64Coder.decodeString(data));
                for (Map.Entry me : json.entrySet()) {
                    LinkedList<String> strings = (LinkedList<String>)dataSet.get(me.getKey());
                    if (strings == null) {
                        strings = new LinkedList<String>();
                        dataSet.put((String)me.getKey(), strings);
                    }
                    strings.add((String)me.getValue());
                }
            }
            StringBuffer msg = new StringBuffer();
            StringBuffer script = new StringBuffer();
            if (!dataSet.isEmpty()) {
                for (Map.Entry entry : this._packs.entrySet()) {
                    String script1;
                    List strings = (List)dataSet.get(entry.getKey());
                    if (strings == null) continue;
                    QuotaPacket quotaPacket = (QuotaPacket)entry.getValue();
                    String[] remotePackets = strings.toArray(new String[0]);
                    String result = null;
                    result = quotaPacket.validate(remotePackets);
                    if (result != null) {
                        msg.append(result).append("\n");
                    }
                    if ((script1 = quotaPacket.getScript(remotePackets)) == null) continue;
                    script.append(script1);
                }
            }
            if (msg.length() > 0 || script.length() > 0) {
                json = new JSONObject();
                if (msg.length() > 0) {
                    json.put((Object)"msg", (Object)msg.toString());
                }
                if (script.length() > 0) {
                    json.put((Object)"script", (Object)script.toString());
                }
                RuntimeUtil.setPrefs(webApp, Base64Coder.encodeString(json.toJSONString()));
            }
        }
        catch (Throwable e) {
            RuntimeUtil.sendError(e);
        }
    }

    private static class QuotaClientThreadHolder {
        private static final QuotaClient INSTANCE = new QuotaClient();

        private QuotaClientThreadHolder() {
        }
    }
}

