/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormLegacy;
import org.zkoss.bind.FormLegacyExt;
import org.zkoss.bind.FormStatus;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.BindContextImpl;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.FormBindingImpl;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.proxy.FormProxyHandler;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.SaveInfo;
import org.zkoss.bind.sys.debugger.impl.info.ValidationInfo;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class SaveFormBindingImpl
extends FormBindingImpl
implements SaveFormBinding {
    private static final Logger log = LoggerFactory.getLogger(SaveFormBindingImpl.class);
    private static final long serialVersionUID = 1463169907348730644L;
    private final ExpressionX _validator;
    private final Map<String, Object> _validatorArgs;
    private static final String VALUEREF = "$VALUEREF$";

    public SaveFormBindingImpl(Binder binder, Component comp, String formId, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        super(binder, comp, formId, saveExpr, conditionType, command, bindingArgs);
        BindEvaluatorX eval = binder.getEvaluatorX();
        this._validator = validatorExpr == null ? null : this.parseValidator(eval, validatorExpr);
        this._validatorArgs = validatorArgs;
        Form form = this.getFormBean();
        if (form instanceof FormLegacy) {
            return;
        }
        this.getFormBean(BindContextUtil.newBindContext(binder, this, false, null, this.getComponent(), null));
    }

    @Override
    public Map<String, Object> getValidatorArgs() {
        return this._validatorArgs;
    }

    @Override
    protected boolean ignoreTracker() {
        return true;
    }

    private ExpressionX parseValidator(BindEvaluatorX eval, String validatorExpr) {
        return eval.parseExpressionX(null, validatorExpr, Object.class);
    }

    @Override
    public Validator getValidator() {
        if (this._validator == null) {
            return null;
        }
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(null, this.getComponent(), this._validator);
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getValidator((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._validator.getExpressionString() + "' is not a Validator, is " + String.valueOf(obj));
    }

    public Form getFormBean(BindContext ctx) {
        Form form = this.getFormBean();
        if (form == null) {
            Component comp;
            Object bean;
            Binder binder = this.getBinder();
            BindEvaluatorX eval = binder.getEvaluatorX();
            form = this.initFormBean(bean, (bean = eval.getValue(ctx, comp = this.getComponent(), this._accessInfo.getProperty())) == null ? eval.getType(ctx, comp, this._accessInfo.getProperty()) : bean.getClass(), ctx);
        }
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(BindContext ctx) {
        Binder binder = this.getBinder();
        Component comp = this.getComponent();
        Form form = this.getFormBean(ctx);
        BindingExecutionInfoCollector collector = ((BinderCtrl)((Object)this.getBinder())).getBindingExecutionInfoCollector();
        if (form instanceof FormLegacy) {
            if (form instanceof FormLegacyExt) {
                BindEvaluatorX eval = binder.getEvaluatorX();
                for (String field : ((FormLegacyExt)((Object)form)).getSaveFieldNames()) {
                    ExpressionX expr = this.getFieldExpression(eval, field);
                    if (expr == null) continue;
                    ExpressionX formExpr = this.getFormExpression(eval, field);
                    Object value = eval.getValue(null, comp, formExpr);
                    eval.setValue(ctx, comp, expr, value);
                }
            }
        } else {
            FormStatus formStatus = form.getFormStatus();
            if (formStatus.isDirty()) {
                Object origin = null;
                try {
                    if (this._accessInfo.getProperty().getExpressionString().contains(".")) {
                        try {
                            MethodHandler handler;
                            ValueReference valueReference = this.getValueReference(ctx);
                            Object target = Fields.get((Object)valueReference.getBase(), (String)((String)valueReference.getProperty()));
                            Object formStatusOrigin = formStatus.getOrigin();
                            if (formStatusOrigin != null && !formStatusOrigin.equals(target) && (handler = ProxyFactory.getHandler((Proxy)((Proxy)formStatusOrigin))) instanceof FormProxyHandler) {
                                Field originField = handler.getClass().getSuperclass().getDeclaredField("_origin");
                                originField.setAccessible(true);
                                origin = originField.get(handler);
                                originField.set(handler, target);
                                originField.setAccessible(false);
                            }
                        }
                        catch (Throwable valueReference) {
                            // empty catch block
                        }
                    }
                    formStatus.submit(ctx);
                }
                finally {
                    if (origin != null) {
                        try {
                            Object formStatusOrigin = formStatus.getOrigin();
                            MethodHandler handler = ProxyFactory.getHandler((Proxy)((Proxy)formStatusOrigin));
                            Field originField = handler.getClass().getSuperclass().getDeclaredField("_origin");
                            originField.setAccessible(true);
                            originField.set(handler, origin);
                            originField.setAccessible(false);
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                }
            }
            binder.notifyChange(formStatus, ".");
        }
        if (collector != null) {
            collector.addInfo(new SaveInfo("form-save", comp, this.getConditionString(ctx), this.getFormId(), this.getPropertyString(), form, this.getArgs(), null));
        }
    }

    private String getConditionString(BindContext ctx) {
        StringBuilder condition = new StringBuilder();
        if (this.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(this.getCommandName()).append("'");
        } else if (this.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(this.getCommandName()).append("'");
        } else {
            condition.append((String)(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName()));
        }
        return condition.length() == 0 ? null : condition.toString();
    }

    @Override
    public Property getValidate(BindContext ctx) {
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        Form form = this.getFormBean(ctx);
        ExpressionX expr = this.getBaseExpression(eval);
        if (expr != null) {
            Object base = eval.getValue(ctx, comp, expr);
            return new PropertyImpl(base, ".", form);
        }
        return null;
    }

    @Override
    public Set<Property> getValidates(BindContext ctx) {
        HashSet<Property> properties = new HashSet<Property>(2);
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        Form form = this.getFormBean(ctx);
        if (form instanceof Form) {
            for (String field : ((BinderCtrl)((Object)binder)).getSaveFormFieldNames(form)) {
                ExpressionX expr;
                if (field.indexOf("[$INDEX$]") != -1 || (expr = this.getFieldExpression(eval, field)) == null) continue;
                ExpressionX formExpr = this.getFormExpression(eval, field);
                Object value = eval.getValue(null, comp, formExpr);
                ValueReference valref = null;
                try {
                    valref = eval.getValueReference(ctx, comp, expr);
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
                if (valref == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("value reference not found by expression [{}], check if you are trying to save to a variable only expression", (Object)expr.getExpressionString());
                    continue;
                }
                properties.add(new PropertyImpl(valref.getBase(), (String)valref.getProperty(), value));
            }
        }
        return properties;
    }

    @Override
    public boolean hasValidator() {
        return this._validator != null;
    }

    public String getValidatorExpressionString() {
        return this._validator == null ? null : BindEvaluatorXUtil.getExpressionString(this._validator);
    }

    @Override
    public void validate(ValidationContext vctx) {
        Validator validator = this.getValidator();
        if (validator == null) {
            throw new NullPointerException("cannot find validator for " + String.valueOf(this));
        }
        validator.validate(vctx);
        BindingExecutionInfoCollector collector = ((BinderCtrl)((Object)this.getBinder())).getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new ValidationInfo("prop", this.getComponent(), this.getValidatorExpressionString(), validator.toString(), vctx.isValid(), ((BindContextImpl)vctx.getBindContext()).getValidatorArgs(), null));
        }
    }

    private ValueReference getValueReference(BindContext ctx) {
        ValueReference valref = (ValueReference)this.getAttribute(ctx, VALUEREF);
        if (valref == null) {
            Component comp = this.getComponent();
            BindEvaluatorX eval = this.getBinder().getEvaluatorX();
            valref = eval.getValueReference(ctx, comp, this._accessInfo.getProperty());
            if (valref == null) {
                throw new UiException("value reference not found by expression [" + this._accessInfo.getProperty().getExpressionString() + "], check if you are trying to save to a variable only expression");
            }
            this.setAttribute(ctx, VALUEREF, valref);
        }
        return valref;
    }

    private Method getValidatorMethod(Class<? extends Validator> cls) {
        try {
            return cls.getMethod("validate", ValidationContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

