/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableElements;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyNodeImpl;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.lang.Objects;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.ListModelSet;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.SelectionControl;

public class ListModelSetProxy<E>
extends ListModelSet<E>
implements Proxy,
FormProxyObject,
Serializable {
    private static final long serialVersionUID = 20210608113022L;
    private ListModelSet<E> _cache;
    private ListModelSet<E> _origin;
    private boolean _dirty;
    private boolean isImmutableElements;
    private ProxyNode _node;

    public ListModelSetProxy(ListModelSet<E> origin, Annotation[] callerAnnots) {
        this._origin = origin;
        this._cache = this.initCache();
        if (callerAnnots != null) {
            for (Annotation annot : callerAnnots) {
                if (!annot.annotationType().isAssignableFrom(ImmutableElements.class)) continue;
                this.isImmutableElements = true;
                break;
            }
        }
        this.resetFromOrigin();
    }

    private ListModelSet<E> initCache() {
        ListModelSet cache = new ListModelSet(this.getOriginObject().size());
        return cache;
    }

    private ListModelSet<E> getCache() {
        return this._cache;
    }

    public void onDirtyChange() {
        ProxyHelper.callOnDirtyChange(this._node);
    }

    public void onDataChange(Object o) {
        ProxyHelper.callOnDataChange(this._node, new Object[]{o, "."});
    }

    protected void setDirty(boolean d) {
        if (this._dirty != d) {
            this._dirty = d;
            this.onDirtyChange();
        }
        if (d) {
            this.onDataChange(this);
        }
    }

    public void addListDataListener(ListDataListener l) {
        this.getCache().addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.getCache().removeListDataListener(l);
    }

    public Set<E> getSelection() {
        return this.getCache().getSelection();
    }

    public void setSelection(Collection<? extends E> selection) {
        this.getCache().setSelection(selection);
        this.setDirty(true);
    }

    public boolean isSelected(Object obj) {
        return this.getCache().isSelected(obj);
    }

    public boolean isSelectionEmpty() {
        return this.getCache().isSelectionEmpty();
    }

    public boolean addToSelection(E obj) {
        boolean result = this.getCache().addToSelection(obj);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public boolean removeFromSelection(Object obj) {
        boolean result = this.getCache().removeFromSelection(obj);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public void clearSelection() {
        if (!this.getCache().getSelection().isEmpty()) {
            this.getCache().clearSelection();
            this.setDirty(true);
        }
    }

    public void setMultiple(boolean multiple) {
        if (this.getCache().isMultiple() != multiple) {
            this.getCache().setMultiple(multiple);
            this.setDirty(true);
        }
    }

    public void setSelectionControl(SelectionControl ctrl) {
        this.getCache().setSelectionControl(ctrl);
    }

    public SelectionControl getSelectionControl() {
        return this.getCache().getSelectionControl();
    }

    public int getPageSize() {
        return this.getCache().getPageSize();
    }

    public void setPageSize(int size) throws WrongValueException {
        this.getCache().setPageSize(size);
        this.setDirty(true);
    }

    public int getPageCount() {
        return this.getCache().getPageCount();
    }

    public int getActivePage() {
        return this.getCache().getActivePage();
    }

    public void setActivePage(int pg) throws WrongValueException {
        this.getCache().setActivePage(pg);
        this.setDirty(true);
    }

    public void addPagingEventListener(PagingListener l) {
        this.getCache().addPagingEventListener(l);
    }

    public void removePagingEventListener(PagingListener l) {
        this.getCache().removePagingEventListener(l);
    }

    public Set<E> getInnerSet() {
        return this.getCache().getInnerSet();
    }

    public int getSize() {
        return this.getCache().getSize();
    }

    public E getElementAt(int j) {
        return (E)this.getCache().getElementAt(j);
    }

    public boolean notifyChange(E element) {
        return this.getCache().notifyChange(element);
    }

    public boolean add(E o) {
        if (this.getCache().add(this.createProxyObject(o))) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        if (modified) {
            this.setDirty(true);
        }
        return modified;
    }

    public void clear() {
        this.getCache().clear();
        this.setDirty(true);
    }

    public boolean contains(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (!ListModelSetProxy.testEquals(e.next(), null)) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!ListModelSetProxy.testEquals(o, e.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this.getCache().equals(o);
    }

    public int hashCode() {
        return this.getCache().hashCode();
    }

    public boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    public String toString() {
        return this.getCache().toString();
    }

    public Iterator<E> iterator() {
        return this.getCache().iterator();
    }

    public boolean remove(Object o) {
        if (this.getCache().remove(this.createProxyObject(o))) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public int indexOf(Object o) {
        return this.getCache().indexOf(o);
    }

    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        c = this.createProxyObject(c);
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        if (modified) {
            this.setDirty(true);
        }
        return modified;
    }

    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        c = this.createProxyObject(c);
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        if (modified) {
            this.setDirty(true);
        }
        return modified;
    }

    public int size() {
        return this.getCache().size();
    }

    public Object[] toArray() {
        return this.getCache().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getCache().toArray((Object[])a);
    }

    public void sort(Comparator<E> cmpr, boolean ascending) {
        this.getCache().sort(cmpr, ascending);
        this.setDirty(true);
    }

    public void sort() {
        this.getCache().sort();
        this.setDirty(true);
    }

    public String getSortDirection(Comparator<E> cmpr) {
        return this.getCache().getSortDirection(cmpr);
    }

    public Object clone() {
        return this.getCache().clone();
    }

    public void addSelection(E obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }

    public void setHandler(MethodHandler mi) {
        throw new UnsupportedOperationException("Not support!");
    }

    public ListModelSet<E> getOriginObject() {
        return this._origin;
    }

    public void resetFromOrigin() {
        this.getCache().clear();
        this.setDirty(false);
        for (Object e : this.getOriginObject()) {
            this.getCache().add(this.createProxyObject(e));
        }
    }

    public void submitToOrigin(BindContext ctx) {
        ListModelSet<Object> origin = this.getOriginObject();
        origin.clear();
        for (Object e : this._cache) {
            if (e instanceof FormProxyObject) {
                FormProxyObject proxy = (FormProxyObject)e;
                proxy.submitToOrigin(ctx);
                origin.add(proxy.getOriginObject());
                continue;
            }
            origin.add(e);
        }
        this.setDirty(false);
    }

    public boolean isFormDirty() {
        if (this._dirty) {
            return true;
        }
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            E o = e.next();
            if (!(o instanceof FormProxyObject) || !((FormProxyObject)o).isFormDirty()) continue;
            return true;
        }
        return false;
    }

    public void setFormOwner(Object owner, FormBinding binding) {
        throw new IllegalAccessError("Not supported");
    }

    public void setPath(String property, ProxyNode parent) {
        if (property == null && this._node != null) {
            this._node.setParent(parent);
        } else {
            this._node = new ProxyNodeImpl(property, parent);
            for (Object e : this._cache) {
                if (!(e instanceof FormProxyObject)) continue;
                ((FormProxyObject)e).setPath("[$INDEX$]", this._node);
            }
        }
    }

    public void cacheSavePropertyBinding(String property, SavePropertyBinding s) {
        ProxyHelper.cacheSavePropertyBinding(this._node, this._node.getProperty() + property, s);
    }

    public Set<Pair<String, SavePropertyBinding>> collectCachedSavePropertyBinding() {
        throw new UnsupportedOperationException("Not support!");
    }

    protected static boolean testEquals(Object e, Object o) {
        if (e == o) {
            return true;
        }
        if (e instanceof FormProxyObject) {
            Object eo = ((FormProxyObject)e).getOriginObject();
            Object oo = o;
            if (o instanceof FormProxyObject) {
                oo = ((FormProxyObject)o).getOriginObject();
            }
            if (Objects.equals((Object)eo, (Object)oo)) {
                return true;
            }
        } else if (o instanceof FormProxyObject ? Objects.equals((Object)e, (Object)((FormProxyObject)o).getOriginObject()) : Objects.equals((Object)e, (Object)o)) {
            return true;
        }
        return false;
    }

    protected <T> T createProxyObject(T t) {
        T p;
        T t2 = p = this.isImmutableElements ? t : ProxyHelper.createProxyIfAny(t);
        if (p instanceof FormProxyObject) {
            ((FormProxyObject)p).setPath("[$INDEX$]", this._node);
        }
        return p;
    }
}

