/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableElements;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyNodeImpl;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.lang.Objects;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.SelectionControl;

public class ListModelArrayProxy<E>
extends ListModelArray<E>
implements Proxy,
FormProxyObject,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ListModelArrayProxy.class);
    private static final long serialVersionUID = 20210608113022L;
    private ListModelArray<E> _cache;
    private ListModelArray<E> _origin;
    private boolean _dirty;
    private boolean isImmutableElements;
    private ProxyNode _node;

    public ListModelArrayProxy(ListModelArray<E> origin, Annotation[] callerAnnots) {
        super(0);
        this._origin = origin;
        this._cache = this.initCache();
        if (callerAnnots != null) {
            for (Annotation annot : callerAnnots) {
                if (!annot.annotationType().isAssignableFrom(ImmutableElements.class)) continue;
                this.isImmutableElements = true;
                break;
            }
        }
        this.resetFromOrigin();
    }

    private ListModelArray<E> initCache() {
        ListModelArray cache = new ListModelArray(this.getOriginObject().getSize());
        return cache;
    }

    private ListModelArray<E> getCache() {
        return this._cache;
    }

    public void onDirtyChange() {
        ProxyHelper.callOnDirtyChange(this._node);
    }

    public void onDataChange(Object o) {
        ProxyHelper.callOnDataChange(this._node, new Object[]{o, "."});
    }

    protected void setDirty(boolean d) {
        if (this._dirty != d) {
            this._dirty = d;
            this.onDirtyChange();
        }
        if (d) {
            this.onDataChange(this);
        }
    }

    public void addListDataListener(ListDataListener l) {
        this.getCache().addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.getCache().removeListDataListener(l);
    }

    public Set<E> getSelection() {
        return this.getCache().getSelection();
    }

    public void setSelection(Collection<? extends E> selection) {
        this.getCache().setSelection(selection);
        this.setDirty(true);
    }

    public boolean isSelected(Object obj) {
        return this.getCache().isSelected(obj);
    }

    public boolean isSelectionEmpty() {
        return this.getCache().isSelectionEmpty();
    }

    public boolean addToSelection(E obj) {
        boolean result = this.getCache().addToSelection(obj);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public boolean removeFromSelection(Object obj) {
        boolean result = this.getCache().removeFromSelection(obj);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public void clearSelection() {
        if (!this.getCache().getSelection().isEmpty()) {
            this.getCache().clearSelection();
            this.setDirty(true);
        }
    }

    public void setMultiple(boolean multiple) {
        if (this.getCache().isMultiple() != multiple) {
            this.getCache().setMultiple(multiple);
            this.setDirty(true);
        }
    }

    public int getPageSize() {
        return this.getCache().getPageSize();
    }

    public void setPageSize(int size) throws WrongValueException {
        this.getCache().setPageSize(size);
        this.setDirty(true);
    }

    public int getPageCount() {
        return this.getCache().getPageCount();
    }

    public int getActivePage() {
        return this.getCache().getActivePage();
    }

    public void setActivePage(int pg) throws WrongValueException {
        this.getCache().setActivePage(pg);
        this.setDirty(true);
    }

    public void setSelectionControl(SelectionControl ctrl) {
        this.getCache().setSelectionControl(ctrl);
    }

    public SelectionControl getSelectionControl() {
        return this.getCache().getSelectionControl();
    }

    public void addPagingEventListener(PagingListener l) {
        this.getCache().addPagingEventListener(l);
    }

    public void removePagingEventListener(PagingListener l) {
        this.getCache().removePagingEventListener(l);
    }

    public E get(int index) {
        return (E)this.getCache().getElementAt(index);
    }

    public void set(int index, E value) {
        this.getCache().set(index, value);
    }

    public Object[] getInnerArray() {
        return this.getCache().getInnerArray();
    }

    public int indexOf(Object elm) {
        return this.getCache().indexOf(elm);
    }

    public boolean notifyChange(E element) {
        return this.getCache().notifyChange(element);
    }

    public int getSize() {
        return this.getCache().getSize();
    }

    public E getElementAt(int j) {
        return (E)this.getCache().getElementAt(j);
    }

    public void sort(Comparator<E> cmpr, boolean ascending) {
        this.getCache().sort(cmpr, ascending);
        this.setDirty(true);
    }

    public void sort() {
        this.getCache().sort();
        this.setDirty(true);
    }

    public String getSortDirection(Comparator<E> cmpr) {
        return this.getCache().getSortDirection(cmpr);
    }

    public boolean equals(Object o) {
        return this.getCache().equals(o);
    }

    public int hashCode() {
        return this.getCache().hashCode();
    }

    public String toString() {
        return this.getCache().toString();
    }

    public Object clone() {
        return this.getCache().clone();
    }

    protected void fireSelectionEvent(E e) {
        Method m = null;
        try {
            m = this.getCache().getClass().getDeclaredMethod("fireSelectionEvent", e.getClass());
            m.setAccessible(true);
            m.invoke(this._cache, e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            log.warn("Exception occurred while firing selection event", (Throwable)ex);
        }
    }

    public void addSelection(E obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }

    public void setHandler(MethodHandler mi) {
        throw new UnsupportedOperationException("Not support!");
    }

    public ListModelArray<E> getOriginObject() {
        return this._origin;
    }

    public void resetFromOrigin() {
        this.setDirty(false);
        ListModelArray<E> originObject = this.getOriginObject();
        int size = this.getSize();
        ListModelArray<E> cache = this.getCache();
        for (int i = 0; i < size; ++i) {
            cache.set(i, originObject.get(i));
        }
    }

    public void submitToOrigin(BindContext ctx) {
        ListModelArray<E> origin = this.getOriginObject();
        int size = this.getSize();
        ListModelArray<E> cache = this.getCache();
        for (int i = 0; i < size; ++i) {
            Object e = cache.get(i);
            if (e instanceof FormProxyObject) {
                FormProxyObject proxy = (FormProxyObject)e;
                proxy.submitToOrigin(ctx);
                origin.set(i, proxy.getOriginObject());
                continue;
            }
            origin.set(i, e);
        }
        this.setDirty(false);
    }

    public boolean isFormDirty() {
        if (this._dirty) {
            return true;
        }
        int size = this.getSize();
        ListModelArray<E> cache = this.getCache();
        for (int i = 0; i < size; ++i) {
            Object e = cache.get(i);
            if (!(e instanceof FormProxyObject) || !((FormProxyObject)e).isFormDirty()) continue;
            return true;
        }
        return false;
    }

    public void setFormOwner(Object owner, FormBinding binding) {
        throw new IllegalAccessError("Not supported");
    }

    public void setPath(String property, ProxyNode parent) {
        if (property == null && this._node != null) {
            this._node.setParent(parent);
        } else {
            this._node = new ProxyNodeImpl(property, parent);
            int size = this.getSize();
            ListModelArray<E> cache = this.getCache();
            for (int i = 0; i < size; ++i) {
                Object e = cache.get(i);
                if (!(e instanceof FormProxyObject)) continue;
                ((FormProxyObject)e).setPath("[$INDEX$]", this._node);
            }
        }
    }

    public void cacheSavePropertyBinding(String property, SavePropertyBinding s) {
        ProxyHelper.cacheSavePropertyBinding(this._node, this._node.getProperty() + property, s);
    }

    public Set<Pair<String, SavePropertyBinding>> collectCachedSavePropertyBinding() {
        throw new UnsupportedOperationException("Not support!");
    }

    protected static boolean testEquals(Object e, Object o) {
        if (e == o) {
            return true;
        }
        if (e instanceof FormProxyObject) {
            Object eo = ((FormProxyObject)e).getOriginObject();
            Object oo = o;
            if (o instanceof FormProxyObject) {
                oo = ((FormProxyObject)o).getOriginObject();
            }
            if (Objects.equals((Object)eo, (Object)oo)) {
                return true;
            }
        } else if (o instanceof FormProxyObject ? Objects.equals((Object)e, (Object)((FormProxyObject)o).getOriginObject()) : Objects.equals((Object)e, (Object)o)) {
            return true;
        }
        return false;
    }

    protected <T> T createProxyObject(T t) {
        T p;
        T t2 = p = this.isImmutableElements ? t : ProxyHelper.createProxyIfAny(t);
        if (p instanceof FormProxyObject) {
            ((FormProxyObject)p).setPath("[$INDEX$]", this._node);
        }
        return p;
    }
}

