/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.BindContextImpl;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.PropertyBindingImpl;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.impl.WrongValuePropertyImpl;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.SaveInfo;
import org.zkoss.bind.sys.debugger.impl.info.ValidationInfo;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.xel.zel.ELXelExpression;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.WrongValuesException;

public class SavePropertyBindingImpl
extends PropertyBindingImpl
implements SavePropertyBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private final ExpressionX _validator;
    private final Map<String, Object> _validatorArgs;
    private FormFieldInfo _formFieldInfo;
    private static final String COMPVALUE = "$COMPVALUE$";
    private static final String COMPVALUENOCONVERT = "$COMPVALUENOCONVERT$";
    private static final String VALUEREF = "$VALUEREF$";

    public SavePropertyBindingImpl(Binder binder, Component comp, String attr, String saveAttr, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        super(binder, comp, attr, "self." + saveAttr, saveExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
        Object base;
        BindEvaluatorX eval = binder.getEvaluatorX();
        this._validator = validatorExpr == null ? null : this.parseValidator(eval, validatorExpr);
        this._validatorArgs = validatorArgs;
        BindContext ctx = BindContextUtil.newBindContext(this.getBinder(), this, true, null, this.getComponent(), null);
        ctx.setAttribute((Object)"$IGNORE_REF_VALUE$", (Object)Boolean.FALSE);
        ctx.setAttribute((Object)"$IGNORE_TRACKER$", (Object)Boolean.TRUE);
        ValueReference valref = null;
        try {
            valref = eval.getValueReference(ctx, this.getComponent(), this._accessInfo.getProperty());
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        if (valref != null && (base = valref.getBase()) instanceof FormProxyObject) {
            ((FormProxyObject)base).cacheSavePropertyBinding((String)valref.getProperty(), (SavePropertyBinding)this);
        }
    }

    public Map<String, Object> getValidatorArgs() {
        return this._validatorArgs;
    }

    @Override
    protected boolean ignoreTracker() {
        return true;
    }

    private ExpressionX parseValidator(BindEvaluatorX eval, String validatorExpr) {
        return eval.parseExpressionX(null, validatorExpr, Object.class);
    }

    public Validator getValidator() {
        if (this._validator == null) {
            return null;
        }
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(null, this.getComponent(), this._validator);
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getValidator((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._validator.getExpressionString() + "' is not a Validator, is " + obj);
    }

    private Object getComponentValue(BindContext ctx) {
        if (!this.containsAttribute(ctx, COMPVALUE)) {
            Component comp = this.getComponent();
            BindEvaluatorX eval = this.getBinder().getEvaluatorX();
            Object value = eval.getValue(null, comp, this._fieldExpr);
            this.setAttribute(ctx, COMPVALUENOCONVERT, value);
            Converter conv = this.getConverter();
            if (conv != null) {
                value = conv.coerceToBean(value, comp, ctx);
            }
            this.setAttribute(ctx, COMPVALUE, value);
        }
        return this.getAttribute(ctx, COMPVALUE);
    }

    public String getValidatorExpressionString() {
        return this._validator == null ? null : BindEvaluatorXUtil.getExpressionString(this._validator);
    }

    public void save(BindContext ctx) {
        BindingExecutionInfoCollector collector = ((BinderCtrl)this.getBinder()).getBindingExecutionInfoCollector();
        Component comp = this.getComponent();
        Object value = this.getComponentValue(ctx);
        if (value == Converter.IGNORED_VALUE) {
            if (collector != null) {
                Object old = this.getAttribute(ctx, COMPVALUENOCONVERT);
                collector.addInfo(new SaveInfo("prop-save", comp, this.getConditionString(ctx), this.getFieldName(), this.getPropertyString(), old, this.getArgs(), "*Converter.IGNORED_VALUE"));
            }
            return;
        }
        if (collector != null) {
            collector.addInfo(new SaveInfo("prop-save", comp, this.getConditionString(ctx), this.getFieldName(), this.getPropertyString(), value, this.getArgs(), null));
        }
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        eval.setValue(ctx, comp, this._accessInfo.getProperty(), value);
    }

    private String getConditionString(BindContext ctx) {
        StringBuilder condition = new StringBuilder();
        if (this.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(this.getCommandName()).append("'");
        } else if (this.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(this.getCommandName()).append("'");
        } else {
            condition.append((String)(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName()));
        }
        return condition.toString();
    }

    private ValueReference getValueReference(BindContext ctx) {
        ValueReference valref = (ValueReference)this.getAttribute(ctx, VALUEREF);
        if (valref == null) {
            if (this._formFieldInfo != null && this._formFieldInfo._fieldName.indexOf("[$INDEX$]") == -1) {
                Object form = this.getComponent().getAttribute(this._formFieldInfo._id, true);
                String fieldName = this._formFieldInfo._fieldName;
                valref = new ELXelExpression.ValueReferenceImpl(form, (Object)fieldName);
            } else {
                Component comp = this.getComponent();
                BindEvaluatorX eval = this.getBinder().getEvaluatorX();
                valref = eval.getValueReference(ctx, comp, this._accessInfo.getProperty());
                if (valref == null) {
                    throw new UiException("value reference not found by expression [" + this._accessInfo.getProperty().getExpressionString() + "], check if you are trying to save to a variable only expression");
                }
            }
            this.setAttribute(ctx, VALUEREF, valref);
        }
        return valref;
    }

    void setFormFieldInfo(Component formComp, String formId, String fieldName) {
        if (this._formFieldInfo == null) {
            this._formFieldInfo = new FormFieldInfo();
        }
        this._formFieldInfo._component = formComp;
        this._formFieldInfo._id = formId;
        this._formFieldInfo._fieldName = fieldName;
    }

    public Property getValidate(BindContext ctx) {
        ValueReference ref = this.getValueReference(ctx);
        try {
            Object value = this.getComponentValue(ctx);
            return new PropertyImpl(ref.getBase(), String.valueOf(ref.getProperty()), value == Converter.IGNORED_VALUE ? null : value);
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof WrongValueException) && !(t instanceof WrongValuesException)) continue;
                return new WrongValuePropertyImpl(ref.getBase(), (String)ref.getProperty(), t);
            }
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    public boolean hasValidator() {
        return this._validator != null;
    }

    public void validate(ValidationContext vctx) {
        Validator validator = this.getValidator();
        if (validator == null) {
            throw new NullPointerException("cannot find validator for " + this);
        }
        if (this._formFieldInfo != null) {
            vctx.getBindContext().setAttribute((Object)"$LOAD_FORM_COMP$", (Object)this._formFieldInfo._component);
        }
        validator.validate(vctx);
        BindingExecutionInfoCollector collector = ((BinderCtrl)this.getBinder()).getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new ValidationInfo("prop", this.getComponent(), this.getValidatorExpressionString(), validator.toString(), vctx.isValid(), ((BindContextImpl)vctx.getBindContext()).getValidatorArgs(), null));
        }
    }

    private Method getConverterMethod(Class<? extends Converter> cls) {
        try {
            return cls.getMethod("coerceToBean", Object.class, Component.class, BindContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Method getValidatorMethod(Class<? extends Validator> cls) {
        try {
            return cls.getMethod("validate", ValidationContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Property getBasePropertyIfFromCollection() {
        BindContext ctx;
        ValueReference valref;
        PropertyImpl p = null;
        int index = -1;
        String fieldName = "";
        if (this._formFieldInfo != null && (fieldName = this._formFieldInfo._fieldName) != null && (index = fieldName.indexOf("[$INDEX$]")) != -1 && (valref = this.getValueReference(ctx = BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null))) != null) {
            Object base = valref.getBase();
            if (base instanceof FormProxyObject) {
                base = ((FormProxyObject)base).getOriginObject();
            }
            if (base != null) {
                BindEvaluatorX eval = this.getBinder().getEvaluatorX();
                Object value = eval.getValue(ctx, this.getComponent(), this._accessInfo.getProperty());
                String replacedFieldString = fieldName.substring(0, index) + ".$each";
                if (fieldName.length() > index + 9) {
                    replacedFieldString = replacedFieldString + fieldName.substring(index + 9);
                }
                p = new PropertyImpl(base, replacedFieldString, value);
            }
        }
        return p;
    }

    private static class FormFieldInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Component _component;
        private String _fieldName;
        private String _id;

        private FormFieldInfo() {
        }
    }
}

