/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Map;
import java.util.regex.Pattern;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.AccessInfo;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BindingImpl;
import org.zkoss.bind.impl.PropertyExpression;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;

public abstract class PropertyBindingImpl
extends BindingImpl
implements PropertyBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    protected final ExpressionX _fieldExpr;
    protected final AccessInfo _accessInfo;
    private final ExpressionX _converter;
    private final Map<String, Object> _converterArgs;
    private String _filedName;
    private static final Pattern FIELD_COMPILER = Pattern.compile("(?:\\(|\\)|\\[|\\]|\\.)");

    protected PropertyBindingImpl(Binder binder, Component comp, String fieldName, String fieldExpr, String accessExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        super(binder, comp, bindingArgs);
        BindEvaluatorX eval = binder.getEvaluatorX();
        Class<Object> returnType = Object.class;
        this._fieldExpr = !FIELD_COMPILER.matcher(fieldName).find() ? (fieldExpr.contains("self.") ? new PropertyExpression(comp, fieldExpr.substring(5)) : eval.parseExpressionX(null, fieldExpr, returnType)) : eval.parseExpressionX(null, fieldExpr, returnType);
        this._accessInfo = AccessInfo.create(this, accessExpr, returnType, conditionType, command, this.ignoreTracker());
        this._converterArgs = converterArgs;
        this._converter = converterExpr == null ? null : this.parseConverter(eval, converterExpr);
        this._filedName = fieldName;
    }

    public Map<String, Object> getConverterArgs() {
        return this._converterArgs;
    }

    protected boolean ignoreTracker() {
        return false;
    }

    private ExpressionX parseConverter(BindEvaluatorX eval, String converterExpr) {
        BindContext ctx = BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null);
        return eval.parseExpressionX(ctx, converterExpr, Object.class);
    }

    public Converter getConverter() {
        if (this._converter == null) {
            return null;
        }
        BindContext ctx = BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null);
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(ctx, this.getComponent(), this._converter);
        if (obj instanceof Converter) {
            return (Converter)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getConverter((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._converter.getExpressionString() + "' is not a Converter, is " + obj);
    }

    public String getFieldName() {
        return this._filedName;
    }

    public String getCommandName() {
        return this._accessInfo.getCommandName();
    }

    public String getPropertyString() {
        return BindEvaluatorXUtil.getExpressionString(this._accessInfo.getProperty());
    }

    public ConditionType getConditionType() {
        return this._accessInfo.getConditionType();
    }

    public ExpressionX getProperty() {
        return this._accessInfo.getProperty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ",component:" + this.getComponent() + ",field:" + this.getFieldName() + ",access:" + this.getProperty().getExpressionString() + ",condition:" + this.getConditionType() + ",command:" + this.getCommandName();
    }
}

