/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.List;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.BindChildRenderer;
import org.zkoss.bind.impl.ChildrenBindingImpl;
import org.zkoss.bind.impl.ChildrenBindingListDataListener;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.InitChildrenBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.LoadInfo;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataListener;

public class InitChildrenBindingImpl
extends ChildrenBindingImpl
implements InitChildrenBinding {
    private static final long serialVersionUID = 1463169907348730644L;

    public InitChildrenBindingImpl(Binder binder, Component comp, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        super(binder, comp, initExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
    }

    @Override
    protected boolean ignoreTracker() {
        return true;
    }

    @Override
    public void load(BindContext ctx) {
        Component comp = this.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        BindingExecutionInfoCollector collector = ((BinderCtrl)this.getBinder()).getBindingExecutionInfoCollector();
        Object value = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        Converter conv = this.getConverter();
        Object old = value;
        if (conv != null && (value = conv.coerceToUi(value, comp, ctx)) == Converter.IGNORED_VALUE) {
            if (collector != null) {
                collector.addInfo(new LoadInfo("children-init", comp, null, this.getPropertyString(), null, old, this.getArgs(), "*Converter.IGNORED_VALUE"));
            }
            return;
        }
        comp.getChildren().clear();
        BindELContext.removeModel(comp);
        if (value != null) {
            List data = null;
            if (!(value instanceof List)) {
                throw new UiException(value + " is not a List, is " + value.getClass());
            }
            data = (List)value;
            BindChildRenderer renderer = new BindChildRenderer();
            BindELContext.addModel(comp, data);
            boolean isUsingListModel = old instanceof ListModel;
            if (isUsingListModel) {
                ChildrenBindingListDataListener dataListener = new ChildrenBindingListDataListener(comp, ctx, conv);
                ((ListModel)old).addListDataListener((ListDataListener)dataListener);
                comp.setAttribute("$CHILDREN_BINDING_MODEL$", old);
                Object attribute = comp.setAttribute("$CHILDREN_BINDING_MODEL_LISTENER$", (Object)dataListener);
                if (attribute instanceof ListDataListener) {
                    ((ListModel)old).removeListDataListener((ListDataListener)attribute);
                }
            }
            int size = data.size();
            int i = 0;
            for (Object obj : data) {
                renderer.render(comp, obj, i++, size, isUsingListModel);
            }
        }
        if (collector != null) {
            collector.addInfo(new LoadInfo("children-init", comp, null, this.getPropertyString(), null, value, this.getArgs(), null));
        }
    }
}

