/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.util.Maps;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.ListModelArray;

public class ChildrenBindingConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;

    public Object coerceToUi(Object val, Component component, BindContext ctx) {
        List<Object> data;
        if (val == null || val instanceof List) {
            return val;
        }
        if (val instanceof Collection) {
            data = new ArrayList((Collection)val);
        } else if (val instanceof Map) {
            data = new ArrayList(Maps.transferToSerializableEntrySet(((Map)val).entrySet()));
        } else if (val instanceof ListModelArray) {
            data = Arrays.asList(((ListModelArray)val).getInnerArray());
        } else if (val instanceof Object[]) {
            data = Arrays.asList((Object[])val);
        } else if (val instanceof Class && Enum.class.isAssignableFrom((Class)val)) {
            data = Arrays.asList(((Class)val).getEnumConstants());
        } else {
            data = new ArrayList();
            data.add(val);
        }
        return data;
    }

    public Object coerceToBean(Object val, Component component, BindContext ctx) {
        return val;
    }
}

