/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.input.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.DocType;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.Text;
import org.zkoss.util.Pair;
import org.zkoss.util.URLs;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.TreeBuilder;
import org.zkoss.zsoup.Zsoup;
import org.zkoss.zsoup.nodes.Comment;
import org.zkoss.zsoup.nodes.DataNode;
import org.zkoss.zsoup.nodes.Document;
import org.zkoss.zsoup.nodes.DocumentType;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.nodes.Node;
import org.zkoss.zsoup.nodes.TextNode;
import org.zkoss.zsoup.nodes.XmlDeclaration;
import org.zkoss.zsoup.parser.Parser;
import org.zkoss.zsoup.parser.XHtmlTreeBuilder;
import org.zkoss.zsoup.select.Elements;

public class HtmlTreeBuilder
implements TreeBuilder {
    private static final Logger log = LoggerFactory.getLogger((String)HtmlTreeBuilder.class.getName());
    private final Map<String, Pair<Element, Namespace>> _nsMap = new HashMap<String, Pair<Element, Namespace>>(6);
    private final Map<Element, List<Namespace>> _elNSMap = new HashMap<Element, List<Namespace>>(6);

    private String getLineNumber(Reader file, String keyword) {
        return this.getLineNumber(new Scanner(file), keyword);
    }

    private String getLineNumber(Scanner scanner) {
        try (Scanner scanner2 = scanner;){
            int row = 0;
            while (scanner.hasNextLine()) {
                scanner.nextLine();
                ++row;
            }
            String string = "line: " + (row + 1) + ", column: 0";
            return string;
        }
    }

    private String getLineNumber(Scanner scanner, String keyword) {
        try (Scanner scanner2 = scanner;){
            int row = 0;
            while (scanner.hasNextLine()) {
                ++row;
                String line = scanner.nextLine();
                int col = line.indexOf(keyword);
                if (col < 0) continue;
                String string = "line: " + row + ", column: " + (col + 1);
                return string;
            }
        }
        return null;
    }

    private void initNamespaceMap(String filePath, Elements elements) {
        String xmlns = "xmlns";
        this._nsMap.put("xml", (Pair<Element, Namespace>)new Pair(null, (Object)Namespace.getSpecial((String)"xml")));
        this._nsMap.put("xmlns", (Pair<Element, Namespace>)new Pair(null, (Object)Namespace.getSpecial((String)"xmlns")));
        for (Element ele : elements) {
            for (org.zkoss.zsoup.nodes.Attribute attr : ele.attributes()) {
                String key = attr.getOriginalKey();
                if (!key.startsWith("xmlns")) continue;
                String prefix = "";
                if (key.startsWith("xmlns:")) {
                    prefix = key.substring(6);
                } else if (attr.getValue().endsWith("zul")) {
                    log.warn("The default namespace should not be ZUL, it may cause some potential errors! Please use ZUL file extension instead. [File at: {}]", (Object)filePath);
                }
                if (this._nsMap.containsKey(prefix)) continue;
                Namespace ns = new Namespace(prefix, attr.getValue());
                this._nsMap.put(prefix, (Pair<Element, Namespace>)new Pair((Object)ele, (Object)ns));
                List<Namespace> list = this._elNSMap.get(ele);
                if (list == null) {
                    list = new LinkedList<Namespace>();
                }
                list.add(ns);
                this._elNSMap.put(ele, list);
            }
        }
        if (this._nsMap.isEmpty()) {
            this._nsMap.put("", (Pair<Element, Namespace>)new Pair(null, (Object)new Namespace("", "")));
        }
    }

    private Namespace getNamespace(Element el) {
        if (el != null) {
            String[] tags = el.tagName().split(":");
            if (tags.length > 1) {
                Pair<Element, Namespace> pair = this._nsMap.get(tags[0]);
                if (pair == null) {
                    throw new UiExceptionX("Unknown namespace: [" + el.tagName() + "]", el.tagName());
                }
                return (Namespace)pair.getY();
            }
            Pair<Element, Namespace> p = this._nsMap.get("");
            if (p == null) {
                return Namespace.NO_NAMESPACE;
            }
            return (Namespace)p.getY();
        }
        return null;
    }

    private Namespace getNamespace(org.zkoss.zsoup.nodes.Attribute attr) {
        if (attr != null) {
            String[] tags = attr.getOriginalKey().split(":");
            if (tags.length > 1) {
                Pair<Element, Namespace> pair = this._nsMap.get(tags[0]);
                if (pair == null) {
                    throw new UiExceptionX("Unknown namespace: [" + attr.getOriginalKey() + "]", attr.getOriginalKey());
                }
                return (Namespace)pair.getY();
            }
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    private List<Namespace> getDeclareNamespace(Element el) {
        return this._elNSMap.get(el);
    }

    private org.zkoss.idom.Document convertToIDOM(Document doc) {
        this.initNamespaceMap(doc.baseUri(), doc.select("[^xmlns]"));
        org.zkoss.idom.Document root = new org.zkoss.idom.Document(null, null);
        for (Node n : doc.childNodes()) {
            if (n instanceof XmlDeclaration) {
                root.appendChild((org.w3c.dom.Node)this.convert((XmlDeclaration)n));
                continue;
            }
            if (n instanceof DocumentType) {
                root.appendChild((org.w3c.dom.Node)this.convert((DocumentType)n));
                continue;
            }
            this.convertChildNodes((org.w3c.dom.Node)root, (org.w3c.dom.Node)root, n);
        }
        return root;
    }

    private ProcessingInstruction convert(XmlDeclaration xd) {
        String data = xd.getWholeDeclaration();
        if (data.endsWith("?")) {
            data = data.substring(0, data.length() - 1);
        }
        String target = "";
        int index = data.indexOf(32);
        if (index > 0) {
            target = data.substring(0, index);
            data = data.substring(index);
        }
        return new ProcessingInstruction(target, data);
    }

    private DocType convert(DocumentType dtype) {
        return new DocType(dtype.attr("name"), dtype.attr("publicId"), dtype.attr("systemId"));
    }

    private Text convert(TextNode text) {
        return new Text(text.getWholeText());
    }

    private org.zkoss.idom.Comment convert(Comment comment) {
        return new org.zkoss.idom.Comment(comment.getData());
    }

    private Text convert(DataNode dataNode) {
        return new Text(dataNode.getWholeData());
    }

    private Attribute convert(org.zkoss.zsoup.nodes.Attribute attr) {
        if (attr == null) {
            throw new UiExceptionX("Attribute is null", null);
        }
        try {
            return new Attribute(this.getNamespace(attr), HtmlTreeBuilder.getLocalName(attr.getOriginalKey()), attr.getValue());
        }
        catch (Exception e) {
            throw new UiExceptionX(e.getMessage(), attr.getOriginalKey());
        }
    }

    private org.zkoss.idom.Element convert(Element element) {
        if (element == null) {
            throw new UiExceptionX("Element is null", null);
        }
        try {
            return new org.zkoss.idom.Element(this.getNamespace(element), HtmlTreeBuilder.getLocalName(element.tagName()));
        }
        catch (Exception e) {
            throw new UiExceptionX(e.getMessage(), element.tagName());
        }
    }

    private static String getLocalName(String name) {
        String[] ns = name.split(":");
        if (ns.length > 1) {
            return ns[1];
        }
        return name;
    }

    private void mergeAttr(org.w3c.dom.Node node, Node n) {
        if (node instanceof org.zkoss.idom.Element) {
            org.zkoss.idom.Element ie = (org.zkoss.idom.Element)node;
            for (org.zkoss.zsoup.nodes.Attribute attr : n.attributes()) {
                ie.setAttribute(this.convert(attr));
            }
        }
    }

    private void convertChildNodes(org.w3c.dom.Node root, org.w3c.dom.Node parent, Node n) {
        org.zkoss.idom.Element node = null;
        if (n instanceof Element) {
            node = this.convert((Element)n);
            List<Namespace> list = this.getDeclareNamespace((Element)n);
            if (list != null) {
                for (Namespace ns : list) {
                    node.addDeclaredNamespace(ns);
                }
            }
        } else if (n instanceof Comment) {
            node = this.convert((Comment)n);
        } else if (n instanceof TextNode) {
            node = this.convert((TextNode)n);
        } else if (n instanceof DataNode) {
            node = this.convert((DataNode)n);
        } else if (n instanceof XmlDeclaration) {
            root.appendChild((org.w3c.dom.Node)this.convert((XmlDeclaration)n));
        }
        if (node != null) {
            parent.appendChild((org.w3c.dom.Node)node);
            this.mergeAttr((org.w3c.dom.Node)node, n);
        }
        for (Node subNode : n.childNodes()) {
            this.convertChildNodes(root, (org.w3c.dom.Node)node, subNode);
        }
    }

    public org.zkoss.idom.Document parse(File file) throws Exception {
        return this.parse(file.toURI().toURL());
    }

    public org.zkoss.idom.Document parse(URL url) throws Exception {
        org.zkoss.idom.Document document;
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("Parsing file: [{}]", (Object)url);
            }
            url = URLs.sanitizeURL((URL)url);
            InputStream inStream = url.openStream();
            try {
                document = this.convertToIDOM(Zsoup.parse((InputStream)inStream, (String)"UTF-8", (String)url.getFile(), (Parser)Parser.xhtmlParser()));
                if (inStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XHtmlTreeBuilder.ExceptionInfo e) {
                    Document currentDocument = e.getCurrentDocument();
                    if (currentDocument != null) {
                        currentDocument.outputSettings(currentDocument.outputSettings().prettyPrint(false));
                        throw new UiException(" at [file:" + url.getFile() + ", " + this.getLineNumber(new Scanner(currentDocument.toString())) + "]", (Throwable)e);
                    }
                    throw new UiException(" at [file:" + url.getFile() + "]", (Throwable)e);
                }
            }
            inStream.close();
        }
        return document;
    }

    public org.zkoss.idom.Document parse(Reader reader) throws Exception {
        try (ReaderInputStream inputStream = null;){
            if (log.isDebugEnabled()) {
                log.debug("Parsing reader: [{}]", (Object)reader);
            }
            inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).get();
            org.zkoss.idom.Document document = this.convertToIDOM(Zsoup.parse((InputStream)inputStream, (String)"UTF-8", null, (Parser)Parser.xhtmlParser()));
            return document;
        }
    }

    private static class UiExceptionX
    extends UiException {
        private static final long serialVersionUID = 20140930153033L;
        private final String _keyword;

        public UiExceptionX(String msg, String keyword) {
            super(msg);
            this._keyword = keyword;
        }

        public String getKeyword() {
            return this._keyword;
        }
    }
}

