package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Tree;

/**
 * Immutable implementation of {@link ITree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ITree.Builder()}.
 */
@Generated(from = "ITree", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableITree implements ITree {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final @Nullable String span;
  private final @Nullable IPaging pagingChild;
  private final boolean sizedByContent;
  private final boolean autopaging;
  private final String pagingPosition;
  private final boolean nativeScrollbar;
  private final String widgetClass;
  private final @Nullable ITreecols treecols;
  private final @Nullable ITreefoot treefoot;
  private final ImmutableList<IAuxhead> auxhead;
  private final @Nullable ITreechildren treechildren;
  private final @Nullable IFrozen frozen;
  private final int rows;
  private final @Nullable String autosort;
  private final boolean multiple;
  private final boolean checkmark;
  private final @Nullable String nonselectableTags;
  private final boolean checkmarkDeselectOther;
  private final boolean selectOnHighlightDisabled;
  private final boolean rightSelect;
  private final int throttleMillis;
  private final ImmutableMap<String, Object> auxInfo;

  private ImmutableITree(ImmutableITree.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.span = builder.span;
    this.pagingChild = builder.pagingChild;
    this.treecols = builder.treecols;
    this.treefoot = builder.treefoot;
    this.treechildren = builder.treechildren;
    this.frozen = builder.frozen;
    this.nonselectableTags = builder.nonselectableTags;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.sizedByContentIsSet()) {
      initShim.setSizedByContent(builder.sizedByContent);
    }
    if (builder.autopagingIsSet()) {
      initShim.setAutopaging(builder.autopaging);
    }
    if (builder.pagingPosition != null) {
      initShim.setPagingPosition(builder.pagingPosition);
    }
    if (builder.nativeScrollbarIsSet()) {
      initShim.setNativeScrollbar(builder.nativeScrollbar);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.auxheadIsSet()) {
      initShim.setAuxhead(builder.auxhead.build());
    }
    if (builder.rowsIsSet()) {
      initShim.setRows(builder.rows);
    }
    if (builder.autosortIsSet()) {
      initShim.setAutosort(builder.autosort);
    }
    if (builder.multipleIsSet()) {
      initShim.setMultiple(builder.multiple);
    }
    if (builder.checkmarkIsSet()) {
      initShim.setCheckmark(builder.checkmark);
    }
    if (builder.checkmarkDeselectOtherIsSet()) {
      initShim.setCheckmarkDeselectOther(builder.checkmarkDeselectOther);
    }
    if (builder.selectOnHighlightDisabledIsSet()) {
      initShim.setSelectOnHighlightDisabled(builder.selectOnHighlightDisabled);
    }
    if (builder.rightSelectIsSet()) {
      initShim.setRightSelect(builder.rightSelect);
    }
    if (builder.throttleMillisIsSet()) {
      initShim.setThrottleMillis(builder.throttleMillis);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.sizedByContent = initShim.isSizedByContent();
    this.autopaging = initShim.isAutopaging();
    this.pagingPosition = initShim.getPagingPosition();
    this.nativeScrollbar = initShim.isNativeScrollbar();
    this.widgetClass = initShim.getWidgetClass();
    this.auxhead = initShim.getAuxhead();
    this.rows = initShim.getRows();
    this.autosort = initShim.getAutosort();
    this.multiple = initShim.isMultiple();
    this.checkmark = initShim.isCheckmark();
    this.checkmarkDeselectOther = initShim.isCheckmarkDeselectOther();
    this.selectOnHighlightDisabled = initShim.isSelectOnHighlightDisabled();
    this.rightSelect = initShim.isRightSelect();
    this.throttleMillis = initShim.getThrottleMillis();
    this.auxInfo = initShim.getAuxInfo();
    this.initShim = null;
  }

  private ImmutableITree(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      @Nullable String span,
      @Nullable IPaging pagingChild,
      boolean sizedByContent,
      boolean autopaging,
      String pagingPosition,
      boolean nativeScrollbar,
      String widgetClass,
      @Nullable ITreecols treecols,
      @Nullable ITreefoot treefoot,
      ImmutableList<IAuxhead> auxhead,
      @Nullable ITreechildren treechildren,
      @Nullable IFrozen frozen,
      int rows,
      @Nullable String autosort,
      boolean multiple,
      boolean checkmark,
      @Nullable String nonselectableTags,
      boolean checkmarkDeselectOther,
      boolean selectOnHighlightDisabled,
      boolean rightSelect,
      int throttleMillis,
      ImmutableMap<String, Object> auxInfo) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.span = span;
    this.pagingChild = pagingChild;
    this.sizedByContent = sizedByContent;
    this.autopaging = autopaging;
    this.pagingPosition = pagingPosition;
    this.nativeScrollbar = nativeScrollbar;
    this.widgetClass = widgetClass;
    this.treecols = treecols;
    this.treefoot = treefoot;
    this.auxhead = auxhead;
    this.treechildren = treechildren;
    this.frozen = frozen;
    this.rows = rows;
    this.autosort = autosort;
    this.multiple = multiple;
    this.checkmark = checkmark;
    this.nonselectableTags = nonselectableTags;
    this.checkmarkDeselectOther = checkmarkDeselectOther;
    this.selectOnHighlightDisabled = selectOnHighlightDisabled;
    this.rightSelect = rightSelect;
    this.throttleMillis = throttleMillis;
    this.auxInfo = auxInfo;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ITree", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte sizedByContentBuildStage = STAGE_UNINITIALIZED;
    private boolean sizedByContent;

    boolean isSizedByContent() {
      if (sizedByContentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sizedByContentBuildStage == STAGE_UNINITIALIZED) {
        sizedByContentBuildStage = STAGE_INITIALIZING;
        this.sizedByContent = isSizedByContentInitialize();
        sizedByContentBuildStage = STAGE_INITIALIZED;
      }
      return this.sizedByContent;
    }

    void setSizedByContent(boolean sizedByContent) {
      this.sizedByContent = sizedByContent;
      sizedByContentBuildStage = STAGE_INITIALIZED;
    }

    private byte autopagingBuildStage = STAGE_UNINITIALIZED;
    private boolean autopaging;

    boolean isAutopaging() {
      if (autopagingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autopagingBuildStage == STAGE_UNINITIALIZED) {
        autopagingBuildStage = STAGE_INITIALIZING;
        this.autopaging = isAutopagingInitialize();
        autopagingBuildStage = STAGE_INITIALIZED;
      }
      return this.autopaging;
    }

    void setAutopaging(boolean autopaging) {
      this.autopaging = autopaging;
      autopagingBuildStage = STAGE_INITIALIZED;
    }

    private byte pagingPositionBuildStage = STAGE_UNINITIALIZED;
    private String pagingPosition;

    String getPagingPosition() {
      if (pagingPositionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pagingPositionBuildStage == STAGE_UNINITIALIZED) {
        pagingPositionBuildStage = STAGE_INITIALIZING;
        this.pagingPosition = Objects.requireNonNull(getPagingPositionInitialize(), "pagingPosition");
        pagingPositionBuildStage = STAGE_INITIALIZED;
      }
      return this.pagingPosition;
    }

    void setPagingPosition(String pagingPosition) {
      this.pagingPosition = pagingPosition;
      pagingPositionBuildStage = STAGE_INITIALIZED;
    }

    private byte nativeScrollbarBuildStage = STAGE_UNINITIALIZED;
    private boolean nativeScrollbar;

    boolean isNativeScrollbar() {
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeScrollbarBuildStage == STAGE_UNINITIALIZED) {
        nativeScrollbarBuildStage = STAGE_INITIALIZING;
        this.nativeScrollbar = isNativeScrollbarInitialize();
        nativeScrollbarBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeScrollbar;
    }

    void setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      nativeScrollbarBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte auxheadBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<IAuxhead> auxhead;

    ImmutableList<IAuxhead> getAuxhead() {
      if (auxheadBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxheadBuildStage == STAGE_UNINITIALIZED) {
        auxheadBuildStage = STAGE_INITIALIZING;
        this.auxhead = ImmutableList.copyOf(getAuxheadInitialize());
        auxheadBuildStage = STAGE_INITIALIZED;
      }
      return this.auxhead;
    }

    void setAuxhead(ImmutableList<IAuxhead> auxhead) {
      this.auxhead = auxhead;
      auxheadBuildStage = STAGE_INITIALIZED;
    }

    private byte rowsBuildStage = STAGE_UNINITIALIZED;
    private int rows;

    int getRows() {
      if (rowsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rowsBuildStage == STAGE_UNINITIALIZED) {
        rowsBuildStage = STAGE_INITIALIZING;
        this.rows = getRowsInitialize();
        rowsBuildStage = STAGE_INITIALIZED;
      }
      return this.rows;
    }

    void setRows(int rows) {
      this.rows = rows;
      rowsBuildStage = STAGE_INITIALIZED;
    }

    private byte autosortBuildStage = STAGE_UNINITIALIZED;
    private String autosort;

    String getAutosort() {
      if (autosortBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autosortBuildStage == STAGE_UNINITIALIZED) {
        autosortBuildStage = STAGE_INITIALIZING;
        this.autosort = getAutosortInitialize();
        autosortBuildStage = STAGE_INITIALIZED;
      }
      return this.autosort;
    }

    void setAutosort(String autosort) {
      this.autosort = autosort;
      autosortBuildStage = STAGE_INITIALIZED;
    }

    private byte multipleBuildStage = STAGE_UNINITIALIZED;
    private boolean multiple;

    boolean isMultiple() {
      if (multipleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (multipleBuildStage == STAGE_UNINITIALIZED) {
        multipleBuildStage = STAGE_INITIALIZING;
        this.multiple = isMultipleInitialize();
        multipleBuildStage = STAGE_INITIALIZED;
      }
      return this.multiple;
    }

    void setMultiple(boolean multiple) {
      this.multiple = multiple;
      multipleBuildStage = STAGE_INITIALIZED;
    }

    private byte checkmarkBuildStage = STAGE_UNINITIALIZED;
    private boolean checkmark;

    boolean isCheckmark() {
      if (checkmarkBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (checkmarkBuildStage == STAGE_UNINITIALIZED) {
        checkmarkBuildStage = STAGE_INITIALIZING;
        this.checkmark = isCheckmarkInitialize();
        checkmarkBuildStage = STAGE_INITIALIZED;
      }
      return this.checkmark;
    }

    void setCheckmark(boolean checkmark) {
      this.checkmark = checkmark;
      checkmarkBuildStage = STAGE_INITIALIZED;
    }

    private byte checkmarkDeselectOtherBuildStage = STAGE_UNINITIALIZED;
    private boolean checkmarkDeselectOther;

    boolean isCheckmarkDeselectOther() {
      if (checkmarkDeselectOtherBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (checkmarkDeselectOtherBuildStage == STAGE_UNINITIALIZED) {
        checkmarkDeselectOtherBuildStage = STAGE_INITIALIZING;
        this.checkmarkDeselectOther = isCheckmarkDeselectOtherInitialize();
        checkmarkDeselectOtherBuildStage = STAGE_INITIALIZED;
      }
      return this.checkmarkDeselectOther;
    }

    void setCheckmarkDeselectOther(boolean checkmarkDeselectOther) {
      this.checkmarkDeselectOther = checkmarkDeselectOther;
      checkmarkDeselectOtherBuildStage = STAGE_INITIALIZED;
    }

    private byte selectOnHighlightDisabledBuildStage = STAGE_UNINITIALIZED;
    private boolean selectOnHighlightDisabled;

    boolean isSelectOnHighlightDisabled() {
      if (selectOnHighlightDisabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selectOnHighlightDisabledBuildStage == STAGE_UNINITIALIZED) {
        selectOnHighlightDisabledBuildStage = STAGE_INITIALIZING;
        this.selectOnHighlightDisabled = isSelectOnHighlightDisabledInitialize();
        selectOnHighlightDisabledBuildStage = STAGE_INITIALIZED;
      }
      return this.selectOnHighlightDisabled;
    }

    void setSelectOnHighlightDisabled(boolean selectOnHighlightDisabled) {
      this.selectOnHighlightDisabled = selectOnHighlightDisabled;
      selectOnHighlightDisabledBuildStage = STAGE_INITIALIZED;
    }

    private byte rightSelectBuildStage = STAGE_UNINITIALIZED;
    private boolean rightSelect;

    boolean isRightSelect() {
      if (rightSelectBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rightSelectBuildStage == STAGE_UNINITIALIZED) {
        rightSelectBuildStage = STAGE_INITIALIZING;
        this.rightSelect = isRightSelectInitialize();
        rightSelectBuildStage = STAGE_INITIALIZED;
      }
      return this.rightSelect;
    }

    void setRightSelect(boolean rightSelect) {
      this.rightSelect = rightSelect;
      rightSelectBuildStage = STAGE_INITIALIZED;
    }

    private byte throttleMillisBuildStage = STAGE_UNINITIALIZED;
    private int throttleMillis;

    int getThrottleMillis() {
      if (throttleMillisBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (throttleMillisBuildStage == STAGE_UNINITIALIZED) {
        throttleMillisBuildStage = STAGE_INITIALIZING;
        this.throttleMillis = getThrottleMillisInitialize();
        throttleMillisBuildStage = STAGE_INITIALIZED;
      }
      return this.throttleMillis;
    }

    void setThrottleMillis(int throttleMillis) {
      this.throttleMillis = throttleMillis;
      throttleMillisBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (sizedByContentBuildStage == STAGE_INITIALIZING) attributes.add("sizedByContent");
      if (autopagingBuildStage == STAGE_INITIALIZING) attributes.add("autopaging");
      if (pagingPositionBuildStage == STAGE_INITIALIZING) attributes.add("pagingPosition");
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) attributes.add("nativeScrollbar");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (auxheadBuildStage == STAGE_INITIALIZING) attributes.add("auxhead");
      if (rowsBuildStage == STAGE_INITIALIZING) attributes.add("rows");
      if (autosortBuildStage == STAGE_INITIALIZING) attributes.add("autosort");
      if (multipleBuildStage == STAGE_INITIALIZING) attributes.add("multiple");
      if (checkmarkBuildStage == STAGE_INITIALIZING) attributes.add("checkmark");
      if (checkmarkDeselectOtherBuildStage == STAGE_INITIALIZING) attributes.add("checkmarkDeselectOther");
      if (selectOnHighlightDisabledBuildStage == STAGE_INITIALIZING) attributes.add("selectOnHighlightDisabled");
      if (rightSelectBuildStage == STAGE_INITIALIZING) attributes.add("rightSelect");
      if (throttleMillisBuildStage == STAGE_INITIALIZING) attributes.add("throttleMillis");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      return "Cannot build ITree, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ITree.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ITree.super.isVisible();
  }

  private String getMoldInitialize() {
    return ITree.super.getMold();
  }

  private int getZIndexInitialize() {
    return ITree.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ITree.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ITree.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ITree.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ITree.super.getRenderdefer();
  }

  private boolean isSizedByContentInitialize() {
    return ITree.super.isSizedByContent();
  }

  private boolean isAutopagingInitialize() {
    return ITree.super.isAutopaging();
  }

  private String getPagingPositionInitialize() {
    return ITree.super.getPagingPosition();
  }

  private boolean isNativeScrollbarInitialize() {
    return ITree.super.isNativeScrollbar();
  }

  private String getWidgetClassInitialize() {
    return ITree.super.getWidgetClass();
  }

  private List<IAuxhead> getAuxheadInitialize() {
    return ITree.super.getAuxhead();
  }

  private int getRowsInitialize() {
    return ITree.super.getRows();
  }

  private @Nullable String getAutosortInitialize() {
    return ITree.super.getAutosort();
  }

  private boolean isMultipleInitialize() {
    return ITree.super.isMultiple();
  }

  private boolean isCheckmarkInitialize() {
    return ITree.super.isCheckmark();
  }

  private boolean isCheckmarkDeselectOtherInitialize() {
    return ITree.super.isCheckmarkDeselectOther();
  }

  private boolean isSelectOnHighlightDisabledInitialize() {
    return ITree.super.isSelectOnHighlightDisabled();
  }

  private boolean isRightSelectInitialize() {
    return ITree.super.isRightSelect();
  }

  private int getThrottleMillisInitialize() {
    return ITree.super.getThrottleMillis();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return ITree.super.getAuxInfo();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code span} attribute
   */
  @Override
  public @Nullable String getSpan() {
    return span;
  }

  /**
   * @return The value of the {@code pagingChild} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable IPaging getPagingChild() {
    return pagingChild;
  }

  /**
   * @return The value of the {@code sizedByContent} attribute
   */
  @Override
  public boolean isSizedByContent() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSizedByContent()
        : this.sizedByContent;
  }

  /**
   * @return The value of the {@code autopaging} attribute
   */
  @Override
  public boolean isAutopaging() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutopaging()
        : this.autopaging;
  }

  /**
   * @return The value of the {@code pagingPosition} attribute
   */
  @Override
  public String getPagingPosition() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPagingPosition()
        : this.pagingPosition;
  }

  /**
   * @return The value of the {@code nativeScrollbar} attribute
   */
  @Override
  public boolean isNativeScrollbar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNativeScrollbar()
        : this.nativeScrollbar;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code treecols} attribute
   */
  @Override
  public @Nullable ITreecols getTreecols() {
    return treecols;
  }

  /**
   * @return The value of the {@code treefoot} attribute
   */
  @Override
  public @Nullable ITreefoot getTreefoot() {
    return treefoot;
  }

  /**
   * @return The value of the {@code auxhead} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<IAuxhead> getAuxhead() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxhead()
        : this.auxhead;
  }

  /**
   * @return The value of the {@code treechildren} attribute
   */
  @Override
  public @Nullable ITreechildren getTreechildren() {
    return treechildren;
  }

  /**
   * @return The value of the {@code frozen} attribute
   */
  @Override
  public @Nullable IFrozen getFrozen() {
    return frozen;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @Override
  public int getRows() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRows()
        : this.rows;
  }

  /**
   * @return The value of the {@code autosort} attribute
   */
  @Override
  public @Nullable String getAutosort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAutosort()
        : this.autosort;
  }

  /**
   * @return The value of the {@code multiple} attribute
   */
  @Override
  public boolean isMultiple() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMultiple()
        : this.multiple;
  }

  /**
   * @return The value of the {@code checkmark} attribute
   */
  @Override
  public boolean isCheckmark() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCheckmark()
        : this.checkmark;
  }

  /**
   * @return The value of the {@code nonselectableTags} attribute
   */
  @Override
  public @Nullable String getNonselectableTags() {
    return nonselectableTags;
  }

  /**
   * @return The value of the {@code checkmarkDeselectOther} attribute
   */
  @Override
  public boolean isCheckmarkDeselectOther() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCheckmarkDeselectOther()
        : this.checkmarkDeselectOther;
  }

  /**
   * @return The value of the {@code selectOnHighlightDisabled} attribute
   */
  @Override
  public boolean isSelectOnHighlightDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSelectOnHighlightDisabled()
        : this.selectOnHighlightDisabled;
  }

  /**
   * @return The value of the {@code rightSelect} attribute
   */
  @Override
  public boolean isRightSelect() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isRightSelect()
        : this.rightSelect;
  }

  /**
   * @return The value of the {@code throttleMillis} attribute
   */
  @Override
  public int getThrottleMillis() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getThrottleMillis()
        : this.throttleMillis;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableITree(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableITree(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ITree#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableITree(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.span,
          this.pagingChild,
          this.sizedByContent,
          this.autopaging,
          this.pagingPosition,
          this.nativeScrollbar,
          this.widgetClass,
          this.treecols,
          this.treefoot,
          this.auxhead,
          this.treechildren,
          this.frozen,
          this.rows,
          this.autosort,
          this.multiple,
          this.checkmark,
          this.nonselectableTags,
          this.checkmarkDeselectOther,
          this.selectOnHighlightDisabled,
          this.rightSelect,
          this.throttleMillis,
          this.auxInfo));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ITree#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITree#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITree#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITree#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getSpan() span} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for span (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withSpan(@Nullable String value) {
    if (Objects.equals(this.span, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getPagingChild() pagingChild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagingChild (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withPagingChild(@Nullable IPaging value) {
    if (this.pagingChild == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        value,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isSizedByContent() sizedByContent} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sizedByContent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withSizedByContent(boolean value) {
    if (this.sizedByContent == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        value,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isAutopaging() autopaging} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autopaging
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withAutopaging(boolean value) {
    if (this.autopaging == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        value,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getPagingPosition() pagingPosition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagingPosition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withPagingPosition(String value) {
    String newValue = Objects.requireNonNull(value, "pagingPosition");
    if (this.pagingPosition.equals(newValue)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        newValue,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isNativeScrollbar() nativeScrollbar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeScrollbar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withNativeScrollbar(boolean value) {
    if (this.nativeScrollbar == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        value,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        newValue,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTreecols() treecols} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treecols (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTreecols(@Nullable ITreecols value) {
    if (this.treecols == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        value,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTreefoot() treefoot} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treefoot (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTreefoot(@Nullable ITreefoot value) {
    if (this.treefoot == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        value,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ITree#getAuxhead() auxhead}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withAuxhead(IAuxhead... elements) {
    ImmutableList<IAuxhead> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        newValue,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ITree#getAuxhead() auxhead}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of auxhead elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withAuxhead(Iterable<? extends IAuxhead> elements) {
    if (this.auxhead == elements) return this;
    ImmutableList<IAuxhead> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        newValue,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getTreechildren() treechildren} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treechildren (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withTreechildren(@Nullable ITreechildren value) {
    if (this.treechildren == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        value,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getFrozen() frozen} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for frozen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withFrozen(@Nullable IFrozen value) {
    if (this.frozen == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        value,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getRows() rows} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rows
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withRows(int value) {
    if (this.rows == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        value,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getAutosort() autosort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autosort (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withAutosort(@Nullable String value) {
    if (Objects.equals(this.autosort, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        value,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isMultiple() multiple} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiple
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withMultiple(boolean value) {
    if (this.multiple == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        value,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isCheckmark() checkmark} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkmark
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withCheckmark(boolean value) {
    if (this.checkmark == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        value,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getNonselectableTags() nonselectableTags} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nonselectableTags (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withNonselectableTags(@Nullable String value) {
    if (Objects.equals(this.nonselectableTags, value)) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        value,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isCheckmarkDeselectOther() checkmarkDeselectOther} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkmarkDeselectOther
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withCheckmarkDeselectOther(boolean value) {
    if (this.checkmarkDeselectOther == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        value,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isSelectOnHighlightDisabled() selectOnHighlightDisabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selectOnHighlightDisabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withSelectOnHighlightDisabled(boolean value) {
    if (this.selectOnHighlightDisabled == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        value,
        this.rightSelect,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#isRightSelect() rightSelect} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rightSelect
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withRightSelect(boolean value) {
    if (this.rightSelect == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        value,
        this.throttleMillis,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ITree#getThrottleMillis() throttleMillis} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for throttleMillis
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableITree withThrottleMillis(int value) {
    if (this.throttleMillis == value) return this;
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        value,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ITree#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableITree withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableITree(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.span,
        this.pagingChild,
        this.sizedByContent,
        this.autopaging,
        this.pagingPosition,
        this.nativeScrollbar,
        this.widgetClass,
        this.treecols,
        this.treefoot,
        this.auxhead,
        this.treechildren,
        this.frozen,
        this.rows,
        this.autosort,
        this.multiple,
        this.checkmark,
        this.nonselectableTags,
        this.checkmarkDeselectOther,
        this.selectOnHighlightDisabled,
        this.rightSelect,
        this.throttleMillis,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableITree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableITree
        && equalTo((ImmutableITree) another);
  }

  private boolean equalTo(ImmutableITree another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && Objects.equals(span, another.span)
        && Objects.equals(pagingChild, another.pagingChild)
        && sizedByContent == another.sizedByContent
        && autopaging == another.autopaging
        && pagingPosition.equals(another.pagingPosition)
        && nativeScrollbar == another.nativeScrollbar
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(treecols, another.treecols)
        && Objects.equals(treefoot, another.treefoot)
        && auxhead.equals(another.auxhead)
        && Objects.equals(treechildren, another.treechildren)
        && Objects.equals(frozen, another.frozen)
        && rows == another.rows
        && Objects.equals(autosort, another.autosort)
        && multiple == another.multiple
        && checkmark == another.checkmark
        && Objects.equals(nonselectableTags, another.nonselectableTags)
        && checkmarkDeselectOther == another.checkmarkDeselectOther
        && selectOnHighlightDisabled == another.selectOnHighlightDisabled
        && rightSelect == another.rightSelect
        && throttleMillis == another.throttleMillis
        && auxInfo.equals(another.auxInfo);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code span}, {@code pagingChild}, {@code sizedByContent}, {@code autopaging}, {@code pagingPosition}, {@code nativeScrollbar}, {@code widgetClass}, {@code treecols}, {@code treefoot}, {@code auxhead}, {@code treechildren}, {@code frozen}, {@code rows}, {@code autosort}, {@code multiple}, {@code checkmark}, {@code nonselectableTags}, {@code checkmarkDeselectOther}, {@code selectOnHighlightDisabled}, {@code rightSelect}, {@code throttleMillis}, {@code auxInfo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Objects.hashCode(span);
    h += (h << 5) + Objects.hashCode(pagingChild);
    h += (h << 5) + Booleans.hashCode(sizedByContent);
    h += (h << 5) + Booleans.hashCode(autopaging);
    h += (h << 5) + pagingPosition.hashCode();
    h += (h << 5) + Booleans.hashCode(nativeScrollbar);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(treecols);
    h += (h << 5) + Objects.hashCode(treefoot);
    h += (h << 5) + auxhead.hashCode();
    h += (h << 5) + Objects.hashCode(treechildren);
    h += (h << 5) + Objects.hashCode(frozen);
    h += (h << 5) + rows;
    h += (h << 5) + Objects.hashCode(autosort);
    h += (h << 5) + Booleans.hashCode(multiple);
    h += (h << 5) + Booleans.hashCode(checkmark);
    h += (h << 5) + Objects.hashCode(nonselectableTags);
    h += (h << 5) + Booleans.hashCode(checkmarkDeselectOther);
    h += (h << 5) + Booleans.hashCode(selectOnHighlightDisabled);
    h += (h << 5) + Booleans.hashCode(rightSelect);
    h += (h << 5) + throttleMillis;
    h += (h << 5) + auxInfo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ITree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ITree")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("span", span)
        .add("pagingChild", pagingChild)
        .add("sizedByContent", sizedByContent)
        .add("autopaging", autopaging)
        .add("pagingPosition", pagingPosition)
        .add("nativeScrollbar", nativeScrollbar)
        .add("widgetClass", widgetClass)
        .add("treecols", treecols)
        .add("treefoot", treefoot)
        .add("auxhead", auxhead)
        .add("treechildren", treechildren)
        .add("frozen", frozen)
        .add("rows", rows)
        .add("autosort", autosort)
        .add("multiple", multiple)
        .add("checkmark", checkmark)
        .add("nonselectableTags", nonselectableTags)
        .add("checkmarkDeselectOther", checkmarkDeselectOther)
        .add("selectOnHighlightDisabled", selectOnHighlightDisabled)
        .add("rightSelect", rightSelect)
        .add("throttleMillis", throttleMillis)
        .add("auxInfo", auxInfo)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Tree> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITree#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Tree> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ITree.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long ITEMS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Collection<ITreeitem> items;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITree#getItems() items} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code items} attribute
   */
  @Override
  public Collection<ITreeitem> getItems() {
    if ((lazyInitBitmap & ITEMS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ITEMS_LAZY_INIT_BIT) == 0) {
          this.items = Objects.requireNonNull(ITree.super.getItems(), "items");
          lazyInitBitmap |= ITEMS_LAZY_INIT_BIT;
        }
      }
    }
    return items;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient List<IMeshComposite> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITree#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IMeshComposite> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(ITree.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static final long AUTOSORT_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient boolean autosort$lazy;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITree#isAutosort() autosort} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code autosort} attribute
   */
  @Override
  public boolean isAutosort() {
    if ((lazyInitBitmap & AUTOSORT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AUTOSORT_LAZY_INIT_BIT) == 0) {
          this.autosort$lazy = ITree.super.isAutosort();
          lazyInitBitmap |= AUTOSORT_LAZY_INIT_BIT;
        }
      }
    }
    return autosort$lazy;
  }

  private static final long IGNORE_SORT_WHEN_CHANGED_LAZY_INIT_BIT = 0x10L;

  @SuppressWarnings("Immutable")
  private transient boolean ignoreSortWhenChanged;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ITree#isIgnoreSortWhenChanged() ignoreSortWhenChanged} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code ignoreSortWhenChanged} attribute
   */
  @Override
  public boolean isIgnoreSortWhenChanged() {
    if ((lazyInitBitmap & IGNORE_SORT_WHEN_CHANGED_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & IGNORE_SORT_WHEN_CHANGED_LAZY_INIT_BIT) == 0) {
          this.ignoreSortWhenChanged = ITree.super.isIgnoreSortWhenChanged();
          lazyInitBitmap |= IGNORE_SORT_WHEN_CHANGED_LAZY_INIT_BIT;
        }
      }
    }
    return ignoreSortWhenChanged;
  }

  private static ImmutableITree validate(ImmutableITree instance) {
    instance = (ImmutableITree) instance.checkMold();
    instance.checkRows();
    instance.checkHeightAndRows();
    instance.checkPagingPosition();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableITree) instance.checkDroppable();
    instance = (ImmutableITree) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ITree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ITree instance
   */
  public static ITree copyOf(ITree instance) {
    if (instance instanceof ImmutableITree) {
      return (ImmutableITree) instance;
    }
    return new ITree.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ITree ITree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ITree", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_SIZED_BY_CONTENT = 0x10L;
    private static final long OPT_BIT_AUTOPAGING = 0x20L;
    private static final long OPT_BIT_NATIVE_SCROLLBAR = 0x40L;
    private static final long OPT_BIT_AUXHEAD = 0x80L;
    private static final long OPT_BIT_ROWS = 0x100L;
    private static final long OPT_BIT_AUTOSORT = 0x200L;
    private static final long OPT_BIT_MULTIPLE = 0x400L;
    private static final long OPT_BIT_CHECKMARK = 0x800L;
    private static final long OPT_BIT_CHECKMARK_DESELECT_OTHER = 0x1000L;
    private static final long OPT_BIT_SELECT_ON_HIGHLIGHT_DISABLED = 0x2000L;
    private static final long OPT_BIT_RIGHT_SELECT = 0x4000L;
    private static final long OPT_BIT_THROTTLE_MILLIS = 0x8000L;
    private static final long OPT_BIT_AUX_INFO = 0x10000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String span;
    private @Nullable IPaging pagingChild;
    private boolean sizedByContent;
    private boolean autopaging;
    private @Nullable String pagingPosition;
    private boolean nativeScrollbar;
    private @Nullable String widgetClass;
    private @Nullable ITreecols treecols;
    private @Nullable ITreefoot treefoot;
    private ImmutableList.Builder<IAuxhead> auxhead = ImmutableList.builder();
    private @Nullable ITreechildren treechildren;
    private @Nullable IFrozen frozen;
    private int rows;
    private @Nullable String autosort;
    private boolean multiple;
    private boolean checkmark;
    private @Nullable String nonselectableTags;
    private boolean checkmarkDeselectOther;
    private boolean selectOnHighlightDisabled;
    private boolean rightSelect;
    private int throttleMillis;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ITree ITree} instances.
     * <pre>
     * new ITree.Builder()
     *    .setId(String) // optional {@link ITree#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ITree#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ITree#getActions() actions}
     *    .setVisible(boolean) // optional {@link ITree#isVisible() visible}
     *    .setMold(String) // optional {@link ITree#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ITree#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITree#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITree#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ITree#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ITree#getLeft() left}
     *    .setTop(String | null) // nullable {@link ITree#getTop() top}
     *    .setZIndex(int) // optional {@link ITree#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ITree#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ITree#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ITree#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ITree#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ITree#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ITree#getStyle() style}
     *    .setDraggable(String) // optional {@link ITree#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ITree#isFocus() focus}
     *    .setDroppable(String) // optional {@link ITree#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ITree#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ITree#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ITree#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ITree#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ITree#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ITree#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ITree#getContext() context}
     *    .setPopup(String | null) // nullable {@link ITree#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ITree#getTooltip() tooltip}
     *    .setSpan(String | null) // nullable {@link ITree#getSpan() span}
     *    .setPagingChild(org.zkoss.stateless.sul.IPaging | null) // nullable {@link ITree#getPagingChild() pagingChild}
     *    .setSizedByContent(boolean) // optional {@link ITree#isSizedByContent() sizedByContent}
     *    .setAutopaging(boolean) // optional {@link ITree#isAutopaging() autopaging}
     *    .setPagingPosition(String) // optional {@link ITree#getPagingPosition() pagingPosition}
     *    .setNativeScrollbar(boolean) // optional {@link ITree#isNativeScrollbar() nativeScrollbar}
     *    .setWidgetClass(String) // optional {@link ITree#getWidgetClass() widgetClass}
     *    .setTreecols(org.zkoss.stateless.sul.ITreecols | null) // nullable {@link ITree#getTreecols() treecols}
     *    .setTreefoot(org.zkoss.stateless.sul.ITreefoot | null) // nullable {@link ITree#getTreefoot() treefoot}
     *    .addAuxhead|addAllAuxhead(org.zkoss.stateless.sul.IAuxhead) // {@link ITree#getAuxhead() auxhead} elements
     *    .setTreechildren(org.zkoss.stateless.sul.ITreechildren | null) // nullable {@link ITree#getTreechildren() treechildren}
     *    .setFrozen(org.zkoss.stateless.sul.IFrozen | null) // nullable {@link ITree#getFrozen() frozen}
     *    .setRows(int) // optional {@link ITree#getRows() rows}
     *    .setAutosort(String | null) // nullable {@link ITree#getAutosort() autosort}
     *    .setMultiple(boolean) // optional {@link ITree#isMultiple() multiple}
     *    .setCheckmark(boolean) // optional {@link ITree#isCheckmark() checkmark}
     *    .setNonselectableTags(String | null) // nullable {@link ITree#getNonselectableTags() nonselectableTags}
     *    .setCheckmarkDeselectOther(boolean) // optional {@link ITree#isCheckmarkDeselectOther() checkmarkDeselectOther}
     *    .setSelectOnHighlightDisabled(boolean) // optional {@link ITree#isSelectOnHighlightDisabled() selectOnHighlightDisabled}
     *    .setRightSelect(boolean) // optional {@link ITree#isRightSelect() rightSelect}
     *    .setThrottleMillis(int) // optional {@link ITree#getThrottleMillis() throttleMillis}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link ITree#getAuxInfo() auxInfo} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ITree.Builder)) {
        throw new UnsupportedOperationException("Use: new ITree.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ITree} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder from(ITree instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      @Nullable String spanValue = instance.getSpan();
      if (spanValue != null) {
        setSpan(spanValue);
      }
      @Nullable IPaging pagingChildValue = instance.getPagingChild();
      if (pagingChildValue != null) {
        setPagingChild(pagingChildValue);
      }
      setSizedByContent(instance.isSizedByContent());
      setAutopaging(instance.isAutopaging());
      setPagingPosition(instance.getPagingPosition());
      setNativeScrollbar(instance.isNativeScrollbar());
      setWidgetClass(instance.getWidgetClass());
      @Nullable ITreecols treecolsValue = instance.getTreecols();
      if (treecolsValue != null) {
        setTreecols(treecolsValue);
      }
      @Nullable ITreefoot treefootValue = instance.getTreefoot();
      if (treefootValue != null) {
        setTreefoot(treefootValue);
      }
      addAllAuxhead(instance.getAuxhead());
      @Nullable ITreechildren treechildrenValue = instance.getTreechildren();
      if (treechildrenValue != null) {
        setTreechildren(treechildrenValue);
      }
      @Nullable IFrozen frozenValue = instance.getFrozen();
      if (frozenValue != null) {
        setFrozen(frozenValue);
      }
      setRows(instance.getRows());
      @Nullable String autosortValue = instance.getAutosort();
      if (autosortValue != null) {
        setAutosort(autosortValue);
      }
      setMultiple(instance.isMultiple());
      setCheckmark(instance.isCheckmark());
      @Nullable String nonselectableTagsValue = instance.getNonselectableTags();
      if (nonselectableTagsValue != null) {
        setNonselectableTags(nonselectableTagsValue);
      }
      setCheckmarkDeselectOther(instance.isCheckmarkDeselectOther());
      setSelectOnHighlightDisabled(instance.isSelectOnHighlightDisabled());
      setRightSelect(instance.isRightSelect());
      setThrottleMillis(instance.getThrottleMillis());
      putAllAuxInfo(instance.getAuxInfo());
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ITree.Builder) this;
    }

    /**
     * Adds one element to {@link ITree#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ITree.Builder) this;
    }

    /**
     * Adds elements to {@link ITree#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ITree.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ITree#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ITree.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ITree#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ITree.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITree#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ITree.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITree#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ITree.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITree#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ITree.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITree#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ITree.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITree#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ITree.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITree#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setContext(@Nullable String context) {
      this.context = context;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getSpan() span} attribute.
     * @param span The value for span (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setSpan(@Nullable String span) {
      this.span = span;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getPagingChild() pagingChild} attribute.
     * @param pagingChild The value for pagingChild (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setPagingChild(@Nullable IPaging pagingChild) {
      this.pagingChild = pagingChild;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isSizedByContent() sizedByContent} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isSizedByContent() sizedByContent}.</em>
     * @param sizedByContent The value for sizedByContent 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setSizedByContent(boolean sizedByContent) {
      this.sizedByContent = sizedByContent;
      optBits |= OPT_BIT_SIZED_BY_CONTENT;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isAutopaging() autopaging} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isAutopaging() autopaging}.</em>
     * @param autopaging The value for autopaging 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setAutopaging(boolean autopaging) {
      this.autopaging = autopaging;
      optBits |= OPT_BIT_AUTOPAGING;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getPagingPosition() pagingPosition} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getPagingPosition() pagingPosition}.</em>
     * @param pagingPosition The value for pagingPosition 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setPagingPosition(String pagingPosition) {
      this.pagingPosition = Objects.requireNonNull(pagingPosition, "pagingPosition");
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isNativeScrollbar() nativeScrollbar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isNativeScrollbar() nativeScrollbar}.</em>
     * @param nativeScrollbar The value for nativeScrollbar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      optBits |= OPT_BIT_NATIVE_SCROLLBAR;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTreecols() treecols} attribute.
     * @param treecols The value for treecols (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTreecols(@Nullable ITreecols treecols) {
      this.treecols = treecols;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTreefoot() treefoot} attribute.
     * @param treefoot The value for treefoot (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTreefoot(@Nullable ITreefoot treefoot) {
      this.treefoot = treefoot;
      return (ITree.Builder) this;
    }

    /**
     * Adds one element to {@link ITree#getAuxhead() auxhead} list.
     * @param element A auxhead element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder addAuxhead(IAuxhead element) {
      this.auxhead.add(element);
      optBits |= OPT_BIT_AUXHEAD;
      return (ITree.Builder) this;
    }

    /**
     * Adds elements to {@link ITree#getAuxhead() auxhead} list.
     * @param elements An array of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder addAuxhead(IAuxhead... elements) {
      this.auxhead.add(elements);
      optBits |= OPT_BIT_AUXHEAD;
      return (ITree.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ITree#getAuxhead() auxhead} list.
     * @param elements An iterable of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setAuxhead(Iterable<? extends IAuxhead> elements) {
      this.auxhead = ImmutableList.builder();
      return addAllAuxhead(elements);
    }

    /**
     * Adds elements to {@link ITree#getAuxhead() auxhead} list.
     * @param elements An iterable of auxhead elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder addAllAuxhead(Iterable<? extends IAuxhead> elements) {
      this.auxhead.addAll(elements);
      optBits |= OPT_BIT_AUXHEAD;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getTreechildren() treechildren} attribute.
     * @param treechildren The value for treechildren (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setTreechildren(@Nullable ITreechildren treechildren) {
      this.treechildren = treechildren;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getFrozen() frozen} attribute.
     * @param frozen The value for frozen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setFrozen(@Nullable IFrozen frozen) {
      this.frozen = frozen;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getRows() rows} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getRows() rows}.</em>
     * @param rows The value for rows 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setRows(int rows) {
      this.rows = rows;
      optBits |= OPT_BIT_ROWS;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getAutosort() autosort} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getAutosort() autosort}.</em>
     * @param autosort The value for autosort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setAutosort(@Nullable String autosort) {
      this.autosort = autosort;
      optBits |= OPT_BIT_AUTOSORT;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isMultiple() multiple} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isMultiple() multiple}.</em>
     * @param multiple The value for multiple 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setMultiple(boolean multiple) {
      this.multiple = multiple;
      optBits |= OPT_BIT_MULTIPLE;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isCheckmark() checkmark} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isCheckmark() checkmark}.</em>
     * @param checkmark The value for checkmark 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setCheckmark(boolean checkmark) {
      this.checkmark = checkmark;
      optBits |= OPT_BIT_CHECKMARK;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getNonselectableTags() nonselectableTags} attribute.
     * @param nonselectableTags The value for nonselectableTags (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setNonselectableTags(@Nullable String nonselectableTags) {
      this.nonselectableTags = nonselectableTags;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isCheckmarkDeselectOther() checkmarkDeselectOther} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isCheckmarkDeselectOther() checkmarkDeselectOther}.</em>
     * @param checkmarkDeselectOther The value for checkmarkDeselectOther 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setCheckmarkDeselectOther(boolean checkmarkDeselectOther) {
      this.checkmarkDeselectOther = checkmarkDeselectOther;
      optBits |= OPT_BIT_CHECKMARK_DESELECT_OTHER;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isSelectOnHighlightDisabled() selectOnHighlightDisabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isSelectOnHighlightDisabled() selectOnHighlightDisabled}.</em>
     * @param selectOnHighlightDisabled The value for selectOnHighlightDisabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setSelectOnHighlightDisabled(boolean selectOnHighlightDisabled) {
      this.selectOnHighlightDisabled = selectOnHighlightDisabled;
      optBits |= OPT_BIT_SELECT_ON_HIGHLIGHT_DISABLED;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#isRightSelect() rightSelect} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#isRightSelect() rightSelect}.</em>
     * @param rightSelect The value for rightSelect 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setRightSelect(boolean rightSelect) {
      this.rightSelect = rightSelect;
      optBits |= OPT_BIT_RIGHT_SELECT;
      return (ITree.Builder) this;
    }

    /**
     * Initializes the value for the {@link ITree#getThrottleMillis() throttleMillis} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ITree#getThrottleMillis() throttleMillis}.</em>
     * @param throttleMillis The value for throttleMillis 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setThrottleMillis(int throttleMillis) {
      this.throttleMillis = throttleMillis;
      optBits |= OPT_BIT_THROTTLE_MILLIS;
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (ITree.Builder) this;
    }

    /**
     * Put one entry to the {@link ITree#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (ITree.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ITree#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ITree#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ITree.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (ITree.Builder) this;
    }

    /**
     * Builds a new {@link ITree ITree}.
     * @return An immutable instance of ITree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ITree build() {
      return ImmutableITree.validate(new ImmutableITree(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean sizedByContentIsSet() {
      return (optBits & OPT_BIT_SIZED_BY_CONTENT) != 0;
    }

    private boolean autopagingIsSet() {
      return (optBits & OPT_BIT_AUTOPAGING) != 0;
    }

    private boolean nativeScrollbarIsSet() {
      return (optBits & OPT_BIT_NATIVE_SCROLLBAR) != 0;
    }

    private boolean auxheadIsSet() {
      return (optBits & OPT_BIT_AUXHEAD) != 0;
    }

    private boolean rowsIsSet() {
      return (optBits & OPT_BIT_ROWS) != 0;
    }

    private boolean autosortIsSet() {
      return (optBits & OPT_BIT_AUTOSORT) != 0;
    }

    private boolean multipleIsSet() {
      return (optBits & OPT_BIT_MULTIPLE) != 0;
    }

    private boolean checkmarkIsSet() {
      return (optBits & OPT_BIT_CHECKMARK) != 0;
    }

    private boolean checkmarkDeselectOtherIsSet() {
      return (optBits & OPT_BIT_CHECKMARK_DESELECT_OTHER) != 0;
    }

    private boolean selectOnHighlightDisabledIsSet() {
      return (optBits & OPT_BIT_SELECT_ON_HIGHLIGHT_DISABLED) != 0;
    }

    private boolean rightSelectIsSet() {
      return (optBits & OPT_BIT_RIGHT_SELECT) != 0;
    }

    private boolean throttleMillisIsSet() {
      return (optBits & OPT_BIT_THROTTLE_MILLIS) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }
  }
}
