package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Slider;

/**
 * Immutable implementation of {@link ISlider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ISlider.Builder()}.
 */
@Generated(from = "ISlider", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableISlider implements ISlider {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final @Nullable String name;
  private final String orient;
  private final String slidingtext;
  private final double curposInDouble;
  private final double minposInDouble;
  private final double maxposInDouble;
  private final double stepInDouble;
  private final double pageIncrementInDouble;
  private final double strokeWidth;
  private final double angleArc;
  private final double scaleInput;

  private ImmutableISlider(ImmutableISlider.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.name = builder.name;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.orient != null) {
      initShim.setOrient(builder.orient);
    }
    if (builder.slidingtext != null) {
      initShim.setSlidingtext(builder.slidingtext);
    }
    if (builder.curposInDoubleIsSet()) {
      initShim.setCurposInDouble(builder.curposInDouble);
    }
    if (builder.minposInDoubleIsSet()) {
      initShim.setMinposInDouble(builder.minposInDouble);
    }
    if (builder.maxposInDoubleIsSet()) {
      initShim.setMaxposInDouble(builder.maxposInDouble);
    }
    if (builder.stepInDoubleIsSet()) {
      initShim.setStepInDouble(builder.stepInDouble);
    }
    if (builder.pageIncrementInDoubleIsSet()) {
      initShim.setPageIncrementInDouble(builder.pageIncrementInDouble);
    }
    if (builder.strokeWidthIsSet()) {
      initShim.setStrokeWidth(builder.strokeWidth);
    }
    if (builder.angleArcIsSet()) {
      initShim.setAngleArc(builder.angleArc);
    }
    if (builder.scaleInputIsSet()) {
      initShim.setScaleInput(builder.scaleInput);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.orient = initShim.getOrient();
    this.slidingtext = initShim.getSlidingtext();
    this.curposInDouble = initShim.getCurposInDouble();
    this.minposInDouble = initShim.getMinposInDouble();
    this.maxposInDouble = initShim.getMaxposInDouble();
    this.stepInDouble = initShim.getStepInDouble();
    this.pageIncrementInDouble = initShim.getPageIncrementInDouble();
    this.strokeWidth = initShim.getStrokeWidth();
    this.angleArc = initShim.getAngleArc();
    this.scaleInput = initShim.getScaleInput();
    this.initShim = null;
  }

  private ImmutableISlider(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      @Nullable String name,
      String orient,
      String slidingtext,
      double curposInDouble,
      double minposInDouble,
      double maxposInDouble,
      double stepInDouble,
      double pageIncrementInDouble,
      double strokeWidth,
      double angleArc,
      double scaleInput) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.name = name;
    this.orient = orient;
    this.slidingtext = slidingtext;
    this.curposInDouble = curposInDouble;
    this.minposInDouble = minposInDouble;
    this.maxposInDouble = maxposInDouble;
    this.stepInDouble = stepInDouble;
    this.pageIncrementInDouble = pageIncrementInDouble;
    this.strokeWidth = strokeWidth;
    this.angleArc = angleArc;
    this.scaleInput = scaleInput;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ISlider", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte orientBuildStage = STAGE_UNINITIALIZED;
    private String orient;

    String getOrient() {
      if (orientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (orientBuildStage == STAGE_UNINITIALIZED) {
        orientBuildStage = STAGE_INITIALIZING;
        this.orient = Objects.requireNonNull(getOrientInitialize(), "orient");
        orientBuildStage = STAGE_INITIALIZED;
      }
      return this.orient;
    }

    void setOrient(String orient) {
      this.orient = orient;
      orientBuildStage = STAGE_INITIALIZED;
    }

    private byte slidingtextBuildStage = STAGE_UNINITIALIZED;
    private String slidingtext;

    String getSlidingtext() {
      if (slidingtextBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (slidingtextBuildStage == STAGE_UNINITIALIZED) {
        slidingtextBuildStage = STAGE_INITIALIZING;
        this.slidingtext = Objects.requireNonNull(getSlidingtextInitialize(), "slidingtext");
        slidingtextBuildStage = STAGE_INITIALIZED;
      }
      return this.slidingtext;
    }

    void setSlidingtext(String slidingtext) {
      this.slidingtext = slidingtext;
      slidingtextBuildStage = STAGE_INITIALIZED;
    }

    private byte curposInDoubleBuildStage = STAGE_UNINITIALIZED;
    private double curposInDouble;

    double getCurposInDouble() {
      if (curposInDoubleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (curposInDoubleBuildStage == STAGE_UNINITIALIZED) {
        curposInDoubleBuildStage = STAGE_INITIALIZING;
        this.curposInDouble = getCurposInDoubleInitialize();
        curposInDoubleBuildStage = STAGE_INITIALIZED;
      }
      return this.curposInDouble;
    }

    void setCurposInDouble(double curposInDouble) {
      this.curposInDouble = curposInDouble;
      curposInDoubleBuildStage = STAGE_INITIALIZED;
    }

    private byte minposInDoubleBuildStage = STAGE_UNINITIALIZED;
    private double minposInDouble;

    double getMinposInDouble() {
      if (minposInDoubleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minposInDoubleBuildStage == STAGE_UNINITIALIZED) {
        minposInDoubleBuildStage = STAGE_INITIALIZING;
        this.minposInDouble = getMinposInDoubleInitialize();
        minposInDoubleBuildStage = STAGE_INITIALIZED;
      }
      return this.minposInDouble;
    }

    void setMinposInDouble(double minposInDouble) {
      this.minposInDouble = minposInDouble;
      minposInDoubleBuildStage = STAGE_INITIALIZED;
    }

    private byte maxposInDoubleBuildStage = STAGE_UNINITIALIZED;
    private double maxposInDouble;

    double getMaxposInDouble() {
      if (maxposInDoubleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxposInDoubleBuildStage == STAGE_UNINITIALIZED) {
        maxposInDoubleBuildStage = STAGE_INITIALIZING;
        this.maxposInDouble = getMaxposInDoubleInitialize();
        maxposInDoubleBuildStage = STAGE_INITIALIZED;
      }
      return this.maxposInDouble;
    }

    void setMaxposInDouble(double maxposInDouble) {
      this.maxposInDouble = maxposInDouble;
      maxposInDoubleBuildStage = STAGE_INITIALIZED;
    }

    private byte stepInDoubleBuildStage = STAGE_UNINITIALIZED;
    private double stepInDouble;

    double getStepInDouble() {
      if (stepInDoubleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stepInDoubleBuildStage == STAGE_UNINITIALIZED) {
        stepInDoubleBuildStage = STAGE_INITIALIZING;
        this.stepInDouble = getStepInDoubleInitialize();
        stepInDoubleBuildStage = STAGE_INITIALIZED;
      }
      return this.stepInDouble;
    }

    void setStepInDouble(double stepInDouble) {
      this.stepInDouble = stepInDouble;
      stepInDoubleBuildStage = STAGE_INITIALIZED;
    }

    private byte pageIncrementInDoubleBuildStage = STAGE_UNINITIALIZED;
    private double pageIncrementInDouble;

    double getPageIncrementInDouble() {
      if (pageIncrementInDoubleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pageIncrementInDoubleBuildStage == STAGE_UNINITIALIZED) {
        pageIncrementInDoubleBuildStage = STAGE_INITIALIZING;
        this.pageIncrementInDouble = getPageIncrementInDoubleInitialize();
        pageIncrementInDoubleBuildStage = STAGE_INITIALIZED;
      }
      return this.pageIncrementInDouble;
    }

    void setPageIncrementInDouble(double pageIncrementInDouble) {
      this.pageIncrementInDouble = pageIncrementInDouble;
      pageIncrementInDoubleBuildStage = STAGE_INITIALIZED;
    }

    private byte strokeWidthBuildStage = STAGE_UNINITIALIZED;
    private double strokeWidth;

    double getStrokeWidth() {
      if (strokeWidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (strokeWidthBuildStage == STAGE_UNINITIALIZED) {
        strokeWidthBuildStage = STAGE_INITIALIZING;
        this.strokeWidth = getStrokeWidthInitialize();
        strokeWidthBuildStage = STAGE_INITIALIZED;
      }
      return this.strokeWidth;
    }

    void setStrokeWidth(double strokeWidth) {
      this.strokeWidth = strokeWidth;
      strokeWidthBuildStage = STAGE_INITIALIZED;
    }

    private byte angleArcBuildStage = STAGE_UNINITIALIZED;
    private double angleArc;

    double getAngleArc() {
      if (angleArcBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (angleArcBuildStage == STAGE_UNINITIALIZED) {
        angleArcBuildStage = STAGE_INITIALIZING;
        this.angleArc = getAngleArcInitialize();
        angleArcBuildStage = STAGE_INITIALIZED;
      }
      return this.angleArc;
    }

    void setAngleArc(double angleArc) {
      this.angleArc = angleArc;
      angleArcBuildStage = STAGE_INITIALIZED;
    }

    private byte scaleInputBuildStage = STAGE_UNINITIALIZED;
    private double scaleInput;

    double getScaleInput() {
      if (scaleInputBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (scaleInputBuildStage == STAGE_UNINITIALIZED) {
        scaleInputBuildStage = STAGE_INITIALIZING;
        this.scaleInput = getScaleInputInitialize();
        scaleInputBuildStage = STAGE_INITIALIZED;
      }
      return this.scaleInput;
    }

    void setScaleInput(double scaleInput) {
      this.scaleInput = scaleInput;
      scaleInputBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (orientBuildStage == STAGE_INITIALIZING) attributes.add("orient");
      if (slidingtextBuildStage == STAGE_INITIALIZING) attributes.add("slidingtext");
      if (curposInDoubleBuildStage == STAGE_INITIALIZING) attributes.add("curposInDouble");
      if (minposInDoubleBuildStage == STAGE_INITIALIZING) attributes.add("minposInDouble");
      if (maxposInDoubleBuildStage == STAGE_INITIALIZING) attributes.add("maxposInDouble");
      if (stepInDoubleBuildStage == STAGE_INITIALIZING) attributes.add("stepInDouble");
      if (pageIncrementInDoubleBuildStage == STAGE_INITIALIZING) attributes.add("pageIncrementInDouble");
      if (strokeWidthBuildStage == STAGE_INITIALIZING) attributes.add("strokeWidth");
      if (angleArcBuildStage == STAGE_INITIALIZING) attributes.add("angleArc");
      if (scaleInputBuildStage == STAGE_INITIALIZING) attributes.add("scaleInput");
      return "Cannot build ISlider, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ISlider.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ISlider.super.isVisible();
  }

  private String getMoldInitialize() {
    return ISlider.super.getMold();
  }

  private int getZIndexInitialize() {
    return ISlider.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ISlider.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ISlider.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ISlider.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ISlider.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return ISlider.super.getWidgetClass();
  }

  private String getOrientInitialize() {
    return ISlider.super.getOrient();
  }

  private String getSlidingtextInitialize() {
    return ISlider.super.getSlidingtext();
  }

  private double getCurposInDoubleInitialize() {
    return ISlider.super.getCurposInDouble();
  }

  private double getMinposInDoubleInitialize() {
    return ISlider.super.getMinposInDouble();
  }

  private double getMaxposInDoubleInitialize() {
    return ISlider.super.getMaxposInDouble();
  }

  private double getStepInDoubleInitialize() {
    return ISlider.super.getStepInDouble();
  }

  private double getPageIncrementInDoubleInitialize() {
    return ISlider.super.getPageIncrementInDouble();
  }

  private double getStrokeWidthInitialize() {
    return ISlider.super.getStrokeWidth();
  }

  private double getAngleArcInitialize() {
    return ISlider.super.getAngleArc();
  }

  private double getScaleInputInitialize() {
    return ISlider.super.getScaleInput();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code orient} attribute
   */
  @Override
  public String getOrient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrient()
        : this.orient;
  }

  /**
   * @return The value of the {@code slidingtext} attribute
   */
  @Override
  public String getSlidingtext() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSlidingtext()
        : this.slidingtext;
  }

  /**
   * @return The value of the {@code curposInDouble} attribute
   */
  @Override
  public double getCurposInDouble() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCurposInDouble()
        : this.curposInDouble;
  }

  /**
   * @return The value of the {@code minposInDouble} attribute
   */
  @Override
  public double getMinposInDouble() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinposInDouble()
        : this.minposInDouble;
  }

  /**
   * @return The value of the {@code maxposInDouble} attribute
   */
  @Override
  public double getMaxposInDouble() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxposInDouble()
        : this.maxposInDouble;
  }

  /**
   * @return The value of the {@code stepInDouble} attribute
   */
  @Override
  public double getStepInDouble() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStepInDouble()
        : this.stepInDouble;
  }

  /**
   * @return The value of the {@code pageIncrementInDouble} attribute
   */
  @Override
  public double getPageIncrementInDouble() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPageIncrementInDouble()
        : this.pageIncrementInDouble;
  }

  /**
   * @return The value of the {@code strokeWidth} attribute
   */
  @Override
  public double getStrokeWidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStrokeWidth()
        : this.strokeWidth;
  }

  /**
   * @return The value of the {@code angleArc} attribute
   */
  @Override
  public double getAngleArc() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAngleArc()
        : this.angleArc;
  }

  /**
   * @return The value of the {@code scaleInput} attribute
   */
  @Override
  public double getScaleInput() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getScaleInput()
        : this.scaleInput;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableISlider(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISlider#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISlider withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableISlider(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.name,
          this.orient,
          this.slidingtext,
          this.curposInDouble,
          this.minposInDouble,
          this.maxposInDouble,
          this.stepInDouble,
          this.pageIncrementInDouble,
          this.strokeWidth,
          this.angleArc,
          this.scaleInput));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISlider#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISlider withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISlider#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISlider withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISlider#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISlider withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISlider#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISlider withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        value,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getOrient() orient} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for orient
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withOrient(String value) {
    String newValue = Objects.requireNonNull(value, "orient");
    if (this.orient.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        newValue,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getSlidingtext() slidingtext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slidingtext
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withSlidingtext(String value) {
    String newValue = Objects.requireNonNull(value, "slidingtext");
    if (this.slidingtext.equals(newValue)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        newValue,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getCurposInDouble() curposInDouble} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for curposInDouble
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withCurposInDouble(double value) {
    if (Double.doubleToLongBits(this.curposInDouble) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        value,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getMinposInDouble() minposInDouble} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minposInDouble
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withMinposInDouble(double value) {
    if (Double.doubleToLongBits(this.minposInDouble) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        value,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getMaxposInDouble() maxposInDouble} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxposInDouble
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withMaxposInDouble(double value) {
    if (Double.doubleToLongBits(this.maxposInDouble) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        value,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getStepInDouble() stepInDouble} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stepInDouble
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withStepInDouble(double value) {
    if (Double.doubleToLongBits(this.stepInDouble) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        value,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getPageIncrementInDouble() pageIncrementInDouble} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageIncrementInDouble
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withPageIncrementInDouble(double value) {
    if (Double.doubleToLongBits(this.pageIncrementInDouble) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        value,
        this.strokeWidth,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getStrokeWidth() strokeWidth} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for strokeWidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withStrokeWidth(double value) {
    if (Double.doubleToLongBits(this.strokeWidth) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        value,
        this.angleArc,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getAngleArc() angleArc} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for angleArc
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withAngleArc(double value) {
    if (Double.doubleToLongBits(this.angleArc) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        value,
        this.scaleInput));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISlider#getScaleInput() scaleInput} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scaleInput
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISlider withScaleInput(double value) {
    if (Double.doubleToLongBits(this.scaleInput) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableISlider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.name,
        this.orient,
        this.slidingtext,
        this.curposInDouble,
        this.minposInDouble,
        this.maxposInDouble,
        this.stepInDouble,
        this.pageIncrementInDouble,
        this.strokeWidth,
        this.angleArc,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableISlider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableISlider
        && equalTo((ImmutableISlider) another);
  }

  private boolean equalTo(ImmutableISlider another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(name, another.name)
        && orient.equals(another.orient)
        && slidingtext.equals(another.slidingtext)
        && Double.doubleToLongBits(curposInDouble) == Double.doubleToLongBits(another.curposInDouble)
        && Double.doubleToLongBits(minposInDouble) == Double.doubleToLongBits(another.minposInDouble)
        && Double.doubleToLongBits(maxposInDouble) == Double.doubleToLongBits(another.maxposInDouble)
        && Double.doubleToLongBits(stepInDouble) == Double.doubleToLongBits(another.stepInDouble)
        && Double.doubleToLongBits(pageIncrementInDouble) == Double.doubleToLongBits(another.pageIncrementInDouble)
        && Double.doubleToLongBits(strokeWidth) == Double.doubleToLongBits(another.strokeWidth)
        && Double.doubleToLongBits(angleArc) == Double.doubleToLongBits(another.angleArc)
        && Double.doubleToLongBits(scaleInput) == Double.doubleToLongBits(another.scaleInput);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code name}, {@code orient}, {@code slidingtext}, {@code curposInDouble}, {@code minposInDouble}, {@code maxposInDouble}, {@code stepInDouble}, {@code pageIncrementInDouble}, {@code strokeWidth}, {@code angleArc}, {@code scaleInput}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + orient.hashCode();
    h += (h << 5) + slidingtext.hashCode();
    h += (h << 5) + Doubles.hashCode(curposInDouble);
    h += (h << 5) + Doubles.hashCode(minposInDouble);
    h += (h << 5) + Doubles.hashCode(maxposInDouble);
    h += (h << 5) + Doubles.hashCode(stepInDouble);
    h += (h << 5) + Doubles.hashCode(pageIncrementInDouble);
    h += (h << 5) + Doubles.hashCode(strokeWidth);
    h += (h << 5) + Doubles.hashCode(angleArc);
    h += (h << 5) + Doubles.hashCode(scaleInput);
    return h;
  }

  /**
   * Prints the immutable value {@code ISlider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ISlider")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("name", name)
        .add("orient", orient)
        .add("slidingtext", slidingtext)
        .add("curposInDouble", curposInDouble)
        .add("minposInDouble", minposInDouble)
        .add("maxposInDouble", maxposInDouble)
        .add("stepInDouble", stepInDouble)
        .add("pageIncrementInDouble", pageIncrementInDouble)
        .add("strokeWidth", strokeWidth)
        .add("angleArc", angleArc)
        .add("scaleInput", scaleInput)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Slider> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISlider#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Slider> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ISlider.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long CURPOS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient int curpos;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISlider#getCurpos() curpos} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code curpos} attribute
   */
  @Override
  public int getCurpos() {
    if ((lazyInitBitmap & CURPOS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CURPOS_LAZY_INIT_BIT) == 0) {
          this.curpos = ISlider.super.getCurpos();
          lazyInitBitmap |= CURPOS_LAZY_INIT_BIT;
        }
      }
    }
    return curpos;
  }

  private static final long MINPOS_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient int minpos;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISlider#getMinpos() minpos} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code minpos} attribute
   */
  @Override
  public int getMinpos() {
    if ((lazyInitBitmap & MINPOS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MINPOS_LAZY_INIT_BIT) == 0) {
          this.minpos = ISlider.super.getMinpos();
          lazyInitBitmap |= MINPOS_LAZY_INIT_BIT;
        }
      }
    }
    return minpos;
  }

  private static final long MAXPOS_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient int maxpos;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISlider#getMaxpos() maxpos} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code maxpos} attribute
   */
  @Override
  public int getMaxpos() {
    if ((lazyInitBitmap & MAXPOS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MAXPOS_LAZY_INIT_BIT) == 0) {
          this.maxpos = ISlider.super.getMaxpos();
          lazyInitBitmap |= MAXPOS_LAZY_INIT_BIT;
        }
      }
    }
    return maxpos;
  }

  private static final long STEP_LAZY_INIT_BIT = 0x10L;

  @SuppressWarnings("Immutable")
  private transient int step;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISlider#getStep() step} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code step} attribute
   */
  @Override
  public int getStep() {
    if ((lazyInitBitmap & STEP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STEP_LAZY_INIT_BIT) == 0) {
          this.step = ISlider.super.getStep();
          lazyInitBitmap |= STEP_LAZY_INIT_BIT;
        }
      }
    }
    return step;
  }

  private static final long PAGE_INCREMENT_LAZY_INIT_BIT = 0x20L;

  @SuppressWarnings("Immutable")
  private transient int pageIncrement;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISlider#getPageIncrement() pageIncrement} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code pageIncrement} attribute
   */
  @Override
  public int getPageIncrement() {
    if ((lazyInitBitmap & PAGE_INCREMENT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & PAGE_INCREMENT_LAZY_INIT_BIT) == 0) {
          this.pageIncrement = ISlider.super.getPageIncrement();
          lazyInitBitmap |= PAGE_INCREMENT_LAZY_INIT_BIT;
        }
      }
    }
    return pageIncrement;
  }

  private static ImmutableISlider validate(ImmutableISlider instance) {
    instance = (ImmutableISlider) instance.checkCurpos();
    instance.checkValue();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableISlider) instance.checkDroppable();
    instance = (ImmutableISlider) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ISlider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ISlider instance
   */
  public static ISlider copyOf(ISlider instance) {
    if (instance instanceof ImmutableISlider) {
      return (ImmutableISlider) instance;
    }
    return new ISlider.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ISlider ISlider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ISlider", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_CURPOS_IN_DOUBLE = 0x10L;
    private static final long OPT_BIT_MINPOS_IN_DOUBLE = 0x20L;
    private static final long OPT_BIT_MAXPOS_IN_DOUBLE = 0x40L;
    private static final long OPT_BIT_STEP_IN_DOUBLE = 0x80L;
    private static final long OPT_BIT_PAGE_INCREMENT_IN_DOUBLE = 0x100L;
    private static final long OPT_BIT_STROKE_WIDTH = 0x200L;
    private static final long OPT_BIT_ANGLE_ARC = 0x400L;
    private static final long OPT_BIT_SCALE_INPUT = 0x800L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private @Nullable String name;
    private @Nullable String orient;
    private @Nullable String slidingtext;
    private double curposInDouble;
    private double minposInDouble;
    private double maxposInDouble;
    private double stepInDouble;
    private double pageIncrementInDouble;
    private double strokeWidth;
    private double angleArc;
    private double scaleInput;

    /**
     * Creates a builder for {@link ISlider ISlider} instances.
     * <pre>
     * new ISlider.Builder()
     *    .setId(String) // optional {@link ISlider#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ISlider#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ISlider#getActions() actions}
     *    .setVisible(boolean) // optional {@link ISlider#isVisible() visible}
     *    .setMold(String) // optional {@link ISlider#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ISlider#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISlider#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISlider#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISlider#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ISlider#getLeft() left}
     *    .setTop(String | null) // nullable {@link ISlider#getTop() top}
     *    .setZIndex(int) // optional {@link ISlider#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ISlider#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ISlider#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ISlider#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ISlider#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ISlider#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ISlider#getStyle() style}
     *    .setDraggable(String) // optional {@link ISlider#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ISlider#isFocus() focus}
     *    .setDroppable(String) // optional {@link ISlider#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ISlider#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ISlider#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ISlider#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ISlider#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ISlider#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ISlider#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ISlider#getContext() context}
     *    .setPopup(String | null) // nullable {@link ISlider#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ISlider#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link ISlider#getWidgetClass() widgetClass}
     *    .setName(String | null) // nullable {@link ISlider#getName() name}
     *    .setOrient(String) // optional {@link ISlider#getOrient() orient}
     *    .setSlidingtext(String) // optional {@link ISlider#getSlidingtext() slidingtext}
     *    .setCurposInDouble(double) // optional {@link ISlider#getCurposInDouble() curposInDouble}
     *    .setMinposInDouble(double) // optional {@link ISlider#getMinposInDouble() minposInDouble}
     *    .setMaxposInDouble(double) // optional {@link ISlider#getMaxposInDouble() maxposInDouble}
     *    .setStepInDouble(double) // optional {@link ISlider#getStepInDouble() stepInDouble}
     *    .setPageIncrementInDouble(double) // optional {@link ISlider#getPageIncrementInDouble() pageIncrementInDouble}
     *    .setStrokeWidth(double) // optional {@link ISlider#getStrokeWidth() strokeWidth}
     *    .setAngleArc(double) // optional {@link ISlider#getAngleArc() angleArc}
     *    .setScaleInput(double) // optional {@link ISlider#getScaleInput() scaleInput}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ISlider.Builder)) {
        throw new UnsupportedOperationException("Use: new ISlider.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ISlider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder from(ISlider instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      setOrient(instance.getOrient());
      setSlidingtext(instance.getSlidingtext());
      setCurposInDouble(instance.getCurposInDouble());
      setMinposInDouble(instance.getMinposInDouble());
      setMaxposInDouble(instance.getMaxposInDouble());
      setStepInDouble(instance.getStepInDouble());
      setPageIncrementInDouble(instance.getPageIncrementInDouble());
      setStrokeWidth(instance.getStrokeWidth());
      setAngleArc(instance.getAngleArc());
      setScaleInput(instance.getScaleInput());
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ISlider.Builder) this;
    }

    /**
     * Adds one element to {@link ISlider#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ISlider.Builder) this;
    }

    /**
     * Adds elements to {@link ISlider#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ISlider.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ISlider#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ISlider.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ISlider#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ISlider.Builder) this;
    }

    /**
     * Put one entry to the {@link ISlider#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ISlider.Builder) this;
    }

    /**
     * Put one entry to the {@link ISlider#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ISlider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISlider#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ISlider.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISlider#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ISlider.Builder) this;
    }

    /**
     * Put one entry to the {@link ISlider#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ISlider.Builder) this;
    }

    /**
     * Put one entry to the {@link ISlider#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ISlider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISlider#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ISlider.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISlider#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ISlider.Builder) this;
    }

    /**
     * Put one entry to the {@link ISlider#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ISlider.Builder) this;
    }

    /**
     * Put one entry to the {@link ISlider#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ISlider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISlider#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ISlider.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISlider#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setContext(@Nullable String context) {
      this.context = context;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setName(@Nullable String name) {
      this.name = name;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getOrient() orient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getOrient() orient}.</em>
     * @param orient The value for orient 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setOrient(String orient) {
      this.orient = Objects.requireNonNull(orient, "orient");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getSlidingtext() slidingtext} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getSlidingtext() slidingtext}.</em>
     * @param slidingtext The value for slidingtext 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setSlidingtext(String slidingtext) {
      this.slidingtext = Objects.requireNonNull(slidingtext, "slidingtext");
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getCurposInDouble() curposInDouble} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getCurposInDouble() curposInDouble}.</em>
     * @param curposInDouble The value for curposInDouble 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setCurposInDouble(double curposInDouble) {
      this.curposInDouble = curposInDouble;
      optBits |= OPT_BIT_CURPOS_IN_DOUBLE;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getMinposInDouble() minposInDouble} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getMinposInDouble() minposInDouble}.</em>
     * @param minposInDouble The value for minposInDouble 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setMinposInDouble(double minposInDouble) {
      this.minposInDouble = minposInDouble;
      optBits |= OPT_BIT_MINPOS_IN_DOUBLE;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getMaxposInDouble() maxposInDouble} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getMaxposInDouble() maxposInDouble}.</em>
     * @param maxposInDouble The value for maxposInDouble 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setMaxposInDouble(double maxposInDouble) {
      this.maxposInDouble = maxposInDouble;
      optBits |= OPT_BIT_MAXPOS_IN_DOUBLE;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getStepInDouble() stepInDouble} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getStepInDouble() stepInDouble}.</em>
     * @param stepInDouble The value for stepInDouble 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setStepInDouble(double stepInDouble) {
      this.stepInDouble = stepInDouble;
      optBits |= OPT_BIT_STEP_IN_DOUBLE;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getPageIncrementInDouble() pageIncrementInDouble} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getPageIncrementInDouble() pageIncrementInDouble}.</em>
     * @param pageIncrementInDouble The value for pageIncrementInDouble 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setPageIncrementInDouble(double pageIncrementInDouble) {
      this.pageIncrementInDouble = pageIncrementInDouble;
      optBits |= OPT_BIT_PAGE_INCREMENT_IN_DOUBLE;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getStrokeWidth() strokeWidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getStrokeWidth() strokeWidth}.</em>
     * @param strokeWidth The value for strokeWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setStrokeWidth(double strokeWidth) {
      this.strokeWidth = strokeWidth;
      optBits |= OPT_BIT_STROKE_WIDTH;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getAngleArc() angleArc} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getAngleArc() angleArc}.</em>
     * @param angleArc The value for angleArc 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setAngleArc(double angleArc) {
      this.angleArc = angleArc;
      optBits |= OPT_BIT_ANGLE_ARC;
      return (ISlider.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISlider#getScaleInput() scaleInput} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISlider#getScaleInput() scaleInput}.</em>
     * @param scaleInput The value for scaleInput 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISlider.Builder setScaleInput(double scaleInput) {
      this.scaleInput = scaleInput;
      optBits |= OPT_BIT_SCALE_INPUT;
      return (ISlider.Builder) this;
    }

    /**
     * Builds a new {@link ISlider ISlider}.
     * @return An immutable instance of ISlider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ISlider build() {
      return ImmutableISlider.validate(new ImmutableISlider(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean curposInDoubleIsSet() {
      return (optBits & OPT_BIT_CURPOS_IN_DOUBLE) != 0;
    }

    private boolean minposInDoubleIsSet() {
      return (optBits & OPT_BIT_MINPOS_IN_DOUBLE) != 0;
    }

    private boolean maxposInDoubleIsSet() {
      return (optBits & OPT_BIT_MAXPOS_IN_DOUBLE) != 0;
    }

    private boolean stepInDoubleIsSet() {
      return (optBits & OPT_BIT_STEP_IN_DOUBLE) != 0;
    }

    private boolean pageIncrementInDoubleIsSet() {
      return (optBits & OPT_BIT_PAGE_INCREMENT_IN_DOUBLE) != 0;
    }

    private boolean strokeWidthIsSet() {
      return (optBits & OPT_BIT_STROKE_WIDTH) != 0;
    }

    private boolean angleArcIsSet() {
      return (optBits & OPT_BIT_ANGLE_ARC) != 0;
    }

    private boolean scaleInputIsSet() {
      return (optBits & OPT_BIT_SCALE_INPUT) != 0;
    }
  }
}
