package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Selectbox;

/**
 * Immutable implementation of {@link ISelectbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ISelectbox.Builder()}.
 */
@Generated(from = "ISelectbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableISelectbox implements ISelectbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final boolean disabled;
  private final String widgetClass;
  private final @Nullable String name;
  private final ImmutableList<String> children;
  private final boolean multiple;
  private final int maxlength;
  private final ImmutableMap<String, Object> auxInfo;

  private ImmutableISelectbox(ImmutableISelectbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.name = builder.name;
    this.children = builder.children.build();
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.multipleIsSet()) {
      initShim.setMultiple(builder.multiple);
    }
    if (builder.maxlengthIsSet()) {
      initShim.setMaxlength(builder.maxlength);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.disabled = initShim.isDisabled();
    this.widgetClass = initShim.getWidgetClass();
    this.multiple = initShim.isMultiple();
    this.maxlength = initShim.getMaxlength();
    this.auxInfo = initShim.getAuxInfo();
    this.initShim = null;
  }

  private ImmutableISelectbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      boolean disabled,
      String widgetClass,
      @Nullable String name,
      ImmutableList<String> children,
      boolean multiple,
      int maxlength,
      ImmutableMap<String, Object> auxInfo) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.disabled = disabled;
    this.widgetClass = widgetClass;
    this.name = name;
    this.children = children;
    this.multiple = multiple;
    this.maxlength = maxlength;
    this.auxInfo = auxInfo;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ISelectbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte multipleBuildStage = STAGE_UNINITIALIZED;
    private boolean multiple;

    boolean isMultiple() {
      if (multipleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (multipleBuildStage == STAGE_UNINITIALIZED) {
        multipleBuildStage = STAGE_INITIALIZING;
        this.multiple = isMultipleInitialize();
        multipleBuildStage = STAGE_INITIALIZED;
      }
      return this.multiple;
    }

    void setMultiple(boolean multiple) {
      this.multiple = multiple;
      multipleBuildStage = STAGE_INITIALIZED;
    }

    private byte maxlengthBuildStage = STAGE_UNINITIALIZED;
    private int maxlength;

    int getMaxlength() {
      if (maxlengthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxlengthBuildStage == STAGE_UNINITIALIZED) {
        maxlengthBuildStage = STAGE_INITIALIZING;
        this.maxlength = getMaxlengthInitialize();
        maxlengthBuildStage = STAGE_INITIALIZED;
      }
      return this.maxlength;
    }

    void setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      maxlengthBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (multipleBuildStage == STAGE_INITIALIZING) attributes.add("multiple");
      if (maxlengthBuildStage == STAGE_INITIALIZING) attributes.add("maxlength");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      return "Cannot build ISelectbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ISelectbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ISelectbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return ISelectbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return ISelectbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ISelectbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ISelectbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ISelectbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ISelectbox.super.getRenderdefer();
  }

  private boolean isDisabledInitialize() {
    return ISelectbox.super.isDisabled();
  }

  private String getWidgetClassInitialize() {
    return ISelectbox.super.getWidgetClass();
  }

  private boolean isMultipleInitialize() {
    return ISelectbox.super.isMultiple();
  }

  private int getMaxlengthInitialize() {
    return ISelectbox.super.getMaxlength();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return ISelectbox.super.getAuxInfo();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<String> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code multiple} attribute
   */
  @StatelessOnly
  @Override
  public boolean isMultiple() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMultiple()
        : this.multiple;
  }

  /**
   * @return The value of the {@code maxlength} attribute
   */
  @StatelessOnly
  @Override
  public int getMaxlength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxlength()
        : this.maxlength;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableISelectbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISelectbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableISelectbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.disabled,
          this.widgetClass,
          this.name,
          this.children,
          this.multiple,
          this.maxlength,
          this.auxInfo));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISelectbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISelectbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISelectbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISelectbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        newValue,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        value,
        this.children,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISelectbox#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withChildren(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        newValue,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ISelectbox#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withChildren(Iterable<String> elements) {
    if (this.children == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        newValue,
        this.multiple,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#isMultiple() multiple} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiple
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withMultiple(boolean value) {
    if (this.multiple == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        value,
        this.maxlength,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ISelectbox#getMaxlength() maxlength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxlength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableISelectbox withMaxlength(int value) {
    if (this.maxlength == value) return this;
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        value,
        this.auxInfo));
  }

  /**
   * Copy the current immutable object by replacing the {@link ISelectbox#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableISelectbox withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableISelectbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.disabled,
        this.widgetClass,
        this.name,
        this.children,
        this.multiple,
        this.maxlength,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableISelectbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableISelectbox
        && equalTo((ImmutableISelectbox) another);
  }

  private boolean equalTo(ImmutableISelectbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && disabled == another.disabled
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(name, another.name)
        && children.equals(another.children)
        && multiple == another.multiple
        && maxlength == another.maxlength
        && auxInfo.equals(another.auxInfo);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code disabled}, {@code widgetClass}, {@code name}, {@code children}, {@code multiple}, {@code maxlength}, {@code auxInfo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + children.hashCode();
    h += (h << 5) + Booleans.hashCode(multiple);
    h += (h << 5) + maxlength;
    h += (h << 5) + auxInfo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ISelectbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ISelectbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("disabled", disabled)
        .add("widgetClass", widgetClass)
        .add("name", name)
        .add("children", children)
        .add("multiple", multiple)
        .add("maxlength", maxlength)
        .add("auxInfo", auxInfo)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Selectbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ISelectbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Selectbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ISelectbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableISelectbox validate(ImmutableISelectbox instance) {
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableISelectbox) instance.checkDroppable();
    instance = (ImmutableISelectbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ISelectbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ISelectbox instance
   */
  public static ISelectbox copyOf(ISelectbox instance) {
    if (instance instanceof ImmutableISelectbox) {
      return (ImmutableISelectbox) instance;
    }
    return new ISelectbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ISelectbox ISelectbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ISelectbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_DISABLED = 0x10L;
    private static final long OPT_BIT_MULTIPLE = 0x20L;
    private static final long OPT_BIT_MAXLENGTH = 0x40L;
    private static final long OPT_BIT_AUX_INFO = 0x80L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private boolean disabled;
    private @Nullable String widgetClass;
    private @Nullable String name;
    private ImmutableList.Builder<String> children = ImmutableList.builder();
    private boolean multiple;
    private int maxlength;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ISelectbox ISelectbox} instances.
     * <pre>
     * new ISelectbox.Builder()
     *    .setId(String) // optional {@link ISelectbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ISelectbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ISelectbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link ISelectbox#isVisible() visible}
     *    .setMold(String) // optional {@link ISelectbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ISelectbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISelectbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISelectbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ISelectbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ISelectbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link ISelectbox#getTop() top}
     *    .setZIndex(int) // optional {@link ISelectbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ISelectbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ISelectbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ISelectbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ISelectbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ISelectbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ISelectbox#getStyle() style}
     *    .setDraggable(String) // optional {@link ISelectbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ISelectbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link ISelectbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ISelectbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ISelectbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ISelectbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ISelectbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ISelectbox#getTabindex() tabindex}
     *    .setDisabled(boolean) // optional {@link ISelectbox#isDisabled() disabled}
     *    .setWidgetClass(String) // optional {@link ISelectbox#getWidgetClass() widgetClass}
     *    .setName(String | null) // nullable {@link ISelectbox#getName() name}
     *    .addChildren|addAllChildren(String) // {@link ISelectbox#getChildren() children} elements
     *    .setMultiple(boolean) // optional {@link ISelectbox#isMultiple() multiple}
     *    .setMaxlength(int) // optional {@link ISelectbox#getMaxlength() maxlength}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link ISelectbox#getAuxInfo() auxInfo} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ISelectbox.Builder)) {
        throw new UnsupportedOperationException("Use: new ISelectbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ISelectbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder from(ISelectbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      setDisabled(instance.isDisabled());
      setWidgetClass(instance.getWidgetClass());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      addAllChildren(instance.getChildren());
      setMultiple(instance.isMultiple());
      setMaxlength(instance.getMaxlength());
      putAllAuxInfo(instance.getAuxInfo());
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ISelectbox.Builder) this;
    }

    /**
     * Adds one element to {@link ISelectbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ISelectbox.Builder) this;
    }

    /**
     * Adds elements to {@link ISelectbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ISelectbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ISelectbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ISelectbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ISelectbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ISelectbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISelectbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ISelectbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISelectbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ISelectbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISelectbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ISelectbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISelectbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ISelectbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISelectbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ISelectbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISelectbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setName(@Nullable String name) {
      this.name = name;
      return (ISelectbox.Builder) this;
    }

    /**
     * Adds one element to {@link ISelectbox#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder addChildren(String element) {
      this.children.add(element);
      return (ISelectbox.Builder) this;
    }

    /**
     * Adds elements to {@link ISelectbox#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder addChildren(String... elements) {
      this.children.add(elements);
      return (ISelectbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link ISelectbox#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setChildren(Iterable<String> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link ISelectbox#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder addAllChildren(Iterable<String> elements) {
      this.children.addAll(elements);
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#isMultiple() multiple} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#isMultiple() multiple}.</em>
     * @param multiple The value for multiple 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setMultiple(boolean multiple) {
      this.multiple = multiple;
      optBits |= OPT_BIT_MULTIPLE;
      return (ISelectbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link ISelectbox#getMaxlength() maxlength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ISelectbox#getMaxlength() maxlength}.</em>
     * @param maxlength The value for maxlength 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      optBits |= OPT_BIT_MAXLENGTH;
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (ISelectbox.Builder) this;
    }

    /**
     * Put one entry to the {@link ISelectbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (ISelectbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ISelectbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ISelectbox#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ISelectbox.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (ISelectbox.Builder) this;
    }

    /**
     * Builds a new {@link ISelectbox ISelectbox}.
     * @return An immutable instance of ISelectbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ISelectbox build() {
      return ImmutableISelectbox.validate(new ImmutableISelectbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean multipleIsSet() {
      return (optBits & OPT_BIT_MULTIPLE) != 0;
    }

    private boolean maxlengthIsSet() {
      return (optBits & OPT_BIT_MAXLENGTH) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }
  }
}
