package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Script;

/**
 * Immutable implementation of {@link IScript}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IScript.Builder()}.
 */
@Generated(from = "IScript", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIScript implements IScript {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final String widgetClass;
  private final @Nullable String charset;
  private final @Nullable String src;
  private final boolean defer;
  private final @Nullable String content;
  private final @Nullable String packages;

  private ImmutableIScript(ImmutableIScript.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.charset = builder.charset;
    this.src = builder.src;
    this.content = builder.content;
    this.packages = builder.packages;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.deferIsSet()) {
      initShim.setDefer(builder.defer);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.widgetClass = initShim.getWidgetClass();
    this.defer = initShim.isDefer();
    this.initShim = null;
  }

  private ImmutableIScript(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      String widgetClass,
      @Nullable String charset,
      @Nullable String src,
      boolean defer,
      @Nullable String content,
      @Nullable String packages) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.widgetClass = widgetClass;
    this.charset = charset;
    this.src = src;
    this.defer = defer;
    this.content = content;
    this.packages = packages;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IScript", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte deferBuildStage = STAGE_UNINITIALIZED;
    private boolean defer;

    boolean isDefer() {
      if (deferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (deferBuildStage == STAGE_UNINITIALIZED) {
        deferBuildStage = STAGE_INITIALIZING;
        this.defer = isDeferInitialize();
        deferBuildStage = STAGE_INITIALIZED;
      }
      return this.defer;
    }

    void setDefer(boolean defer) {
      this.defer = defer;
      deferBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (deferBuildStage == STAGE_INITIALIZING) attributes.add("defer");
      return "Cannot build IScript, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IScript.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IScript.super.isVisible();
  }

  private String getMoldInitialize() {
    return IScript.super.getMold();
  }

  private String getWidgetClassInitialize() {
    return IScript.super.getWidgetClass();
  }

  private boolean isDeferInitialize() {
    return IScript.super.isDefer();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code charset} attribute
   */
  @Override
  public @Nullable String getCharset() {
    return charset;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @Override
  public @Nullable String getSrc() {
    return src;
  }

  /**
   * @return The value of the {@code defer} attribute
   */
  @Override
  public boolean isDefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDefer()
        : this.defer;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public @Nullable String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code packages} attribute
   */
  @Override
  public @Nullable String getPackages() {
    return packages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIScript(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIScript(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IScript#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIScript withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIScript(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.widgetClass,
          this.charset,
          this.src,
          this.defer,
          this.content,
          this.packages));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IScript#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIScript withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by replacing the {@link IScript#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIScript withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by replacing the {@link IScript#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIScript withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by replacing the {@link IScript#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIScript withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        newValue,
        this.charset,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getCharset() charset} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for charset (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withCharset(@Nullable String value) {
    if (Objects.equals(this.charset, value)) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        value,
        this.src,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getSrc() src} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withSrc(@Nullable String value) {
    if (Objects.equals(this.src, value)) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        value,
        this.defer,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#isDefer() defer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withDefer(boolean value) {
    if (this.defer == value) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        value,
        this.content,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withContent(@Nullable String value) {
    if (Objects.equals(this.content, value)) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        value,
        this.packages));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IScript#getPackages() packages} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for packages (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIScript withPackages(@Nullable String value) {
    if (Objects.equals(this.packages, value)) return this;
    return validate(new ImmutableIScript(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.widgetClass,
        this.charset,
        this.src,
        this.defer,
        this.content,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIScript} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIScript
        && equalTo((ImmutableIScript) another);
  }

  private boolean equalTo(ImmutableIScript another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(charset, another.charset)
        && Objects.equals(src, another.src)
        && defer == another.defer
        && Objects.equals(content, another.content)
        && Objects.equals(packages, another.packages);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code widgetClass}, {@code charset}, {@code src}, {@code defer}, {@code content}, {@code packages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(charset);
    h += (h << 5) + Objects.hashCode(src);
    h += (h << 5) + Booleans.hashCode(defer);
    h += (h << 5) + Objects.hashCode(content);
    h += (h << 5) + Objects.hashCode(packages);
    return h;
  }

  /**
   * Prints the immutable value {@code IScript} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IScript")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("widgetClass", widgetClass)
        .add("charset", charset)
        .add("src", src)
        .add("defer", defer)
        .add("content", content)
        .add("packages", packages)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Script> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IScript#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Script> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IScript.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIScript validate(ImmutableIScript instance) {
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IScript} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IScript instance
   */
  public static IScript copyOf(IScript instance) {
    if (instance instanceof ImmutableIScript) {
      return (ImmutableIScript) instance;
    }
    return new IScript.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IScript IScript}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IScript", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_DEFER = 0x2L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String widgetClass;
    private @Nullable String charset;
    private @Nullable String src;
    private boolean defer;
    private @Nullable String content;
    private @Nullable String packages;

    /**
     * Creates a builder for {@link IScript IScript} instances.
     * <pre>
     * new IScript.Builder()
     *    .setId(String) // optional {@link IScript#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IScript#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IScript#getActions() actions}
     *    .setVisible(boolean) // optional {@link IScript#isVisible() visible}
     *    .setMold(String) // optional {@link IScript#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IScript#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IScript#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IScript#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IScript#getClientAttributes() clientAttributes}
     *    .setWidgetClass(String) // optional {@link IScript#getWidgetClass() widgetClass}
     *    .setCharset(String | null) // nullable {@link IScript#getCharset() charset}
     *    .setSrc(String | null) // nullable {@link IScript#getSrc() src}
     *    .setDefer(boolean) // optional {@link IScript#isDefer() defer}
     *    .setContent(String | null) // nullable {@link IScript#getContent() content}
     *    .setPackages(String | null) // nullable {@link IScript#getPackages() packages}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IScript.Builder)) {
        throw new UnsupportedOperationException("Use: new IScript.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IScript} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder from(IScript instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String charsetValue = instance.getCharset();
      if (charsetValue != null) {
        setCharset(charsetValue);
      }
      @Nullable String srcValue = instance.getSrc();
      if (srcValue != null) {
        setSrc(srcValue);
      }
      setDefer(instance.isDefer());
      @Nullable String contentValue = instance.getContent();
      if (contentValue != null) {
        setContent(contentValue);
      }
      @Nullable String packagesValue = instance.getPackages();
      if (packagesValue != null) {
        setPackages(packagesValue);
      }
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IScript#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IScript.Builder) this;
    }

    /**
     * Adds one element to {@link IScript#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IScript.Builder) this;
    }

    /**
     * Adds elements to {@link IScript#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IScript.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IScript#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IScript.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IScript#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IScript#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IScript#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IScript.Builder) this;
    }

    /**
     * Put one entry to the {@link IScript#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IScript.Builder) this;
    }

    /**
     * Put one entry to the {@link IScript#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IScript.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IScript#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IScript.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IScript#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IScript.Builder) this;
    }

    /**
     * Put one entry to the {@link IScript#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IScript.Builder) this;
    }

    /**
     * Put one entry to the {@link IScript#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IScript.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IScript#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IScript.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IScript#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IScript.Builder) this;
    }

    /**
     * Put one entry to the {@link IScript#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IScript.Builder) this;
    }

    /**
     * Put one entry to the {@link IScript#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IScript.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IScript#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IScript.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IScript#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IScript#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getCharset() charset} attribute.
     * @param charset The value for charset (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setCharset(@Nullable String charset) {
      this.charset = charset;
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getSrc() src} attribute.
     * @param src The value for src (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setSrc(@Nullable String src) {
      this.src = src;
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#isDefer() defer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IScript#isDefer() defer}.</em>
     * @param defer The value for defer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setDefer(boolean defer) {
      this.defer = defer;
      optBits |= OPT_BIT_DEFER;
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getContent() content} attribute.
     * @param content The value for content (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setContent(@Nullable String content) {
      this.content = content;
      return (IScript.Builder) this;
    }

    /**
     * Initializes the value for the {@link IScript#getPackages() packages} attribute.
     * @param packages The value for packages (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IScript.Builder setPackages(@Nullable String packages) {
      this.packages = packages;
      return (IScript.Builder) this;
    }

    /**
     * Builds a new {@link IScript IScript}.
     * @return An immutable instance of IScript
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IScript build() {
      return ImmutableIScript.validate(new ImmutableIScript(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean deferIsSet() {
      return (optBits & OPT_BIT_DEFER) != 0;
    }
  }
}
