package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkex.zul.Pdfviewer;

/**
 * Immutable implementation of {@link IPdfviewer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IPdfviewer.Builder()}.
 */
@Generated(from = "IPdfviewer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIPdfviewer implements IPdfviewer {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final @Nullable IToolbar child;
  private final String widgetClass;
  private final @Nullable String src;
  private final double zoom;
  private final IPdfviewer.ZoomMode zoomMode;
  private final ImmutableMap<String, Object> auxInfo;
  private final int rotation;

  private ImmutableIPdfviewer(ImmutableIPdfviewer.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.child = builder.child;
    this.src = builder.src;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.zoomIsSet()) {
      initShim.setZoom(builder.zoom);
    }
    if (builder.zoomMode != null) {
      initShim.setZoomMode(builder.zoomMode);
    }
    if (builder.auxInfoIsSet()) {
      initShim.setAuxInfo(builder.auxInfo.build());
    }
    if (builder.rotationIsSet()) {
      initShim.setRotation(builder.rotation);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.zoom = initShim.getZoom();
    this.zoomMode = initShim.getZoomMode();
    this.auxInfo = initShim.getAuxInfo();
    this.rotation = initShim.getRotation();
    this.initShim = null;
  }

  private ImmutableIPdfviewer(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      @Nullable IToolbar child,
      String widgetClass,
      @Nullable String src,
      double zoom,
      IPdfviewer.ZoomMode zoomMode,
      ImmutableMap<String, Object> auxInfo,
      int rotation) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.child = child;
    this.widgetClass = widgetClass;
    this.src = src;
    this.zoom = zoom;
    this.zoomMode = zoomMode;
    this.auxInfo = auxInfo;
    this.rotation = rotation;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IPdfviewer", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte zoomBuildStage = STAGE_UNINITIALIZED;
    private double zoom;

    double getZoom() {
      if (zoomBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zoomBuildStage == STAGE_UNINITIALIZED) {
        zoomBuildStage = STAGE_INITIALIZING;
        this.zoom = getZoomInitialize();
        zoomBuildStage = STAGE_INITIALIZED;
      }
      return this.zoom;
    }

    void setZoom(double zoom) {
      this.zoom = zoom;
      zoomBuildStage = STAGE_INITIALIZED;
    }

    private byte zoomModeBuildStage = STAGE_UNINITIALIZED;
    private IPdfviewer.ZoomMode zoomMode;

    IPdfviewer.ZoomMode getZoomMode() {
      if (zoomModeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zoomModeBuildStage == STAGE_UNINITIALIZED) {
        zoomModeBuildStage = STAGE_INITIALIZING;
        this.zoomMode = Objects.requireNonNull(getZoomModeInitialize(), "zoomMode");
        zoomModeBuildStage = STAGE_INITIALIZED;
      }
      return this.zoomMode;
    }

    void setZoomMode(IPdfviewer.ZoomMode zoomMode) {
      this.zoomMode = zoomMode;
      zoomModeBuildStage = STAGE_INITIALIZED;
    }

    private byte auxInfoBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, Object> auxInfo;

    ImmutableMap<String, Object> getAuxInfo() {
      if (auxInfoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auxInfoBuildStage == STAGE_UNINITIALIZED) {
        auxInfoBuildStage = STAGE_INITIALIZING;
        this.auxInfo = ImmutableMap.copyOf(getAuxInfoInitialize());
        auxInfoBuildStage = STAGE_INITIALIZED;
      }
      return this.auxInfo;
    }

    void setAuxInfo(ImmutableMap<String, Object> auxInfo) {
      this.auxInfo = auxInfo;
      auxInfoBuildStage = STAGE_INITIALIZED;
    }

    private byte rotationBuildStage = STAGE_UNINITIALIZED;
    private int rotation;

    int getRotation() {
      if (rotationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rotationBuildStage == STAGE_UNINITIALIZED) {
        rotationBuildStage = STAGE_INITIALIZING;
        this.rotation = getRotationInitialize();
        rotationBuildStage = STAGE_INITIALIZED;
      }
      return this.rotation;
    }

    void setRotation(int rotation) {
      this.rotation = rotation;
      rotationBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (zoomBuildStage == STAGE_INITIALIZING) attributes.add("zoom");
      if (zoomModeBuildStage == STAGE_INITIALIZING) attributes.add("zoomMode");
      if (auxInfoBuildStage == STAGE_INITIALIZING) attributes.add("auxInfo");
      if (rotationBuildStage == STAGE_INITIALIZING) attributes.add("rotation");
      return "Cannot build IPdfviewer, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IPdfviewer.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IPdfviewer.super.isVisible();
  }

  private String getMoldInitialize() {
    return IPdfviewer.super.getMold();
  }

  private int getZIndexInitialize() {
    return IPdfviewer.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IPdfviewer.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IPdfviewer.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IPdfviewer.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IPdfviewer.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IPdfviewer.super.getWidgetClass();
  }

  private double getZoomInitialize() {
    return IPdfviewer.super.getZoom();
  }

  private IPdfviewer.ZoomMode getZoomModeInitialize() {
    return IPdfviewer.super.getZoomMode();
  }

  private Map<String, Object> getAuxInfoInitialize() {
    return IPdfviewer.super.getAuxInfo();
  }

  private int getRotationInitialize() {
    return IPdfviewer.super.getRotation();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code child} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable IToolbar getChild() {
    return child;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @Override
  public @Nullable String getSrc() {
    return src;
  }

  /**
   * @return The value of the {@code zoom} attribute
   */
  @Override
  public double getZoom() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZoom()
        : this.zoom;
  }

  /**
   * @return The value of the {@code zoomMode} attribute
   */
  @StatelessOnly
  @Override
  public IPdfviewer.ZoomMode getZoomMode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZoomMode()
        : this.zoomMode;
  }

  /**
   * @return The value of the {@code auxInfo} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableMap<String, Object> getAuxInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAuxInfo()
        : this.auxInfo;
  }

  /**
   * @return The value of the {@code rotation} attribute
   */
  @Override
  public int getRotation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRotation()
        : this.rotation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIPdfviewer(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IPdfviewer#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPdfviewer withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIPdfviewer(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.child,
          this.widgetClass,
          this.src,
          this.zoom,
          this.zoomMode,
          this.auxInfo,
          this.rotation));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IPdfviewer#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPdfviewer withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPdfviewer#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPdfviewer withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPdfviewer#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPdfviewer withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPdfviewer#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPdfviewer withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getChild() child} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for child (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withChild(@Nullable IToolbar value) {
    if (this.child == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        newValue,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getSrc() src} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withSrc(@Nullable String value) {
    if (Objects.equals(this.src, value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        value,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getZoom() zoom} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoom
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withZoom(double value) {
    if (Double.doubleToLongBits(this.zoom) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        value,
        this.zoomMode,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getZoomMode() zoomMode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoomMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withZoomMode(IPdfviewer.ZoomMode value) {
    if (this.zoomMode == value) return this;
    IPdfviewer.ZoomMode newValue = Objects.requireNonNull(value, "zoomMode");
    if (this.zoomMode.equals(newValue)) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        newValue,
        this.auxInfo,
        this.rotation));
  }

  /**
   * Copy the current immutable object by replacing the {@link IPdfviewer#getAuxInfo() auxInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auxInfo map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIPdfviewer withAuxInfo(Map<String, ? extends Object> entries) {
    if (this.auxInfo == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        newValue,
        this.rotation));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IPdfviewer#getRotation() rotation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rotation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIPdfviewer withRotation(int value) {
    if (this.rotation == value) return this;
    return validate(new ImmutableIPdfviewer(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.child,
        this.widgetClass,
        this.src,
        this.zoom,
        this.zoomMode,
        this.auxInfo,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIPdfviewer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIPdfviewer
        && equalTo((ImmutableIPdfviewer) another);
  }

  private boolean equalTo(ImmutableIPdfviewer another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && Objects.equals(child, another.child)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(src, another.src)
        && Double.doubleToLongBits(zoom) == Double.doubleToLongBits(another.zoom)
        && zoomMode.equals(another.zoomMode)
        && auxInfo.equals(another.auxInfo)
        && rotation == another.rotation;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code child}, {@code widgetClass}, {@code src}, {@code zoom}, {@code zoomMode}, {@code auxInfo}, {@code rotation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Objects.hashCode(child);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(src);
    h += (h << 5) + Doubles.hashCode(zoom);
    h += (h << 5) + zoomMode.hashCode();
    h += (h << 5) + auxInfo.hashCode();
    h += (h << 5) + rotation;
    return h;
  }

  /**
   * Prints the immutable value {@code IPdfviewer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IPdfviewer")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("child", child)
        .add("widgetClass", widgetClass)
        .add("src", src)
        .add("zoom", zoom)
        .add("zoomMode", zoomMode)
        .add("auxInfo", auxInfo)
        .add("rotation", rotation)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Pdfviewer> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IPdfviewer#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Pdfviewer> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IPdfviewer.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIPdfviewer validate(ImmutableIPdfviewer instance) {
    instance.checkRotation();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIPdfviewer) instance.checkDroppable();
    instance = (ImmutableIPdfviewer) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IPdfviewer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IPdfviewer instance
   */
  public static IPdfviewer copyOf(IPdfviewer instance) {
    if (instance instanceof ImmutableIPdfviewer) {
      return (ImmutableIPdfviewer) instance;
    }
    return new IPdfviewer.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IPdfviewer IPdfviewer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IPdfviewer", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_ZOOM = 0x10L;
    private static final long OPT_BIT_AUX_INFO = 0x20L;
    private static final long OPT_BIT_ROTATION = 0x40L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable IToolbar child;
    private @Nullable String widgetClass;
    private @Nullable String src;
    private double zoom;
    private @Nullable IPdfviewer.ZoomMode zoomMode;
    private ImmutableMap.Builder<String, Object> auxInfo = ImmutableMap.builder();
    private int rotation;

    /**
     * Creates a builder for {@link IPdfviewer IPdfviewer} instances.
     * <pre>
     * new IPdfviewer.Builder()
     *    .setId(String) // optional {@link IPdfviewer#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IPdfviewer#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IPdfviewer#getActions() actions}
     *    .setVisible(boolean) // optional {@link IPdfviewer#isVisible() visible}
     *    .setMold(String) // optional {@link IPdfviewer#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IPdfviewer#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPdfviewer#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPdfviewer#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IPdfviewer#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IPdfviewer#getLeft() left}
     *    .setTop(String | null) // nullable {@link IPdfviewer#getTop() top}
     *    .setZIndex(int) // optional {@link IPdfviewer#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IPdfviewer#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IPdfviewer#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IPdfviewer#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IPdfviewer#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IPdfviewer#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IPdfviewer#getStyle() style}
     *    .setDraggable(String) // optional {@link IPdfviewer#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IPdfviewer#isFocus() focus}
     *    .setDroppable(String) // optional {@link IPdfviewer#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IPdfviewer#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IPdfviewer#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IPdfviewer#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IPdfviewer#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IPdfviewer#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IPdfviewer#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IPdfviewer#getContext() context}
     *    .setPopup(String | null) // nullable {@link IPdfviewer#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IPdfviewer#getTooltip() tooltip}
     *    .setChild(org.zkoss.stateless.sul.IToolbar | null) // nullable {@link IPdfviewer#getChild() child}
     *    .setWidgetClass(String) // optional {@link IPdfviewer#getWidgetClass() widgetClass}
     *    .setSrc(String | null) // nullable {@link IPdfviewer#getSrc() src}
     *    .setZoom(double) // optional {@link IPdfviewer#getZoom() zoom}
     *    .setZoomMode(org.zkoss.stateless.sul.IPdfviewer.ZoomMode) // optional {@link IPdfviewer#getZoomMode() zoomMode}
     *    .putAuxInfo|putAllAuxInfo(String =&gt; Object) // {@link IPdfviewer#getAuxInfo() auxInfo} mappings
     *    .setRotation(int) // optional {@link IPdfviewer#getRotation() rotation}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IPdfviewer.Builder)) {
        throw new UnsupportedOperationException("Use: new IPdfviewer.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IPdfviewer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder from(IPdfviewer instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      @Nullable IToolbar childValue = instance.getChild();
      if (childValue != null) {
        setChild(childValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String srcValue = instance.getSrc();
      if (srcValue != null) {
        setSrc(srcValue);
      }
      setZoom(instance.getZoom());
      setZoomMode(instance.getZoomMode());
      putAllAuxInfo(instance.getAuxInfo());
      setRotation(instance.getRotation());
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Adds one element to {@link IPdfviewer#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Adds elements to {@link IPdfviewer#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IPdfviewer.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IPdfviewer#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IPdfviewer.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IPdfviewer#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPdfviewer#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IPdfviewer.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPdfviewer#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPdfviewer#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IPdfviewer.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPdfviewer#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPdfviewer#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IPdfviewer.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPdfviewer#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getChild() child} attribute.
     * @param child The value for child (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setChild(@Nullable IToolbar child) {
      this.child = child;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getSrc() src} attribute.
     * @param src The value for src (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setSrc(@Nullable String src) {
      this.src = src;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getZoom() zoom} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getZoom() zoom}.</em>
     * @param zoom The value for zoom 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setZoom(double zoom) {
      this.zoom = zoom;
      optBits |= OPT_BIT_ZOOM;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getZoomMode() zoomMode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getZoomMode() zoomMode}.</em>
     * @param zoomMode The value for zoomMode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setZoomMode(IPdfviewer.ZoomMode zoomMode) {
      this.zoomMode = Objects.requireNonNull(zoomMode, "zoomMode");
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getAuxInfo() auxInfo} map.
     * @param key The key in the auxInfo map
     * @param value The associated value in the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putAuxInfo(String key, Object value) {
      this.auxInfo.put(key, value);
      optBits |= OPT_BIT_AUX_INFO;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Put one entry to the {@link IPdfviewer#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putAuxInfo(Map.Entry<String, ? extends Object> entry) {
      this.auxInfo.put(entry);
      optBits |= OPT_BIT_AUX_INFO;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IPdfviewer#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo = ImmutableMap.builder();
      optBits |= OPT_BIT_AUX_INFO;
      return putAllAuxInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IPdfviewer#getAuxInfo() auxInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the auxInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder putAllAuxInfo(Map<String, ? extends Object> entries) {
      this.auxInfo.putAll(entries);
      optBits |= OPT_BIT_AUX_INFO;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Initializes the value for the {@link IPdfviewer#getRotation() rotation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IPdfviewer#getRotation() rotation}.</em>
     * @param rotation The value for rotation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IPdfviewer.Builder setRotation(int rotation) {
      this.rotation = rotation;
      optBits |= OPT_BIT_ROTATION;
      return (IPdfviewer.Builder) this;
    }

    /**
     * Builds a new {@link IPdfviewer IPdfviewer}.
     * @return An immutable instance of IPdfviewer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IPdfviewer build() {
      return ImmutableIPdfviewer.validate(new ImmutableIPdfviewer(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean zoomIsSet() {
      return (optBits & OPT_BIT_ZOOM) != 0;
    }

    private boolean auxInfoIsSet() {
      return (optBits & OPT_BIT_AUX_INFO) != 0;
    }

    private boolean rotationIsSet() {
      return (optBits & OPT_BIT_ROTATION) != 0;
    }
  }
}
