package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Orgitem;

/**
 * Immutable implementation of {@link IOrgitem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IOrgitem.Builder()}.
 */
@Generated(from = "IOrgitem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIOrgitem implements IOrgitem {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final String widgetClass;
  private final @Nullable String label;
  private final @Nullable String image;
  private final boolean selectable;
  private final boolean disabled;
  private final boolean rendered;
  private final boolean loaded;
  private final boolean open;
  private final boolean selected;
  private final @Nullable IOrgchildren orgchildren;
  private final @Nullable IOrgnode<IAnyGroup> orgnode;

  private ImmutableIOrgitem(ImmutableIOrgitem.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.orgchildren = builder.orgchildren;
    this.orgnode = builder.orgnode;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.labelIsSet()) {
      initShim.setLabel(builder.label);
    }
    if (builder.imageIsSet()) {
      initShim.setImage(builder.image);
    }
    if (builder.selectableIsSet()) {
      initShim.setSelectable(builder.selectable);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.renderedIsSet()) {
      initShim.setRendered(builder.rendered);
    }
    if (builder.loadedIsSet()) {
      initShim.setLoaded(builder.loaded);
    }
    if (builder.openIsSet()) {
      initShim.setOpen(builder.open);
    }
    if (builder.selectedIsSet()) {
      initShim.setSelected(builder.selected);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.label = initShim.getLabel();
    this.image = initShim.getImage();
    this.selectable = initShim.isSelectable();
    this.disabled = initShim.isDisabled();
    this.rendered = initShim.isRendered();
    this.loaded = initShim.isLoaded();
    this.open = initShim.isOpen();
    this.selected = initShim.isSelected();
    this.initShim = null;
  }

  private ImmutableIOrgitem(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      String widgetClass,
      @Nullable String label,
      @Nullable String image,
      boolean selectable,
      boolean disabled,
      boolean rendered,
      boolean loaded,
      boolean open,
      boolean selected,
      @Nullable IOrgchildren orgchildren,
      @Nullable IOrgnode<IAnyGroup> orgnode) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.widgetClass = widgetClass;
    this.label = label;
    this.image = image;
    this.selectable = selectable;
    this.disabled = disabled;
    this.rendered = rendered;
    this.loaded = loaded;
    this.open = open;
    this.selected = selected;
    this.orgchildren = orgchildren;
    this.orgnode = orgnode;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IOrgitem", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte labelBuildStage = STAGE_UNINITIALIZED;
    private String label;

    String getLabel() {
      if (labelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelBuildStage == STAGE_UNINITIALIZED) {
        labelBuildStage = STAGE_INITIALIZING;
        this.label = getLabelInitialize();
        labelBuildStage = STAGE_INITIALIZED;
      }
      return this.label;
    }

    void setLabel(String label) {
      this.label = label;
      labelBuildStage = STAGE_INITIALIZED;
    }

    private byte imageBuildStage = STAGE_UNINITIALIZED;
    private String image;

    String getImage() {
      if (imageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (imageBuildStage == STAGE_UNINITIALIZED) {
        imageBuildStage = STAGE_INITIALIZING;
        this.image = getImageInitialize();
        imageBuildStage = STAGE_INITIALIZED;
      }
      return this.image;
    }

    void setImage(String image) {
      this.image = image;
      imageBuildStage = STAGE_INITIALIZED;
    }

    private byte selectableBuildStage = STAGE_UNINITIALIZED;
    private boolean selectable;

    boolean isSelectable() {
      if (selectableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selectableBuildStage == STAGE_UNINITIALIZED) {
        selectableBuildStage = STAGE_INITIALIZING;
        this.selectable = isSelectableInitialize();
        selectableBuildStage = STAGE_INITIALIZED;
      }
      return this.selectable;
    }

    void setSelectable(boolean selectable) {
      this.selectable = selectable;
      selectableBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte renderedBuildStage = STAGE_UNINITIALIZED;
    private boolean rendered;

    boolean isRendered() {
      if (renderedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderedBuildStage == STAGE_UNINITIALIZED) {
        renderedBuildStage = STAGE_INITIALIZING;
        this.rendered = isRenderedInitialize();
        renderedBuildStage = STAGE_INITIALIZED;
      }
      return this.rendered;
    }

    void setRendered(boolean rendered) {
      this.rendered = rendered;
      renderedBuildStage = STAGE_INITIALIZED;
    }

    private byte loadedBuildStage = STAGE_UNINITIALIZED;
    private boolean loaded;

    boolean isLoaded() {
      if (loadedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (loadedBuildStage == STAGE_UNINITIALIZED) {
        loadedBuildStage = STAGE_INITIALIZING;
        this.loaded = isLoadedInitialize();
        loadedBuildStage = STAGE_INITIALIZED;
      }
      return this.loaded;
    }

    void setLoaded(boolean loaded) {
      this.loaded = loaded;
      loadedBuildStage = STAGE_INITIALIZED;
    }

    private byte openBuildStage = STAGE_UNINITIALIZED;
    private boolean open;

    boolean isOpen() {
      if (openBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (openBuildStage == STAGE_UNINITIALIZED) {
        openBuildStage = STAGE_INITIALIZING;
        this.open = isOpenInitialize();
        openBuildStage = STAGE_INITIALIZED;
      }
      return this.open;
    }

    void setOpen(boolean open) {
      this.open = open;
      openBuildStage = STAGE_INITIALIZED;
    }

    private byte selectedBuildStage = STAGE_UNINITIALIZED;
    private boolean selected;

    boolean isSelected() {
      if (selectedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selectedBuildStage == STAGE_UNINITIALIZED) {
        selectedBuildStage = STAGE_INITIALIZING;
        this.selected = isSelectedInitialize();
        selectedBuildStage = STAGE_INITIALIZED;
      }
      return this.selected;
    }

    void setSelected(boolean selected) {
      this.selected = selected;
      selectedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (labelBuildStage == STAGE_INITIALIZING) attributes.add("label");
      if (imageBuildStage == STAGE_INITIALIZING) attributes.add("image");
      if (selectableBuildStage == STAGE_INITIALIZING) attributes.add("selectable");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (renderedBuildStage == STAGE_INITIALIZING) attributes.add("rendered");
      if (loadedBuildStage == STAGE_INITIALIZING) attributes.add("loaded");
      if (openBuildStage == STAGE_INITIALIZING) attributes.add("open");
      if (selectedBuildStage == STAGE_INITIALIZING) attributes.add("selected");
      return "Cannot build IOrgitem, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IOrgitem.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IOrgitem.super.isVisible();
  }

  private String getMoldInitialize() {
    return IOrgitem.super.getMold();
  }

  private int getZIndexInitialize() {
    return IOrgitem.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IOrgitem.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IOrgitem.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IOrgitem.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IOrgitem.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IOrgitem.super.getWidgetClass();
  }

  private @Nullable String getLabelInitialize() {
    return IOrgitem.super.getLabel();
  }

  private @Nullable String getImageInitialize() {
    return IOrgitem.super.getImage();
  }

  private boolean isSelectableInitialize() {
    return IOrgitem.super.isSelectable();
  }

  private boolean isDisabledInitialize() {
    return IOrgitem.super.isDisabled();
  }

  private boolean isRenderedInitialize() {
    return IOrgitem.super.isRendered();
  }

  private boolean isLoadedInitialize() {
    return IOrgitem.super.isLoaded();
  }

  private boolean isOpenInitialize() {
    return IOrgitem.super.isOpen();
  }

  private boolean isSelectedInitialize() {
    return IOrgitem.super.isSelected();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public @Nullable String getLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabel()
        : this.label;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @Override
  public @Nullable String getImage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getImage()
        : this.image;
  }

  /**
   * @return The value of the {@code selectable} attribute
   */
  @Override
  public boolean isSelectable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSelectable()
        : this.selectable;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code rendered} attribute
   */
  @Override
  public boolean isRendered() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isRendered()
        : this.rendered;
  }

  /**
   * @return The value of the {@code loaded} attribute
   */
  @Override
  public boolean isLoaded() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isLoaded()
        : this.loaded;
  }

  /**
   * @return The value of the {@code open} attribute
   */
  @Override
  public boolean isOpen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOpen()
        : this.open;
  }

  /**
   * @return The value of the {@code selected} attribute
   */
  @Override
  public boolean isSelected() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSelected()
        : this.selected;
  }

  /**
   * @return The value of the {@code orgchildren} attribute
   */
  @Override
  public @Nullable IOrgchildren getOrgchildren() {
    return orgchildren;
  }

  /**
   * @return The value of the {@code orgnode} attribute
   */
  @Override
  public @Nullable IOrgnode<IAnyGroup> getOrgnode() {
    return orgnode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIOrgitem(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IOrgitem#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIOrgitem withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIOrgitem(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.widgetClass,
          this.label,
          this.image,
          this.selectable,
          this.disabled,
          this.rendered,
          this.loaded,
          this.open,
          this.selected,
          this.orgchildren,
          this.orgnode));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IOrgitem#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIOrgitem withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by replacing the {@link IOrgitem#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIOrgitem withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by replacing the {@link IOrgitem#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIOrgitem withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by replacing the {@link IOrgitem#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIOrgitem withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withLabel(@Nullable String value) {
    if (Objects.equals(this.label, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        value,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getImage() image} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for image (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withImage(@Nullable String value) {
    if (Objects.equals(this.image, value)) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        value,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isSelectable() selectable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selectable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withSelectable(boolean value) {
    if (this.selectable == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        value,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        value,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isRendered() rendered} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rendered
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withRendered(boolean value) {
    if (this.rendered == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        value,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isLoaded() loaded} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for loaded
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withLoaded(boolean value) {
    if (this.loaded == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        value,
        this.open,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isOpen() open} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for open
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withOpen(boolean value) {
    if (this.open == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        value,
        this.selected,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#isSelected() selected} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selected
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withSelected(boolean value) {
    if (this.selected == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        value,
        this.orgchildren,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getOrgchildren() orgchildren} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for orgchildren (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withOrgchildren(@Nullable IOrgchildren value) {
    if (this.orgchildren == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        value,
        this.orgnode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IOrgitem#getOrgnode() orgnode} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for orgnode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIOrgitem withOrgnode(@Nullable IOrgnode<IAnyGroup> value) {
    if (this.orgnode == value) return this;
    return validate(new ImmutableIOrgitem(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.widgetClass,
        this.label,
        this.image,
        this.selectable,
        this.disabled,
        this.rendered,
        this.loaded,
        this.open,
        this.selected,
        this.orgchildren,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIOrgitem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIOrgitem
        && equalTo((ImmutableIOrgitem) another);
  }

  private boolean equalTo(ImmutableIOrgitem another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(label, another.label)
        && Objects.equals(image, another.image)
        && selectable == another.selectable
        && disabled == another.disabled
        && rendered == another.rendered
        && loaded == another.loaded
        && open == another.open
        && selected == another.selected
        && Objects.equals(orgchildren, another.orgchildren)
        && Objects.equals(orgnode, another.orgnode);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code widgetClass}, {@code label}, {@code image}, {@code selectable}, {@code disabled}, {@code rendered}, {@code loaded}, {@code open}, {@code selected}, {@code orgchildren}, {@code orgnode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(image);
    h += (h << 5) + Booleans.hashCode(selectable);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Booleans.hashCode(rendered);
    h += (h << 5) + Booleans.hashCode(loaded);
    h += (h << 5) + Booleans.hashCode(open);
    h += (h << 5) + Booleans.hashCode(selected);
    h += (h << 5) + Objects.hashCode(orgchildren);
    h += (h << 5) + Objects.hashCode(orgnode);
    return h;
  }

  /**
   * Prints the immutable value {@code IOrgitem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IOrgitem")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("widgetClass", widgetClass)
        .add("label", label)
        .add("image", image)
        .add("selectable", selectable)
        .add("disabled", disabled)
        .add("rendered", rendered)
        .add("loaded", loaded)
        .add("open", open)
        .add("selected", selected)
        .add("orgchildren", orgchildren)
        .add("orgnode", orgnode)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Orgitem> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IOrgitem#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Orgitem> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IOrgitem.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long CONTAINER_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient boolean container;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IOrgitem#isContainer() container} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code container} attribute
   */
  @Override
  public boolean isContainer() {
    if ((lazyInitBitmap & CONTAINER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CONTAINER_LAZY_INIT_BIT) == 0) {
          this.container = IOrgitem.super.isContainer();
          lazyInitBitmap |= CONTAINER_LAZY_INIT_BIT;
        }
      }
    }
    return container;
  }

  private static final long EMPTY_LAZY_INIT_BIT = 0x4L;

  @SuppressWarnings("Immutable")
  private transient boolean empty;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IOrgitem#isEmpty() empty} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code empty} attribute
   */
  @Override
  public boolean isEmpty() {
    if ((lazyInitBitmap & EMPTY_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & EMPTY_LAZY_INIT_BIT) == 0) {
          this.empty = IOrgitem.super.isEmpty();
          lazyInitBitmap |= EMPTY_LAZY_INIT_BIT;
        }
      }
    }
    return empty;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x8L;

  @SuppressWarnings("Immutable")
  private transient List<IOrgitemComposite> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IOrgitem#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IOrgitemComposite> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(IOrgitem.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static ImmutableIOrgitem validate(ImmutableIOrgitem instance) {
    instance = (ImmutableIOrgitem) instance.checkLabel();
    instance = (ImmutableIOrgitem) instance.checkImage();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIOrgitem) instance.checkDroppable();
    instance = (ImmutableIOrgitem) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IOrgitem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IOrgitem instance
   */
  public static IOrgitem copyOf(IOrgitem instance) {
    if (instance instanceof ImmutableIOrgitem) {
      return (ImmutableIOrgitem) instance;
    }
    return new IOrgitem.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IOrgitem IOrgitem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IOrgitem", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_LABEL = 0x10L;
    private static final long OPT_BIT_IMAGE = 0x20L;
    private static final long OPT_BIT_SELECTABLE = 0x40L;
    private static final long OPT_BIT_DISABLED = 0x80L;
    private static final long OPT_BIT_RENDERED = 0x100L;
    private static final long OPT_BIT_LOADED = 0x200L;
    private static final long OPT_BIT_OPEN = 0x400L;
    private static final long OPT_BIT_SELECTED = 0x800L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private @Nullable String widgetClass;
    private @Nullable String label;
    private @Nullable String image;
    private boolean selectable;
    private boolean disabled;
    private boolean rendered;
    private boolean loaded;
    private boolean open;
    private boolean selected;
    private @Nullable IOrgchildren orgchildren;
    private @Nullable IOrgnode<IAnyGroup> orgnode;

    /**
     * Creates a builder for {@link IOrgitem IOrgitem} instances.
     * <pre>
     * new IOrgitem.Builder()
     *    .setId(String) // optional {@link IOrgitem#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IOrgitem#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IOrgitem#getActions() actions}
     *    .setVisible(boolean) // optional {@link IOrgitem#isVisible() visible}
     *    .setMold(String) // optional {@link IOrgitem#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IOrgitem#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IOrgitem#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IOrgitem#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IOrgitem#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IOrgitem#getLeft() left}
     *    .setTop(String | null) // nullable {@link IOrgitem#getTop() top}
     *    .setZIndex(int) // optional {@link IOrgitem#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IOrgitem#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IOrgitem#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IOrgitem#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IOrgitem#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IOrgitem#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IOrgitem#getStyle() style}
     *    .setDraggable(String) // optional {@link IOrgitem#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IOrgitem#isFocus() focus}
     *    .setDroppable(String) // optional {@link IOrgitem#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IOrgitem#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IOrgitem#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IOrgitem#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IOrgitem#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IOrgitem#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IOrgitem#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IOrgitem#getContext() context}
     *    .setPopup(String | null) // nullable {@link IOrgitem#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IOrgitem#getTooltip() tooltip}
     *    .setWidgetClass(String) // optional {@link IOrgitem#getWidgetClass() widgetClass}
     *    .setLabel(String | null) // nullable {@link IOrgitem#getLabel() label}
     *    .setImage(String | null) // nullable {@link IOrgitem#getImage() image}
     *    .setSelectable(boolean) // optional {@link IOrgitem#isSelectable() selectable}
     *    .setDisabled(boolean) // optional {@link IOrgitem#isDisabled() disabled}
     *    .setRendered(boolean) // optional {@link IOrgitem#isRendered() rendered}
     *    .setLoaded(boolean) // optional {@link IOrgitem#isLoaded() loaded}
     *    .setOpen(boolean) // optional {@link IOrgitem#isOpen() open}
     *    .setSelected(boolean) // optional {@link IOrgitem#isSelected() selected}
     *    .setOrgchildren(org.zkoss.stateless.sul.IOrgchildren | null) // nullable {@link IOrgitem#getOrgchildren() orgchildren}
     *    .setOrgnode(org.zkoss.stateless.sul.IOrgnode&amp;lt;org.zkoss.stateless.sul.IAnyGroup&amp;gt; | null) // nullable {@link IOrgitem#getOrgnode() orgnode}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IOrgitem.Builder)) {
        throw new UnsupportedOperationException("Use: new IOrgitem.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IOrgitem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder from(IOrgitem instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String labelValue = instance.getLabel();
      if (labelValue != null) {
        setLabel(labelValue);
      }
      @Nullable String imageValue = instance.getImage();
      if (imageValue != null) {
        setImage(imageValue);
      }
      setSelectable(instance.isSelectable());
      setDisabled(instance.isDisabled());
      setRendered(instance.isRendered());
      setLoaded(instance.isLoaded());
      setOpen(instance.isOpen());
      setSelected(instance.isSelected());
      @Nullable IOrgchildren orgchildrenValue = instance.getOrgchildren();
      if (orgchildrenValue != null) {
        setOrgchildren(orgchildrenValue);
      }
      @Nullable IOrgnode<IAnyGroup> orgnodeValue = instance.getOrgnode();
      if (orgnodeValue != null) {
        setOrgnode(orgnodeValue);
      }
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IOrgitem.Builder) this;
    }

    /**
     * Adds one element to {@link IOrgitem#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IOrgitem.Builder) this;
    }

    /**
     * Adds elements to {@link IOrgitem#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IOrgitem.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IOrgitem#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IOrgitem.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IOrgitem#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IOrgitem.Builder) this;
    }

    /**
     * Put one entry to the {@link IOrgitem#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IOrgitem.Builder) this;
    }

    /**
     * Put one entry to the {@link IOrgitem#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IOrgitem.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IOrgitem#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IOrgitem.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IOrgitem#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IOrgitem.Builder) this;
    }

    /**
     * Put one entry to the {@link IOrgitem#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IOrgitem.Builder) this;
    }

    /**
     * Put one entry to the {@link IOrgitem#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IOrgitem.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IOrgitem#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IOrgitem.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IOrgitem#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IOrgitem.Builder) this;
    }

    /**
     * Put one entry to the {@link IOrgitem#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IOrgitem.Builder) this;
    }

    /**
     * Put one entry to the {@link IOrgitem#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IOrgitem.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IOrgitem#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IOrgitem.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IOrgitem#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getLabel() label} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getLabel() label}.</em>
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setLabel(@Nullable String label) {
      this.label = label;
      optBits |= OPT_BIT_LABEL;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getImage() image} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#getImage() image}.</em>
     * @param image The value for image (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setImage(@Nullable String image) {
      this.image = image;
      optBits |= OPT_BIT_IMAGE;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isSelectable() selectable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isSelectable() selectable}.</em>
     * @param selectable The value for selectable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setSelectable(boolean selectable) {
      this.selectable = selectable;
      optBits |= OPT_BIT_SELECTABLE;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isRendered() rendered} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isRendered() rendered}.</em>
     * @param rendered The value for rendered 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setRendered(boolean rendered) {
      this.rendered = rendered;
      optBits |= OPT_BIT_RENDERED;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isLoaded() loaded} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isLoaded() loaded}.</em>
     * @param loaded The value for loaded 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setLoaded(boolean loaded) {
      this.loaded = loaded;
      optBits |= OPT_BIT_LOADED;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isOpen() open} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isOpen() open}.</em>
     * @param open The value for open 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setOpen(boolean open) {
      this.open = open;
      optBits |= OPT_BIT_OPEN;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#isSelected() selected} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IOrgitem#isSelected() selected}.</em>
     * @param selected The value for selected 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setSelected(boolean selected) {
      this.selected = selected;
      optBits |= OPT_BIT_SELECTED;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getOrgchildren() orgchildren} attribute.
     * @param orgchildren The value for orgchildren (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setOrgchildren(@Nullable IOrgchildren orgchildren) {
      this.orgchildren = orgchildren;
      return (IOrgitem.Builder) this;
    }

    /**
     * Initializes the value for the {@link IOrgitem#getOrgnode() orgnode} attribute.
     * @param orgnode The value for orgnode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IOrgitem.Builder setOrgnode(@Nullable IOrgnode<IAnyGroup> orgnode) {
      this.orgnode = orgnode;
      return (IOrgitem.Builder) this;
    }

    /**
     * Builds a new {@link IOrgitem IOrgitem}.
     * @return An immutable instance of IOrgitem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IOrgitem build() {
      return ImmutableIOrgitem.validate(new ImmutableIOrgitem(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean labelIsSet() {
      return (optBits & OPT_BIT_LABEL) != 0;
    }

    private boolean imageIsSet() {
      return (optBits & OPT_BIT_IMAGE) != 0;
    }

    private boolean selectableIsSet() {
      return (optBits & OPT_BIT_SELECTABLE) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean renderedIsSet() {
      return (optBits & OPT_BIT_RENDERED) != 0;
    }

    private boolean loadedIsSet() {
      return (optBits & OPT_BIT_LOADED) != 0;
    }

    private boolean openIsSet() {
      return (optBits & OPT_BIT_OPEN) != 0;
    }

    private boolean selectedIsSet() {
      return (optBits & OPT_BIT_SELECTED) != 0;
    }
  }
}
