package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Multislider;

/**
 * Immutable implementation of {@link IMultislider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IMultislider.Builder()}.
 */
@Generated(from = "IMultislider", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIMultislider implements IMultislider {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final boolean disabled;
  private final @Nullable ISliderbuttons child;
  private final @Nullable ImmutableMap<Integer, String> marks;
  private final int min;
  private final int max;
  private final int step;
  private final String orient;
  private final boolean tooltipVisible;
  private final int markScale;
  private final ImmutableList<ISliderbuttons> children;
  private final String widgetClass;

  private ImmutableIMultislider(ImmutableIMultislider.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.child = builder.child;
    this.marks = builder.marks == null ? null : builder.marks.build();
    this.children = builder.children.build();
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.minIsSet()) {
      initShim.setMin(builder.min);
    }
    if (builder.maxIsSet()) {
      initShim.setMax(builder.max);
    }
    if (builder.stepIsSet()) {
      initShim.setStep(builder.step);
    }
    if (builder.orient != null) {
      initShim.setOrient(builder.orient);
    }
    if (builder.tooltipVisibleIsSet()) {
      initShim.setTooltipVisible(builder.tooltipVisible);
    }
    if (builder.markScaleIsSet()) {
      initShim.setMarkScale(builder.markScale);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.disabled = initShim.isDisabled();
    this.min = initShim.getMin();
    this.max = initShim.getMax();
    this.step = initShim.getStep();
    this.orient = initShim.getOrient();
    this.tooltipVisible = initShim.isTooltipVisible();
    this.markScale = initShim.getMarkScale();
    this.widgetClass = initShim.getWidgetClass();
    this.initShim = null;
  }

  private ImmutableIMultislider(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      boolean disabled,
      @Nullable ISliderbuttons child,
      @Nullable ImmutableMap<Integer, String> marks,
      int min,
      int max,
      int step,
      String orient,
      boolean tooltipVisible,
      int markScale,
      ImmutableList<ISliderbuttons> children,
      String widgetClass) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.disabled = disabled;
    this.child = child;
    this.marks = marks;
    this.min = min;
    this.max = max;
    this.step = step;
    this.orient = orient;
    this.tooltipVisible = tooltipVisible;
    this.markScale = markScale;
    this.children = children;
    this.widgetClass = widgetClass;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IMultislider", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte minBuildStage = STAGE_UNINITIALIZED;
    private int min;

    int getMin() {
      if (minBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minBuildStage == STAGE_UNINITIALIZED) {
        minBuildStage = STAGE_INITIALIZING;
        this.min = getMinInitialize();
        minBuildStage = STAGE_INITIALIZED;
      }
      return this.min;
    }

    void setMin(int min) {
      this.min = min;
      minBuildStage = STAGE_INITIALIZED;
    }

    private byte maxBuildStage = STAGE_UNINITIALIZED;
    private int max;

    int getMax() {
      if (maxBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxBuildStage == STAGE_UNINITIALIZED) {
        maxBuildStage = STAGE_INITIALIZING;
        this.max = getMaxInitialize();
        maxBuildStage = STAGE_INITIALIZED;
      }
      return this.max;
    }

    void setMax(int max) {
      this.max = max;
      maxBuildStage = STAGE_INITIALIZED;
    }

    private byte stepBuildStage = STAGE_UNINITIALIZED;
    private int step;

    int getStep() {
      if (stepBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stepBuildStage == STAGE_UNINITIALIZED) {
        stepBuildStage = STAGE_INITIALIZING;
        this.step = getStepInitialize();
        stepBuildStage = STAGE_INITIALIZED;
      }
      return this.step;
    }

    void setStep(int step) {
      this.step = step;
      stepBuildStage = STAGE_INITIALIZED;
    }

    private byte orientBuildStage = STAGE_UNINITIALIZED;
    private String orient;

    String getOrient() {
      if (orientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (orientBuildStage == STAGE_UNINITIALIZED) {
        orientBuildStage = STAGE_INITIALIZING;
        this.orient = Objects.requireNonNull(getOrientInitialize(), "orient");
        orientBuildStage = STAGE_INITIALIZED;
      }
      return this.orient;
    }

    void setOrient(String orient) {
      this.orient = orient;
      orientBuildStage = STAGE_INITIALIZED;
    }

    private byte tooltipVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean tooltipVisible;

    boolean isTooltipVisible() {
      if (tooltipVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tooltipVisibleBuildStage == STAGE_UNINITIALIZED) {
        tooltipVisibleBuildStage = STAGE_INITIALIZING;
        this.tooltipVisible = isTooltipVisibleInitialize();
        tooltipVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.tooltipVisible;
    }

    void setTooltipVisible(boolean tooltipVisible) {
      this.tooltipVisible = tooltipVisible;
      tooltipVisibleBuildStage = STAGE_INITIALIZED;
    }

    private byte markScaleBuildStage = STAGE_UNINITIALIZED;
    private int markScale;

    int getMarkScale() {
      if (markScaleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (markScaleBuildStage == STAGE_UNINITIALIZED) {
        markScaleBuildStage = STAGE_INITIALIZING;
        this.markScale = getMarkScaleInitialize();
        markScaleBuildStage = STAGE_INITIALIZED;
      }
      return this.markScale;
    }

    void setMarkScale(int markScale) {
      this.markScale = markScale;
      markScaleBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (minBuildStage == STAGE_INITIALIZING) attributes.add("min");
      if (maxBuildStage == STAGE_INITIALIZING) attributes.add("max");
      if (stepBuildStage == STAGE_INITIALIZING) attributes.add("step");
      if (orientBuildStage == STAGE_INITIALIZING) attributes.add("orient");
      if (tooltipVisibleBuildStage == STAGE_INITIALIZING) attributes.add("tooltipVisible");
      if (markScaleBuildStage == STAGE_INITIALIZING) attributes.add("markScale");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      return "Cannot build IMultislider, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IMultislider.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IMultislider.super.isVisible();
  }

  private String getMoldInitialize() {
    return IMultislider.super.getMold();
  }

  private int getZIndexInitialize() {
    return IMultislider.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IMultislider.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IMultislider.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IMultislider.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IMultislider.super.getRenderdefer();
  }

  private boolean isDisabledInitialize() {
    return IMultislider.super.isDisabled();
  }

  private int getMinInitialize() {
    return IMultislider.super.getMin();
  }

  private int getMaxInitialize() {
    return IMultislider.super.getMax();
  }

  private int getStepInitialize() {
    return IMultislider.super.getStep();
  }

  private String getOrientInitialize() {
    return IMultislider.super.getOrient();
  }

  private boolean isTooltipVisibleInitialize() {
    return IMultislider.super.isTooltipVisible();
  }

  private int getMarkScaleInitialize() {
    return IMultislider.super.getMarkScale();
  }

  private String getWidgetClassInitialize() {
    return IMultislider.super.getWidgetClass();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code child} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ISliderbuttons getChild() {
    return child;
  }

  /**
   * @return The value of the {@code marks} attribute
   */
  @Override
  public @Nullable ImmutableMap<Integer, String> getMarks() {
    return marks;
  }

  /**
   * @return The value of the {@code min} attribute
   */
  @Override
  public int getMin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMin()
        : this.min;
  }

  /**
   * @return The value of the {@code max} attribute
   */
  @Override
  public int getMax() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMax()
        : this.max;
  }

  /**
   * @return The value of the {@code step} attribute
   */
  @Override
  public int getStep() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStep()
        : this.step;
  }

  /**
   * @return The value of the {@code orient} attribute
   */
  @Override
  public String getOrient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrient()
        : this.orient;
  }

  /**
   * @return The value of the {@code tooltipVisible} attribute
   */
  @Override
  public boolean isTooltipVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isTooltipVisible()
        : this.tooltipVisible;
  }

  /**
   * @return The value of the {@code markScale} attribute
   */
  @Override
  public int getMarkScale() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMarkScale()
        : this.markScale;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<ISliderbuttons> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIMultislider(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IMultislider#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIMultislider(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.disabled,
          this.child,
          this.marks,
          this.min,
          this.max,
          this.step,
          this.orient,
          this.tooltipVisible,
          this.markScale,
          this.children,
          this.widgetClass));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IMultislider#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link IMultislider#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link IMultislider#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link IMultislider#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getChild() child} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for child (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withChild(@Nullable ISliderbuttons value) {
    if (this.child == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        value,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by replacing the {@link IMultislider#getMarks() marks} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the marks map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withMarks(@Nullable Map<Integer, ? extends String> entries) {
    if (this.marks == entries) return this;
    @Nullable ImmutableMap<Integer, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        newValue,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getMin() min} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for min
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withMin(int value) {
    if (this.min == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        value,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getMax() max} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for max
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withMax(int value) {
    if (this.max == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        value,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getStep() step} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for step
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withStep(int value) {
    if (this.step == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        value,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getOrient() orient} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for orient
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withOrient(String value) {
    String newValue = Objects.requireNonNull(value, "orient");
    if (this.orient.equals(newValue)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        newValue,
        this.tooltipVisible,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#isTooltipVisible() tooltipVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltipVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withTooltipVisible(boolean value) {
    if (this.tooltipVisible == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        value,
        this.markScale,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getMarkScale() markScale} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for markScale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withMarkScale(int value) {
    if (this.markScale == value) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        value,
        this.children,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IMultislider#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withChildren(ISliderbuttons... elements) {
    ImmutableList<ISliderbuttons> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        newValue,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IMultislider#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIMultislider withChildren(Iterable<? extends ISliderbuttons> elements) {
    if (this.children == elements) return this;
    ImmutableList<ISliderbuttons> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        newValue,
        this.widgetClass));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IMultislider#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIMultislider withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIMultislider(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.disabled,
        this.child,
        this.marks,
        this.min,
        this.max,
        this.step,
        this.orient,
        this.tooltipVisible,
        this.markScale,
        this.children,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIMultislider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIMultislider
        && equalTo((ImmutableIMultislider) another);
  }

  private boolean equalTo(ImmutableIMultislider another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && disabled == another.disabled
        && Objects.equals(child, another.child)
        && Objects.equals(marks, another.marks)
        && min == another.min
        && max == another.max
        && step == another.step
        && orient.equals(another.orient)
        && tooltipVisible == another.tooltipVisible
        && markScale == another.markScale
        && children.equals(another.children)
        && widgetClass.equals(another.widgetClass);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code disabled}, {@code child}, {@code marks}, {@code min}, {@code max}, {@code step}, {@code orient}, {@code tooltipVisible}, {@code markScale}, {@code children}, {@code widgetClass}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Objects.hashCode(child);
    h += (h << 5) + Objects.hashCode(marks);
    h += (h << 5) + min;
    h += (h << 5) + max;
    h += (h << 5) + step;
    h += (h << 5) + orient.hashCode();
    h += (h << 5) + Booleans.hashCode(tooltipVisible);
    h += (h << 5) + markScale;
    h += (h << 5) + children.hashCode();
    h += (h << 5) + widgetClass.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IMultislider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IMultislider")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("disabled", disabled)
        .add("child", child)
        .add("marks", marks)
        .add("min", min)
        .add("max", max)
        .add("step", step)
        .add("orient", orient)
        .add("tooltipVisible", tooltipVisible)
        .add("markScale", markScale)
        .add("children", children)
        .add("widgetClass", widgetClass)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Multislider> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IMultislider#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Multislider> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IMultislider.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIMultislider validate(ImmutableIMultislider instance) {
    instance = (ImmutableIMultislider) instance.checkMinAndMax();
    instance.checkValue();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIMultislider) instance.checkDroppable();
    instance = (ImmutableIMultislider) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IMultislider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IMultislider instance
   */
  public static IMultislider copyOf(IMultislider instance) {
    if (instance instanceof ImmutableIMultislider) {
      return (ImmutableIMultislider) instance;
    }
    return new IMultislider.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IMultislider IMultislider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IMultislider", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_DISABLED = 0x10L;
    private static final long OPT_BIT_MIN = 0x20L;
    private static final long OPT_BIT_MAX = 0x40L;
    private static final long OPT_BIT_STEP = 0x80L;
    private static final long OPT_BIT_TOOLTIP_VISIBLE = 0x100L;
    private static final long OPT_BIT_MARK_SCALE = 0x200L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private boolean disabled;
    private @Nullable ISliderbuttons child;
    private ImmutableMap.Builder<Integer, String> marks = null;
    private int min;
    private int max;
    private int step;
    private @Nullable String orient;
    private boolean tooltipVisible;
    private int markScale;
    private ImmutableList.Builder<ISliderbuttons> children = ImmutableList.builder();
    private @Nullable String widgetClass;

    /**
     * Creates a builder for {@link IMultislider IMultislider} instances.
     * <pre>
     * new IMultislider.Builder()
     *    .setId(String) // optional {@link IMultislider#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IMultislider#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IMultislider#getActions() actions}
     *    .setVisible(boolean) // optional {@link IMultislider#isVisible() visible}
     *    .setMold(String) // optional {@link IMultislider#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IMultislider#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IMultislider#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IMultislider#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IMultislider#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IMultislider#getLeft() left}
     *    .setTop(String | null) // nullable {@link IMultislider#getTop() top}
     *    .setZIndex(int) // optional {@link IMultislider#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IMultislider#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IMultislider#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IMultislider#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IMultislider#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IMultislider#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IMultislider#getStyle() style}
     *    .setDraggable(String) // optional {@link IMultislider#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IMultislider#isFocus() focus}
     *    .setDroppable(String) // optional {@link IMultislider#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IMultislider#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IMultislider#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IMultislider#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IMultislider#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IMultislider#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IMultislider#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IMultislider#getContext() context}
     *    .setPopup(String | null) // nullable {@link IMultislider#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IMultislider#getTooltip() tooltip}
     *    .setDisabled(boolean) // optional {@link IMultislider#isDisabled() disabled}
     *    .setChild(org.zkoss.stateless.sul.ISliderbuttons | null) // nullable {@link IMultislider#getChild() child}
     *    .setMarks(Map&amp;lt;Integer, String&amp;gt; | null) // nullable {@link IMultislider#getMarks() marks}
     *    .setMin(int) // optional {@link IMultislider#getMin() min}
     *    .setMax(int) // optional {@link IMultislider#getMax() max}
     *    .setStep(int) // optional {@link IMultislider#getStep() step}
     *    .setOrient(String) // optional {@link IMultislider#getOrient() orient}
     *    .setTooltipVisible(boolean) // optional {@link IMultislider#isTooltipVisible() tooltipVisible}
     *    .setMarkScale(int) // optional {@link IMultislider#getMarkScale() markScale}
     *    .addChildren|addAllChildren(org.zkoss.stateless.sul.ISliderbuttons) // {@link IMultislider#getChildren() children} elements
     *    .setWidgetClass(String) // optional {@link IMultislider#getWidgetClass() widgetClass}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IMultislider.Builder)) {
        throw new UnsupportedOperationException("Use: new IMultislider.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IMultislider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder from(IMultislider instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setDisabled(instance.isDisabled());
      @Nullable ISliderbuttons childValue = instance.getChild();
      if (childValue != null) {
        setChild(childValue);
      }
      @Nullable Map<Integer, String> marksValue = instance.getMarks();
      if (marksValue != null) {
        putAllMarks(marksValue);
      }
      setMin(instance.getMin());
      setMax(instance.getMax());
      setStep(instance.getStep());
      setOrient(instance.getOrient());
      setTooltipVisible(instance.isTooltipVisible());
      setMarkScale(instance.getMarkScale());
      addAllChildren(instance.getChildren());
      setWidgetClass(instance.getWidgetClass());
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IMultislider.Builder) this;
    }

    /**
     * Adds one element to {@link IMultislider#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IMultislider.Builder) this;
    }

    /**
     * Adds elements to {@link IMultislider#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IMultislider.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IMultislider#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IMultislider.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IMultislider#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IMultislider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IMultislider#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IMultislider.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IMultislider#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IMultislider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IMultislider#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IMultislider.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IMultislider#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IMultislider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IMultislider#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IMultislider.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IMultislider#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getChild() child} attribute.
     * @param child The value for child (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setChild(@Nullable ISliderbuttons child) {
      this.child = child;
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getMarks() marks} map.
     * @param key The key in the marks map
     * @param value The associated value in the marks map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putMarks(int key, String value) {
      if (this.marks == null) {
        this.marks = ImmutableMap.builder();
      }
      this.marks.put(key, value);
      return (IMultislider.Builder) this;
    }

    /**
     * Put one entry to the {@link IMultislider#getMarks() marks} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putMarks(Map.Entry<Integer, ? extends String> entry) {
      if (this.marks == null) {
        this.marks = ImmutableMap.builder();
      }
      this.marks.put(entry);
      return (IMultislider.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IMultislider#getMarks() marks} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the marks map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setMarks(@Nullable Map<Integer, ? extends String> entries) {
      if (entries == null) {
        this.marks = null;
        return (IMultislider.Builder) this;
      }
      this.marks = ImmutableMap.builder();
      return putAllMarks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IMultislider#getMarks() marks} map. Nulls are not permitted
     * @param entries The entries that will be added to the marks map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder putAllMarks(Map<Integer, ? extends String> entries) {
      if (this.marks == null) {
        this.marks = ImmutableMap.builder();
      }
      this.marks.putAll(entries);
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getMin() min} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getMin() min}.</em>
     * @param min The value for min 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setMin(int min) {
      this.min = min;
      optBits |= OPT_BIT_MIN;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getMax() max} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getMax() max}.</em>
     * @param max The value for max 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setMax(int max) {
      this.max = max;
      optBits |= OPT_BIT_MAX;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getStep() step} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getStep() step}.</em>
     * @param step The value for step 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setStep(int step) {
      this.step = step;
      optBits |= OPT_BIT_STEP;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getOrient() orient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getOrient() orient}.</em>
     * @param orient The value for orient 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setOrient(String orient) {
      this.orient = Objects.requireNonNull(orient, "orient");
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#isTooltipVisible() tooltipVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#isTooltipVisible() tooltipVisible}.</em>
     * @param tooltipVisible The value for tooltipVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setTooltipVisible(boolean tooltipVisible) {
      this.tooltipVisible = tooltipVisible;
      optBits |= OPT_BIT_TOOLTIP_VISIBLE;
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getMarkScale() markScale} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getMarkScale() markScale}.</em>
     * @param markScale The value for markScale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setMarkScale(int markScale) {
      this.markScale = markScale;
      optBits |= OPT_BIT_MARK_SCALE;
      return (IMultislider.Builder) this;
    }

    /**
     * Adds one element to {@link IMultislider#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder addChildren(ISliderbuttons element) {
      this.children.add(element);
      return (IMultislider.Builder) this;
    }

    /**
     * Adds elements to {@link IMultislider#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder addChildren(ISliderbuttons... elements) {
      this.children.add(elements);
      return (IMultislider.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IMultislider#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setChildren(Iterable<? extends ISliderbuttons> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link IMultislider#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder addAllChildren(Iterable<? extends ISliderbuttons> elements) {
      this.children.addAll(elements);
      return (IMultislider.Builder) this;
    }

    /**
     * Initializes the value for the {@link IMultislider#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IMultislider#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IMultislider.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IMultislider.Builder) this;
    }

    /**
     * Builds a new {@link IMultislider IMultislider}.
     * @return An immutable instance of IMultislider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IMultislider build() {
      return ImmutableIMultislider.validate(new ImmutableIMultislider(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean minIsSet() {
      return (optBits & OPT_BIT_MIN) != 0;
    }

    private boolean maxIsSet() {
      return (optBits & OPT_BIT_MAX) != 0;
    }

    private boolean stepIsSet() {
      return (optBits & OPT_BIT_STEP) != 0;
    }

    private boolean tooltipVisibleIsSet() {
      return (optBits & OPT_BIT_TOOLTIP_VISIBLE) != 0;
    }

    private boolean markScaleIsSet() {
      return (optBits & OPT_BIT_MARK_SCALE) != 0;
    }
  }
}
