package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.image.Image;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zkmax.zul.Lineitem;

/**
 * Immutable implementation of {@link ILineitem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ILineitem.Builder()}.
 */
@Generated(from = "ILineitem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableILineitem<I extends IAnyGroup>
    implements ILineitem<I> {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final ImmutableList<I> children;
  private final String widgetClass;
  private final @Nullable String pointStyle;
  private final @Nullable String pointIconSclass;
  private final @Nullable String frontSpace;
  private final @Nullable String backSpace;
  private final boolean pointVisible;
  private final boolean opposite;
  private final @Nullable String pointImageSrc;
  private final @Nullable Image pointImageContent;

  private ImmutableILineitem(ImmutableILineitem.Builder<I> builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.children = builder.children.build();
    this.pointStyle = builder.pointStyle;
    this.pointIconSclass = builder.pointIconSclass;
    this.frontSpace = builder.frontSpace;
    this.backSpace = builder.backSpace;
    this.pointImageSrc = builder.pointImageSrc;
    this.pointImageContent = builder.pointImageContent;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.pointVisibleIsSet()) {
      initShim.setPointVisible(builder.pointVisible);
    }
    if (builder.oppositeIsSet()) {
      initShim.setOpposite(builder.opposite);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.pointVisible = initShim.isPointVisible();
    this.opposite = initShim.isOpposite();
    this.initShim = null;
  }

  private ImmutableILineitem(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      ImmutableList<I> children,
      String widgetClass,
      @Nullable String pointStyle,
      @Nullable String pointIconSclass,
      @Nullable String frontSpace,
      @Nullable String backSpace,
      boolean pointVisible,
      boolean opposite,
      @Nullable String pointImageSrc,
      @Nullable Image pointImageContent) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.children = children;
    this.widgetClass = widgetClass;
    this.pointStyle = pointStyle;
    this.pointIconSclass = pointIconSclass;
    this.frontSpace = frontSpace;
    this.backSpace = backSpace;
    this.pointVisible = pointVisible;
    this.opposite = opposite;
    this.pointImageSrc = pointImageSrc;
    this.pointImageContent = pointImageContent;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ILineitem", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte pointVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean pointVisible;

    boolean isPointVisible() {
      if (pointVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pointVisibleBuildStage == STAGE_UNINITIALIZED) {
        pointVisibleBuildStage = STAGE_INITIALIZING;
        this.pointVisible = isPointVisibleInitialize();
        pointVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.pointVisible;
    }

    void setPointVisible(boolean pointVisible) {
      this.pointVisible = pointVisible;
      pointVisibleBuildStage = STAGE_INITIALIZED;
    }

    private byte oppositeBuildStage = STAGE_UNINITIALIZED;
    private boolean opposite;

    boolean isOpposite() {
      if (oppositeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (oppositeBuildStage == STAGE_UNINITIALIZED) {
        oppositeBuildStage = STAGE_INITIALIZING;
        this.opposite = isOppositeInitialize();
        oppositeBuildStage = STAGE_INITIALIZED;
      }
      return this.opposite;
    }

    void setOpposite(boolean opposite) {
      this.opposite = opposite;
      oppositeBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (pointVisibleBuildStage == STAGE_INITIALIZING) attributes.add("pointVisible");
      if (oppositeBuildStage == STAGE_INITIALIZING) attributes.add("opposite");
      return "Cannot build ILineitem, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return ILineitem.super.getId();
  }

  private boolean isVisibleInitialize() {
    return ILineitem.super.isVisible();
  }

  private String getMoldInitialize() {
    return ILineitem.super.getMold();
  }

  private int getZIndexInitialize() {
    return ILineitem.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return ILineitem.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return ILineitem.super.isFocus();
  }

  private String getDroppableInitialize() {
    return ILineitem.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return ILineitem.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return ILineitem.super.getWidgetClass();
  }

  private boolean isPointVisibleInitialize() {
    return ILineitem.super.isPointVisible();
  }

  private boolean isOppositeInitialize() {
    return ILineitem.super.isOpposite();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<I> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code pointStyle} attribute
   */
  @Override
  public @Nullable String getPointStyle() {
    return pointStyle;
  }

  /**
   * @return The value of the {@code pointIconSclass} attribute
   */
  @Override
  public @Nullable String getPointIconSclass() {
    return pointIconSclass;
  }

  /**
   * @return The value of the {@code frontSpace} attribute
   */
  @Override
  public @Nullable String getFrontSpace() {
    return frontSpace;
  }

  /**
   * @return The value of the {@code backSpace} attribute
   */
  @Override
  public @Nullable String getBackSpace() {
    return backSpace;
  }

  /**
   * @return The value of the {@code pointVisible} attribute
   */
  @Override
  public boolean isPointVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPointVisible()
        : this.pointVisible;
  }

  /**
   * @return The value of the {@code opposite} attribute
   */
  @Override
  public boolean isOpposite() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOpposite()
        : this.opposite;
  }

  /**
   * @return The value of the {@code pointImageSrc} attribute
   */
  @Override
  public @Nullable String getPointImageSrc() {
    return pointImageSrc;
  }

  /**
   * @return The value of the {@code pointImageContent} attribute
   */
  @Override
  public @Nullable Image getPointImageContent() {
    return pointImageContent;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableILineitem<>(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ILineitem#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableILineitem<I> withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableILineitem<>(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.children,
          this.widgetClass,
          this.pointStyle,
          this.pointIconSclass,
          this.frontSpace,
          this.backSpace,
          this.pointVisible,
          this.opposite,
          this.pointImageSrc,
          this.pointImageContent));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ILineitem#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableILineitem<I> withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by replacing the {@link ILineitem#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableILineitem<I> withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by replacing the {@link ILineitem#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableILineitem<I> withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by replacing the {@link ILineitem#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableILineitem<I> withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ILineitem#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableILineitem<I> withChildren(I... elements) {
    ImmutableList<I> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ILineitem#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableILineitem<I> withChildren(Iterable<? extends I> elements) {
    if (this.children == elements) return this;
    ImmutableList<I> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        newValue,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getPointStyle() pointStyle} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointStyle (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withPointStyle(@Nullable String value) {
    if (Objects.equals(this.pointStyle, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        value,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getPointIconSclass() pointIconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointIconSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withPointIconSclass(@Nullable String value) {
    if (Objects.equals(this.pointIconSclass, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        value,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getFrontSpace() frontSpace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for frontSpace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withFrontSpace(@Nullable String value) {
    if (Objects.equals(this.frontSpace, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        value,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getBackSpace() backSpace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for backSpace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withBackSpace(@Nullable String value) {
    if (Objects.equals(this.backSpace, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        value,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#isPointVisible() pointVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withPointVisible(boolean value) {
    if (this.pointVisible == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        value,
        this.opposite,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#isOpposite() opposite} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for opposite
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withOpposite(boolean value) {
    if (this.opposite == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        value,
        this.pointImageSrc,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getPointImageSrc() pointImageSrc} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointImageSrc (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withPointImageSrc(@Nullable String value) {
    if (Objects.equals(this.pointImageSrc, value)) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        value,
        this.pointImageContent));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ILineitem#getPointImageContent() pointImageContent} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointImageContent (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableILineitem<I> withPointImageContent(@Nullable Image value) {
    if (this.pointImageContent == value) return this;
    return validate(new ImmutableILineitem<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.pointStyle,
        this.pointIconSclass,
        this.frontSpace,
        this.backSpace,
        this.pointVisible,
        this.opposite,
        this.pointImageSrc,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableILineitem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableILineitem<?>
        && equalTo((ImmutableILineitem<?>) another);
  }

  private boolean equalTo(ImmutableILineitem<?> another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && children.equals(another.children)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(pointStyle, another.pointStyle)
        && Objects.equals(pointIconSclass, another.pointIconSclass)
        && Objects.equals(frontSpace, another.frontSpace)
        && Objects.equals(backSpace, another.backSpace)
        && pointVisible == another.pointVisible
        && opposite == another.opposite
        && Objects.equals(pointImageSrc, another.pointImageSrc)
        && Objects.equals(pointImageContent, another.pointImageContent);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code children}, {@code widgetClass}, {@code pointStyle}, {@code pointIconSclass}, {@code frontSpace}, {@code backSpace}, {@code pointVisible}, {@code opposite}, {@code pointImageSrc}, {@code pointImageContent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + children.hashCode();
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(pointStyle);
    h += (h << 5) + Objects.hashCode(pointIconSclass);
    h += (h << 5) + Objects.hashCode(frontSpace);
    h += (h << 5) + Objects.hashCode(backSpace);
    h += (h << 5) + Booleans.hashCode(pointVisible);
    h += (h << 5) + Booleans.hashCode(opposite);
    h += (h << 5) + Objects.hashCode(pointImageSrc);
    h += (h << 5) + Objects.hashCode(pointImageContent);
    return h;
  }

  /**
   * Prints the immutable value {@code ILineitem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ILineitem")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("children", children)
        .add("widgetClass", widgetClass)
        .add("pointStyle", pointStyle)
        .add("pointIconSclass", pointIconSclass)
        .add("frontSpace", frontSpace)
        .add("backSpace", backSpace)
        .add("pointVisible", pointVisible)
        .add("opposite", opposite)
        .add("pointImageSrc", pointImageSrc)
        .add("pointImageContent", pointImageContent)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Lineitem> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ILineitem#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Lineitem> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(ILineitem.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static <I extends IAnyGroup> ImmutableILineitem<I> validate(ImmutableILineitem<I> instance) {
    instance.checkChildren();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableILineitem<I>) instance.checkDroppable();
    instance = (ImmutableILineitem<I>) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ILineitem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <I> generic parameter I
   * @param instance The instance to copy
   * @return A copied immutable ILineitem instance
   */
  public static <I extends IAnyGroup> ILineitem<I> copyOf(ILineitem<I> instance) {
    if (instance instanceof ImmutableILineitem<?>) {
      return (ImmutableILineitem<I>) instance;
    }
    return new ILineitem.Builder<I>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ILineitem ILineitem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ILineitem", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<I extends IAnyGroup> {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_POINT_VISIBLE = 0x10L;
    private static final long OPT_BIT_OPPOSITE = 0x20L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private ImmutableList.Builder<I> children = ImmutableList.builder();
    private @Nullable String widgetClass;
    private @Nullable String pointStyle;
    private @Nullable String pointIconSclass;
    private @Nullable String frontSpace;
    private @Nullable String backSpace;
    private boolean pointVisible;
    private boolean opposite;
    private @Nullable String pointImageSrc;
    private @Nullable Image pointImageContent;

    /**
     * Creates a builder for {@link ILineitem ILineitem} instances.
     * <pre>
     * new ILineitem.Builder&amp;lt;I&amp;gt;()
     *    .setId(String) // optional {@link ILineitem#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link ILineitem#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link ILineitem#getActions() actions}
     *    .setVisible(boolean) // optional {@link ILineitem#isVisible() visible}
     *    .setMold(String) // optional {@link ILineitem#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link ILineitem#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ILineitem#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ILineitem#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ILineitem#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link ILineitem#getLeft() left}
     *    .setTop(String | null) // nullable {@link ILineitem#getTop() top}
     *    .setZIndex(int) // optional {@link ILineitem#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link ILineitem#getHeight() height}
     *    .setWidth(String | null) // nullable {@link ILineitem#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link ILineitem#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link ILineitem#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link ILineitem#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link ILineitem#getStyle() style}
     *    .setDraggable(String) // optional {@link ILineitem#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link ILineitem#isFocus() focus}
     *    .setDroppable(String) // optional {@link ILineitem#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link ILineitem#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link ILineitem#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link ILineitem#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link ILineitem#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link ILineitem#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link ILineitem#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link ILineitem#getContext() context}
     *    .setPopup(String | null) // nullable {@link ILineitem#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link ILineitem#getTooltip() tooltip}
     *    .addChildren|addAllChildren(I) // {@link ILineitem#getChildren() children} elements
     *    .setWidgetClass(String) // optional {@link ILineitem#getWidgetClass() widgetClass}
     *    .setPointStyle(String | null) // nullable {@link ILineitem#getPointStyle() pointStyle}
     *    .setPointIconSclass(String | null) // nullable {@link ILineitem#getPointIconSclass() pointIconSclass}
     *    .setFrontSpace(String | null) // nullable {@link ILineitem#getFrontSpace() frontSpace}
     *    .setBackSpace(String | null) // nullable {@link ILineitem#getBackSpace() backSpace}
     *    .setPointVisible(boolean) // optional {@link ILineitem#isPointVisible() pointVisible}
     *    .setOpposite(boolean) // optional {@link ILineitem#isOpposite() opposite}
     *    .setPointImageSrc(String | null) // nullable {@link ILineitem#getPointImageSrc() pointImageSrc}
     *    .setPointImageContent(org.zkoss.image.Image | null) // nullable {@link ILineitem#getPointImageContent() pointImageContent}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ILineitem.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new ILineitem.Builder<I>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ILineitem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> from(ILineitem<I> instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      addAllChildren(instance.getChildren());
      setWidgetClass(instance.getWidgetClass());
      @Nullable String pointStyleValue = instance.getPointStyle();
      if (pointStyleValue != null) {
        setPointStyle(pointStyleValue);
      }
      @Nullable String pointIconSclassValue = instance.getPointIconSclass();
      if (pointIconSclassValue != null) {
        setPointIconSclass(pointIconSclassValue);
      }
      @Nullable String frontSpaceValue = instance.getFrontSpace();
      if (frontSpaceValue != null) {
        setFrontSpace(frontSpaceValue);
      }
      @Nullable String backSpaceValue = instance.getBackSpace();
      if (backSpaceValue != null) {
        setBackSpace(backSpaceValue);
      }
      setPointVisible(instance.isPointVisible());
      setOpposite(instance.isOpposite());
      @Nullable String pointImageSrcValue = instance.getPointImageSrc();
      if (pointImageSrcValue != null) {
        setPointImageSrc(pointImageSrcValue);
      }
      @Nullable Image pointImageContentValue = instance.getPointImageContent();
      if (pointImageContentValue != null) {
        setPointImageContent(pointImageContentValue);
      }
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Adds one element to {@link ILineitem#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Adds elements to {@link ILineitem#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (ILineitem.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link ILineitem#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (ILineitem.Builder<I>) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link ILineitem#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link ILineitem#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link ILineitem#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ILineitem#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (ILineitem.Builder<I>) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ILineitem#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link ILineitem#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link ILineitem#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ILineitem#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (ILineitem.Builder<I>) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ILineitem#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link ILineitem#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link ILineitem#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ILineitem#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (ILineitem.Builder<I>) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ILineitem#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setLeft(@Nullable String left) {
      this.left = left;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setTop(@Nullable String top) {
      this.top = top;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setHeight(@Nullable String height) {
      this.height = height;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setWidth(@Nullable String width) {
      this.width = width;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setStyle(@Nullable String style) {
      this.style = style;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setContext(@Nullable String context) {
      this.context = context;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setPopup(@Nullable String popup) {
      this.popup = popup;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Adds one element to {@link ILineitem#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> addChildren(I element) {
      this.children.add(element);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Adds elements to {@link ILineitem#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final ILineitem.Builder<I> addChildren(I... elements) {
      this.children.add(elements);
      return (ILineitem.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link ILineitem#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setChildren(Iterable<? extends I> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link ILineitem#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> addAllChildren(Iterable<? extends I> elements) {
      this.children.addAll(elements);
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getPointStyle() pointStyle} attribute.
     * @param pointStyle The value for pointStyle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setPointStyle(@Nullable String pointStyle) {
      this.pointStyle = pointStyle;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getPointIconSclass() pointIconSclass} attribute.
     * @param pointIconSclass The value for pointIconSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setPointIconSclass(@Nullable String pointIconSclass) {
      this.pointIconSclass = pointIconSclass;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getFrontSpace() frontSpace} attribute.
     * @param frontSpace The value for frontSpace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setFrontSpace(@Nullable String frontSpace) {
      this.frontSpace = frontSpace;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getBackSpace() backSpace} attribute.
     * @param backSpace The value for backSpace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setBackSpace(@Nullable String backSpace) {
      this.backSpace = backSpace;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#isPointVisible() pointVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#isPointVisible() pointVisible}.</em>
     * @param pointVisible The value for pointVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setPointVisible(boolean pointVisible) {
      this.pointVisible = pointVisible;
      optBits |= OPT_BIT_POINT_VISIBLE;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#isOpposite() opposite} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ILineitem#isOpposite() opposite}.</em>
     * @param opposite The value for opposite 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setOpposite(boolean opposite) {
      this.opposite = opposite;
      optBits |= OPT_BIT_OPPOSITE;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getPointImageSrc() pointImageSrc} attribute.
     * @param pointImageSrc The value for pointImageSrc (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setPointImageSrc(@Nullable String pointImageSrc) {
      this.pointImageSrc = pointImageSrc;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link ILineitem#getPointImageContent() pointImageContent} attribute.
     * @param pointImageContent The value for pointImageContent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ILineitem.Builder<I> setPointImageContent(@Nullable Image pointImageContent) {
      this.pointImageContent = pointImageContent;
      return (ILineitem.Builder<I>) this;
    }

    /**
     * Builds a new {@link ILineitem ILineitem}.
     * @return An immutable instance of ILineitem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ILineitem<I> build() {
      return ImmutableILineitem.validate(new ImmutableILineitem<I>(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean pointVisibleIsSet() {
      return (optBits & OPT_BIT_POINT_VISIBLE) != 0;
    }

    private boolean oppositeIsSet() {
      return (optBits & OPT_BIT_OPPOSITE) != 0;
    }
  }
}
