package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.annotation.ParametersAreNonnullByDefault;
import jakarta.annotation.concurrent.Immutable;
import jakarta.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Bandbox;

/**
 * Immutable implementation of {@link IBandbox}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IBandbox.Builder()}.
 */
@Generated(from = "IBandbox", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIBandbox implements IBandbox {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final boolean readonly;
  private final @Nullable String name;
  private final @Nullable String placeholder;
  private final @Nullable ImmutableMap<String, String> inputAttributes;
  private final @Nullable String value;
  private final @Nullable String constraint;
  private final @Nullable String errorboxSclass;
  private final @Nullable String errorboxIconSclass;
  private final boolean disabled;
  private final boolean inplace;
  private final int maxlength;
  private final int cols;
  private final boolean instant;
  private final @Nullable String errorMessage;
  private final boolean multiline;
  private final int rows;
  private final boolean tabbable;
  private final String type;
  private final boolean submitByEnter;
  private final @Nullable IBandpopup child;
  private final String widgetClass;
  private final @Nullable String popupWidth;
  private final boolean autodrop;
  private final boolean buttonVisible;
  private final String iconSclass;
  private final boolean open;

  private ImmutableIBandbox(ImmutableIBandbox.Builder builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.name = builder.name;
    this.placeholder = builder.placeholder;
    this.inputAttributes = builder.inputAttributes == null ? null : builder.inputAttributes.build();
    this.value = builder.value;
    this.constraint = builder.constraint;
    this.errorboxSclass = builder.errorboxSclass;
    this.errorboxIconSclass = builder.errorboxIconSclass;
    this.errorMessage = builder.errorMessage;
    this.child = builder.child;
    this.popupWidth = builder.popupWidth;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.readonlyIsSet()) {
      initShim.setReadonly(builder.readonly);
    }
    if (builder.disabledIsSet()) {
      initShim.setDisabled(builder.disabled);
    }
    if (builder.inplaceIsSet()) {
      initShim.setInplace(builder.inplace);
    }
    if (builder.maxlengthIsSet()) {
      initShim.setMaxlength(builder.maxlength);
    }
    if (builder.colsIsSet()) {
      initShim.setCols(builder.cols);
    }
    if (builder.instantIsSet()) {
      initShim.setInstant(builder.instant);
    }
    if (builder.multilineIsSet()) {
      initShim.setMultiline(builder.multiline);
    }
    if (builder.rowsIsSet()) {
      initShim.setRows(builder.rows);
    }
    if (builder.tabbableIsSet()) {
      initShim.setTabbable(builder.tabbable);
    }
    if (builder.type != null) {
      initShim.setType(builder.type);
    }
    if (builder.submitByEnterIsSet()) {
      initShim.setSubmitByEnter(builder.submitByEnter);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.autodropIsSet()) {
      initShim.setAutodrop(builder.autodrop);
    }
    if (builder.buttonVisibleIsSet()) {
      initShim.setButtonVisible(builder.buttonVisible);
    }
    if (builder.iconSclass != null) {
      initShim.setIconSclass(builder.iconSclass);
    }
    if (builder.openIsSet()) {
      initShim.setOpen(builder.open);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.readonly = initShim.isReadonly();
    this.disabled = initShim.isDisabled();
    this.inplace = initShim.isInplace();
    this.maxlength = initShim.getMaxlength();
    this.cols = initShim.getCols();
    this.instant = initShim.getInstant();
    this.multiline = initShim.isMultiline();
    this.rows = initShim.getRows();
    this.tabbable = initShim.isTabbable();
    this.type = initShim.getType();
    this.submitByEnter = initShim.isSubmitByEnter();
    this.widgetClass = initShim.getWidgetClass();
    this.autodrop = initShim.isAutodrop();
    this.buttonVisible = initShim.isButtonVisible();
    this.iconSclass = initShim.getIconSclass();
    this.open = initShim.isOpen();
    this.initShim = null;
  }

  private ImmutableIBandbox(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      boolean readonly,
      @Nullable String name,
      @Nullable String placeholder,
      @Nullable ImmutableMap<String, String> inputAttributes,
      @Nullable String value,
      @Nullable String constraint,
      @Nullable String errorboxSclass,
      @Nullable String errorboxIconSclass,
      boolean disabled,
      boolean inplace,
      int maxlength,
      int cols,
      boolean instant,
      @Nullable String errorMessage,
      boolean multiline,
      int rows,
      boolean tabbable,
      String type,
      boolean submitByEnter,
      @Nullable IBandpopup child,
      String widgetClass,
      @Nullable String popupWidth,
      boolean autodrop,
      boolean buttonVisible,
      String iconSclass,
      boolean open) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.readonly = readonly;
    this.name = name;
    this.placeholder = placeholder;
    this.inputAttributes = inputAttributes;
    this.value = value;
    this.constraint = constraint;
    this.errorboxSclass = errorboxSclass;
    this.errorboxIconSclass = errorboxIconSclass;
    this.disabled = disabled;
    this.inplace = inplace;
    this.maxlength = maxlength;
    this.cols = cols;
    this.instant = instant;
    this.errorMessage = errorMessage;
    this.multiline = multiline;
    this.rows = rows;
    this.tabbable = tabbable;
    this.type = type;
    this.submitByEnter = submitByEnter;
    this.child = child;
    this.widgetClass = widgetClass;
    this.popupWidth = popupWidth;
    this.autodrop = autodrop;
    this.buttonVisible = buttonVisible;
    this.iconSclass = iconSclass;
    this.open = open;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IBandbox", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte readonlyBuildStage = STAGE_UNINITIALIZED;
    private boolean readonly;

    boolean isReadonly() {
      if (readonlyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (readonlyBuildStage == STAGE_UNINITIALIZED) {
        readonlyBuildStage = STAGE_INITIALIZING;
        this.readonly = isReadonlyInitialize();
        readonlyBuildStage = STAGE_INITIALIZED;
      }
      return this.readonly;
    }

    void setReadonly(boolean readonly) {
      this.readonly = readonly;
      readonlyBuildStage = STAGE_INITIALIZED;
    }

    private byte disabledBuildStage = STAGE_UNINITIALIZED;
    private boolean disabled;

    boolean isDisabled() {
      if (disabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disabledBuildStage == STAGE_UNINITIALIZED) {
        disabledBuildStage = STAGE_INITIALIZING;
        this.disabled = isDisabledInitialize();
        disabledBuildStage = STAGE_INITIALIZED;
      }
      return this.disabled;
    }

    void setDisabled(boolean disabled) {
      this.disabled = disabled;
      disabledBuildStage = STAGE_INITIALIZED;
    }

    private byte inplaceBuildStage = STAGE_UNINITIALIZED;
    private boolean inplace;

    boolean isInplace() {
      if (inplaceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (inplaceBuildStage == STAGE_UNINITIALIZED) {
        inplaceBuildStage = STAGE_INITIALIZING;
        this.inplace = isInplaceInitialize();
        inplaceBuildStage = STAGE_INITIALIZED;
      }
      return this.inplace;
    }

    void setInplace(boolean inplace) {
      this.inplace = inplace;
      inplaceBuildStage = STAGE_INITIALIZED;
    }

    private byte maxlengthBuildStage = STAGE_UNINITIALIZED;
    private int maxlength;

    int getMaxlength() {
      if (maxlengthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxlengthBuildStage == STAGE_UNINITIALIZED) {
        maxlengthBuildStage = STAGE_INITIALIZING;
        this.maxlength = getMaxlengthInitialize();
        maxlengthBuildStage = STAGE_INITIALIZED;
      }
      return this.maxlength;
    }

    void setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      maxlengthBuildStage = STAGE_INITIALIZED;
    }

    private byte colsBuildStage = STAGE_UNINITIALIZED;
    private int cols;

    int getCols() {
      if (colsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colsBuildStage == STAGE_UNINITIALIZED) {
        colsBuildStage = STAGE_INITIALIZING;
        this.cols = getColsInitialize();
        colsBuildStage = STAGE_INITIALIZED;
      }
      return this.cols;
    }

    void setCols(int cols) {
      this.cols = cols;
      colsBuildStage = STAGE_INITIALIZED;
    }

    private byte instantBuildStage = STAGE_UNINITIALIZED;
    private boolean instant;

    boolean getInstant() {
      if (instantBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (instantBuildStage == STAGE_UNINITIALIZED) {
        instantBuildStage = STAGE_INITIALIZING;
        this.instant = getInstantInitialize();
        instantBuildStage = STAGE_INITIALIZED;
      }
      return this.instant;
    }

    void setInstant(boolean instant) {
      this.instant = instant;
      instantBuildStage = STAGE_INITIALIZED;
    }

    private byte multilineBuildStage = STAGE_UNINITIALIZED;
    private boolean multiline;

    boolean isMultiline() {
      if (multilineBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (multilineBuildStage == STAGE_UNINITIALIZED) {
        multilineBuildStage = STAGE_INITIALIZING;
        this.multiline = isMultilineInitialize();
        multilineBuildStage = STAGE_INITIALIZED;
      }
      return this.multiline;
    }

    void setMultiline(boolean multiline) {
      this.multiline = multiline;
      multilineBuildStage = STAGE_INITIALIZED;
    }

    private byte rowsBuildStage = STAGE_UNINITIALIZED;
    private int rows;

    int getRows() {
      if (rowsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rowsBuildStage == STAGE_UNINITIALIZED) {
        rowsBuildStage = STAGE_INITIALIZING;
        this.rows = getRowsInitialize();
        rowsBuildStage = STAGE_INITIALIZED;
      }
      return this.rows;
    }

    void setRows(int rows) {
      this.rows = rows;
      rowsBuildStage = STAGE_INITIALIZED;
    }

    private byte tabbableBuildStage = STAGE_UNINITIALIZED;
    private boolean tabbable;

    boolean isTabbable() {
      if (tabbableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tabbableBuildStage == STAGE_UNINITIALIZED) {
        tabbableBuildStage = STAGE_INITIALIZING;
        this.tabbable = isTabbableInitialize();
        tabbableBuildStage = STAGE_INITIALIZED;
      }
      return this.tabbable;
    }

    void setTabbable(boolean tabbable) {
      this.tabbable = tabbable;
      tabbableBuildStage = STAGE_INITIALIZED;
    }

    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private String type;

    String getType() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(getTypeInitialize(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void setType(String type) {
      this.type = type;
      typeBuildStage = STAGE_INITIALIZED;
    }

    private byte submitByEnterBuildStage = STAGE_UNINITIALIZED;
    private boolean submitByEnter;

    boolean isSubmitByEnter() {
      if (submitByEnterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (submitByEnterBuildStage == STAGE_UNINITIALIZED) {
        submitByEnterBuildStage = STAGE_INITIALIZING;
        this.submitByEnter = isSubmitByEnterInitialize();
        submitByEnterBuildStage = STAGE_INITIALIZED;
      }
      return this.submitByEnter;
    }

    void setSubmitByEnter(boolean submitByEnter) {
      this.submitByEnter = submitByEnter;
      submitByEnterBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte autodropBuildStage = STAGE_UNINITIALIZED;
    private boolean autodrop;

    boolean isAutodrop() {
      if (autodropBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autodropBuildStage == STAGE_UNINITIALIZED) {
        autodropBuildStage = STAGE_INITIALIZING;
        this.autodrop = isAutodropInitialize();
        autodropBuildStage = STAGE_INITIALIZED;
      }
      return this.autodrop;
    }

    void setAutodrop(boolean autodrop) {
      this.autodrop = autodrop;
      autodropBuildStage = STAGE_INITIALIZED;
    }

    private byte buttonVisibleBuildStage = STAGE_UNINITIALIZED;
    private boolean buttonVisible;

    boolean isButtonVisible() {
      if (buttonVisibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buttonVisibleBuildStage == STAGE_UNINITIALIZED) {
        buttonVisibleBuildStage = STAGE_INITIALIZING;
        this.buttonVisible = isButtonVisibleInitialize();
        buttonVisibleBuildStage = STAGE_INITIALIZED;
      }
      return this.buttonVisible;
    }

    void setButtonVisible(boolean buttonVisible) {
      this.buttonVisible = buttonVisible;
      buttonVisibleBuildStage = STAGE_INITIALIZED;
    }

    private byte iconSclassBuildStage = STAGE_UNINITIALIZED;
    private String iconSclass;

    String getIconSclass() {
      if (iconSclassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (iconSclassBuildStage == STAGE_UNINITIALIZED) {
        iconSclassBuildStage = STAGE_INITIALIZING;
        this.iconSclass = Objects.requireNonNull(getIconSclassInitialize(), "iconSclass");
        iconSclassBuildStage = STAGE_INITIALIZED;
      }
      return this.iconSclass;
    }

    void setIconSclass(String iconSclass) {
      this.iconSclass = iconSclass;
      iconSclassBuildStage = STAGE_INITIALIZED;
    }

    private byte openBuildStage = STAGE_UNINITIALIZED;
    private boolean open;

    boolean isOpen() {
      if (openBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (openBuildStage == STAGE_UNINITIALIZED) {
        openBuildStage = STAGE_INITIALIZING;
        this.open = isOpenInitialize();
        openBuildStage = STAGE_INITIALIZED;
      }
      return this.open;
    }

    void setOpen(boolean open) {
      this.open = open;
      openBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (readonlyBuildStage == STAGE_INITIALIZING) attributes.add("readonly");
      if (disabledBuildStage == STAGE_INITIALIZING) attributes.add("disabled");
      if (inplaceBuildStage == STAGE_INITIALIZING) attributes.add("inplace");
      if (maxlengthBuildStage == STAGE_INITIALIZING) attributes.add("maxlength");
      if (colsBuildStage == STAGE_INITIALIZING) attributes.add("cols");
      if (instantBuildStage == STAGE_INITIALIZING) attributes.add("instant");
      if (multilineBuildStage == STAGE_INITIALIZING) attributes.add("multiline");
      if (rowsBuildStage == STAGE_INITIALIZING) attributes.add("rows");
      if (tabbableBuildStage == STAGE_INITIALIZING) attributes.add("tabbable");
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      if (submitByEnterBuildStage == STAGE_INITIALIZING) attributes.add("submitByEnter");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (autodropBuildStage == STAGE_INITIALIZING) attributes.add("autodrop");
      if (buttonVisibleBuildStage == STAGE_INITIALIZING) attributes.add("buttonVisible");
      if (iconSclassBuildStage == STAGE_INITIALIZING) attributes.add("iconSclass");
      if (openBuildStage == STAGE_INITIALIZING) attributes.add("open");
      return "Cannot build IBandbox, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IBandbox.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IBandbox.super.isVisible();
  }

  private String getMoldInitialize() {
    return IBandbox.super.getMold();
  }

  private int getZIndexInitialize() {
    return IBandbox.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IBandbox.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IBandbox.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IBandbox.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IBandbox.super.getRenderdefer();
  }

  private boolean isReadonlyInitialize() {
    return IBandbox.super.isReadonly();
  }

  private boolean isDisabledInitialize() {
    return IBandbox.super.isDisabled();
  }

  private boolean isInplaceInitialize() {
    return IBandbox.super.isInplace();
  }

  private int getMaxlengthInitialize() {
    return IBandbox.super.getMaxlength();
  }

  private int getColsInitialize() {
    return IBandbox.super.getCols();
  }

  private boolean getInstantInitialize() {
    return IBandbox.super.getInstant();
  }

  private boolean isMultilineInitialize() {
    return IBandbox.super.isMultiline();
  }

  private int getRowsInitialize() {
    return IBandbox.super.getRows();
  }

  private boolean isTabbableInitialize() {
    return IBandbox.super.isTabbable();
  }

  private String getTypeInitialize() {
    return IBandbox.super.getType();
  }

  private boolean isSubmitByEnterInitialize() {
    return IBandbox.super.isSubmitByEnter();
  }

  private String getWidgetClassInitialize() {
    return IBandbox.super.getWidgetClass();
  }

  private boolean isAutodropInitialize() {
    return IBandbox.super.isAutodrop();
  }

  private boolean isButtonVisibleInitialize() {
    return IBandbox.super.isButtonVisible();
  }

  private String getIconSclassInitialize() {
    return IBandbox.super.getIconSclass();
  }

  private boolean isOpenInitialize() {
    return IBandbox.super.isOpen();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code readonly} attribute
   */
  @Override
  public boolean isReadonly() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isReadonly()
        : this.readonly;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @Override
  public @Nullable String getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code inputAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getInputAttributes() {
    return inputAttributes;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code constraint} attribute
   */
  @Override
  public @Nullable String getConstraint() {
    return constraint;
  }

  /**
   * @return The value of the {@code errorboxSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxSclass() {
    return errorboxSclass;
  }

  /**
   * @return The value of the {@code errorboxIconSclass} attribute
   */
  @Override
  public @Nullable String getErrorboxIconSclass() {
    return errorboxIconSclass;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @Override
  public boolean isDisabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDisabled()
        : this.disabled;
  }

  /**
   * @return The value of the {@code inplace} attribute
   */
  @Override
  public boolean isInplace() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInplace()
        : this.inplace;
  }

  /**
   * @return The value of the {@code maxlength} attribute
   */
  @Override
  public int getMaxlength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxlength()
        : this.maxlength;
  }

  /**
   * @return The value of the {@code cols} attribute
   */
  @Override
  public int getCols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCols()
        : this.cols;
  }

  /**
   * @return The value of the {@code instant} attribute
   */
  @Override
  public boolean getInstant() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInstant()
        : this.instant;
  }

  /**
   * @return The value of the {@code errorMessage} attribute
   */
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * @return The value of the {@code multiline} attribute
   */
  @Override
  public boolean isMultiline() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMultiline()
        : this.multiline;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @Override
  public int getRows() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRows()
        : this.rows;
  }

  /**
   * @return The value of the {@code tabbable} attribute
   */
  @Override
  public boolean isTabbable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isTabbable()
        : this.tabbable;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * @return The value of the {@code submitByEnter} attribute
   */
  @Override
  public boolean isSubmitByEnter() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSubmitByEnter()
        : this.submitByEnter;
  }

  /**
   * @return The value of the {@code child} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable IBandpopup getChild() {
    return child;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code popupWidth} attribute
   */
  @Override
  public @Nullable String getPopupWidth() {
    return popupWidth;
  }

  /**
   * @return The value of the {@code autodrop} attribute
   */
  @Override
  public boolean isAutodrop() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAutodrop()
        : this.autodrop;
  }

  /**
   * @return The value of the {@code buttonVisible} attribute
   */
  @Override
  public boolean isButtonVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isButtonVisible()
        : this.buttonVisible;
  }

  /**
   * @return The value of the {@code iconSclass} attribute
   */
  @Override
  public String getIconSclass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIconSclass()
        : this.iconSclass;
  }

  /**
   * @return The value of the {@code open} attribute
   */
  @Override
  public boolean isOpen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOpen()
        : this.open;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IBandbox#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBandbox withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIBandbox(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.readonly,
          this.name,
          this.placeholder,
          this.inputAttributes,
          this.value,
          this.constraint,
          this.errorboxSclass,
          this.errorboxIconSclass,
          this.disabled,
          this.inplace,
          this.maxlength,
          this.cols,
          this.instant,
          this.errorMessage,
          this.multiline,
          this.rows,
          this.tabbable,
          this.type,
          this.submitByEnter,
          this.child,
          this.widgetClass,
          this.popupWidth,
          this.autodrop,
          this.buttonVisible,
          this.iconSclass,
          this.open));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IBandbox#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBandbox withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBandbox#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBandbox withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBandbox#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBandbox withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBandbox#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBandbox withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isReadonly() readonly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readonly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withReadonly(boolean value) {
    if (this.readonly == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        value,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        value,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getPlaceholder() placeholder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for placeholder (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withPlaceholder(@Nullable String value) {
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        value,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by replacing the {@link IBandbox#getInputAttributes() inputAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the inputAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIBandbox withInputAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.inputAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        newValue,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withValue(@Nullable String value) {
    if (Objects.equals(this.value, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getConstraint() constraint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constraint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withConstraint(@Nullable String value) {
    if (Objects.equals(this.constraint, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        value,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getErrorboxSclass() errorboxSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withErrorboxSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxSclass, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        value,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getErrorboxIconSclass() errorboxIconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorboxIconSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withErrorboxIconSclass(@Nullable String value) {
    if (Objects.equals(this.errorboxIconSclass, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        value,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isDisabled() disabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withDisabled(boolean value) {
    if (this.disabled == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        value,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isInplace() inplace} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inplace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withInplace(boolean value) {
    if (this.inplace == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        value,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getMaxlength() maxlength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxlength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withMaxlength(int value) {
    if (this.maxlength == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        value,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getCols() cols} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cols
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withCols(int value) {
    if (this.cols == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        value,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getInstant() instant} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withInstant(boolean value) {
    if (this.instant == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        value,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getErrorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withErrorMessage(@Nullable String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        value,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isMultiline() multiline} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiline
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withMultiline(boolean value) {
    if (this.multiline == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        value,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getRows() rows} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rows
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withRows(int value) {
    if (this.rows == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        value,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isTabbable() tabbable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabbable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withTabbable(boolean value) {
    if (this.tabbable == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        value,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        newValue,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isSubmitByEnter() submitByEnter} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for submitByEnter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withSubmitByEnter(boolean value) {
    if (this.submitByEnter == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        value,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getChild() child} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for child (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withChild(@Nullable IBandpopup value) {
    if (this.child == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        value,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        newValue,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getPopupWidth() popupWidth} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popupWidth (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withPopupWidth(@Nullable String value) {
    if (Objects.equals(this.popupWidth, value)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        value,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isAutodrop() autodrop} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autodrop
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withAutodrop(boolean value) {
    if (this.autodrop == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        value,
        this.buttonVisible,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isButtonVisible() buttonVisible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buttonVisible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withButtonVisible(boolean value) {
    if (this.buttonVisible == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        value,
        this.iconSclass,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#getIconSclass() iconSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for iconSclass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withIconSclass(String value) {
    String newValue = Objects.requireNonNull(value, "iconSclass");
    if (this.iconSclass.equals(newValue)) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        newValue,
        this.open));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IBandbox#isOpen() open} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for open
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIBandbox withOpen(boolean value) {
    if (this.open == value) return this;
    return validate(new ImmutableIBandbox(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.readonly,
        this.name,
        this.placeholder,
        this.inputAttributes,
        this.value,
        this.constraint,
        this.errorboxSclass,
        this.errorboxIconSclass,
        this.disabled,
        this.inplace,
        this.maxlength,
        this.cols,
        this.instant,
        this.errorMessage,
        this.multiline,
        this.rows,
        this.tabbable,
        this.type,
        this.submitByEnter,
        this.child,
        this.widgetClass,
        this.popupWidth,
        this.autodrop,
        this.buttonVisible,
        this.iconSclass,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIBandbox} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIBandbox
        && equalTo((ImmutableIBandbox) another);
  }

  private boolean equalTo(ImmutableIBandbox another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && readonly == another.readonly
        && Objects.equals(name, another.name)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(inputAttributes, another.inputAttributes)
        && Objects.equals(value, another.value)
        && Objects.equals(constraint, another.constraint)
        && Objects.equals(errorboxSclass, another.errorboxSclass)
        && Objects.equals(errorboxIconSclass, another.errorboxIconSclass)
        && disabled == another.disabled
        && inplace == another.inplace
        && maxlength == another.maxlength
        && cols == another.cols
        && instant == another.instant
        && Objects.equals(errorMessage, another.errorMessage)
        && multiline == another.multiline
        && rows == another.rows
        && tabbable == another.tabbable
        && type.equals(another.type)
        && submitByEnter == another.submitByEnter
        && Objects.equals(child, another.child)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(popupWidth, another.popupWidth)
        && autodrop == another.autodrop
        && buttonVisible == another.buttonVisible
        && iconSclass.equals(another.iconSclass)
        && open == another.open;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code readonly}, {@code name}, {@code placeholder}, {@code inputAttributes}, {@code value}, {@code constraint}, {@code errorboxSclass}, {@code errorboxIconSclass}, {@code disabled}, {@code inplace}, {@code maxlength}, {@code cols}, {@code instant}, {@code errorMessage}, {@code multiline}, {@code rows}, {@code tabbable}, {@code type}, {@code submitByEnter}, {@code child}, {@code widgetClass}, {@code popupWidth}, {@code autodrop}, {@code buttonVisible}, {@code iconSclass}, {@code open}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + Booleans.hashCode(readonly);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(placeholder);
    h += (h << 5) + Objects.hashCode(inputAttributes);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(constraint);
    h += (h << 5) + Objects.hashCode(errorboxSclass);
    h += (h << 5) + Objects.hashCode(errorboxIconSclass);
    h += (h << 5) + Booleans.hashCode(disabled);
    h += (h << 5) + Booleans.hashCode(inplace);
    h += (h << 5) + maxlength;
    h += (h << 5) + cols;
    h += (h << 5) + Booleans.hashCode(instant);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Booleans.hashCode(multiline);
    h += (h << 5) + rows;
    h += (h << 5) + Booleans.hashCode(tabbable);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Booleans.hashCode(submitByEnter);
    h += (h << 5) + Objects.hashCode(child);
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(popupWidth);
    h += (h << 5) + Booleans.hashCode(autodrop);
    h += (h << 5) + Booleans.hashCode(buttonVisible);
    h += (h << 5) + iconSclass.hashCode();
    h += (h << 5) + Booleans.hashCode(open);
    return h;
  }

  /**
   * Prints the immutable value {@code IBandbox} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IBandbox")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("readonly", readonly)
        .add("name", name)
        .add("placeholder", placeholder)
        .add("inputAttributes", inputAttributes)
        .add("value", value)
        .add("constraint", constraint)
        .add("errorboxSclass", errorboxSclass)
        .add("errorboxIconSclass", errorboxIconSclass)
        .add("disabled", disabled)
        .add("inplace", inplace)
        .add("maxlength", maxlength)
        .add("cols", cols)
        .add("instant", instant)
        .add("errorMessage", errorMessage)
        .add("multiline", multiline)
        .add("rows", rows)
        .add("tabbable", tabbable)
        .add("type", type)
        .add("submitByEnter", submitByEnter)
        .add("child", child)
        .add("widgetClass", widgetClass)
        .add("popupWidth", popupWidth)
        .add("autodrop", autodrop)
        .add("buttonVisible", buttonVisible)
        .add("iconSclass", iconSclass)
        .add("open", open)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Bandbox> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IBandbox#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Bandbox> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IBandbox.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static ImmutableIBandbox validate(ImmutableIBandbox instance) {
    instance.checkRows();
    instance.checkMultiline();
    instance.checkCols();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIBandbox) instance.checkDroppable();
    instance = (ImmutableIBandbox) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IBandbox} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IBandbox instance
   */
  public static IBandbox copyOf(IBandbox instance) {
    if (instance instanceof ImmutableIBandbox) {
      return (ImmutableIBandbox) instance;
    }
    return new IBandbox.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IBandbox IBandbox}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IBandbox", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_READONLY = 0x10L;
    private static final long OPT_BIT_DISABLED = 0x20L;
    private static final long OPT_BIT_INPLACE = 0x40L;
    private static final long OPT_BIT_MAXLENGTH = 0x80L;
    private static final long OPT_BIT_COLS = 0x100L;
    private static final long OPT_BIT_INSTANT = 0x200L;
    private static final long OPT_BIT_MULTILINE = 0x400L;
    private static final long OPT_BIT_ROWS = 0x800L;
    private static final long OPT_BIT_TABBABLE = 0x1000L;
    private static final long OPT_BIT_SUBMIT_BY_ENTER = 0x2000L;
    private static final long OPT_BIT_AUTODROP = 0x4000L;
    private static final long OPT_BIT_BUTTON_VISIBLE = 0x8000L;
    private static final long OPT_BIT_OPEN = 0x10000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private boolean readonly;
    private @Nullable String name;
    private @Nullable String placeholder;
    private ImmutableMap.Builder<String, String> inputAttributes = null;
    private @Nullable String value;
    private @Nullable String constraint;
    private @Nullable String errorboxSclass;
    private @Nullable String errorboxIconSclass;
    private boolean disabled;
    private boolean inplace;
    private int maxlength;
    private int cols;
    private boolean instant;
    private @Nullable String errorMessage;
    private boolean multiline;
    private int rows;
    private boolean tabbable;
    private @Nullable String type;
    private boolean submitByEnter;
    private @Nullable IBandpopup child;
    private @Nullable String widgetClass;
    private @Nullable String popupWidth;
    private boolean autodrop;
    private boolean buttonVisible;
    private @Nullable String iconSclass;
    private boolean open;

    /**
     * Creates a builder for {@link IBandbox IBandbox} instances.
     * <pre>
     * new IBandbox.Builder()
     *    .setId(String) // optional {@link IBandbox#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IBandbox#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IBandbox#getActions() actions}
     *    .setVisible(boolean) // optional {@link IBandbox#isVisible() visible}
     *    .setMold(String) // optional {@link IBandbox#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IBandbox#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBandbox#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBandbox#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBandbox#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IBandbox#getLeft() left}
     *    .setTop(String | null) // nullable {@link IBandbox#getTop() top}
     *    .setZIndex(int) // optional {@link IBandbox#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IBandbox#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IBandbox#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IBandbox#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IBandbox#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IBandbox#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IBandbox#getStyle() style}
     *    .setDraggable(String) // optional {@link IBandbox#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IBandbox#isFocus() focus}
     *    .setDroppable(String) // optional {@link IBandbox#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IBandbox#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IBandbox#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IBandbox#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IBandbox#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IBandbox#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IBandbox#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IBandbox#getContext() context}
     *    .setPopup(String | null) // nullable {@link IBandbox#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IBandbox#getTooltip() tooltip}
     *    .setReadonly(boolean) // optional {@link IBandbox#isReadonly() readonly}
     *    .setName(String | null) // nullable {@link IBandbox#getName() name}
     *    .setPlaceholder(String | null) // nullable {@link IBandbox#getPlaceholder() placeholder}
     *    .setInputAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IBandbox#getInputAttributes() inputAttributes}
     *    .setValue(String | null) // nullable {@link IBandbox#getValue() value}
     *    .setConstraint(String | null) // nullable {@link IBandbox#getConstraint() constraint}
     *    .setErrorboxSclass(String | null) // nullable {@link IBandbox#getErrorboxSclass() errorboxSclass}
     *    .setErrorboxIconSclass(String | null) // nullable {@link IBandbox#getErrorboxIconSclass() errorboxIconSclass}
     *    .setDisabled(boolean) // optional {@link IBandbox#isDisabled() disabled}
     *    .setInplace(boolean) // optional {@link IBandbox#isInplace() inplace}
     *    .setMaxlength(int) // optional {@link IBandbox#getMaxlength() maxlength}
     *    .setCols(int) // optional {@link IBandbox#getCols() cols}
     *    .setInstant(boolean) // optional {@link IBandbox#getInstant() instant}
     *    .setErrorMessage(String | null) // nullable {@link IBandbox#getErrorMessage() errorMessage}
     *    .setMultiline(boolean) // optional {@link IBandbox#isMultiline() multiline}
     *    .setRows(int) // optional {@link IBandbox#getRows() rows}
     *    .setTabbable(boolean) // optional {@link IBandbox#isTabbable() tabbable}
     *    .setType(String) // optional {@link IBandbox#getType() type}
     *    .setSubmitByEnter(boolean) // optional {@link IBandbox#isSubmitByEnter() submitByEnter}
     *    .setChild(org.zkoss.stateless.sul.IBandpopup | null) // nullable {@link IBandbox#getChild() child}
     *    .setWidgetClass(String) // optional {@link IBandbox#getWidgetClass() widgetClass}
     *    .setPopupWidth(String | null) // nullable {@link IBandbox#getPopupWidth() popupWidth}
     *    .setAutodrop(boolean) // optional {@link IBandbox#isAutodrop() autodrop}
     *    .setButtonVisible(boolean) // optional {@link IBandbox#isButtonVisible() buttonVisible}
     *    .setIconSclass(String) // optional {@link IBandbox#getIconSclass() iconSclass}
     *    .setOpen(boolean) // optional {@link IBandbox#isOpen() open}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IBandbox.Builder)) {
        throw new UnsupportedOperationException("Use: new IBandbox.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IBandbox} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder from(IBandbox instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      setReadonly(instance.isReadonly());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      @Nullable String placeholderValue = instance.getPlaceholder();
      if (placeholderValue != null) {
        setPlaceholder(placeholderValue);
      }
      @Nullable Map<String, String> inputAttributesValue = instance.getInputAttributes();
      if (inputAttributesValue != null) {
        putAllInputAttributes(inputAttributesValue);
      }
      @Nullable String valueValue = instance.getValue();
      if (valueValue != null) {
        setValue(valueValue);
      }
      @Nullable String constraintValue = instance.getConstraint();
      if (constraintValue != null) {
        setConstraint(constraintValue);
      }
      @Nullable String errorboxSclassValue = instance.getErrorboxSclass();
      if (errorboxSclassValue != null) {
        setErrorboxSclass(errorboxSclassValue);
      }
      @Nullable String errorboxIconSclassValue = instance.getErrorboxIconSclass();
      if (errorboxIconSclassValue != null) {
        setErrorboxIconSclass(errorboxIconSclassValue);
      }
      setDisabled(instance.isDisabled());
      setInplace(instance.isInplace());
      setMaxlength(instance.getMaxlength());
      setCols(instance.getCols());
      setInstant(instance.getInstant());
      @Nullable String errorMessageValue = instance.getErrorMessage();
      if (errorMessageValue != null) {
        setErrorMessage(errorMessageValue);
      }
      setMultiline(instance.isMultiline());
      setRows(instance.getRows());
      setTabbable(instance.isTabbable());
      setType(instance.getType());
      setSubmitByEnter(instance.isSubmitByEnter());
      @Nullable IBandpopup childValue = instance.getChild();
      if (childValue != null) {
        setChild(childValue);
      }
      setWidgetClass(instance.getWidgetClass());
      @Nullable String popupWidthValue = instance.getPopupWidth();
      if (popupWidthValue != null) {
        setPopupWidth(popupWidthValue);
      }
      setAutodrop(instance.isAutodrop());
      setButtonVisible(instance.isButtonVisible());
      setIconSclass(instance.getIconSclass());
      setOpen(instance.isOpen());
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IBandbox.Builder) this;
    }

    /**
     * Adds one element to {@link IBandbox#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IBandbox.Builder) this;
    }

    /**
     * Adds elements to {@link IBandbox#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IBandbox.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link IBandbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IBandbox.Builder) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IBandbox#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IBandbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBandbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IBandbox.Builder) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBandbox#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IBandbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBandbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IBandbox.Builder) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBandbox#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IBandbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBandbox#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IBandbox.Builder) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBandbox#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setLeft(@Nullable String left) {
      this.left = left;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setTop(@Nullable String top) {
      this.top = top;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setHeight(@Nullable String height) {
      this.height = height;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setWidth(@Nullable String width) {
      this.width = width;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setStyle(@Nullable String style) {
      this.style = style;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setContext(@Nullable String context) {
      this.context = context;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isReadonly() readonly} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isReadonly() readonly}.</em>
     * @param readonly The value for readonly 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setReadonly(boolean readonly) {
      this.readonly = readonly;
      optBits |= OPT_BIT_READONLY;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setName(@Nullable String name) {
      this.name = name;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getInputAttributes() inputAttributes} map.
     * @param key The key in the inputAttributes map
     * @param value The associated value in the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putInputAttributes(String key, String value) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(key, value);
      return (IBandbox.Builder) this;
    }

    /**
     * Put one entry to the {@link IBandbox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putInputAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.put(entry);
      return (IBandbox.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IBandbox#getInputAttributes() inputAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setInputAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.inputAttributes = null;
        return (IBandbox.Builder) this;
      }
      this.inputAttributes = ImmutableMap.builder();
      return putAllInputAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IBandbox#getInputAttributes() inputAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the inputAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder putAllInputAttributes(Map<String, ? extends String> entries) {
      if (this.inputAttributes == null) {
        this.inputAttributes = ImmutableMap.builder();
      }
      this.inputAttributes.putAll(entries);
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setValue(@Nullable String value) {
      this.value = value;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getConstraint() constraint} attribute.
     * @param constraint The value for constraint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setConstraint(@Nullable String constraint) {
      this.constraint = constraint;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getErrorboxSclass() errorboxSclass} attribute.
     * @param errorboxSclass The value for errorboxSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setErrorboxSclass(@Nullable String errorboxSclass) {
      this.errorboxSclass = errorboxSclass;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getErrorboxIconSclass() errorboxIconSclass} attribute.
     * @param errorboxIconSclass The value for errorboxIconSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setErrorboxIconSclass(@Nullable String errorboxIconSclass) {
      this.errorboxIconSclass = errorboxIconSclass;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isDisabled() disabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isDisabled() disabled}.</em>
     * @param disabled The value for disabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setDisabled(boolean disabled) {
      this.disabled = disabled;
      optBits |= OPT_BIT_DISABLED;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isInplace() inplace} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isInplace() inplace}.</em>
     * @param inplace The value for inplace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setInplace(boolean inplace) {
      this.inplace = inplace;
      optBits |= OPT_BIT_INPLACE;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getMaxlength() maxlength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getMaxlength() maxlength}.</em>
     * @param maxlength The value for maxlength 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setMaxlength(int maxlength) {
      this.maxlength = maxlength;
      optBits |= OPT_BIT_MAXLENGTH;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getCols() cols} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getCols() cols}.</em>
     * @param cols The value for cols 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setCols(int cols) {
      this.cols = cols;
      optBits |= OPT_BIT_COLS;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getInstant() instant} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getInstant() instant}.</em>
     * @param instant The value for instant 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setInstant(boolean instant) {
      this.instant = instant;
      optBits |= OPT_BIT_INSTANT;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setErrorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isMultiline() multiline} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isMultiline() multiline}.</em>
     * @param multiline The value for multiline 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setMultiline(boolean multiline) {
      this.multiline = multiline;
      optBits |= OPT_BIT_MULTILINE;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getRows() rows} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getRows() rows}.</em>
     * @param rows The value for rows 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setRows(int rows) {
      this.rows = rows;
      optBits |= OPT_BIT_ROWS;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isTabbable() tabbable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isTabbable() tabbable}.</em>
     * @param tabbable The value for tabbable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setTabbable(boolean tabbable) {
      this.tabbable = tabbable;
      optBits |= OPT_BIT_TABBABLE;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isSubmitByEnter() submitByEnter} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isSubmitByEnter() submitByEnter}.</em>
     * @param submitByEnter The value for submitByEnter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setSubmitByEnter(boolean submitByEnter) {
      this.submitByEnter = submitByEnter;
      optBits |= OPT_BIT_SUBMIT_BY_ENTER;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getChild() child} attribute.
     * @param child The value for child (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setChild(@Nullable IBandpopup child) {
      this.child = child;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getPopupWidth() popupWidth} attribute.
     * @param popupWidth The value for popupWidth (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setPopupWidth(@Nullable String popupWidth) {
      this.popupWidth = popupWidth;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isAutodrop() autodrop} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isAutodrop() autodrop}.</em>
     * @param autodrop The value for autodrop 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setAutodrop(boolean autodrop) {
      this.autodrop = autodrop;
      optBits |= OPT_BIT_AUTODROP;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isButtonVisible() buttonVisible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isButtonVisible() buttonVisible}.</em>
     * @param buttonVisible The value for buttonVisible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setButtonVisible(boolean buttonVisible) {
      this.buttonVisible = buttonVisible;
      optBits |= OPT_BIT_BUTTON_VISIBLE;
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#getIconSclass() iconSclass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#getIconSclass() iconSclass}.</em>
     * @param iconSclass The value for iconSclass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setIconSclass(String iconSclass) {
      this.iconSclass = Objects.requireNonNull(iconSclass, "iconSclass");
      return (IBandbox.Builder) this;
    }

    /**
     * Initializes the value for the {@link IBandbox#isOpen() open} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IBandbox#isOpen() open}.</em>
     * @param open The value for open 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IBandbox.Builder setOpen(boolean open) {
      this.open = open;
      optBits |= OPT_BIT_OPEN;
      return (IBandbox.Builder) this;
    }

    /**
     * Builds a new {@link IBandbox IBandbox}.
     * @return An immutable instance of IBandbox
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IBandbox build() {
      return ImmutableIBandbox.validate(new ImmutableIBandbox(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean readonlyIsSet() {
      return (optBits & OPT_BIT_READONLY) != 0;
    }

    private boolean disabledIsSet() {
      return (optBits & OPT_BIT_DISABLED) != 0;
    }

    private boolean inplaceIsSet() {
      return (optBits & OPT_BIT_INPLACE) != 0;
    }

    private boolean maxlengthIsSet() {
      return (optBits & OPT_BIT_MAXLENGTH) != 0;
    }

    private boolean colsIsSet() {
      return (optBits & OPT_BIT_COLS) != 0;
    }

    private boolean instantIsSet() {
      return (optBits & OPT_BIT_INSTANT) != 0;
    }

    private boolean multilineIsSet() {
      return (optBits & OPT_BIT_MULTILINE) != 0;
    }

    private boolean rowsIsSet() {
      return (optBits & OPT_BIT_ROWS) != 0;
    }

    private boolean tabbableIsSet() {
      return (optBits & OPT_BIT_TABBABLE) != 0;
    }

    private boolean submitByEnterIsSet() {
      return (optBits & OPT_BIT_SUBMIT_BY_ENTER) != 0;
    }

    private boolean autodropIsSet() {
      return (optBits & OPT_BIT_AUTODROP) != 0;
    }

    private boolean buttonVisibleIsSet() {
      return (optBits & OPT_BIT_BUTTON_VISIBLE) != 0;
    }

    private boolean openIsSet() {
      return (optBits & OPT_BIT_OPEN) != 0;
    }
  }
}
