package org.zkoss.stateless.sul;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.zkoss.stateless.immutable.StatelessOnly;
import org.zkoss.stateless.util.ActionHandler;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zul.Window;

/**
 * Immutable implementation of {@link IWindow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new IWindow.Builder()}.
 */
@Generated(from = "IWindow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableIWindow<I extends IAnyGroup>
    implements IWindow<I> {
  private final String id;
  private final @Nullable ActionHandler action;
  private final @Nullable ImmutableList<ActionHandler> actions;
  private final boolean visible;
  private final String mold;
  private final @Nullable EventListenerMap eventListenerMap;
  private final @Nullable ImmutableMap<String, String> widgetListeners;
  private final @Nullable ImmutableMap<String, String> widgetOverrides;
  private final @Nullable ImmutableMap<String, String> clientAttributes;
  private final @Nullable String left;
  private final @Nullable String top;
  private final int zIndex;
  private final @Nullable String height;
  private final @Nullable String width;
  private final @Nullable String tooltiptext;
  private final @Nullable String zclass;
  private final @Nullable String sclass;
  private final @Nullable String style;
  private final String draggable;
  private final boolean focus;
  private final String droppable;
  private final @Nullable String vflex;
  private final @Nullable String hflex;
  private final int renderdefer;
  private final @Nullable String clientAction;
  private final @Nullable Integer tabindex;
  private final @Nullable String ctrlKeys;
  private final @Nullable String context;
  private final @Nullable String popup;
  private final @Nullable String tooltip;
  private final ImmutableList<I> children;
  private final String widgetClass;
  private final @Nullable ICaption caption;
  private final String title;
  private final String mode;
  private final @Nullable String position;
  private final @Nullable String contentStyle;
  private final @Nullable String contentSclass;
  private final boolean closable;
  private final boolean maximizable;
  private final boolean minimizable;
  private final boolean maximized;
  private final boolean minimized;
  private final boolean sizable;
  private final int minheight;
  private final int minwidth;
  private final String border;
  private final boolean shadow;
  private final boolean nativeScrollbar;

  private ImmutableIWindow(ImmutableIWindow.Builder<I> builder) {
    this.action = builder.action;
    this.actions = builder.actions == null ? null : builder.actions.build();
    this.eventListenerMap = builder.eventListenerMap;
    this.widgetListeners = builder.widgetListeners == null ? null : builder.widgetListeners.build();
    this.widgetOverrides = builder.widgetOverrides == null ? null : builder.widgetOverrides.build();
    this.clientAttributes = builder.clientAttributes == null ? null : builder.clientAttributes.build();
    this.left = builder.left;
    this.top = builder.top;
    this.height = builder.height;
    this.width = builder.width;
    this.tooltiptext = builder.tooltiptext;
    this.zclass = builder.zclass;
    this.sclass = builder.sclass;
    this.style = builder.style;
    this.vflex = builder.vflex;
    this.hflex = builder.hflex;
    this.clientAction = builder.clientAction;
    this.tabindex = builder.tabindex;
    this.ctrlKeys = builder.ctrlKeys;
    this.context = builder.context;
    this.popup = builder.popup;
    this.tooltip = builder.tooltip;
    this.children = builder.children.build();
    this.caption = builder.caption;
    this.position = builder.position;
    this.contentStyle = builder.contentStyle;
    this.contentSclass = builder.contentSclass;
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.visibleIsSet()) {
      initShim.setVisible(builder.visible);
    }
    if (builder.mold != null) {
      initShim.setMold(builder.mold);
    }
    if (builder.zIndexIsSet()) {
      initShim.setZIndex(builder.zIndex);
    }
    if (builder.draggable != null) {
      initShim.setDraggable(builder.draggable);
    }
    if (builder.focusIsSet()) {
      initShim.setFocus(builder.focus);
    }
    if (builder.droppable != null) {
      initShim.setDroppable(builder.droppable);
    }
    if (builder.renderdeferIsSet()) {
      initShim.setRenderdefer(builder.renderdefer);
    }
    if (builder.widgetClass != null) {
      initShim.setWidgetClass(builder.widgetClass);
    }
    if (builder.title != null) {
      initShim.setTitle(builder.title);
    }
    if (builder.mode != null) {
      initShim.setMode(builder.mode);
    }
    if (builder.closableIsSet()) {
      initShim.setClosable(builder.closable);
    }
    if (builder.maximizableIsSet()) {
      initShim.setMaximizable(builder.maximizable);
    }
    if (builder.minimizableIsSet()) {
      initShim.setMinimizable(builder.minimizable);
    }
    if (builder.maximizedIsSet()) {
      initShim.setMaximized(builder.maximized);
    }
    if (builder.minimizedIsSet()) {
      initShim.setMinimized(builder.minimized);
    }
    if (builder.sizableIsSet()) {
      initShim.setSizable(builder.sizable);
    }
    if (builder.minheightIsSet()) {
      initShim.setMinheight(builder.minheight);
    }
    if (builder.minwidthIsSet()) {
      initShim.setMinwidth(builder.minwidth);
    }
    if (builder.border != null) {
      initShim.setBorder(builder.border);
    }
    if (builder.shadowIsSet()) {
      initShim.setShadow(builder.shadow);
    }
    if (builder.nativeScrollbarIsSet()) {
      initShim.setNativeScrollbar(builder.nativeScrollbar);
    }
    this.id = initShim.getId();
    this.visible = initShim.isVisible();
    this.mold = initShim.getMold();
    this.zIndex = initShim.getZIndex();
    this.draggable = initShim.getDraggable();
    this.focus = initShim.isFocus();
    this.droppable = initShim.getDroppable();
    this.renderdefer = initShim.getRenderdefer();
    this.widgetClass = initShim.getWidgetClass();
    this.title = initShim.getTitle();
    this.mode = initShim.getMode();
    this.closable = initShim.isClosable();
    this.maximizable = initShim.isMaximizable();
    this.minimizable = initShim.isMinimizable();
    this.maximized = initShim.isMaximized();
    this.minimized = initShim.isMinimized();
    this.sizable = initShim.isSizable();
    this.minheight = initShim.getMinheight();
    this.minwidth = initShim.getMinwidth();
    this.border = initShim.getBorder();
    this.shadow = initShim.isShadow();
    this.nativeScrollbar = initShim.isNativeScrollbar();
    this.initShim = null;
  }

  private ImmutableIWindow(
      String id,
      @Nullable ActionHandler action,
      @Nullable ImmutableList<ActionHandler> actions,
      boolean visible,
      String mold,
      @Nullable EventListenerMap eventListenerMap,
      @Nullable ImmutableMap<String, String> widgetListeners,
      @Nullable ImmutableMap<String, String> widgetOverrides,
      @Nullable ImmutableMap<String, String> clientAttributes,
      @Nullable String left,
      @Nullable String top,
      int zIndex,
      @Nullable String height,
      @Nullable String width,
      @Nullable String tooltiptext,
      @Nullable String zclass,
      @Nullable String sclass,
      @Nullable String style,
      String draggable,
      boolean focus,
      String droppable,
      @Nullable String vflex,
      @Nullable String hflex,
      int renderdefer,
      @Nullable String clientAction,
      @Nullable Integer tabindex,
      @Nullable String ctrlKeys,
      @Nullable String context,
      @Nullable String popup,
      @Nullable String tooltip,
      ImmutableList<I> children,
      String widgetClass,
      @Nullable ICaption caption,
      String title,
      String mode,
      @Nullable String position,
      @Nullable String contentStyle,
      @Nullable String contentSclass,
      boolean closable,
      boolean maximizable,
      boolean minimizable,
      boolean maximized,
      boolean minimized,
      boolean sizable,
      int minheight,
      int minwidth,
      String border,
      boolean shadow,
      boolean nativeScrollbar) {
    this.id = id;
    this.action = action;
    this.actions = actions;
    this.visible = visible;
    this.mold = mold;
    this.eventListenerMap = eventListenerMap;
    this.widgetListeners = widgetListeners;
    this.widgetOverrides = widgetOverrides;
    this.clientAttributes = clientAttributes;
    this.left = left;
    this.top = top;
    this.zIndex = zIndex;
    this.height = height;
    this.width = width;
    this.tooltiptext = tooltiptext;
    this.zclass = zclass;
    this.sclass = sclass;
    this.style = style;
    this.draggable = draggable;
    this.focus = focus;
    this.droppable = droppable;
    this.vflex = vflex;
    this.hflex = hflex;
    this.renderdefer = renderdefer;
    this.clientAction = clientAction;
    this.tabindex = tabindex;
    this.ctrlKeys = ctrlKeys;
    this.context = context;
    this.popup = popup;
    this.tooltip = tooltip;
    this.children = children;
    this.widgetClass = widgetClass;
    this.caption = caption;
    this.title = title;
    this.mode = mode;
    this.position = position;
    this.contentStyle = contentStyle;
    this.contentSclass = contentSclass;
    this.closable = closable;
    this.maximizable = maximizable;
    this.minimizable = minimizable;
    this.maximized = maximized;
    this.minimized = minimized;
    this.sizable = sizable;
    this.minheight = minheight;
    this.minwidth = minwidth;
    this.border = border;
    this.shadow = shadow;
    this.nativeScrollbar = nativeScrollbar;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "IWindow", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte visibleBuildStage = STAGE_UNINITIALIZED;
    private boolean visible;

    boolean isVisible() {
      if (visibleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (visibleBuildStage == STAGE_UNINITIALIZED) {
        visibleBuildStage = STAGE_INITIALIZING;
        this.visible = isVisibleInitialize();
        visibleBuildStage = STAGE_INITIALIZED;
      }
      return this.visible;
    }

    void setVisible(boolean visible) {
      this.visible = visible;
      visibleBuildStage = STAGE_INITIALIZED;
    }

    private byte moldBuildStage = STAGE_UNINITIALIZED;
    private String mold;

    String getMold() {
      if (moldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (moldBuildStage == STAGE_UNINITIALIZED) {
        moldBuildStage = STAGE_INITIALIZING;
        this.mold = Objects.requireNonNull(getMoldInitialize(), "mold");
        moldBuildStage = STAGE_INITIALIZED;
      }
      return this.mold;
    }

    void setMold(String mold) {
      this.mold = mold;
      moldBuildStage = STAGE_INITIALIZED;
    }

    private byte zIndexBuildStage = STAGE_UNINITIALIZED;
    private int zIndex;

    int getZIndex() {
      if (zIndexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zIndexBuildStage == STAGE_UNINITIALIZED) {
        zIndexBuildStage = STAGE_INITIALIZING;
        this.zIndex = getZIndexInitialize();
        zIndexBuildStage = STAGE_INITIALIZED;
      }
      return this.zIndex;
    }

    void setZIndex(int zIndex) {
      this.zIndex = zIndex;
      zIndexBuildStage = STAGE_INITIALIZED;
    }

    private byte draggableBuildStage = STAGE_UNINITIALIZED;
    private String draggable;

    String getDraggable() {
      if (draggableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (draggableBuildStage == STAGE_UNINITIALIZED) {
        draggableBuildStage = STAGE_INITIALIZING;
        this.draggable = Objects.requireNonNull(getDraggableInitialize(), "draggable");
        draggableBuildStage = STAGE_INITIALIZED;
      }
      return this.draggable;
    }

    void setDraggable(String draggable) {
      this.draggable = draggable;
      draggableBuildStage = STAGE_INITIALIZED;
    }

    private byte focusBuildStage = STAGE_UNINITIALIZED;
    private boolean focus;

    boolean isFocus() {
      if (focusBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (focusBuildStage == STAGE_UNINITIALIZED) {
        focusBuildStage = STAGE_INITIALIZING;
        this.focus = isFocusInitialize();
        focusBuildStage = STAGE_INITIALIZED;
      }
      return this.focus;
    }

    void setFocus(boolean focus) {
      this.focus = focus;
      focusBuildStage = STAGE_INITIALIZED;
    }

    private byte droppableBuildStage = STAGE_UNINITIALIZED;
    private String droppable;

    String getDroppable() {
      if (droppableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (droppableBuildStage == STAGE_UNINITIALIZED) {
        droppableBuildStage = STAGE_INITIALIZING;
        this.droppable = Objects.requireNonNull(getDroppableInitialize(), "droppable");
        droppableBuildStage = STAGE_INITIALIZED;
      }
      return this.droppable;
    }

    void setDroppable(String droppable) {
      this.droppable = droppable;
      droppableBuildStage = STAGE_INITIALIZED;
    }

    private byte renderdeferBuildStage = STAGE_UNINITIALIZED;
    private int renderdefer;

    int getRenderdefer() {
      if (renderdeferBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (renderdeferBuildStage == STAGE_UNINITIALIZED) {
        renderdeferBuildStage = STAGE_INITIALIZING;
        this.renderdefer = getRenderdeferInitialize();
        renderdeferBuildStage = STAGE_INITIALIZED;
      }
      return this.renderdefer;
    }

    void setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      renderdeferBuildStage = STAGE_INITIALIZED;
    }

    private byte widgetClassBuildStage = STAGE_UNINITIALIZED;
    private String widgetClass;

    String getWidgetClass() {
      if (widgetClassBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (widgetClassBuildStage == STAGE_UNINITIALIZED) {
        widgetClassBuildStage = STAGE_INITIALIZING;
        this.widgetClass = Objects.requireNonNull(getWidgetClassInitialize(), "widgetClass");
        widgetClassBuildStage = STAGE_INITIALIZED;
      }
      return this.widgetClass;
    }

    void setWidgetClass(String widgetClass) {
      this.widgetClass = widgetClass;
      widgetClassBuildStage = STAGE_INITIALIZED;
    }

    private byte titleBuildStage = STAGE_UNINITIALIZED;
    private String title;

    String getTitle() {
      if (titleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (titleBuildStage == STAGE_UNINITIALIZED) {
        titleBuildStage = STAGE_INITIALIZING;
        this.title = Objects.requireNonNull(getTitleInitialize(), "title");
        titleBuildStage = STAGE_INITIALIZED;
      }
      return this.title;
    }

    void setTitle(String title) {
      this.title = title;
      titleBuildStage = STAGE_INITIALIZED;
    }

    private byte modeBuildStage = STAGE_UNINITIALIZED;
    private String mode;

    String getMode() {
      if (modeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (modeBuildStage == STAGE_UNINITIALIZED) {
        modeBuildStage = STAGE_INITIALIZING;
        this.mode = Objects.requireNonNull(getModeInitialize(), "mode");
        modeBuildStage = STAGE_INITIALIZED;
      }
      return this.mode;
    }

    void setMode(String mode) {
      this.mode = mode;
      modeBuildStage = STAGE_INITIALIZED;
    }

    private byte closableBuildStage = STAGE_UNINITIALIZED;
    private boolean closable;

    boolean isClosable() {
      if (closableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (closableBuildStage == STAGE_UNINITIALIZED) {
        closableBuildStage = STAGE_INITIALIZING;
        this.closable = isClosableInitialize();
        closableBuildStage = STAGE_INITIALIZED;
      }
      return this.closable;
    }

    void setClosable(boolean closable) {
      this.closable = closable;
      closableBuildStage = STAGE_INITIALIZED;
    }

    private byte maximizableBuildStage = STAGE_UNINITIALIZED;
    private boolean maximizable;

    boolean isMaximizable() {
      if (maximizableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maximizableBuildStage == STAGE_UNINITIALIZED) {
        maximizableBuildStage = STAGE_INITIALIZING;
        this.maximizable = isMaximizableInitialize();
        maximizableBuildStage = STAGE_INITIALIZED;
      }
      return this.maximizable;
    }

    void setMaximizable(boolean maximizable) {
      this.maximizable = maximizable;
      maximizableBuildStage = STAGE_INITIALIZED;
    }

    private byte minimizableBuildStage = STAGE_UNINITIALIZED;
    private boolean minimizable;

    boolean isMinimizable() {
      if (minimizableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minimizableBuildStage == STAGE_UNINITIALIZED) {
        minimizableBuildStage = STAGE_INITIALIZING;
        this.minimizable = isMinimizableInitialize();
        minimizableBuildStage = STAGE_INITIALIZED;
      }
      return this.minimizable;
    }

    void setMinimizable(boolean minimizable) {
      this.minimizable = minimizable;
      minimizableBuildStage = STAGE_INITIALIZED;
    }

    private byte maximizedBuildStage = STAGE_UNINITIALIZED;
    private boolean maximized;

    boolean isMaximized() {
      if (maximizedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maximizedBuildStage == STAGE_UNINITIALIZED) {
        maximizedBuildStage = STAGE_INITIALIZING;
        this.maximized = isMaximizedInitialize();
        maximizedBuildStage = STAGE_INITIALIZED;
      }
      return this.maximized;
    }

    void setMaximized(boolean maximized) {
      this.maximized = maximized;
      maximizedBuildStage = STAGE_INITIALIZED;
    }

    private byte minimizedBuildStage = STAGE_UNINITIALIZED;
    private boolean minimized;

    boolean isMinimized() {
      if (minimizedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minimizedBuildStage == STAGE_UNINITIALIZED) {
        minimizedBuildStage = STAGE_INITIALIZING;
        this.minimized = isMinimizedInitialize();
        minimizedBuildStage = STAGE_INITIALIZED;
      }
      return this.minimized;
    }

    void setMinimized(boolean minimized) {
      this.minimized = minimized;
      minimizedBuildStage = STAGE_INITIALIZED;
    }

    private byte sizableBuildStage = STAGE_UNINITIALIZED;
    private boolean sizable;

    boolean isSizable() {
      if (sizableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sizableBuildStage == STAGE_UNINITIALIZED) {
        sizableBuildStage = STAGE_INITIALIZING;
        this.sizable = isSizableInitialize();
        sizableBuildStage = STAGE_INITIALIZED;
      }
      return this.sizable;
    }

    void setSizable(boolean sizable) {
      this.sizable = sizable;
      sizableBuildStage = STAGE_INITIALIZED;
    }

    private byte minheightBuildStage = STAGE_UNINITIALIZED;
    private int minheight;

    int getMinheight() {
      if (minheightBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minheightBuildStage == STAGE_UNINITIALIZED) {
        minheightBuildStage = STAGE_INITIALIZING;
        this.minheight = getMinheightInitialize();
        minheightBuildStage = STAGE_INITIALIZED;
      }
      return this.minheight;
    }

    void setMinheight(int minheight) {
      this.minheight = minheight;
      minheightBuildStage = STAGE_INITIALIZED;
    }

    private byte minwidthBuildStage = STAGE_UNINITIALIZED;
    private int minwidth;

    int getMinwidth() {
      if (minwidthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minwidthBuildStage == STAGE_UNINITIALIZED) {
        minwidthBuildStage = STAGE_INITIALIZING;
        this.minwidth = getMinwidthInitialize();
        minwidthBuildStage = STAGE_INITIALIZED;
      }
      return this.minwidth;
    }

    void setMinwidth(int minwidth) {
      this.minwidth = minwidth;
      minwidthBuildStage = STAGE_INITIALIZED;
    }

    private byte borderBuildStage = STAGE_UNINITIALIZED;
    private String border;

    String getBorder() {
      if (borderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (borderBuildStage == STAGE_UNINITIALIZED) {
        borderBuildStage = STAGE_INITIALIZING;
        this.border = Objects.requireNonNull(getBorderInitialize(), "border");
        borderBuildStage = STAGE_INITIALIZED;
      }
      return this.border;
    }

    void setBorder(String border) {
      this.border = border;
      borderBuildStage = STAGE_INITIALIZED;
    }

    private byte shadowBuildStage = STAGE_UNINITIALIZED;
    private boolean shadow;

    boolean isShadow() {
      if (shadowBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (shadowBuildStage == STAGE_UNINITIALIZED) {
        shadowBuildStage = STAGE_INITIALIZING;
        this.shadow = isShadowInitialize();
        shadowBuildStage = STAGE_INITIALIZED;
      }
      return this.shadow;
    }

    void setShadow(boolean shadow) {
      this.shadow = shadow;
      shadowBuildStage = STAGE_INITIALIZED;
    }

    private byte nativeScrollbarBuildStage = STAGE_UNINITIALIZED;
    private boolean nativeScrollbar;

    boolean isNativeScrollbar() {
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeScrollbarBuildStage == STAGE_UNINITIALIZED) {
        nativeScrollbarBuildStage = STAGE_INITIALIZING;
        this.nativeScrollbar = isNativeScrollbarInitialize();
        nativeScrollbarBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeScrollbar;
    }

    void setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      nativeScrollbarBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (visibleBuildStage == STAGE_INITIALIZING) attributes.add("visible");
      if (moldBuildStage == STAGE_INITIALIZING) attributes.add("mold");
      if (zIndexBuildStage == STAGE_INITIALIZING) attributes.add("zIndex");
      if (draggableBuildStage == STAGE_INITIALIZING) attributes.add("draggable");
      if (focusBuildStage == STAGE_INITIALIZING) attributes.add("focus");
      if (droppableBuildStage == STAGE_INITIALIZING) attributes.add("droppable");
      if (renderdeferBuildStage == STAGE_INITIALIZING) attributes.add("renderdefer");
      if (widgetClassBuildStage == STAGE_INITIALIZING) attributes.add("widgetClass");
      if (titleBuildStage == STAGE_INITIALIZING) attributes.add("title");
      if (modeBuildStage == STAGE_INITIALIZING) attributes.add("mode");
      if (closableBuildStage == STAGE_INITIALIZING) attributes.add("closable");
      if (maximizableBuildStage == STAGE_INITIALIZING) attributes.add("maximizable");
      if (minimizableBuildStage == STAGE_INITIALIZING) attributes.add("minimizable");
      if (maximizedBuildStage == STAGE_INITIALIZING) attributes.add("maximized");
      if (minimizedBuildStage == STAGE_INITIALIZING) attributes.add("minimized");
      if (sizableBuildStage == STAGE_INITIALIZING) attributes.add("sizable");
      if (minheightBuildStage == STAGE_INITIALIZING) attributes.add("minheight");
      if (minwidthBuildStage == STAGE_INITIALIZING) attributes.add("minwidth");
      if (borderBuildStage == STAGE_INITIALIZING) attributes.add("border");
      if (shadowBuildStage == STAGE_INITIALIZING) attributes.add("shadow");
      if (nativeScrollbarBuildStage == STAGE_INITIALIZING) attributes.add("nativeScrollbar");
      return "Cannot build IWindow, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return IWindow.super.getId();
  }

  private boolean isVisibleInitialize() {
    return IWindow.super.isVisible();
  }

  private String getMoldInitialize() {
    return IWindow.super.getMold();
  }

  private int getZIndexInitialize() {
    return IWindow.super.getZIndex();
  }

  private String getDraggableInitialize() {
    return IWindow.super.getDraggable();
  }

  private boolean isFocusInitialize() {
    return IWindow.super.isFocus();
  }

  private String getDroppableInitialize() {
    return IWindow.super.getDroppable();
  }

  private int getRenderdeferInitialize() {
    return IWindow.super.getRenderdefer();
  }

  private String getWidgetClassInitialize() {
    return IWindow.super.getWidgetClass();
  }

  private String getTitleInitialize() {
    return IWindow.super.getTitle();
  }

  private String getModeInitialize() {
    return IWindow.super.getMode();
  }

  private boolean isClosableInitialize() {
    return IWindow.super.isClosable();
  }

  private boolean isMaximizableInitialize() {
    return IWindow.super.isMaximizable();
  }

  private boolean isMinimizableInitialize() {
    return IWindow.super.isMinimizable();
  }

  private boolean isMaximizedInitialize() {
    return IWindow.super.isMaximized();
  }

  private boolean isMinimizedInitialize() {
    return IWindow.super.isMinimized();
  }

  private boolean isSizableInitialize() {
    return IWindow.super.isSizable();
  }

  private int getMinheightInitialize() {
    return IWindow.super.getMinheight();
  }

  private int getMinwidthInitialize() {
    return IWindow.super.getMinwidth();
  }

  private String getBorderInitialize() {
    return IWindow.super.getBorder();
  }

  private boolean isShadowInitialize() {
    return IWindow.super.isShadow();
  }

  private boolean isNativeScrollbarInitialize() {
    return IWindow.super.isNativeScrollbar();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ActionHandler getAction() {
    return action;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @StatelessOnly
  @Override
  public @Nullable ImmutableList<ActionHandler> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code visible} attribute
   */
  @Override
  public boolean isVisible() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVisible()
        : this.visible;
  }

  /**
   * @return The value of the {@code mold} attribute
   */
  @Override
  public String getMold() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMold()
        : this.mold;
  }

  /**
   * @return The value of the {@code eventListenerMap} attribute
   */
  @Override
  public @Nullable EventListenerMap getEventListenerMap() {
    return eventListenerMap;
  }

  /**
   * @return The value of the {@code widgetListeners} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetListeners() {
    return widgetListeners;
  }

  /**
   * @return The value of the {@code widgetOverrides} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getWidgetOverrides() {
    return widgetOverrides;
  }

  /**
   * @return The value of the {@code clientAttributes} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getClientAttributes() {
    return clientAttributes;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable String getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code top} attribute
   */
  @Override
  public @Nullable String getTop() {
    return top;
  }

  /**
   * @return The value of the {@code zIndex} attribute
   */
  @Override
  public int getZIndex() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getZIndex()
        : this.zIndex;
  }

  /**
   * @return The value of the {@code height} attribute
   */
  @Override
  public @Nullable String getHeight() {
    return height;
  }

  /**
   * @return The value of the {@code width} attribute
   */
  @Override
  public @Nullable String getWidth() {
    return width;
  }

  /**
   * @return The value of the {@code tooltiptext} attribute
   */
  @Override
  public @Nullable String getTooltiptext() {
    return tooltiptext;
  }

  /**
   * @return The value of the {@code zclass} attribute
   */
  @Override
  public @Nullable String getZclass() {
    return zclass;
  }

  /**
   * @return The value of the {@code sclass} attribute
   */
  @Override
  public @Nullable String getSclass() {
    return sclass;
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @Override
  public @Nullable String getStyle() {
    return style;
  }

  /**
   * @return The value of the {@code draggable} attribute
   */
  @Override
  public String getDraggable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDraggable()
        : this.draggable;
  }

  /**
   * @return The value of the {@code focus} attribute
   */
  @Override
  public boolean isFocus() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFocus()
        : this.focus;
  }

  /**
   * @return The value of the {@code droppable} attribute
   */
  @Override
  public String getDroppable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDroppable()
        : this.droppable;
  }

  /**
   * @return The value of the {@code vflex} attribute
   */
  @Override
  public @Nullable String getVflex() {
    return vflex;
  }

  /**
   * @return The value of the {@code hflex} attribute
   */
  @Override
  public @Nullable String getHflex() {
    return hflex;
  }

  /**
   * @return The value of the {@code renderdefer} attribute
   */
  @Override
  public int getRenderdefer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRenderdefer()
        : this.renderdefer;
  }

  /**
   * @return The value of the {@code clientAction} attribute
   */
  @Override
  public @Nullable String getClientAction() {
    return clientAction;
  }

  /**
   * @return The value of the {@code tabindex} attribute
   */
  @Override
  public @Nullable Integer getTabindex() {
    return tabindex;
  }

  /**
   * @return The value of the {@code ctrlKeys} attribute
   */
  @Override
  public @Nullable String getCtrlKeys() {
    return ctrlKeys;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @Override
  public @Nullable String getContext() {
    return context;
  }

  /**
   * @return The value of the {@code popup} attribute
   */
  @Override
  public @Nullable String getPopup() {
    return popup;
  }

  /**
   * @return The value of the {@code tooltip} attribute
   */
  @Override
  public @Nullable String getTooltip() {
    return tooltip;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @StatelessOnly
  @Override
  public ImmutableList<I> getChildren() {
    return children;
  }

  /**
   * @return The value of the {@code widgetClass} attribute
   */
  @Override
  public String getWidgetClass() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getWidgetClass()
        : this.widgetClass;
  }

  /**
   * @return The value of the {@code caption} attribute
   */
  @Override
  public @Nullable ICaption getCaption() {
    return caption;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public String getTitle() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTitle()
        : this.title;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @Override
  public String getMode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMode()
        : this.mode;
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public @Nullable String getPosition() {
    return position;
  }

  /**
   * @return The value of the {@code contentStyle} attribute
   */
  @Override
  public @Nullable String getContentStyle() {
    return contentStyle;
  }

  /**
   * @return The value of the {@code contentSclass} attribute
   */
  @Override
  public @Nullable String getContentSclass() {
    return contentSclass;
  }

  /**
   * @return The value of the {@code closable} attribute
   */
  @Override
  public boolean isClosable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isClosable()
        : this.closable;
  }

  /**
   * @return The value of the {@code maximizable} attribute
   */
  @Override
  public boolean isMaximizable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMaximizable()
        : this.maximizable;
  }

  /**
   * @return The value of the {@code minimizable} attribute
   */
  @Override
  public boolean isMinimizable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMinimizable()
        : this.minimizable;
  }

  /**
   * @return The value of the {@code maximized} attribute
   */
  @Override
  public boolean isMaximized() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMaximized()
        : this.maximized;
  }

  /**
   * @return The value of the {@code minimized} attribute
   */
  @Override
  public boolean isMinimized() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMinimized()
        : this.minimized;
  }

  /**
   * @return The value of the {@code sizable} attribute
   */
  @Override
  public boolean isSizable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSizable()
        : this.sizable;
  }

  /**
   * @return The value of the {@code minheight} attribute
   */
  @Override
  public int getMinheight() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinheight()
        : this.minheight;
  }

  /**
   * @return The value of the {@code minwidth} attribute
   */
  @Override
  public int getMinwidth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinwidth()
        : this.minwidth;
  }

  /**
   * @return The value of the {@code border} attribute
   */
  @Override
  public String getBorder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBorder()
        : this.border;
  }

  /**
   * @return The value of the {@code shadow} attribute
   */
  @Override
  public boolean isShadow() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isShadow()
        : this.shadow;
  }

  /**
   * @return The value of the {@code nativeScrollbar} attribute
   */
  @Override
  public boolean isNativeScrollbar() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNativeScrollbar()
        : this.nativeScrollbar;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        newValue,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getAction() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withAction(@Nullable ActionHandler value) {
    if (this.action == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        value,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IWindow#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWindow<I> withActions(@Nullable ActionHandler... elements) {
    if (elements == null) {
      return validate(new ImmutableIWindow<>(
          this.id,
          this.action,
          null,
          this.visible,
          this.mold,
          this.eventListenerMap,
          this.widgetListeners,
          this.widgetOverrides,
          this.clientAttributes,
          this.left,
          this.top,
          this.zIndex,
          this.height,
          this.width,
          this.tooltiptext,
          this.zclass,
          this.sclass,
          this.style,
          this.draggable,
          this.focus,
          this.droppable,
          this.vflex,
          this.hflex,
          this.renderdefer,
          this.clientAction,
          this.tabindex,
          this.ctrlKeys,
          this.context,
          this.popup,
          this.tooltip,
          this.children,
          this.widgetClass,
          this.caption,
          this.title,
          this.mode,
          this.position,
          this.contentStyle,
          this.contentSclass,
          this.closable,
          this.maximizable,
          this.minimizable,
          this.maximized,
          this.minimized,
          this.sizable,
          this.minheight,
          this.minwidth,
          this.border,
          this.shadow,
          this.nativeScrollbar));
    }
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IWindow#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWindow<I> withActions(@Nullable Iterable<? extends ActionHandler> elements) {
    if (this.actions == elements) return this;
    @Nullable ImmutableList<ActionHandler> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        newValue,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isVisible() visible} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visible
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withVisible(boolean value) {
    if (this.visible == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        value,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getMold() mold} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mold
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMold(String value) {
    String newValue = Objects.requireNonNull(value, "mold");
    if (this.mold.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        newValue,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getEventListenerMap() eventListenerMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventListenerMap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withEventListenerMap(@Nullable EventListenerMap value) {
    if (this.eventListenerMap == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        value,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by replacing the {@link IWindow#getWidgetListeners() widgetListeners} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetListeners map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWindow<I> withWidgetListeners(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetListeners == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        newValue,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by replacing the {@link IWindow#getWidgetOverrides() widgetOverrides} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the widgetOverrides map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWindow<I> withWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
    if (this.widgetOverrides == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        newValue,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by replacing the {@link IWindow#getClientAttributes() clientAttributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the clientAttributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWindow<I> withClientAttributes(@Nullable Map<String, ? extends String> entries) {
    if (this.clientAttributes == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        newValue,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getLeft() left} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withLeft(@Nullable String value) {
    if (Objects.equals(this.left, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        value,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getTop() top} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for top (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withTop(@Nullable String value) {
    if (Objects.equals(this.top, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        value,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getZIndex() zIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withZIndex(int value) {
    if (this.zIndex == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        value,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getHeight() height} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for height (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withHeight(@Nullable String value) {
    if (Objects.equals(this.height, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        value,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getWidth() width} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for width (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withWidth(@Nullable String value) {
    if (Objects.equals(this.width, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        value,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getTooltiptext() tooltiptext} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltiptext (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withTooltiptext(@Nullable String value) {
    if (Objects.equals(this.tooltiptext, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        value,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getZclass() zclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withZclass(@Nullable String value) {
    if (Objects.equals(this.zclass, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        value,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getSclass() sclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withSclass(@Nullable String value) {
    if (Objects.equals(this.sclass, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        value,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getStyle() style} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for style (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withStyle(@Nullable String value) {
    if (Objects.equals(this.style, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        value,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getDraggable() draggable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for draggable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withDraggable(String value) {
    String newValue = Objects.requireNonNull(value, "draggable");
    if (this.draggable.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        newValue,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isFocus() focus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withFocus(boolean value) {
    if (this.focus == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        value,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getDroppable() droppable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for droppable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withDroppable(String value) {
    String newValue = Objects.requireNonNull(value, "droppable");
    if (this.droppable.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        newValue,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getVflex() vflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for vflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withVflex(@Nullable String value) {
    if (Objects.equals(this.vflex, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        value,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getHflex() hflex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hflex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withHflex(@Nullable String value) {
    if (Objects.equals(this.hflex, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        value,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getRenderdefer() renderdefer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for renderdefer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withRenderdefer(int value) {
    if (this.renderdefer == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        value,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getClientAction() clientAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientAction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withClientAction(@Nullable String value) {
    if (Objects.equals(this.clientAction, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        value,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getTabindex() tabindex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tabindex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withTabindex(@Nullable Integer value) {
    if (Objects.equals(this.tabindex, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        value,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getCtrlKeys() ctrlKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctrlKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withCtrlKeys(@Nullable String value) {
    if (Objects.equals(this.ctrlKeys, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        value,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withContext(@Nullable String value) {
    if (Objects.equals(this.context, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        value,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getPopup() popup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for popup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withPopup(@Nullable String value) {
    if (Objects.equals(this.popup, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        value,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getTooltip() tooltip} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tooltip (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withTooltip(@Nullable String value) {
    if (Objects.equals(this.tooltip, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        value,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IWindow#getChildren() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableIWindow<I> withChildren(I... elements) {
    ImmutableList<I> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IWindow#getChildren() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIWindow<I> withChildren(Iterable<? extends I> elements) {
    if (this.children == elements) return this;
    ImmutableList<I> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        newValue,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getWidgetClass() widgetClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for widgetClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withWidgetClass(String value) {
    String newValue = Objects.requireNonNull(value, "widgetClass");
    if (this.widgetClass.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        newValue,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getCaption() caption} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caption (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withCaption(@Nullable ICaption value) {
    if (this.caption == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        value,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        newValue,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getMode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMode(String value) {
    String newValue = Objects.requireNonNull(value, "mode");
    if (this.mode.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        newValue,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getPosition() position} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withPosition(@Nullable String value) {
    if (Objects.equals(this.position, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        value,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getContentStyle() contentStyle} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentStyle (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withContentStyle(@Nullable String value) {
    if (Objects.equals(this.contentStyle, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        value,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getContentSclass() contentSclass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentSclass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withContentSclass(@Nullable String value) {
    if (Objects.equals(this.contentSclass, value)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        value,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isClosable() closable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withClosable(boolean value) {
    if (this.closable == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        value,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isMaximizable() maximizable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maximizable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMaximizable(boolean value) {
    if (this.maximizable == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        value,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isMinimizable() minimizable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minimizable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMinimizable(boolean value) {
    if (this.minimizable == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        value,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isMaximized() maximized} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maximized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMaximized(boolean value) {
    if (this.maximized == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        value,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isMinimized() minimized} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minimized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMinimized(boolean value) {
    if (this.minimized == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        value,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isSizable() sizable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sizable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withSizable(boolean value) {
    if (this.sizable == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        value,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getMinheight() minheight} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minheight
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMinheight(int value) {
    if (this.minheight == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        value,
        this.minwidth,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getMinwidth() minwidth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minwidth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withMinwidth(int value) {
    if (this.minwidth == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        value,
        this.border,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#getBorder() border} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for border
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withBorder(String value) {
    String newValue = Objects.requireNonNull(value, "border");
    if (this.border.equals(newValue)) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        newValue,
        this.shadow,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isShadow() shadow} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for shadow
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withShadow(boolean value) {
    if (this.shadow == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        value,
        this.nativeScrollbar));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IWindow#isNativeScrollbar() nativeScrollbar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeScrollbar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIWindow<I> withNativeScrollbar(boolean value) {
    if (this.nativeScrollbar == value) return this;
    return validate(new ImmutableIWindow<>(
        this.id,
        this.action,
        this.actions,
        this.visible,
        this.mold,
        this.eventListenerMap,
        this.widgetListeners,
        this.widgetOverrides,
        this.clientAttributes,
        this.left,
        this.top,
        this.zIndex,
        this.height,
        this.width,
        this.tooltiptext,
        this.zclass,
        this.sclass,
        this.style,
        this.draggable,
        this.focus,
        this.droppable,
        this.vflex,
        this.hflex,
        this.renderdefer,
        this.clientAction,
        this.tabindex,
        this.ctrlKeys,
        this.context,
        this.popup,
        this.tooltip,
        this.children,
        this.widgetClass,
        this.caption,
        this.title,
        this.mode,
        this.position,
        this.contentStyle,
        this.contentSclass,
        this.closable,
        this.maximizable,
        this.minimizable,
        this.maximized,
        this.minimized,
        this.sizable,
        this.minheight,
        this.minwidth,
        this.border,
        this.shadow,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIWindow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIWindow<?>
        && equalTo((ImmutableIWindow<?>) another);
  }

  private boolean equalTo(ImmutableIWindow<?> another) {
    return id.equals(another.id)
        && Objects.equals(action, another.action)
        && Objects.equals(actions, another.actions)
        && visible == another.visible
        && mold.equals(another.mold)
        && Objects.equals(eventListenerMap, another.eventListenerMap)
        && Objects.equals(widgetListeners, another.widgetListeners)
        && Objects.equals(widgetOverrides, another.widgetOverrides)
        && Objects.equals(clientAttributes, another.clientAttributes)
        && Objects.equals(left, another.left)
        && Objects.equals(top, another.top)
        && zIndex == another.zIndex
        && Objects.equals(height, another.height)
        && Objects.equals(width, another.width)
        && Objects.equals(tooltiptext, another.tooltiptext)
        && Objects.equals(zclass, another.zclass)
        && Objects.equals(sclass, another.sclass)
        && Objects.equals(style, another.style)
        && draggable.equals(another.draggable)
        && focus == another.focus
        && droppable.equals(another.droppable)
        && Objects.equals(vflex, another.vflex)
        && Objects.equals(hflex, another.hflex)
        && renderdefer == another.renderdefer
        && Objects.equals(clientAction, another.clientAction)
        && Objects.equals(tabindex, another.tabindex)
        && Objects.equals(ctrlKeys, another.ctrlKeys)
        && Objects.equals(context, another.context)
        && Objects.equals(popup, another.popup)
        && Objects.equals(tooltip, another.tooltip)
        && children.equals(another.children)
        && widgetClass.equals(another.widgetClass)
        && Objects.equals(caption, another.caption)
        && title.equals(another.title)
        && mode.equals(another.mode)
        && Objects.equals(position, another.position)
        && Objects.equals(contentStyle, another.contentStyle)
        && Objects.equals(contentSclass, another.contentSclass)
        && closable == another.closable
        && maximizable == another.maximizable
        && minimizable == another.minimizable
        && maximized == another.maximized
        && minimized == another.minimized
        && sizable == another.sizable
        && minheight == another.minheight
        && minwidth == another.minwidth
        && border.equals(another.border)
        && shadow == another.shadow
        && nativeScrollbar == another.nativeScrollbar;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code action}, {@code actions}, {@code visible}, {@code mold}, {@code eventListenerMap}, {@code widgetListeners}, {@code widgetOverrides}, {@code clientAttributes}, {@code left}, {@code top}, {@code zIndex}, {@code height}, {@code width}, {@code tooltiptext}, {@code zclass}, {@code sclass}, {@code style}, {@code draggable}, {@code focus}, {@code droppable}, {@code vflex}, {@code hflex}, {@code renderdefer}, {@code clientAction}, {@code tabindex}, {@code ctrlKeys}, {@code context}, {@code popup}, {@code tooltip}, {@code children}, {@code widgetClass}, {@code caption}, {@code title}, {@code mode}, {@code position}, {@code contentStyle}, {@code contentSclass}, {@code closable}, {@code maximizable}, {@code minimizable}, {@code maximized}, {@code minimized}, {@code sizable}, {@code minheight}, {@code minwidth}, {@code border}, {@code shadow}, {@code nativeScrollbar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(actions);
    h += (h << 5) + Booleans.hashCode(visible);
    h += (h << 5) + mold.hashCode();
    h += (h << 5) + Objects.hashCode(eventListenerMap);
    h += (h << 5) + Objects.hashCode(widgetListeners);
    h += (h << 5) + Objects.hashCode(widgetOverrides);
    h += (h << 5) + Objects.hashCode(clientAttributes);
    h += (h << 5) + Objects.hashCode(left);
    h += (h << 5) + Objects.hashCode(top);
    h += (h << 5) + zIndex;
    h += (h << 5) + Objects.hashCode(height);
    h += (h << 5) + Objects.hashCode(width);
    h += (h << 5) + Objects.hashCode(tooltiptext);
    h += (h << 5) + Objects.hashCode(zclass);
    h += (h << 5) + Objects.hashCode(sclass);
    h += (h << 5) + Objects.hashCode(style);
    h += (h << 5) + draggable.hashCode();
    h += (h << 5) + Booleans.hashCode(focus);
    h += (h << 5) + droppable.hashCode();
    h += (h << 5) + Objects.hashCode(vflex);
    h += (h << 5) + Objects.hashCode(hflex);
    h += (h << 5) + renderdefer;
    h += (h << 5) + Objects.hashCode(clientAction);
    h += (h << 5) + Objects.hashCode(tabindex);
    h += (h << 5) + Objects.hashCode(ctrlKeys);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(popup);
    h += (h << 5) + Objects.hashCode(tooltip);
    h += (h << 5) + children.hashCode();
    h += (h << 5) + widgetClass.hashCode();
    h += (h << 5) + Objects.hashCode(caption);
    h += (h << 5) + title.hashCode();
    h += (h << 5) + mode.hashCode();
    h += (h << 5) + Objects.hashCode(position);
    h += (h << 5) + Objects.hashCode(contentStyle);
    h += (h << 5) + Objects.hashCode(contentSclass);
    h += (h << 5) + Booleans.hashCode(closable);
    h += (h << 5) + Booleans.hashCode(maximizable);
    h += (h << 5) + Booleans.hashCode(minimizable);
    h += (h << 5) + Booleans.hashCode(maximized);
    h += (h << 5) + Booleans.hashCode(minimized);
    h += (h << 5) + Booleans.hashCode(sizable);
    h += (h << 5) + minheight;
    h += (h << 5) + minwidth;
    h += (h << 5) + border.hashCode();
    h += (h << 5) + Booleans.hashCode(shadow);
    h += (h << 5) + Booleans.hashCode(nativeScrollbar);
    return h;
  }

  /**
   * Prints the immutable value {@code IWindow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IWindow")
        .omitNullValues()
        .add("id", id)
        .add("action", action)
        .add("actions", actions)
        .add("visible", visible)
        .add("mold", mold)
        .add("eventListenerMap", eventListenerMap)
        .add("widgetListeners", widgetListeners)
        .add("widgetOverrides", widgetOverrides)
        .add("clientAttributes", clientAttributes)
        .add("left", left)
        .add("top", top)
        .add("zIndex", zIndex)
        .add("height", height)
        .add("width", width)
        .add("tooltiptext", tooltiptext)
        .add("zclass", zclass)
        .add("sclass", sclass)
        .add("style", style)
        .add("draggable", draggable)
        .add("focus", focus)
        .add("droppable", droppable)
        .add("vflex", vflex)
        .add("hflex", hflex)
        .add("renderdefer", renderdefer)
        .add("clientAction", clientAction)
        .add("tabindex", tabindex)
        .add("ctrlKeys", ctrlKeys)
        .add("context", context)
        .add("popup", popup)
        .add("tooltip", tooltip)
        .add("children", children)
        .add("widgetClass", widgetClass)
        .add("caption", caption)
        .add("title", title)
        .add("mode", mode)
        .add("position", position)
        .add("contentStyle", contentStyle)
        .add("contentSclass", contentSclass)
        .add("closable", closable)
        .add("maximizable", maximizable)
        .add("minimizable", minimizable)
        .add("maximized", maximized)
        .add("minimized", minimized)
        .add("sizable", sizable)
        .add("minheight", minheight)
        .add("minwidth", minwidth)
        .add("border", border)
        .add("shadow", shadow)
        .add("nativeScrollbar", nativeScrollbar)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long Z_K_TYPE_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Class<Window> zKType;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IWindow#getZKType() zKType} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code zKType} attribute
   */
  @Override
  public Class<Window> getZKType() {
    if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & Z_K_TYPE_LAZY_INIT_BIT) == 0) {
          this.zKType = Objects.requireNonNull(IWindow.super.getZKType(), "zKType");
          lazyInitBitmap |= Z_K_TYPE_LAZY_INIT_BIT;
        }
      }
    }
    return zKType;
  }

  private static final long ALL_COMPONENTS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient List<IAnyGroup> allComponents;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link IWindow#getAllComponents() allComponents} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code allComponents} attribute
   */
  @Override
  public List<IAnyGroup> getAllComponents() {
    if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ALL_COMPONENTS_LAZY_INIT_BIT) == 0) {
          this.allComponents = Objects.requireNonNull(IWindow.super.getAllComponents(), "allComponents");
          lazyInitBitmap |= ALL_COMPONENTS_LAZY_INIT_BIT;
        }
      }
    }
    return allComponents;
  }

  private static <I extends IAnyGroup> ImmutableIWindow<I> validate(ImmutableIWindow<I> instance) {
    instance = (ImmutableIWindow<I>) instance.checkMinwidth();
    instance = (ImmutableIWindow<I>) instance.checkMinheight();
    instance = (ImmutableIWindow<I>) instance.checkBorder();
    instance.checkMode();
    instance.checkMinimized();
    instance.checkMaximized();
    instance.checkDraggableWithMode();
    instance.checkHflexAndWidth();
    instance.checkVflexAndHeight();
    instance = (ImmutableIWindow<I>) instance.checkDroppable();
    instance = (ImmutableIWindow<I>) instance.checkDraggable();
    instance.checkActions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IWindow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <I> generic parameter I
   * @param instance The instance to copy
   * @return A copied immutable IWindow instance
   */
  public static <I extends IAnyGroup> IWindow<I> copyOf(IWindow<I> instance) {
    if (instance instanceof ImmutableIWindow<?>) {
      return (ImmutableIWindow<I>) instance;
    }
    return new IWindow.Builder<I>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link IWindow IWindow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IWindow", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<I extends IAnyGroup> {
    private static final long OPT_BIT_VISIBLE = 0x1L;
    private static final long OPT_BIT_Z_INDEX = 0x2L;
    private static final long OPT_BIT_FOCUS = 0x4L;
    private static final long OPT_BIT_RENDERDEFER = 0x8L;
    private static final long OPT_BIT_CLOSABLE = 0x10L;
    private static final long OPT_BIT_MAXIMIZABLE = 0x20L;
    private static final long OPT_BIT_MINIMIZABLE = 0x40L;
    private static final long OPT_BIT_MAXIMIZED = 0x80L;
    private static final long OPT_BIT_MINIMIZED = 0x100L;
    private static final long OPT_BIT_SIZABLE = 0x200L;
    private static final long OPT_BIT_MINHEIGHT = 0x400L;
    private static final long OPT_BIT_MINWIDTH = 0x800L;
    private static final long OPT_BIT_SHADOW = 0x1000L;
    private static final long OPT_BIT_NATIVE_SCROLLBAR = 0x2000L;
    private long optBits;

    private @Nullable String id;
    private @Nullable ActionHandler action;
    private ImmutableList.Builder<ActionHandler> actions = null;
    private boolean visible;
    private @Nullable String mold;
    private @Nullable EventListenerMap eventListenerMap;
    private ImmutableMap.Builder<String, String> widgetListeners = null;
    private ImmutableMap.Builder<String, String> widgetOverrides = null;
    private ImmutableMap.Builder<String, String> clientAttributes = null;
    private @Nullable String left;
    private @Nullable String top;
    private int zIndex;
    private @Nullable String height;
    private @Nullable String width;
    private @Nullable String tooltiptext;
    private @Nullable String zclass;
    private @Nullable String sclass;
    private @Nullable String style;
    private @Nullable String draggable;
    private boolean focus;
    private @Nullable String droppable;
    private @Nullable String vflex;
    private @Nullable String hflex;
    private int renderdefer;
    private @Nullable String clientAction;
    private @Nullable Integer tabindex;
    private @Nullable String ctrlKeys;
    private @Nullable String context;
    private @Nullable String popup;
    private @Nullable String tooltip;
    private ImmutableList.Builder<I> children = ImmutableList.builder();
    private @Nullable String widgetClass;
    private @Nullable ICaption caption;
    private @Nullable String title;
    private @Nullable String mode;
    private @Nullable String position;
    private @Nullable String contentStyle;
    private @Nullable String contentSclass;
    private boolean closable;
    private boolean maximizable;
    private boolean minimizable;
    private boolean maximized;
    private boolean minimized;
    private boolean sizable;
    private int minheight;
    private int minwidth;
    private @Nullable String border;
    private boolean shadow;
    private boolean nativeScrollbar;

    /**
     * Creates a builder for {@link IWindow IWindow} instances.
     * <pre>
     * new IWindow.Builder&amp;lt;I&amp;gt;()
     *    .setId(String) // optional {@link IWindow#getId() id}
     *    .setAction(org.zkoss.stateless.util.ActionHandler | null) // nullable {@link IWindow#getAction() action}
     *    .setActions(List&amp;lt;org.zkoss.stateless.util.ActionHandler&amp;gt; | null) // nullable {@link IWindow#getActions() actions}
     *    .setVisible(boolean) // optional {@link IWindow#isVisible() visible}
     *    .setMold(String) // optional {@link IWindow#getMold() mold}
     *    .setEventListenerMap(org.zkoss.zk.ui.sys.EventListenerMap | null) // nullable {@link IWindow#getEventListenerMap() eventListenerMap}
     *    .setWidgetListeners(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IWindow#getWidgetListeners() widgetListeners}
     *    .setWidgetOverrides(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IWindow#getWidgetOverrides() widgetOverrides}
     *    .setClientAttributes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IWindow#getClientAttributes() clientAttributes}
     *    .setLeft(String | null) // nullable {@link IWindow#getLeft() left}
     *    .setTop(String | null) // nullable {@link IWindow#getTop() top}
     *    .setZIndex(int) // optional {@link IWindow#getZIndex() zIndex}
     *    .setHeight(String | null) // nullable {@link IWindow#getHeight() height}
     *    .setWidth(String | null) // nullable {@link IWindow#getWidth() width}
     *    .setTooltiptext(String | null) // nullable {@link IWindow#getTooltiptext() tooltiptext}
     *    .setZclass(String | null) // nullable {@link IWindow#getZclass() zclass}
     *    .setSclass(String | null) // nullable {@link IWindow#getSclass() sclass}
     *    .setStyle(String | null) // nullable {@link IWindow#getStyle() style}
     *    .setDraggable(String) // optional {@link IWindow#getDraggable() draggable}
     *    .setFocus(boolean) // optional {@link IWindow#isFocus() focus}
     *    .setDroppable(String) // optional {@link IWindow#getDroppable() droppable}
     *    .setVflex(String | null) // nullable {@link IWindow#getVflex() vflex}
     *    .setHflex(String | null) // nullable {@link IWindow#getHflex() hflex}
     *    .setRenderdefer(int) // optional {@link IWindow#getRenderdefer() renderdefer}
     *    .setClientAction(String | null) // nullable {@link IWindow#getClientAction() clientAction}
     *    .setTabindex(Integer | null) // nullable {@link IWindow#getTabindex() tabindex}
     *    .setCtrlKeys(String | null) // nullable {@link IWindow#getCtrlKeys() ctrlKeys}
     *    .setContext(String | null) // nullable {@link IWindow#getContext() context}
     *    .setPopup(String | null) // nullable {@link IWindow#getPopup() popup}
     *    .setTooltip(String | null) // nullable {@link IWindow#getTooltip() tooltip}
     *    .addChildren|addAllChildren(I) // {@link IWindow#getChildren() children} elements
     *    .setWidgetClass(String) // optional {@link IWindow#getWidgetClass() widgetClass}
     *    .setCaption(org.zkoss.stateless.sul.ICaption | null) // nullable {@link IWindow#getCaption() caption}
     *    .setTitle(String) // optional {@link IWindow#getTitle() title}
     *    .setMode(String) // optional {@link IWindow#getMode() mode}
     *    .setPosition(String | null) // nullable {@link IWindow#getPosition() position}
     *    .setContentStyle(String | null) // nullable {@link IWindow#getContentStyle() contentStyle}
     *    .setContentSclass(String | null) // nullable {@link IWindow#getContentSclass() contentSclass}
     *    .setClosable(boolean) // optional {@link IWindow#isClosable() closable}
     *    .setMaximizable(boolean) // optional {@link IWindow#isMaximizable() maximizable}
     *    .setMinimizable(boolean) // optional {@link IWindow#isMinimizable() minimizable}
     *    .setMaximized(boolean) // optional {@link IWindow#isMaximized() maximized}
     *    .setMinimized(boolean) // optional {@link IWindow#isMinimized() minimized}
     *    .setSizable(boolean) // optional {@link IWindow#isSizable() sizable}
     *    .setMinheight(int) // optional {@link IWindow#getMinheight() minheight}
     *    .setMinwidth(int) // optional {@link IWindow#getMinwidth() minwidth}
     *    .setBorder(String) // optional {@link IWindow#getBorder() border}
     *    .setShadow(boolean) // optional {@link IWindow#isShadow() shadow}
     *    .setNativeScrollbar(boolean) // optional {@link IWindow#isNativeScrollbar() nativeScrollbar}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof IWindow.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new IWindow.Builder<I>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code IWindow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> from(IWindow<I> instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      @Nullable ActionHandler actionValue = instance.getAction();
      if (actionValue != null) {
        setAction(actionValue);
      }
      @Nullable List<ActionHandler> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      setVisible(instance.isVisible());
      setMold(instance.getMold());
      @Nullable EventListenerMap eventListenerMapValue = instance.getEventListenerMap();
      if (eventListenerMapValue != null) {
        setEventListenerMap(eventListenerMapValue);
      }
      @Nullable Map<String, String> widgetListenersValue = instance.getWidgetListeners();
      if (widgetListenersValue != null) {
        putAllWidgetListeners(widgetListenersValue);
      }
      @Nullable Map<String, String> widgetOverridesValue = instance.getWidgetOverrides();
      if (widgetOverridesValue != null) {
        putAllWidgetOverrides(widgetOverridesValue);
      }
      @Nullable Map<String, String> clientAttributesValue = instance.getClientAttributes();
      if (clientAttributesValue != null) {
        putAllClientAttributes(clientAttributesValue);
      }
      @Nullable String leftValue = instance.getLeft();
      if (leftValue != null) {
        setLeft(leftValue);
      }
      @Nullable String topValue = instance.getTop();
      if (topValue != null) {
        setTop(topValue);
      }
      setZIndex(instance.getZIndex());
      @Nullable String heightValue = instance.getHeight();
      if (heightValue != null) {
        setHeight(heightValue);
      }
      @Nullable String widthValue = instance.getWidth();
      if (widthValue != null) {
        setWidth(widthValue);
      }
      @Nullable String tooltiptextValue = instance.getTooltiptext();
      if (tooltiptextValue != null) {
        setTooltiptext(tooltiptextValue);
      }
      @Nullable String zclassValue = instance.getZclass();
      if (zclassValue != null) {
        setZclass(zclassValue);
      }
      @Nullable String sclassValue = instance.getSclass();
      if (sclassValue != null) {
        setSclass(sclassValue);
      }
      @Nullable String styleValue = instance.getStyle();
      if (styleValue != null) {
        setStyle(styleValue);
      }
      setDraggable(instance.getDraggable());
      setFocus(instance.isFocus());
      setDroppable(instance.getDroppable());
      @Nullable String vflexValue = instance.getVflex();
      if (vflexValue != null) {
        setVflex(vflexValue);
      }
      @Nullable String hflexValue = instance.getHflex();
      if (hflexValue != null) {
        setHflex(hflexValue);
      }
      setRenderdefer(instance.getRenderdefer());
      @Nullable String clientActionValue = instance.getClientAction();
      if (clientActionValue != null) {
        setClientAction(clientActionValue);
      }
      @Nullable Integer tabindexValue = instance.getTabindex();
      if (tabindexValue != null) {
        setTabindex(tabindexValue);
      }
      @Nullable String ctrlKeysValue = instance.getCtrlKeys();
      if (ctrlKeysValue != null) {
        setCtrlKeys(ctrlKeysValue);
      }
      @Nullable String contextValue = instance.getContext();
      if (contextValue != null) {
        setContext(contextValue);
      }
      @Nullable String popupValue = instance.getPopup();
      if (popupValue != null) {
        setPopup(popupValue);
      }
      @Nullable String tooltipValue = instance.getTooltip();
      if (tooltipValue != null) {
        setTooltip(tooltipValue);
      }
      addAllChildren(instance.getChildren());
      setWidgetClass(instance.getWidgetClass());
      @Nullable ICaption captionValue = instance.getCaption();
      if (captionValue != null) {
        setCaption(captionValue);
      }
      setTitle(instance.getTitle());
      setMode(instance.getMode());
      @Nullable String positionValue = instance.getPosition();
      if (positionValue != null) {
        setPosition(positionValue);
      }
      @Nullable String contentStyleValue = instance.getContentStyle();
      if (contentStyleValue != null) {
        setContentStyle(contentStyleValue);
      }
      @Nullable String contentSclassValue = instance.getContentSclass();
      if (contentSclassValue != null) {
        setContentSclass(contentSclassValue);
      }
      setClosable(instance.isClosable());
      setMaximizable(instance.isMaximizable());
      setMinimizable(instance.isMinimizable());
      setMaximized(instance.isMaximized());
      setMinimized(instance.isMinimized());
      setSizable(instance.isSizable());
      setMinheight(instance.getMinheight());
      setMinwidth(instance.getMinwidth());
      setBorder(instance.getBorder());
      setShadow(instance.isShadow());
      setNativeScrollbar(instance.isNativeScrollbar());
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setAction(@Nullable ActionHandler action) {
      this.action = action;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Adds one element to {@link IWindow#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> addActions(ActionHandler element) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(element);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Adds elements to {@link IWindow#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> addActions(ActionHandler... elements) {
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.add(elements);
      return (IWindow.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link IWindow#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setActions(@Nullable Iterable<? extends ActionHandler> elements) {
      if (elements == null) {
        this.actions = null;
        return (IWindow.Builder<I>) this;
      }
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link IWindow#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> addAllActions(Iterable<? extends ActionHandler> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = ImmutableList.builder();
      }
      this.actions.addAll(elements);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isVisible() visible} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isVisible() visible}.</em>
     * @param visible The value for visible 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setVisible(boolean visible) {
      this.visible = visible;
      optBits |= OPT_BIT_VISIBLE;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getMold() mold} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getMold() mold}.</em>
     * @param mold The value for mold 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMold(String mold) {
      this.mold = Objects.requireNonNull(mold, "mold");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getEventListenerMap() eventListenerMap} attribute.
     * @param eventListenerMap The value for eventListenerMap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setEventListenerMap(@Nullable EventListenerMap eventListenerMap) {
      this.eventListenerMap = eventListenerMap;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWindow#getWidgetListeners() widgetListeners} map.
     * @param key The key in the widgetListeners map
     * @param value The associated value in the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putWidgetListeners(String key, String value) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(key, value);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWindow#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putWidgetListeners(Map.Entry<String, ? extends String> entry) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.put(entry);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IWindow#getWidgetListeners() widgetListeners} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setWidgetListeners(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetListeners = null;
        return (IWindow.Builder<I>) this;
      }
      this.widgetListeners = ImmutableMap.builder();
      return putAllWidgetListeners(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IWindow#getWidgetListeners() widgetListeners} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetListeners map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putAllWidgetListeners(Map<String, ? extends String> entries) {
      if (this.widgetListeners == null) {
        this.widgetListeners = ImmutableMap.builder();
      }
      this.widgetListeners.putAll(entries);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWindow#getWidgetOverrides() widgetOverrides} map.
     * @param key The key in the widgetOverrides map
     * @param value The associated value in the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putWidgetOverrides(String key, String value) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(key, value);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWindow#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putWidgetOverrides(Map.Entry<String, ? extends String> entry) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.put(entry);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IWindow#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setWidgetOverrides(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.widgetOverrides = null;
        return (IWindow.Builder<I>) this;
      }
      this.widgetOverrides = ImmutableMap.builder();
      return putAllWidgetOverrides(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IWindow#getWidgetOverrides() widgetOverrides} map. Nulls are not permitted
     * @param entries The entries that will be added to the widgetOverrides map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putAllWidgetOverrides(Map<String, ? extends String> entries) {
      if (this.widgetOverrides == null) {
        this.widgetOverrides = ImmutableMap.builder();
      }
      this.widgetOverrides.putAll(entries);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWindow#getClientAttributes() clientAttributes} map.
     * @param key The key in the clientAttributes map
     * @param value The associated value in the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putClientAttributes(String key, String value) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(key, value);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Put one entry to the {@link IWindow#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putClientAttributes(Map.Entry<String, ? extends String> entry) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.put(entry);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IWindow#getClientAttributes() clientAttributes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setClientAttributes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.clientAttributes = null;
        return (IWindow.Builder<I>) this;
      }
      this.clientAttributes = ImmutableMap.builder();
      return putAllClientAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IWindow#getClientAttributes() clientAttributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the clientAttributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> putAllClientAttributes(Map<String, ? extends String> entries) {
      if (this.clientAttributes == null) {
        this.clientAttributes = ImmutableMap.builder();
      }
      this.clientAttributes.putAll(entries);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getLeft() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setLeft(@Nullable String left) {
      this.left = left;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getTop() top} attribute.
     * @param top The value for top (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setTop(@Nullable String top) {
      this.top = top;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getZIndex() zIndex} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getZIndex() zIndex}.</em>
     * @param zIndex The value for zIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setZIndex(int zIndex) {
      this.zIndex = zIndex;
      optBits |= OPT_BIT_Z_INDEX;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getHeight() height} attribute.
     * @param height The value for height (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setHeight(@Nullable String height) {
      this.height = height;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getWidth() width} attribute.
     * @param width The value for width (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setWidth(@Nullable String width) {
      this.width = width;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getTooltiptext() tooltiptext} attribute.
     * @param tooltiptext The value for tooltiptext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setTooltiptext(@Nullable String tooltiptext) {
      this.tooltiptext = tooltiptext;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getZclass() zclass} attribute.
     * @param zclass The value for zclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setZclass(@Nullable String zclass) {
      this.zclass = zclass;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getSclass() sclass} attribute.
     * @param sclass The value for sclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setSclass(@Nullable String sclass) {
      this.sclass = sclass;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getStyle() style} attribute.
     * @param style The value for style (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setStyle(@Nullable String style) {
      this.style = style;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getDraggable() draggable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getDraggable() draggable}.</em>
     * @param draggable The value for draggable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setDraggable(String draggable) {
      this.draggable = Objects.requireNonNull(draggable, "draggable");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isFocus() focus} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isFocus() focus}.</em>
     * @param focus The value for focus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setFocus(boolean focus) {
      this.focus = focus;
      optBits |= OPT_BIT_FOCUS;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getDroppable() droppable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getDroppable() droppable}.</em>
     * @param droppable The value for droppable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setDroppable(String droppable) {
      this.droppable = Objects.requireNonNull(droppable, "droppable");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getVflex() vflex} attribute.
     * @param vflex The value for vflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setVflex(@Nullable String vflex) {
      this.vflex = vflex;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getHflex() hflex} attribute.
     * @param hflex The value for hflex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setHflex(@Nullable String hflex) {
      this.hflex = hflex;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getRenderdefer() renderdefer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getRenderdefer() renderdefer}.</em>
     * @param renderdefer The value for renderdefer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setRenderdefer(int renderdefer) {
      this.renderdefer = renderdefer;
      optBits |= OPT_BIT_RENDERDEFER;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getClientAction() clientAction} attribute.
     * @param clientAction The value for clientAction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setClientAction(@Nullable String clientAction) {
      this.clientAction = clientAction;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getTabindex() tabindex} attribute.
     * @param tabindex The value for tabindex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setTabindex(@Nullable Integer tabindex) {
      this.tabindex = tabindex;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getCtrlKeys() ctrlKeys} attribute.
     * @param ctrlKeys The value for ctrlKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setCtrlKeys(@Nullable String ctrlKeys) {
      this.ctrlKeys = ctrlKeys;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setContext(@Nullable String context) {
      this.context = context;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getPopup() popup} attribute.
     * @param popup The value for popup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setPopup(@Nullable String popup) {
      this.popup = popup;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getTooltip() tooltip} attribute.
     * @param tooltip The value for tooltip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setTooltip(@Nullable String tooltip) {
      this.tooltip = tooltip;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Adds one element to {@link IWindow#getChildren() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> addChildren(I element) {
      this.children.add(element);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Adds elements to {@link IWindow#getChildren() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final IWindow.Builder<I> addChildren(I... elements) {
      this.children.add(elements);
      return (IWindow.Builder<I>) this;
    }


    /**
     * Sets or replaces all elements for {@link IWindow#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setChildren(Iterable<? extends I> elements) {
      this.children = ImmutableList.builder();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link IWindow#getChildren() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> addAllChildren(Iterable<? extends I> elements) {
      this.children.addAll(elements);
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getWidgetClass() widgetClass} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getWidgetClass() widgetClass}.</em>
     * @param widgetClass The value for widgetClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setWidgetClass(String widgetClass) {
      this.widgetClass = Objects.requireNonNull(widgetClass, "widgetClass");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getCaption() caption} attribute.
     * @param caption The value for caption (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setCaption(@Nullable ICaption caption) {
      this.caption = caption;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getTitle() title} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getTitle() title}.</em>
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getMode() mode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getMode() mode}.</em>
     * @param mode The value for mode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMode(String mode) {
      this.mode = Objects.requireNonNull(mode, "mode");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getPosition() position} attribute.
     * @param position The value for position (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setPosition(@Nullable String position) {
      this.position = position;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getContentStyle() contentStyle} attribute.
     * @param contentStyle The value for contentStyle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setContentStyle(@Nullable String contentStyle) {
      this.contentStyle = contentStyle;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getContentSclass() contentSclass} attribute.
     * @param contentSclass The value for contentSclass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setContentSclass(@Nullable String contentSclass) {
      this.contentSclass = contentSclass;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isClosable() closable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isClosable() closable}.</em>
     * @param closable The value for closable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setClosable(boolean closable) {
      this.closable = closable;
      optBits |= OPT_BIT_CLOSABLE;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isMaximizable() maximizable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isMaximizable() maximizable}.</em>
     * @param maximizable The value for maximizable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMaximizable(boolean maximizable) {
      this.maximizable = maximizable;
      optBits |= OPT_BIT_MAXIMIZABLE;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isMinimizable() minimizable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isMinimizable() minimizable}.</em>
     * @param minimizable The value for minimizable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMinimizable(boolean minimizable) {
      this.minimizable = minimizable;
      optBits |= OPT_BIT_MINIMIZABLE;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isMaximized() maximized} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isMaximized() maximized}.</em>
     * @param maximized The value for maximized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMaximized(boolean maximized) {
      this.maximized = maximized;
      optBits |= OPT_BIT_MAXIMIZED;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isMinimized() minimized} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isMinimized() minimized}.</em>
     * @param minimized The value for minimized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMinimized(boolean minimized) {
      this.minimized = minimized;
      optBits |= OPT_BIT_MINIMIZED;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isSizable() sizable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isSizable() sizable}.</em>
     * @param sizable The value for sizable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setSizable(boolean sizable) {
      this.sizable = sizable;
      optBits |= OPT_BIT_SIZABLE;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getMinheight() minheight} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getMinheight() minheight}.</em>
     * @param minheight The value for minheight 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMinheight(int minheight) {
      this.minheight = minheight;
      optBits |= OPT_BIT_MINHEIGHT;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getMinwidth() minwidth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getMinwidth() minwidth}.</em>
     * @param minwidth The value for minwidth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setMinwidth(int minwidth) {
      this.minwidth = minwidth;
      optBits |= OPT_BIT_MINWIDTH;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#getBorder() border} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#getBorder() border}.</em>
     * @param border The value for border 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setBorder(String border) {
      this.border = Objects.requireNonNull(border, "border");
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isShadow() shadow} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isShadow() shadow}.</em>
     * @param shadow The value for shadow 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setShadow(boolean shadow) {
      this.shadow = shadow;
      optBits |= OPT_BIT_SHADOW;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Initializes the value for the {@link IWindow#isNativeScrollbar() nativeScrollbar} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IWindow#isNativeScrollbar() nativeScrollbar}.</em>
     * @param nativeScrollbar The value for nativeScrollbar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final IWindow.Builder<I> setNativeScrollbar(boolean nativeScrollbar) {
      this.nativeScrollbar = nativeScrollbar;
      optBits |= OPT_BIT_NATIVE_SCROLLBAR;
      return (IWindow.Builder<I>) this;
    }

    /**
     * Builds a new {@link IWindow IWindow}.
     * @return An immutable instance of IWindow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IWindow<I> build() {
      return ImmutableIWindow.validate(new ImmutableIWindow<I>(this));
    }

    private boolean visibleIsSet() {
      return (optBits & OPT_BIT_VISIBLE) != 0;
    }

    private boolean zIndexIsSet() {
      return (optBits & OPT_BIT_Z_INDEX) != 0;
    }

    private boolean focusIsSet() {
      return (optBits & OPT_BIT_FOCUS) != 0;
    }

    private boolean renderdeferIsSet() {
      return (optBits & OPT_BIT_RENDERDEFER) != 0;
    }

    private boolean closableIsSet() {
      return (optBits & OPT_BIT_CLOSABLE) != 0;
    }

    private boolean maximizableIsSet() {
      return (optBits & OPT_BIT_MAXIMIZABLE) != 0;
    }

    private boolean minimizableIsSet() {
      return (optBits & OPT_BIT_MINIMIZABLE) != 0;
    }

    private boolean maximizedIsSet() {
      return (optBits & OPT_BIT_MAXIMIZED) != 0;
    }

    private boolean minimizedIsSet() {
      return (optBits & OPT_BIT_MINIMIZED) != 0;
    }

    private boolean sizableIsSet() {
      return (optBits & OPT_BIT_SIZABLE) != 0;
    }

    private boolean minheightIsSet() {
      return (optBits & OPT_BIT_MINHEIGHT) != 0;
    }

    private boolean minwidthIsSet() {
      return (optBits & OPT_BIT_MINWIDTH) != 0;
    }

    private boolean shadowIsSet() {
      return (optBits & OPT_BIT_SHADOW) != 0;
    }

    private boolean nativeScrollbarIsSet() {
      return (optBits & OPT_BIT_NATIVE_SCROLLBAR) != 0;
    }
  }
}
